/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.yzf.YzfMessageSendConstant;
import kd.taxc.tsate.common.enums.yzf.YzfdlfsMappingEnums;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbpzMessageVo;
import kd.taxc.tsate.msmessage.enums.yzf.YzfdlsfMappingEnums;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.service.yzf.YzfRequest;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import org.apache.commons.collections4.CollectionUtils;

public class YzfDirectDeclareService {
    private static Log logger = LogFactory.getLog(YzfDirectDeclareService.class);

    public static ApiResult addCompany(IdentityData identityData, SBMessageBaseVo vo) {
        ApiResult apiResult;
        try {
            DynamicObject taxoffice;
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("qymc", vo.getOrgName());
            paramMap.put("nsrzgdm", "001");
            paramMap.put("xzqhid", YzfMessageSendConstant.getXzqhMap().get(vo.getSbdq()));
            paramMap.put("gsdlfs", YzfdlfsMappingEnums.getDlfsByCode((String)identityData.getLoginType()));
            paramMap.put("nsrsbh", vo.getNsrsbh());
            if (EmptyCheckUtils.isNotEmpty((Object)identityData.getDlsf())) {
                paramMap.put("gsjbrlx", YzfdlsfMappingEnums.getDlsfByCode(identityData.getDlsf()));
            }
            if ((taxoffice = YzfDirectDeclareService.getTaxoffice(vo)) != null) {
                paramMap.put("gszgswjg", taxoffice.getString("name"));
            }
            paramMap.put("generalMode", true);
            paramMap.put("gsbdsjh", identityData.getTelephoneNum());
            paramMap.put("gsclientyhm", identityData.getTaxmanName());
            paramMap.put("gsclientmm", identityData.getTaxmanPwd());
            paramMap.put("gscadlmm", identityData.getCapassword());
            paramMap.put("gsdlyhm", identityData.getUsername());
            paramMap.put("gsdlmm", identityData.getPassword());
            paramMap.put("gssfzh", identityData.getUsername());
            paramMap.put("gszjlx", "1");
            paramMap.put("smdlmm", identityData.getTaxmanPwd());
            paramMap.put("smdlyhm", identityData.getTaxmanName());
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("yzf_app_Code");
            String baseUrl = (String)configMap.get("yzf_base_url");
            String url = baseUrl + "/open/api/user/company/add";
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("appCode", appCode);
            logger.info("\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.toJson(paramMap));
            String response = YzfRequest.doPost(url, httpHeader, JsonUtil.toJson(paramMap));
            logger.info("nsrsbh = {} \u63a5\u53e3\u8fd4\u56de\u503c={}", (Object)vo.getNsrsbh(), (Object)response);
            if (org.apache.commons.lang.StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u65b0\u589e\u4f01\u4e1a\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                return CustomApiResult.dealResponse(null, message, "3", false);
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(((Map)responseMap.get("result")).get("qyid"), String.valueOf(responseMap.get("message")), "4", true) : CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "3", false);
            } else {
                String message = ResManager.loadKDString((String)"\u65b0\u589e\u4f01\u4e1a\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u4f01\u4e1a\u5904\u7406\u5f02\u5e38, %s", (String)"YzfDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            logger.error("\u65b0\u589e\u4f01\u4e1a\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(ExceptionUtil.toString((Exception)e));
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult modifyCompany(SBMessageBaseVo vo, IdentityData identityData) {
        ApiResult apiResult;
        try {
            DynamicObject taxoffice;
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("qyid", vo.getQybdid());
            paramMap.put("qymc", vo.getOrgName());
            paramMap.put("nsrzgdm", "001");
            paramMap.put("xzqhid", YzfMessageSendConstant.getXzqhMap().get(vo.getSbdq()));
            paramMap.put("gsdlfs", YzfdlfsMappingEnums.getDlfsByCode((String)identityData.getLoginType()));
            paramMap.put("nsrsbh", vo.getNsrsbh());
            if (EmptyCheckUtils.isNotEmpty((Object)identityData.getDlsf())) {
                paramMap.put("gsjbrlx", YzfdlsfMappingEnums.getDlsfByCode(identityData.getDlsf()));
            }
            if ((taxoffice = YzfDirectDeclareService.getTaxoffice(vo)) != null) {
                paramMap.put("gszgswjg", taxoffice.getString("name"));
            }
            paramMap.put("generalMode", true);
            paramMap.put("gsbdsjh", identityData.getTelephoneNum());
            paramMap.put("gsclientyhm", identityData.getTaxmanName());
            paramMap.put("gsclientmm", identityData.getTaxmanPwd());
            paramMap.put("gscadlmm", identityData.getCapassword());
            paramMap.put("gsdlyhm", identityData.getUsername());
            paramMap.put("gsdlmm", identityData.getPassword());
            paramMap.put("gssfzh", identityData.getUsername());
            paramMap.put("gszjlx", "1");
            paramMap.put("smdlmm", identityData.getTaxmanPwd());
            paramMap.put("smdlyhm", identityData.getTaxmanName());
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("yzf_app_Code");
            String baseUrl = (String)configMap.get("yzf_base_url");
            String url = baseUrl + "/open/api/user/company/modify";
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("appCode", appCode);
            logger.info("\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.toJson(paramMap));
            String response = YzfRequest.doPost(url, httpHeader, JsonUtil.toJson(paramMap));
            logger.info("nsrsbh = {} \u63a5\u53e3\u8fd4\u56de\u503c={}", (Object)vo.getNsrsbh(), (Object)response);
            if (org.apache.commons.lang.StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4fee\u6539\u4f01\u4e1a\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_13", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                return CustomApiResult.dealResponse(null, message, "3", false);
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "4", true) : CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "3", false);
            } else {
                String message = ResManager.loadKDString((String)"\u4fee\u6539\u4f01\u4e1a\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_13", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u4fee\u6539\u4f01\u4e1a\u5904\u7406\u5f02\u5e38, %s", (String)"YzfDirectDeclareService_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            logger.error("\u4fee\u6539\u4f01\u4e1a\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(ExceptionUtil.toString((Exception)e));
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult declare(SBMessageBaseVo vo) {
        ApiResult apiResult;
        try {
            MessageSend send = new MessageSend();
            send.setMsgtype("declare");
            send.setBusinessid(vo.getBusinessId());
            send.setBusinesstype(vo.getBusinessType());
            send.setNodetype(vo.getSbdq());
            send.setSupplier(SupplierEnum.YZF.getName());
            String reqContent = MessageService.collectionData(send, null, vo.getNsrsbh());
            DirectDeclareLogUtils.dealDetailLog(new StringBuilder(reqContent), vo.getId());
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("qyId", vo.getQybdid());
            paramMap.put("kjnd", DateUtils.getYearOfDate((Date)vo.getSkssqz()));
            paramMap.put("kjqj", DateUtils.getMonthOfDate((Date)vo.getSkssqz()));
            paramMap.put("version", "version3");
            paramMap.put("nsqxdm", YzfDirectDeclareService.getTaxLimit(vo.getSkssqq(), vo.getSkssqz()));
            String urlParam = YzfDirectDeclareService.buildUrlParams(paramMap);
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("yzf_app_Code");
            String baseUrl = (String)configMap.get("yzf_base_url");
            String url = baseUrl + "/open/api/report/task/declare" + "?" + urlParam;
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("appCode", appCode);
            String response = YzfRequest.doPost(url, httpHeader, reqContent);
            if (org.apache.commons.lang.StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u7533\u62a5\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                ApiResult apiResult2 = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult2;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(responseMap.get("code")) ? YzfDirectDeclareService.dealResponse(vo, "5") : CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "3", false);
            } else {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u7533\u62a5\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u7533\u62a5\u5904\u7406\u5f02\u5e38, %s", (String)"YzfDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            logger.error("\u7533\u62a5\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(message);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static ApiResult dealResponse(SBMessageBaseVo vo, String type) throws Exception {
        ApiResult apiResult = YzfDirectDeclareService.queryTaskStatus(vo, type);
        if (apiResult.getSuccess() && ("1".equals(apiResult.getErrorCode()) || "2".equals(apiResult.getErrorCode()))) {
            logger.info("\u4efb\u52a1\u5df2\u4e0b\u53d1+" + apiResult.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
            boolean isCompleted = false;
            int times = 0;
            do {
                ++times;
                apiResult = YzfDirectDeclareService.queryTaskStatus(vo, type);
                if (apiResult.getSuccess() && !"3".equals(apiResult.getErrorCode()) && !"4".equals(apiResult.getErrorCode())) continue;
                isCompleted = true;
            } while (!isCompleted && times <= 3);
        }
        return apiResult;
    }

    public static ApiResult pay(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("qyid", vo.getQybdid());
            paramMap.put("sbbmc", YzfMessageSendConstant.getTaxTypeMap().get(vo.getBusinessType()));
            paramMap.put("kjnd", DateUtils.getYearOfDate((Date)vo.getSkssqz()));
            paramMap.put("kjqj", DateUtils.getMonthOfDate((Date)vo.getSkssqz()));
            YzfDirectDeclareService.dealBankInfo(vo, paramMap);
            paramMap.put("nsqxdm", YzfDirectDeclareService.getTaxLimit(vo.getSkssqq(), vo.getSkssqz()));
            paramMap.put("money", vo.getYbtse());
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("yzf_app_Code");
            String baseUrl = (String)configMap.get("yzf_base_url");
            String url = baseUrl + "/open/api/report/task/payment";
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("appCode", appCode);
            String response = YzfRequest.doPost(url, httpHeader, JsonUtil.toJson(paramMap));
            if (org.apache.commons.lang.StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u6263\u6b3e\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(responseMap.get("code")) ? YzfDirectDeclareService.dealResponse(vo, "8") : CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "3", false);
            } else {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u6263\u6b3e\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u6263\u6b3e\u5904\u7406\u5f02\u5e38, %s", (String)"YzfDirectDeclareService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            logger.error("\u6263\u6b3e\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(message);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static void dealBankInfo(SBMessageBaseVo vo, Map<String, Object> paramMap) {
        if (EmptyCheckUtils.isNotEmpty((Object)vo.getOrg())) {
            DynamicObject d = BusinessDataServiceHelper.loadSingle((String)"tctb_tax_main", (String)"entryentity.tripleaggrement,entryentity.bankacct,entryentity.taxacct", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.valueOf(vo.getOrg()))});
            if (null != d) {
                DynamicObjectCollection objs = d.getDynamicObjectCollection("entryentity");
                if (CollectionUtils.isNotEmpty((Collection)objs)) {
                    Optional<DynamicObject> optional = objs.stream().filter(a -> a.getBoolean("taxacct")).findFirst();
                    if (optional.isPresent()) {
                        paramMap.put("xyh", optional.get().getString("tripleaggrement"));
                        paramMap.put("yhzh", optional.get().getString("bankacct"));
                    } else {
                        paramMap.put("xyh", ((DynamicObject)objs.get(0)).getString("tripleaggrement"));
                        paramMap.put("yhzh", ((DynamicObject)objs.get(0)).getString("bankacct"));
                    }
                } else {
                    paramMap.put("yhzh", ResManager.loadKDString((String)"\u9ed8\u8ba4\u94f6\u884c", (String)"YzfDirectDeclareService_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                }
            } else {
                paramMap.put("yhzh", ResManager.loadKDString((String)"\u9ed8\u8ba4\u94f6\u884c", (String)"YzfDirectDeclareService_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            }
        } else {
            paramMap.put("yhzh", ResManager.loadKDString((String)"\u9ed8\u8ba4\u94f6\u884c", (String)"YzfDirectDeclareService_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
    }

    private static DynamicObject getTaxoffice(SBMessageBaseVo vo) {
        DynamicObject taxMain;
        if (EmptyCheckUtils.isNotEmpty((Object)vo.getOrg()) && null != (taxMain = BusinessDataServiceHelper.loadSingle((String)"tctb_tax_main", (String)"id,taxoffice", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.valueOf(vo.getOrg()))}))) {
            return taxMain.getDynamicObject("taxoffice");
        }
        return null;
    }

    public static ApiResult addCertificateTask(SBMessageBaseVo vo, IdentityData identityData) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("qyid", vo.getQybdid());
            paramMap.put("kjnd", DateUtils.getYearOfDate((Date)vo.getDate(SbpzMessageVo.Key.SKSSQZ)));
            paramMap.put("kjqj", DateUtils.getMonthOfDate((Date)vo.getDate(SbpzMessageVo.Key.SKSSQZ)));
            String declareType = vo.getString(SbpzMessageVo.Key.TYPENUMBER);
            if ("fcscztdsys".equals(declareType)) {
                String taxcode = (String)vo.getParams().get("taxtype");
                if (DeclareTaxType.FCS.getBaseTaxCode().equals(taxcode)) {
                    declareType = "fcs";
                } else if (DeclareTaxType.CZTDSYS.getBaseTaxCode().equals(taxcode)) {
                    declareType = "cztdsys";
                }
            }
            paramMap.put("subType", vo.getString(SbpzMessageVo.Key.VOUCHER_TYPE));
            String nsqxdm = YzfDirectDeclareService.getTaxLimit(vo.getDate(SbpzMessageVo.Key.SKSSQQ), vo.getDate(SbpzMessageVo.Key.SKSSQZ));
            paramMap.put("nsqxdm", nsqxdm);
            paramMap.put("sbbname", YzfMessageSendConstant.getTaxTypeMap().get(declareType));
            YzfDirectDeclareService.dealAreaCode(vo, paramMap);
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("yzf_app_Code");
            String baseUrl = (String)configMap.get("yzf_base_url");
            String url = baseUrl + "/open/api/report/task/addCertificateTask";
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("appCode", appCode);
            logger.info("yzf\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u8bf7\u6c42\u4efb\u52a1\u5f00\u59cb" + vo.getNsrsbh());
            logger.info("yzf\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u8bf7\u6c42\u4efb\u52a1\u53c2\u6570" + JsonUtil.toJson(paramMap));
            String response = YzfRequest.doPost(url, httpHeader, JsonUtil.toJson(paramMap));
            logger.info("yzf\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u8bf7\u6c42\u4efb\u52a1\u7ed3\u675f" + vo.getNsrsbh());
            logger.info("yzf\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u8bf7\u6c42\u4efb\u52a1\u8fd4\u56de" + response);
            if (org.apache.commons.lang.StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u5b8c\u7a0e\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(responseMap.get("code")) ? YzfDirectDeclareService.dealCertificateTaskResponse(vo) : CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "3", false);
            } else {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u5b8c\u7a0e\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u5b8c\u7a0e\u4efb\u52a1\u5904\u7406\u5f02\u5e38\uff1a%s", (String)"YzfDirectDeclareService_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            logger.error("\u65b0\u589e\u5b8c\u7a0e\u4efb\u52a1\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(message);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult getCertificateTaskUrls(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("qyid", vo.getQybdid());
            paramMap.put("kjnd", DateUtils.getYearOfDate((Date)vo.getDate(SbpzMessageVo.Key.SKSSQZ)));
            paramMap.put("kjqj", DateUtils.getMonthOfDate((Date)vo.getDate(SbpzMessageVo.Key.SKSSQZ)));
            String declareType = vo.getString(SbpzMessageVo.Key.TYPENUMBER);
            if ("fcscztdsys".equals(declareType)) {
                String taxcode = (String)vo.getParams().get("taxtype");
                if (DeclareTaxType.FCS.getBaseTaxCode().equals(taxcode)) {
                    declareType = "fcs";
                } else if (DeclareTaxType.CZTDSYS.getBaseTaxCode().equals(taxcode)) {
                    declareType = "cztdsys";
                }
            }
            paramMap.put("subType", vo.getString(SbpzMessageVo.Key.VOUCHER_TYPE));
            String nsqxdm = YzfDirectDeclareService.getTaxLimit(vo.getDate(SbpzMessageVo.Key.SKSSQQ), vo.getDate(SbpzMessageVo.Key.SKSSQZ));
            paramMap.put("nsqxdm", nsqxdm);
            paramMap.put("sbbname", YzfMessageSendConstant.getTaxTypeMap().get(declareType));
            YzfDirectDeclareService.dealAreaCode(vo, paramMap);
            String urlParam = YzfDirectDeclareService.buildUrlParams(paramMap);
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("yzf_app_Code");
            String baseUrl = (String)configMap.get("yzf_base_url");
            String url = baseUrl + "/open/api/report/task/getCertificateTaskUrls" + "?" + urlParam;
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("appCode", appCode);
            logger.info("yzf\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u67e5\u8be2\u4efb\u52a1\u7ed3\u679c\u5f00\u59cb" + vo.getNsrsbh());
            logger.info("yzf\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u8bf7\u6c42\u67e5\u8be2\u4efb\u52a1\u7ed3\u53c2\u6570" + JsonUtil.toJson(paramMap));
            String response = YzfRequest.doGet(url, httpHeader, paramMap);
            logger.info("yzf\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u67e5\u8be2\u4efb\u52a1\u7ed3\u679c\u7ed3\u675f" + vo.getNsrsbh());
            logger.info("yzf\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u67e5\u8be2\u4efb\u52a1\u7ed3\u679c\u8fd4\u56de" + response);
            if (org.apache.commons.lang.StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u5b8c\u7a0e\u4efb\u52a1\u72b6\u6001\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                return CustomApiResult.dealResponse(null, message, "3", false);
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = YzfDirectDeclareService.getCertificateTaskStatus(responseMap);
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5b8c\u7a0e\u51ed\u8bc1\u5904\u7406\u5f02\u5e38, %s", (String)"YzfDirectDeclareService_9", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            logger.error("\u83b7\u53d6\u5b8c\u7a0e\u51ed\u8bc1\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(message);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static ApiResult dealCertificateTaskResponse(SBMessageBaseVo vo) throws Exception {
        ApiResult apiResult = YzfDirectDeclareService.getCertificateTaskUrls(vo);
        return apiResult;
    }

    public static ApiResult queryTaskStatus(SBMessageBaseVo vo, String type) {
        ApiResult apiResult = new ApiResult();
        String response = null;
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("qyid", vo.getQybdid());
            if (vo.getSkssqz() != null) {
                paramMap.put("kjnd", DateUtils.getYearOfDate((Date)vo.getSkssqz()));
                paramMap.put("kjqj", DateUtils.getMonthOfDate((Date)vo.getSkssqz()));
            } else {
                paramMap.put("kjnd", DateUtils.getYearOfDate((Date)new Date()));
                paramMap.put("kjqj", DateUtils.getMonthOfDate((Date)new Date()));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)vo.getBusinessType())) {
                paramMap.put("sbbmc", YzfMessageSendConstant.getTaxTypeMap().get(vo.getBusinessType()));
            }
            paramMap.put("type", type);
            String urlParam = YzfDirectDeclareService.buildUrlParams(paramMap);
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("yzf_app_Code");
            String baseUrl = (String)configMap.get("yzf_base_url");
            String url = baseUrl + "/open/api/report/task/query" + "?" + urlParam;
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("appCode", appCode);
            response = YzfRequest.doGet(url, httpHeader, paramMap);
            if (org.apache.commons.lang.StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null && StringUtils.equals((CharSequence)"2", (CharSequence)(apiResult = YzfDirectDeclareService.getTaskStatus(responseMap, type)).getErrorCode())) {
                logger.info("yzf\u5904\u7406\u4e2d" + JsonUtil.toJson((Object)apiResult));
                StringBuilder msg = new StringBuilder();
                if (kd.bos.util.StringUtils.isNotEmpty((String)apiResult.getMessage())) {
                    msg.append(apiResult.getMessage());
                }
                if ("5".equals(type)) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declaring", "1", msg);
                } else if ("8".equals(type)) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "paying", "1", msg);
                }
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7ed3\u679c\u5904\u7406\u5f02\u5e38, %s", (String)"YzfDirectDeclareService_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            if (response != null) {
                logger.error("\u67e5\u8be2\u7ed3\u679c\uff1a" + response);
            }
            logger.error(message);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult undo(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("qyid", vo.getQybdid());
            paramMap.put("kjnd", DateUtils.getYearOfDate((Date)vo.getSkssqz()));
            paramMap.put("kjqj", DateUtils.getMonthOfDate((Date)vo.getSkssqz()));
            paramMap.put("sbbmc", YzfMessageSendConstant.getTaxTypeMap().get(vo.getBusinessType()));
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("yzf_app_Code");
            String baseUrl = (String)configMap.get("yzf_base_url");
            String url = baseUrl + "/open/api/report/task/undo";
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("appCode", appCode);
            String response = YzfRequest.doPost(url, httpHeader, JsonUtil.toJson(paramMap));
            if (org.apache.commons.lang.StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4f5c\u5e9f\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(responseMap.get("code")) ? YzfDirectDeclareService.dealResponse(vo, "11") : CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "3", false);
            } else {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4f5c\u5e9f\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u6f0f\u62a5\u68c0\u67e5\u5904\u7406\u5f02\u5e38, %s", (String)"YzfDirectDeclareService_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            logger.error("\u4e0b\u53d1\u4f5c\u5e9f\u4efb\u52a1\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(message);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult addSbQzsbBean(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            ArrayList paramMaps = new ArrayList();
            if (CollectionUtils.isNotEmpty(vo.getForceCodes())) {
                for (String forceCode : vo.getForceCodes()) {
                    HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                    paramMap.put("qymc", vo.getOrgName());
                    paramMap.put("qyId", vo.getQybdid());
                    paramMap.put("kjnd", DateUtils.getYearOfDate((Date)vo.getSkssqz()));
                    paramMap.put("kjqj", DateUtils.getMonthOfDate((Date)vo.getSkssqz()));
                    paramMap.put("forceCode", forceCode);
                    paramMap.put("nsqxdm", YzfDirectDeclareService.getTaxLimit(vo.getSkssqq(), vo.getSkssqz()));
                    paramMap.put("sbbname", YzfMessageSendConstant.getTaxTypeMap().get(vo.getBusinessType()));
                    String areaCode = (String)YzfMessageSendConstant.getXzqhMap().get(vo.getSbdq());
                    if (org.apache.commons.lang.StringUtils.isNotBlank((String)areaCode)) {
                        paramMap.put("areaCode", areaCode.substring(0, 2));
                    }
                    paramMaps.add(paramMap);
                }
                Map configMap = CommonInfoUtil.getCommonConfigInfo();
                String appCode = (String)configMap.get("yzf_app_Code");
                String baseUrl = (String)configMap.get("yzf_base_url");
                String url = baseUrl + "/open/api/report/task/addSbQzsbBean";
                HashMap<String, String> httpHeader = new HashMap<String, String>();
                httpHeader.put("appCode", appCode);
                String response = YzfRequest.doPost(url, httpHeader, JsonUtil.toJson(paramMaps));
                if (org.apache.commons.lang.StringUtils.isBlank((String)response)) {
                    String message = ResManager.loadKDString((String)"\u5f3a\u5236\u7533\u62a5\u914d\u7f6e\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_21", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    return CustomApiResult.dealResponse(null, message, "3", false);
                }
                Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
                if (responseMap != null) {
                    apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "4", true) : CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "3", false);
                } else {
                    String message = ResManager.loadKDString((String)"\u5f3a\u5236\u7533\u62a5\u914d\u7f6e\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_21", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                }
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u4f01\u4e1a\u5904\u7406\u5f02\u5e38, %s", (String)"YzfDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            logger.error("\u65b0\u589e\u4f01\u4e1a\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(message);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult addJdxxTask(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("qyid", vo.getQybdid());
            paramMap.put("kjnd", DateUtils.getYearOfDate((Date)new Date()));
            paramMap.put("kjqj", DateUtils.getMonthOfDate((Date)new Date()));
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("yzf_app_Code");
            String baseUrl = (String)configMap.get("yzf_base_url");
            String url = baseUrl + "/open/api/report/task/addJdxxTask";
            HashMap<String, String> httpHeader = new HashMap<String, String>();
            httpHeader.put("appCode", appCode);
            String response = YzfRequest.doPost(url, httpHeader, JsonUtil.toJson(paramMap));
            if (org.apache.commons.lang.StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4f01\u4e1a\u9274\u5b9a\u4fe1\u606f\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_22", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(responseMap.get("code")) ? YzfDirectDeclareService.dealResponse(vo, "2") : CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "3", false);
            } else {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4f01\u4e1a\u9274\u5b9a\u4fe1\u606f\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfDirectDeclareService_22", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u9274\u5b9a\u4fe1\u606f\u4efb\u52a1\u5904\u7406\u5f02\u5e38, %s", (String)"YzfDirectDeclareService_23", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            logger.error("\u4e0b\u53d1\u4f01\u4e1a\u9274\u5b9a\u4fe1\u606f\u4efb\u52a1\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(message);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static String buildUrlParams(Map<String, Object> paramMap) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, Object>> iterator = paramMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> item = iterator.next();
            stringBuilder.append(item.getKey()).append('=').append(item.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }

    private static ApiResult getTaskStatus(Map<String, Object> responseMap, String type) {
        ApiResult apiResult = new ApiResult();
        if (!org.apache.commons.lang.StringUtils.equals((String)"0", (String)String.valueOf(responseMap.get("code")))) {
            apiResult = CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "3", false);
        } else {
            Map statusMap;
            Map result = (Map)responseMap.get("result");
            if (result != null && (statusMap = (Map)result.get("status")) != null) {
                String status = null;
                String message = String.valueOf(result.get("message"));
                boolean isSuccess = true;
                for (Map.Entry entry : statusMap.entrySet()) {
                    status = (String)entry.getKey();
                    if (status == null) continue;
                    if (message == null || "null".equals(message)) {
                        message = " ";
                    }
                    message = message + entry.getValue().toString();
                    message = message.replace("<br/>", "");
                    break;
                }
                if ("3".equals(status) || "0".equals(status)) {
                    isSuccess = false;
                    status = "3";
                } else if ("2".equals(status)) {
                    status = "4";
                } else if ("1".equals(status)) {
                    status = "2";
                } else if ("4".equals(status) || org.apache.commons.lang.StringUtils.isBlank((String)status)) {
                    status = "1";
                }
                apiResult = CustomApiResult.dealResponse(JSONObject.toJSONString((Object)result), message, status, isSuccess);
            }
        }
        return apiResult;
    }

    private static ApiResult getCertificateTaskStatus(Map<String, Object> responseMap) {
        ApiResult apiResult;
        String status = String.valueOf(responseMap.get("code"));
        boolean isSuccess = true;
        if ("0".equals(status)) {
            status = "4";
        } else if ("1".equals(status)) {
            status = "2";
        } else {
            isSuccess = false;
            status = "3";
        }
        if (responseMap.get("result") != null) {
            List result = (List)responseMap.get("result");
            apiResult = CustomApiResult.dealResponse(JSONObject.toJSONString((Object)result), String.valueOf(responseMap.get("message")), status, isSuccess);
        } else {
            apiResult = CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), status, isSuccess);
        }
        return apiResult;
    }

    private static String getTaxLimit(Date skssqq, Date skssqz) {
        String taxLimit = DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz);
        if ("season".equals(taxLimit)) {
            return "2";
        }
        if ("year".equals(taxLimit)) {
            return "4";
        }
        if ("month".equals(taxLimit)) {
            return "1";
        }
        if ("single".equals(taxLimit)) {
            return "5";
        }
        if ("halfyear".equals(taxLimit)) {
            return "3";
        }
        return "";
    }

    private static void dealAreaCode(SBMessageBaseVo vo, Map<String, Object> paramMap) {
        String areaCode;
        DynamicObject obj;
        String nsrsbh;
        String sbdq = vo.getSbdq();
        if ((kd.bos.util.StringUtils.isEmpty((String)sbdq) || "null".equals(sbdq)) && (nsrsbh = vo.getNsrsbh()) != null && (obj = CommonInfoUtil.getAreaInfoByNsrsbh((String)nsrsbh)) != null) {
            sbdq = obj.getString("xzqh");
            vo.setSbdq(sbdq);
        }
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)(areaCode = (String)YzfMessageSendConstant.getXzqhMap().get(vo.getSbdq())))) {
            paramMap.put("areaCode", areaCode.substring(0, 2));
        }
    }
}

