/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.common.constant.RequestResult;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.constant.ErrorCode;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.exception.MessageException;
import kd.taxc.tsate.msmessage.service.MessageSendService;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.service.YzfDirectDeclareService;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import kd.taxc.tsate.msmessage.util.SbpzRecordSaveUtils;
import kd.taxc.tsate.msxml.util.XmlTJsonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class YzfMessageSendServiceImpl
implements MessageSendService {
    private static Log logger = LogFactory.getLog(YzfMessageSendServiceImpl.class);
    private static final String DECLARESTATUS = "declarestatus";
    private static final String PAYSTATUS = "paystatus";

    @Override
    public ApiResult sendMessage(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38%s\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"YzfMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), System.getProperty("line.separator"));
                failedLog.append(msg);
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                return result;
            }
            YzfMessageSendServiceImpl.dealCompanyInfo(vo, identityData, failedLog);
            Boolean isQuery = vo.getQuery();
            logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            logger.info("yzf\u7533\u62a5\u7b2c\u4e8c\u6b65,\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
            result = YzfMessageSendServiceImpl.dealGetStatus(vo, "5");
            logger.info("\u7533\u62a5\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("yzf\u7533\u62a5\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5" + vo.getNsrsbh());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
                YzfMessageSendServiceImpl.dealPicxx(vo.getId(), result.getData());
            } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode()) || StringUtils.equals((String)"1", (String)result.getErrorCode())) {
                logger.info("\u7533\u62a5\u5931\u8d25" + JsonUtil.toJson((Object)result));
                if (isQuery.booleanValue()) {
                    DynamicObject declare;
                    if (StringUtils.equals((String)"3", (String)result.getErrorCode()) || !result.getSuccess()) {
                        logger.info("\u7533\u62a5\u5931\u8d25-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
                        result.setErrorCode(ErrorCode.FAIL.getCode());
                        result.setSuccess(false);
                        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"YzfMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(System.getProperty("line.separator")).append(result.getMessage());
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                        YzfMessageSendServiceImpl.dealPicxx(vo.getId(), result.getData());
                    } else if (StringUtils.equals((String)"1", (String)result.getErrorCode()) && (declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx")) != null && "declaring".equals(declare.getString(DECLARESTATUS))) {
                        YzfMessageSendServiceImpl.tryDeclare(result, vo, identityData, failedLog);
                    }
                } else {
                    logger.info("yzf\u7533\u62a5\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25\uff0c\u91cd\u65b0\u7533\u62a5" + vo.getNsrsbh());
                    YzfMessageSendServiceImpl.tryDeclare(result, vo, identityData, failedLog);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458", (String)"YzfMessageSendServiceImpl_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            failedLog.append(e.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult paymentRequest(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"YzfMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh());
                failedLog.append(msg).append(String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38%s\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"YzfMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), System.getProperty("line.separator")));
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
                return result;
            }
            YzfMessageSendServiceImpl.dealCompanyInfo(vo, identityData, failedLog);
            logger.info("yzf\u6263\u6b3e\u7b2c\u4e00\u6b65,\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
            Boolean isQuery = vo.getQuery();
            logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            result = YzfMessageSendServiceImpl.dealGetStatus(vo, "8");
            logger.info("\u6263\u6b3e\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("yzf\u6263\u6b3e\u7b2c\u4e8c\u6b65,\u72b6\u6001\u4e3a\u6263\u6b3e\u6210\u529f\uff0c\u66f4\u65b0\u6263\u6b3e\u72b6\u6001" + vo.getNsrsbh());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "paid", "2", failedLog);
                YzfMessageSendServiceImpl.dealPicxx(vo.getId(), result.getData());
            } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode()) || StringUtils.equals((String)"1", (String)result.getErrorCode())) {
                logger.info("\u7f34\u6b3e\u5931\u8d25" + JsonUtil.toJson((Object)result));
                if (isQuery.booleanValue()) {
                    DynamicObject declare;
                    if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                        logger.info("\u7f34\u6b3e\u5931\u8d25-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
                        result.setErrorCode(ErrorCode.FAIL.getCode());
                        result.setSuccess(false);
                        String msg = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s %2$s\u7f34\u6b3e\u5931\u8d25\uff1a%3$s", (String)"YzfMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), System.getProperty("line.separator"), result.getMessage());
                        failedLog.append(msg);
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
                        YzfMessageSendServiceImpl.dealPicxx(vo.getId(), result.getData());
                    } else if (StringUtils.equals((String)"1", (String)result.getErrorCode()) && (declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx")) != null && "paying".equals(declare.getString(PAYSTATUS))) {
                        this.tryPay(vo, result, failedLog, identityData);
                    }
                } else {
                    this.tryPay(vo, result, failedLog, identityData);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a%2$s", (String)"YzfMessageSendServiceImpl_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult verify(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38%s\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"YzfMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), System.getProperty("line.separator"));
                failedLog.append(msg);
                result.setSuccess(false);
                result.setMessage(failedLog.toString());
                return result;
            }
            result = YzfMessageSendServiceImpl.dealCompanyInfo(vo, identityData, failedLog);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a%2$s", (String)"YzfMessageSendServiceImpl_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            result.setMessage(message);
            failedLog.append(message);
        }
        return result;
    }

    @Override
    public ApiResult screenshot(SBMessageBaseVo vo) {
        return null;
    }

    @Override
    public ApiResult downloadVoucher(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38%s\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"YzfMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), System.getProperty("line.separator"));
                failedLog.append(msg);
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                return result;
            }
            YzfMessageSendServiceImpl.dealCompanyInfo(vo, identityData, failedLog);
            logger.info("yzf\u7533\u62a5\u51ed\u8bc1\u4e0b\u8f7d\u5f00\u59cb" + vo.getNsrsbh());
            result = YzfDirectDeclareService.addCertificateTask(vo, identityData);
            logger.info("yzf\u7533\u62a5\u51ed\u8bc1\u4e0b\u7ed3\u675f" + vo.getNsrsbh());
            logger.info("yzf\u7533\u62a5\u51ed\u8bc1\u4e0b\u7ed3\u675f" + JsonUtil.toJson((Object)result));
            if (result.getSuccess()) {
                if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                    logger.info("yzf\u4e0b\u8f7d\u5b8c\u7a0e\u51ed\u8bc1\u6210\u529f" + vo.getNsrsbh());
                    YzfMessageSendServiceImpl.dealAttachment(vo, result, failedLog);
                } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                    logger.info("yzf\u4e0b\u8f7d\u5b8c\u7a0e\u51ed\u8bc1\u5931\u8d25" + vo.getNsrsbh());
                    failedLog.append(result.getMessage());
                    DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                }
            } else {
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setSuccess(false);
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"YzfMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(System.getProperty("line.separator")).append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a%2$s", (String)"YzfMessageSendServiceImpl_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult refresh(SBMessageBaseVo vo) {
        ApiResult result;
        block33: {
            result = new ApiResult();
            StringBuilder failedLog = new StringBuilder();
            try {
                Long minutes;
                DynamicObject declare;
                IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
                if (identityData == null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38%s\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"YzfMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), System.getProperty("line.separator"));
                    failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"YzfMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(msg);
                    DirectDeclareLogUtils.uploadLogById(failedLog, vo.getId());
                    return result;
                }
                YzfMessageSendServiceImpl.dealCompanyInfo(vo, identityData, failedLog);
                if ("wspz".equals(vo.getName()) || "sbbfile".equals(vo.getName())) {
                    return this.syncSbpzStatus(vo);
                }
                logger.info("yzf\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
                if ("directdeclare".equals(vo.getName())) {
                    result = YzfMessageSendServiceImpl.dealGetStatus(vo, "5");
                } else if ("fastpay".equals(vo.getName())) {
                    result = YzfMessageSendServiceImpl.dealGetStatus(vo, "8");
                } else if ("undo".equals(vo.getName())) {
                    result = YzfMessageSendServiceImpl.dealGetStatus(vo, "11");
                } else if ("sfzhdxx".equals(vo.getName())) {
                    result = YzfMessageSendServiceImpl.dealGetStatus(vo, "2");
                }
                logger.info("yzf\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
                if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                    logger.info("yzf\u5904\u7406\u6210\u529f" + vo.getNsrsbh());
                    failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"YzfMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(System.getProperty("line.separator")).append(result.getMessage());
                    if ("directdeclare".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
                    } else if ("fastpay".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "paid", "2", failedLog);
                    } else if ("undo".equals(vo.getName())) {
                        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelDeclare", (Object[])new Object[]{Collections.singletonList(Long.valueOf(vo.getBusinessId()))});
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "editing", "2", failedLog);
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "unpaid", "2", failedLog);
                    } else if ("sfzhdxx".equals(vo.getName())) {
                        logger.info("szyh\u4e0b\u8f7d\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u6210\u529f" + vo.getNsrsbh());
                        Object data = result.getData();
                        if (data != null) {
                            Map dataMap = (Map)JsonUtil.fromJson((String)((String)data), Map.class);
                            result = this.dealVerificationData(vo, dataMap, failedLog);
                            if (result.getSuccess()) {
                                DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
                            } else {
                                failedLog.append(result.getMessage());
                                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                            }
                        }
                    }
                    YzfMessageSendServiceImpl.dealPicxx(vo.getId(), result.getData());
                } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                    logger.info("yzf\u5904\u7406\u5931\u8d25" + JsonUtil.toJson((Object)result));
                    result.setErrorCode(ErrorCode.FAIL.getCode());
                    result.setSuccess(false);
                    String msg = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s %2$s\u5904\u7406\u5931\u8d25\uff1a%3$s", (String)"YzfMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), System.getProperty("line.separator"), result.getMessage());
                    failedLog.append(msg);
                    if ("directdeclare".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                    } else if ("fastpay".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
                    } else if ("undo".equals(vo.getName()) || "sfzhdxx".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                    }
                    YzfMessageSendServiceImpl.dealPicxx(vo.getId(), result.getData());
                } else if (StringUtils.equals((String)"1", (String)result.getErrorCode()) && "directdeclare".equals(vo.getName()) && (declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx")) != null && "submitted".equals(declare.getString(DECLARESTATUS)) && (minutes = Long.valueOf(Duration.between(declare.getDate("sbrq").toInstant(), Instant.now()).toMinutes())) > 5L) {
                    logger.info("yzf\u65e0\u7533\u62a5\u8bb0\u5f55\u4e14\u8d85\u65f65\u5206\u949f\uff0c\u91cd\u65b0\u53d1\u8d77\u7533\u62a5" + vo.getNsrsbh());
                    YzfMessageSendServiceImpl.tryDeclare(result, vo, identityData, failedLog);
                }
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + ExceptionUtil.toString((Exception)e));
                String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a%2$s", (String)"YzfMessageSendServiceImpl_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setMessage(message);
                failedLog.append(message);
                if ("directdeclare".equals(vo.getName())) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                }
                if ("fastpay".equals(vo.getName())) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
                }
                if (!"undo".equals(vo.getName()) && !"sfzhdxx".equals(vo.getName())) break block33;
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
        }
        return result;
    }

    @Override
    public ApiResult undo(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38%s\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"YzfMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), System.getProperty("line.separator"));
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"YzfMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(msg);
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
                return result;
            }
            YzfMessageSendServiceImpl.dealCompanyInfo(vo, identityData, failedLog);
            logger.info("yzf\u7a0e\u5c40\u4f5c\u5e9f\u7b2c\u4e00\u6b65,\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
            Boolean isQuery = vo.getQuery();
            logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            result = YzfMessageSendServiceImpl.dealGetStatus(vo, "11");
            logger.info("yzf\u7a0e\u5c40\u4f5c\u5e9f\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("yzfyzf\u7a0e\u5c40\u4f5c\u5e9f\u7b2c\u4e8c\u6b65,\u72b6\u6001\u4e3a\u4f5c\u5e9f\u6210\u529f\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001" + vo.getNsrsbh());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelDeclare", (Object[])new Object[]{Collections.singletonList(Long.valueOf(vo.getBusinessId()))});
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "editing", "2", failedLog);
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "unpaid", "2", failedLog);
            } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode()) || StringUtils.equals((String)"1", (String)result.getErrorCode())) {
                logger.info("\u4f5c\u5e9f\u5931\u8d25" + JsonUtil.toJson((Object)result));
                this.tryUndo(vo, result, failedLog, identityData);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a%2$s", (String)"YzfMessageSendServiceImpl_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult addSbQzsbBean(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38%s\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"YzfMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), System.getProperty("line.separator"));
                failedLog.append(msg);
                result.setSuccess(false);
                result.setMessage(failedLog.toString());
                return result;
            }
            YzfMessageSendServiceImpl.dealCompanyInfo(vo, identityData, failedLog);
            result = YzfDirectDeclareService.addSbQzsbBean(vo);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a%2$s", (String)"YzfMessageSendServiceImpl_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            result.setMessage(message);
            failedLog.append(message);
        }
        return result;
    }

    @Override
    public ApiResult downloadVerification(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38%s\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"YzfMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), System.getProperty("line.separator"));
                failedLog.append(msg);
                result.setSuccess(false);
                result.setMessage(failedLog.toString());
                return result;
            }
            YzfMessageSendServiceImpl.dealCompanyInfo(vo, identityData, failedLog);
            result = YzfDirectDeclareService.addJdxxTask(vo);
            if (!result.getSuccess()) {
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"YzfMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a%2$s", (String)"YzfMessageSendServiceImpl_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    private static ApiResult dealGetStatus(SBMessageBaseVo vo, String type) throws Exception {
        ApiResult result = YzfDirectDeclareService.queryTaskStatus(vo, type);
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u83b7\u53d6\u72b6\u6001\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int times = 0;
                do {
                    ++times;
                    result = YzfDirectDeclareService.queryTaskStatus(vo, type);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && times <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(result.getData(), result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(result.getData(), result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static void tryDeclare(ApiResult result, SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) throws Exception {
        result = YzfMessageSendServiceImpl.dealDeclare(vo, identityData, failedLog);
        if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
            logger.info("yzf\u7533\u62a5\u7b2c\u56db\u6b65,\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5" + vo.getNsrsbh());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
            YzfMessageSendServiceImpl.dealPicxx(vo.getId(), result.getData());
        } else if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
            logger.info("yzf\u7533\u62a5\u7b2c\u56db\u6b65,\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25" + vo.getNsrsbh());
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"YzfMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(System.getProperty("line.separator")).append(result.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
            YzfMessageSendServiceImpl.dealPicxx(vo.getId(), result.getData());
        }
    }

    private static ApiResult dealDeclare(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) throws Exception {
        ApiResult result = YzfDirectDeclareService.declare(vo);
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u7533\u62a5\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int times = 0;
                do {
                    ++times;
                    result = YzfDirectDeclareService.declare(vo);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && times <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(result.getData(), result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(result.getData(), result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static ApiResult dealCompanyInfo(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_register", (String)"id,authorizationcode", (QFilter[])new QFilter[]{new QFilter("nsrsbh", "=", (Object)vo.getNsrsbh()).and(new QFilter("channel", "=", (Object)SupplierEnum.YZF.getCode()))});
        ApiResult result = new ApiResult();
        if (obj == null) {
            result = YzfDirectDeclareService.addCompany(identityData, vo);
            if (!result.getSuccess()) {
                failedLog.append(result.getMessage());
                return result;
            }
            obj = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_register");
            DynamicObject channelObj = BusinessDataServiceHelper.loadSingle((String)"tsate_channel", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)SupplierEnum.YZF.getCode())});
            if (channelObj != null) {
                obj.set("channel", (Object)SupplierEnum.YZF.getCode());
                obj.set("declarechannel", (Object)channelObj.getLong("id"));
            }
            obj.set("nsrsbh", (Object)vo.getNsrsbh());
            obj.set("authorizationcode", (Object)String.valueOf(result.getData()));
            String qyId = obj.getString("authorizationcode");
            vo.setQybdid(String.valueOf(qyId));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        } else {
            String qyId = obj.getString("authorizationcode");
            vo.setQybdid(String.valueOf(qyId));
            if ("verify".equals(vo.getName())) {
                result = YzfDirectDeclareService.modifyCompany(vo, identityData);
            }
        }
        return result;
    }

    private ApiResult tryPay(SBMessageBaseVo vo, ApiResult result, StringBuilder failedLog, IdentityData identityData) throws Exception {
        logger.info("yzf\u6263\u6b3e\u7b2c\u4e8c\u6b65,\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u5931\u8d25\uff0c\u91cd\u65b0\u7f34\u6b3e" + vo.getNsrsbh());
        result = YzfMessageSendServiceImpl.dealPay(vo, identityData, failedLog);
        if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
            logger.info("yzf\u6263\u6b3e\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u65e0\u9700\u6263\u6b3e\u6216\u6263\u6b3e\u6210\u529f\uff0c\u66f4\u65b0\u6263\u6b3e\u72b6\u6001" + vo.getNsrsbh());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "paid", "2", failedLog);
            YzfMessageSendServiceImpl.dealPicxx(vo.getId(), result.getData());
        } else if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
            logger.info("yzf\u6263\u6b3e\u7b2c\u4e09\u6b65,\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u5931\u8d25\uff0c\u66f4\u65b0\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u5931\u8d25" + vo.getNsrsbh());
            String msg = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s %2$s\u7f34\u6b3e\u5931\u8d25\uff1a%3$s", (String)"YzfMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), System.getProperty("line.separator"), result.getMessage());
            failedLog.append(msg);
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
            YzfMessageSendServiceImpl.dealPicxx(vo.getId(), result.getData());
        }
        return result;
    }

    private ApiResult tryUndo(SBMessageBaseVo vo, ApiResult result, StringBuilder failedLog, IdentityData identityData) throws Exception {
        logger.info("yzf\u4f5c\u5e9f\u7b2c\u4e8c\u6b65,\u4f5c\u5e9f\u72b6\u6001\u4e3a\u5931\u8d25\uff0c\u91cd\u65b0\u4f5c\u5e9f" + vo.getNsrsbh());
        result = YzfMessageSendServiceImpl.dealUndo(vo, identityData, failedLog);
        if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
            logger.info("yzf\u4f5c\u5e9f\u7b2c\u4e09\u6b65,\u72b6\u6001\u4f5c\u5e9f\u6210\u529f\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001" + vo.getNsrsbh());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "editing", "2", failedLog);
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "unpaid", "2", failedLog);
        } else if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
            logger.info("yzf\u4f5c\u5e9f\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u4f5c\u5e9f\u5931\u8d25" + vo.getNsrsbh());
            String msg = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s\u4f5c\u5e9f\u5931\u8d25\uff1a%2$s %3$s", (String)"YzfMessageSendServiceImpl_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), System.getProperty("line.separator"), result.getMessage());
            failedLog.append(msg);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    private static ApiResult dealPay(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) throws Exception {
        ApiResult result = YzfDirectDeclareService.pay(vo);
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u7f34\u6b3e\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int times = 0;
                do {
                    ++times;
                    result = YzfDirectDeclareService.pay(vo);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && times <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(result.getData(), result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(result.getData(), result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static ApiResult dealUndo(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) throws Exception {
        ApiResult result = YzfDirectDeclareService.undo(vo);
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u7f34\u6b3e\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int times = 0;
                do {
                    ++times;
                    result = YzfDirectDeclareService.pay(vo);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && times <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(result.getData(), result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(result.getData(), result.getMessage(), "3", false);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void dealAttachment(SBMessageBaseVo vo, ApiResult result, StringBuilder failedLog) throws Exception {
        block23: {
            InputStream in;
            block21: {
                String msg;
                in = null;
                DecimalFormat format = new DecimalFormat("000");
                if (result.getSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
                    List screenUrlList = (List)JsonUtil.fromJson((String)String.valueOf(result.getData()), List.class);
                    if (EmptyCheckUtils.isNotEmpty((Object)screenUrlList)) {
                        DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((Object)vo.getId(), (String)"tsate_declare_record");
                        if (StringUtils.equals((String)recordObj.getString("executestatus"), (String)"1")) {
                            DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
                            String orgName = ((DynamicObject)org.get("org")).getString("name");
                            ArrayList<Map<String, Object>> files = new ArrayList<Map<String, Object>>(screenUrlList.size());
                            int idx = 1;
                            for (Map screenUrlMap : screenUrlList) {
                                HashMap<String, Object> fileMap = new HashMap<String, Object>(16);
                                String imgUrl = YzfMessageSendServiceImpl.dealWithGatewayUrl((String)screenUrlMap.get("url"));
                                URL url = new URL(imgUrl);
                                Map configMap = CommonInfoUtil.getCommonConfigInfo();
                                String proxyUrl = (String)configMap.get("kd_file_proxy");
                                if (StringUtils.isNotEmpty((String)proxyUrl)) {
                                    String[] values = proxyUrl.trim().split(":");
                                    if (values.length < 2) {
                                        throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u914d\u7f6e\u683c\u5f0f\u9519\u8bef", (String)"YzfMessageSendServiceImpl_24", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                                    }
                                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(values[0], Integer.parseInt(values[1])));
                                    in = url.openConnection(proxy).getInputStream();
                                } else {
                                    in = url.openStream();
                                }
                                StringBuilder sb = new StringBuilder(vo.getPzTypeName());
                                sb.append("-").append(format.format(idx));
                                sb.append(".").append((String)screenUrlMap.get("typeDesc"));
                                fileMap.put("inputstream", in);
                                fileMap.put("orgName", orgName);
                                fileMap.put("filename", sb.toString());
                                files.add(fileMap);
                                ++idx;
                            }
                            if (CollectionUtils.isNotEmpty(files)) {
                                SbpzRecordSaveUtils.saveRecordBatch(vo, files, failedLog);
                            }
                        }
                    } else {
                        msg = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s %2$s \u6682\u65e0\u9644\u4ef6\u622a\u56fe", (String)"YzfMessageSendServiceImpl_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), System.getProperty("line.separator"));
                        failedLog.append(msg);
                        DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                    }
                }
                if (in == null) break block21;
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                    msg = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"YzfMessageSendServiceImpl_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh());
                    failedLog.append(msg);
                    DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                }
                break block23;
            }
            String msg = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"YzfMessageSendServiceImpl_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh());
            failedLog.append(msg);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            break block23;
            catch (Exception e) {
                block22: {
                    String msg2;
                    try {
                        logger.error("\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458", (Throwable)e);
                        msg2 = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u5904\u7406\u9644\u4ef6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458", (String)"YzfMessageSendServiceImpl_15", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh());
                        failedLog.append(msg2);
                        DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                        if (in == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e2);
                                String msg3 = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"YzfMessageSendServiceImpl_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh());
                                failedLog.append(msg3);
                                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                            }
                        } else {
                            String msg4 = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"YzfMessageSendServiceImpl_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh());
                            failedLog.append(msg4);
                            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException e3) {
                        logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e3);
                        msg2 = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"YzfMessageSendServiceImpl_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh());
                        failedLog.append(msg2);
                        DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                    }
                }
                msg = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"YzfMessageSendServiceImpl_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh());
                failedLog.append(msg);
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
        }
    }

    private static void dealPicxx(Long recordId, Object result) {
        Map returnMap;
        if (result != null && EmptyCheckUtils.isNotEmpty((Object)result) && (returnMap = (Map)JsonUtil.fromJson((String)((String)result), Map.class)) != null) {
            Object imageUrlList = returnMap.get("imageUrlList");
            Object forceCodeList = returnMap.get("forceCodeList");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            if (EmptyCheckUtils.isNotEmpty(imageUrlList)) {
                dataMap.put("imageUrlList", imageUrlList);
            }
            if (EmptyCheckUtils.isNotEmpty(forceCodeList)) {
                dataMap.put("forceCodeList", forceCodeList);
            }
            DirectDeclareLogUtils.dealPicxx(dataMap, recordId);
        }
    }

    private ApiResult syncSbpzStatus(SBMessageBaseVo vo) throws Exception {
        StringBuilder failedLog = new StringBuilder();
        ApiResult result = YzfDirectDeclareService.getCertificateTaskUrls(vo);
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("tsate\u5b9a\u65f6\u4efb\u52a1 yzf\u4e0b\u8f7d\u5b8c\u7a0e\u51ed\u8bc1\u6210\u529f" + vo.getNsrsbh());
                YzfMessageSendServiceImpl.dealAttachment(vo, result, failedLog);
            } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("tsate\u5b9a\u65f6\u4efb\u52a1 yzf\u4e0b\u8f7d\u5b8c\u7a0e\u51ed\u8bc1\u5931\u8d25" + vo.getNsrsbh());
                failedLog.append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"YzfMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(System.getProperty("line.separator")).append(result.getMessage());
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    private ApiResult dealVerificationData(SBMessageBaseVo vo, Map<String, Object> map, StringBuilder failedLog) throws MessageException {
        MessageSend send = new MessageSend();
        send.setMsgtype("verification");
        send.setBusinessid(vo.getBusinessId());
        send.setBusinesstype("verification");
        send.setNsrType(vo.getType());
        send.setNodetype(vo.getSbdq());
        send.setSupplier(SupplierEnum.YZF.getName());
        String sfzhdData = MessageService.collectionHistoryData(send, map, vo.getNsrsbh());
        Map<String, Object> sbbDataRootMap = XmlTJsonUtil.xml2ObjectMap(sfzhdData);
        Map sfzhdMap = (Map)sbbDataRootMap.get("Root");
        return this.dealSfzhdxxObj(sfzhdMap, vo, failedLog);
    }

    private ApiResult dealSfzhdxxObj(Map<String, Object> sfzhdMap, SBMessageBaseVo vo, StringBuilder failedLog) {
        ApiResult apiResult;
        if (sfzhdMap != null && sfzhdMap.size() > 0) {
            HashMap<String, Long> saveMap = new HashMap<String, Long>();
            saveMap.put("orgId", Long.valueOf(vo.getOrg()));
            logger.info("\u4fdd\u5b58\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u4efb\u52a1\u5f00\u59cb" + vo.getNsrsbh());
            String response = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxtypeCardService", (String)"save", (Object[])new Object[]{SerializationUtils.toJsonString(sfzhdMap), SerializationUtils.toJsonString(saveMap)});
            logger.info("\u4e0b\u8f7d\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u4efb\u52a1\u5b8c\u6210" + response);
            if (EmptyCheckUtils.isNotEmpty((Object)response)) {
                RequestResult result = (RequestResult)SerializationUtils.fromJsonString((String)response, RequestResult.class);
                if (result.getSuccess()) {
                    HashMap<String, String> extensionParams = new HashMap<String, String>();
                    extensionParams.put("isAuto", "1");
                    logger.info("\u5f00\u59cb\u8fdb\u884c\u5dee\u5f02\u6bd4\u5bf9----" + vo.getNsrsbh());
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxtypeCardService", (String)"compare", (Object[])new Object[]{SerializationUtils.toJsonString((Object)result.getData()), SerializationUtils.toJsonString(extensionParams)});
                    logger.info("\u7ed3\u675f\u5dee\u5f02\u6bd4\u5bf9----" + vo.getNsrsbh());
                    apiResult = CustomApiResult.dealResponse(null, null, "4", true);
                } else {
                    failedLog.append(ResManager.loadKDString((String)"\u4e0b\u8f7d\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u4efb\u52a1\u4fdd\u5b58\u5931\u8d25", (String)"YzfMessageSendServiceImpl_20", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    apiResult = CustomApiResult.dealResponse(null, failedLog.toString(), "3", false);
                }
            } else {
                failedLog.append(ResManager.loadKDString((String)"\u4e0b\u8f7d\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u4efb\u52a1\u4fdd\u5b58\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfMessageSendServiceImpl_21", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                apiResult = CustomApiResult.dealResponse(null, failedLog.toString(), "3", false);
            }
        } else {
            failedLog.append(ResManager.loadKDString((String)"\u4e0b\u8f7d\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u6570\u636e\u8fd4\u56de\u4e3a\u7a7a", (String)"YzfMessageSendServiceImpl_22", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            apiResult = CustomApiResult.dealResponse(null, failedLog.toString(), "3", false);
        }
        return apiResult;
    }

    private static String dealWithGatewayUrl(String urlStr) {
        try {
            QFilter filter = new QFilter("key", "=", (Object)"yzf_gateway_url");
            DynamicObject obj = QueryServiceHelper.queryOne((String)"tsate_param_setting", (String)"key,value", (QFilter[])new QFilter[]{filter});
            if (obj == null || obj.getString("value") == null) {
                return urlStr;
            }
            String gatewayUrl = obj.getString("value");
            if (kd.bos.util.StringUtils.isEmpty((String)gatewayUrl)) {
                return urlStr;
            }
            URL originUrl = new URL(urlStr);
            if (gatewayUrl.endsWith("/")) {
                gatewayUrl = gatewayUrl.substring(0, gatewayUrl.length() - 1);
            }
            int subIndex = urlStr.indexOf(originUrl.getPath());
            String targetUrl = gatewayUrl + urlStr.substring(subIndex);
            logger.info("\u5df2\u53d8\u66f4\u4e3a\u7f51\u5173URL" + targetUrl);
            return targetUrl;
        }
        catch (MalformedURLException e) {
            logger.error(urlStr + " \u8f6c\u6362url\u5f02\u5e38");
            return urlStr;
        }
    }
}

