/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.gxdzsj;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.common.enums.RequestTypeEnum;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.constant.ErrorCode;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.service.MessageSendService;
import kd.taxc.tsate.msmessage.service.gxdzsj.GxsjDeclareService;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.QcInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.VoucherInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.YjsfInfo;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import kd.taxc.tsate.msmessage.util.SbpzRecordSaveUtils;
import org.apache.commons.lang.StringUtils;

public class GxdzsjDeclareFromZzsynbsr
implements MessageSendService {
    private static final Log logger = LogFactory.getLog(GxdzsjDeclareFromZzsynbsr.class);
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String DECLARESTATUS_PROPNAME = "declarestatus";
    private static final String PAYSTATUS_PROPNAME = "paystatus";

    @Override
    public ApiResult sendMessage(SBMessageBaseVo vo) {
        String status;
        ApiResult result = null;
        if (!this.checkIdentity(vo)) {
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38", (String)"GxdzsjDeclareFromZzsynbsr_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
            return result;
        }
        logger.info("gxsj\u7533\u62a5step1-\u540c\u6b65\u7a0e\u5c40\u72b6\u6001" + vo.getNsrsbh());
        ApiResult statusResult = this.synchStatusBeforeDeclare(vo);
        String string = status = statusResult.getData() != null ? statusResult.getData().toString() : "unknown";
        if ("declared".equals(status)) {
            logger.info("gxsj\u7533\u62a5step1.1-\u540c\u6b65\u6210\u529f\uff0c\u5df2\u5b8c\u6210\u7533\u62a5\uff0c\u4e0d\u9700\u8981\u91cd\u65b0\u7533\u62a5" + vo.getNsrsbh());
            return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u6210\u529f", (String)"GxdzsjDeclareFromZzsynbsr_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
        }
        logger.info("gxsj\u7533\u62a5step2-\u5f00\u59cb\u5c1d\u8bd5\u7533\u62a5" + vo.getNsrsbh());
        result = GxdzsjDeclareFromZzsynbsr.tryDeclare(vo);
        return result;
    }

    @Override
    public ApiResult paymentRequest(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38", (String)"GxdzsjDeclareFromZzsynbsr_22", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()})).append(SEPARATOR).append(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"GxdzsjDeclareFromZzsynbsr_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "payfailed", "3", failedLog);
                return result;
            }
            logger.info("gxsj\u7f34\u6b3estep1-1 \u540c\u6b65\u7a0e\u5c40\u7f34\u6b3e\u72b6\u6001" + vo.getNsrsbh());
            ApiResult syncResult = this.synchStatusBeforPay(vo);
            logger.info("gxsj\u7f34\u6b3estep1-1 \u540c\u6b65\u7a0e\u5c40\u7f34\u6b3e\u7ed3\u679c" + JSON.toJSONString((Object)syncResult));
            if (!syncResult.getSuccess()) {
                logger.info("gxsj\u7f34\u6b3estep1-1 \u540c\u6b65\u7a0e\u5c40\u7f34\u6b3e\u5931\u8d25,\u8be6\u60c5\uff1a" + syncResult.getMessage());
                failedLog.append(ResManager.loadKDString((String)"\u7f34\u6b3e\u5931\u8d25\uff0c\u540c\u6b65\u7a0e\u5c40\u7f34\u6b3e\u72b6\u6001\u5f02\u5e38\uff0c\u8be6\u60c5:", (String)"GxdzsjDeclareFromZzsynbsr_11", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(syncResult.getMessage());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "payfailed", "3", failedLog);
                return syncResult;
            }
            String payStatus = syncResult.getData().toString();
            Boolean isQuery = vo.getQuery();
            logger.info("gxsj\u7f34\u6b3estep1-2 \u7f34\u6b3e\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            if (isQuery.booleanValue()) {
                logger.info("gxshs\u7f34\u6b3etep1-2 \u7f34\u6b3e\u72b6\u6001\u540c\u6b65\u7a0e\u5c40\u5b8c\u6210");
                return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f", (String)"GxdzsjDeclareFromZzsynbsr_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
            }
            if ("paid".equals(payStatus)) {
                logger.info("gxsh\u7f34\u6b3estep1-3 \u7f34\u6b3e\u5df2\u5b8c\u6210\uff0c\u4e0d\u9700\u8981\u91cd\u65b0\u53d1\u8d77");
                return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u7f34\u6b3e\u5df2\u5b8c\u6210", (String)"GxdzsjDeclareFromZzsynbsr_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
            }
            logger.info("gxsh\u7f34\u6b3estep1-3 \u5f00\u59cb\u5c1d\u8bd5\u7f34\u6b3e\u8bf7\u6c42");
            return GxdzsjDeclareFromZzsynbsr.tryPay(vo);
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.toString((Exception)e));
            return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u7f34\u6b3e\u5f02\u5e38\uff1a%s", (String)"GxdzsjDeclareFromZzsynbsr_8", (String)"taxc-tsate-mservice", (Object[])new Object[]{e.getMessage()}), "4", true);
        }
    }

    @Override
    public ApiResult verify(SBMessageBaseVo vo) {
        return null;
    }

    @Override
    public ApiResult screenshot(SBMessageBaseVo vo) {
        return null;
    }

    @Override
    public ApiResult downloadVoucher(SBMessageBaseVo vo) {
        logger.info("gxsj \u4e0b\u8f7d\u51ed\u8bc1step1-1 \u67e5\u8be2\u7a0e\u7968\u53f7");
        ApiResult payInfoResult = GxsjDeclareService.getPayInfo(vo, null);
        if (!payInfoResult.getSuccess()) {
            logger.error("gxsj \u4e0b\u8f7d\u51ed\u8bc1\u5931\u8d25-\u67e5\u8be2\u7a0e\u7968\u53f7\u5931\u8d25");
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", new StringBuilder(payInfoResult.getMessage()));
            return payInfoResult;
        }
        List payInfo = (List)payInfoResult.getData();
        HashSet<String> sphms = new HashSet<String>();
        for (Object yjsf : payInfo) {
            if (!kd.bos.util.StringUtils.isNotEmpty((String)((YjsfInfo)yjsf).getYpzh())) continue;
            sphms.add(((YjsfInfo)yjsf).getYpzh());
        }
        if (sphms.size() != 1) {
            logger.warn("gxsj \u4e0b\u8f7d\u51ed\u8bc1 \uff0c\u7a0e\u7968\u53f7\u5b58\u5728\u591a\u4e2a\uff0c\u53ef\u80fd\u672a\u7ecf\u8fc7\u7a0e\u4f01\u76f4\u8fde\u5e94\u7528\u6b63\u5e38\u7533\u62a5");
        }
        ArrayList<byte[]> fileContents = new ArrayList<byte[]>(16);
        for (String sphm : sphms) {
            logger.info("gxsj \u4e0b\u8f7d\u51ed\u8bc1step2-1 \u83b7\u53d6\u51ed\u8bc1\u6587\u4ef6");
            ApiResult voucherInfoResult = GxsjDeclareService.downloadVoucher(vo, sphm);
            if (!voucherInfoResult.getSuccess()) {
                logger.error("gxsj \u4e0b\u8f7d\u51ed\u8bc1\u5931\u8d25");
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", new StringBuilder(voucherInfoResult.getMessage()));
                return voucherInfoResult;
            }
            logger.info("gxsj \u4e0b\u8f7d\u51ed\u8bc1step2-2 \u89e3\u6790\u51ed\u8bc1\u6587\u4ef6");
            VoucherInfo voucherInfo = (VoucherInfo)voucherInfoResult.getData();
            String base64Content = voucherInfo.getLayoutFile();
            fileContents.add(Base64.getDecoder().decode(base64Content.getBytes(StandardCharsets.UTF_8)));
        }
        logger.info("gxsj \u4e0b\u8f7d\u51ed\u8bc1step3-1 \u4fdd\u5b58\u51ed\u8bc1\u6587\u4ef6");
        ApiResult saveResult = this.saveZspz(vo, "pdf", fileContents);
        if (!saveResult.getSuccess()) {
            logger.error("gxsj \u4e0b\u8f7d\u51ed\u8bc1\u5931\u8d25-\u4fdd\u5b58\u5931\u8d25," + saveResult.getMessage());
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", new StringBuilder(ResManager.loadKDString((String)"\u4fdd\u5b58\u51ed\u8bc1\u5f02\u5e38", (String)"GxdzsjDeclareFromZzsynbsr_21", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(saveResult.getMessage()));
            return saveResult;
        }
        logger.info("gxsj \u4e0b\u8f7d\u51ed\u8bc1\u5b8c\u6210");
        return CustomApiResult.dealResponse(null, null, "4", true);
    }

    @Override
    public ApiResult refresh(SBMessageBaseVo vo) {
        DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx");
        String declareStatus = declare.getString("declareStatus");
        String payStatus = declare.getString("payStatus");
        if ("declaring".equals(declareStatus) || "submitted".equals(declareStatus)) {
            return this.refreshDeclareStatus(vo);
        }
        if ("declared".equals(declareStatus) && ("paying".equals(payStatus) || "submitted".equals(payStatus))) {
            return this.refreshPayStatus(vo);
        }
        return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u8bb0\u5f55\u4e0d\u9700\u8981\u5237\u65b0\uff0c\u8df3\u8fc7", (String)"GxdzsjDeclareFromZzsynbsr_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
    }

    public ApiResult refreshDeclareStatus(SBMessageBaseVo vo) {
        ApiResult result = null;
        if (!this.checkIdentity(vo)) {
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38", (String)"GxdzsjDeclareFromZzsynbsr_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
            return result;
        }
        String declareStatus = "declaring";
        DynamicObject requestObj = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1");
        if (requestObj == null) {
            logger.warn("gxsj-\u7533\u62a5\u5df2\u5b8c\u6210\u72b6\u6001\u53cd\u5199\u6216\u7533\u62a5\u6b63\u5728\u6267\u884c\u4e2d,\u4e0d\u9700\u6267\u884c\u5237\u65b0");
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u4e0d\u9700\u8981\u5237\u65b0", (String)"GxdzsjDeclareFromZzsynbsr_9", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", false);
            return result;
        }
        Date now = new Date();
        Date createTime = requestObj.getDate("createtime");
        if (now.getTime() - createTime.getTime() <= 30000L) {
            logger.warn("gxsj-\u8ddd\u7533\u62a5\u63a5\u53e3\u8c03\u7528\u65f6\u95f4\u5c0f\u4e8e30s\uff0c\u63a5\u53e3\u6b63\u5728\u6267\u884c\u4e2d,\u4e0d\u9700\u6267\u884c\u5237\u65b0");
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u4e0d\u9700\u8981\u5237\u65b0", (String)"GxdzsjDeclareFromZzsynbsr_9", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", false);
            return result;
        }
        logger.info("gxsj\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
        result = GxsjDeclareService.getDeclareStatus(vo);
        logger.info("gxsj\u67e5\u8be2\u7ed3\u679c" + JSON.toJSONString((Object)result));
        String code = result.getData().toString();
        StringBuilder failedLog = new StringBuilder();
        failedLog.append(result.getMessage());
        result.setData((Object)declareStatus);
        switch (code) {
            case "3": {
                if (!"declaring".equals(declareStatus) && !"declared".equals(declareStatus) && !"submitted".equals(declareStatus)) break;
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS_PROPNAME, "declarefailed", "3", failedLog);
                result.setData((Object)"declarefailed");
                break;
            }
            case "4": {
                if (!"declared".equals(declareStatus)) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS_PROPNAME, "declared", "2", failedLog);
                }
                result.setData((Object)"declared");
                break;
            }
        }
        result.setErrorCode("4");
        result.setSuccess(true);
        return result;
    }

    public ApiResult refreshPayStatus(SBMessageBaseVo vo) {
        ApiResult statusResult;
        ApiResult result = null;
        if (!this.checkIdentity(vo)) {
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38", (String)"GxdzsjDeclareFromZzsynbsr_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
            return result;
        }
        StringBuilder failedLog = new StringBuilder();
        DynamicObject requestObj = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1", RequestTypeEnum.PAY);
        String requestId = null;
        if (requestObj == null) {
            logger.warn("gxsj-\u5237\u65b0\u7f34\u6b3e\u72b6\u6001\uff0c\u4f46\u662f\u672a\u67e5\u8be2\u5230\u6267\u884c\u4e2d\u7684request\u8bb0\u5f55");
            DynamicObject finishRequest = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "2", RequestTypeEnum.PAY);
            DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx");
            String paystatus = declare.getString(PAYSTATUS_PROPNAME);
            Date modifyTime = declare.getDate("modifytime");
            boolean continueRefresh = false;
            if ("paying".equals(paystatus) || "submitted".equals(paystatus)) {
                if (System.currentTimeMillis() - modifyTime.getTime() >= 120000L) {
                    continueRefresh = true;
                    logger.info("gxsj-\u5237\u65b0\u7f34\u6b3e\uff08continue\uff1f\uff09\u8bb0\u5f55\u5904\u4e8e\u7f34\u6b3e\u4e2d\u6216\u7f34\u6b3e\u5f85\u63d0\u4ea4\u72b6\u6001 \u4e14\u4fee\u65f6\u95f4\u8ddd\u5f53\u524d\u8d85\u8fc72\u5206\u949f\uff0c\u9700\u8981\u5237\u65b0");
                } else {
                    logger.info("gxsj-\u5237\u65b0\u7f34\u6b3e\uff08continue\uff1f\uff09\u8bb0\u5f55\u5904\u4e8e\u7f34\u6b3e\u4e2d\u6216\u7f34\u6b3e\u5f85\u63d0\u4ea4\u72b6\u6001 \u4e14\u4fee\u65f6\u95f4\u8ddd\u5f53\u524d\u5c0f\u4e8e2\u5206\u949f\uff0c\u4e0d\u9700\u8981\u5237\u65b0");
                }
            } else {
                logger.info("gxsj-\u5237\u65b0\u7f34\u6b3e(continue?) \u7533\u62a5\u8bb0\u5f55\u7684\u7f34\u6b3e\u72b6\u6001\u5df2\u5b8c\u6210\uff08\u975e\u7f34\u6b3e\u4e2d \u6216\u975e \u7f34\u6b3e\u5f85\u63d0\u4ea4\uff09 \u4e0d\u9700\u8981\u5237\u65b0");
            }
            if (!continueRefresh) {
                logger.info("gxsj-\u5237\u65b0\u7f34\u6b3e \u524d\u7f6e\u6761\u4ef6\u5224\u65ad\u4e0d\u9700\u8981\u5237\u65b0\uff0c\u7ec8\u6b62\u5237\u65b0");
                result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u4e0d\u9700\u8981\u5237\u65b0", (String)"GxdzsjDeclareFromZzsynbsr_9", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", false);
                return result;
            }
        } else {
            requestId = requestObj.getString("requestid");
        }
        if ((statusResult = GxsjDeclareService.getPayStatus(vo, requestId)).getSuccess()) {
            String taxPayStatus;
            switch (taxPayStatus = statusResult.getData().toString()) {
                case "1": {
                    failedLog.append(ResManager.loadKDString((String)"\u7f34\u6b3e\u5931\u8d25\uff1a\u7a0e\u5c40\u672a\u67e5\u8be2\u5230\u7f34\u6b3e\u8bb0\u5f55\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\u7f34\u6b3e", (String)"GxdzsjDeclareFromZzsynbsr_13", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    logger.warn("gxsj \u7f34\u6b3e\u5237\u65b0\u8b66\u544a\uff0c\u7a0e\u4f01\u76f4\u8fde\u5df2\u63d0\u4ea4\u7f34\u6b3e\u8bf7\u6c42\uff0c\u4f46\u662f\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8bb0\u5f55\uff0c\u7eb3\u7a0e\u4eba-" + vo.getNsrsbh());
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "payfailed", "3", failedLog);
                    break;
                }
                case "2": {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "paid", "2", failedLog);
                    break;
                }
                case "4": {
                    failedLog.append(statusResult.getMessage());
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "payfailed", "3", failedLog);
                    break;
                }
                case "0": {
                    failedLog.append(statusResult.getMessage());
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "submitted", "1", failedLog);
                    break;
                }
                default: {
                    logger.info("gxsh \u7f34\u6b3e\u5237\u65b0\u4e0d\u9700\u8981\u89e6\u53d1\uff0c\u5f53\u524d\u7a0e\u5c40\u7f34\u6b3e\u72b6\u6001-" + JSON.toJSONString((Object)statusResult));
                }
            }
            return CustomApiResult.dealResponse(null, statusResult.getMessage(), "4", true);
        }
        logger.error("gxsj \u7f34\u6b3e\u5237\u65b0\u5f02\u5e38\uff0c\u8be6\u60c5\uff1a" + statusResult.getMessage());
        failedLog.append(ResManager.loadKDString((String)"\u7f34\u6b3e\u5237\u65b0\u5f02\u5e38\uff0c\u8be6\u60c5\uff1a", (String)"GxdzsjDeclareFromZzsynbsr_14", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(statusResult.getMessage());
        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "payfailed", "3", failedLog);
        return CustomApiResult.dealResponse(null, statusResult.getMessage(), "3", false);
    }

    public ApiResult synchStatusBeforeDeclare(SBMessageBaseVo vo) {
        ApiResult result = null;
        if (!this.checkIdentity(vo)) {
            result = CustomApiResult.dealResponse("3", ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38", (String)"GxdzsjDeclareFromZzsynbsr_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
            return result;
        }
        DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx");
        String declareStatus = declare.getString("declareStatus");
        logger.info("gxsj\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
        result = GxsjDeclareService.getDeclareStatus(vo);
        logger.info("gxsj\u67e5\u8be2\u7ed3\u679c" + JSON.toJSONString((Object)result));
        String code = result.getData().toString();
        StringBuilder failedLog = new StringBuilder();
        failedLog.append(result.getMessage());
        result.setData((Object)declareStatus);
        switch (code) {
            case "4": {
                if (!"declared".equals(declareStatus)) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS_PROPNAME, "declared", "2", failedLog);
                }
                result.setData((Object)"declared");
                logger.info("gxsj-\u7a0e\u5c40\u5df2\u7533\u62a5");
                break;
            }
            default: {
                logger.info("gxsj-\u7a0e\u5c40\u672a\u7533\u62a5\u8fc7");
            }
        }
        result.setErrorCode("4");
        result.setSuccess(true);
        return result;
    }

    public ApiResult synchStatusBeforPay(SBMessageBaseVo vo) {
        String payStatus;
        ApiResult result = null;
        if (!this.checkIdentity(vo)) {
            result = CustomApiResult.dealResponse("3", ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38", (String)"GxdzsjDeclareFromZzsynbsr_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
            return result;
        }
        DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx");
        String payStatusChange = payStatus = declare.getString("payStatus");
        switch (payStatus) {
            case "paid": {
                return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u5df2\u7f34\u6b3e", (String)"GxdzsjDeclareFromZzsynbsr_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
            }
        }
        String nsrsbh = vo.getNsrsbh();
        String nsrType = vo.getType();
        Date qq = vo.getSkssqq();
        Date qz = vo.getSkssqz();
        String status = "1";
        String requestId = null;
        DynamicObject dynObj = ConnectConfigService.getRequestId(nsrsbh, nsrType, qq, qz, status, RequestTypeEnum.PAY);
        if (dynObj != null) {
            requestId = dynObj.getString("requestid");
        }
        ApiResult payStatusResult = GxsjDeclareService.getPayStatus(vo, requestId);
        StringBuilder failedLog = new StringBuilder();
        if (payStatusResult.getSuccess()) {
            String taxPayStatus;
            switch (taxPayStatus = payStatusResult.getData().toString()) {
                case "2": {
                    if ("paid".equals(payStatus)) break;
                    payStatusChange = "paid";
                    logger.info("gxsj \u540c\u6b65\u7f34\u6b3e\u72b6\u6001-\u9700\u8981\u66f4\u65b0\uff0c\u7cfb\u7edf\u4e0e\u7a0e\u5c40\u4e0d\u4e00\u81f4\u4e14\u7a0e\u5c40\u5df2\u7f34\u6b3e");
                    break;
                }
                case "4": {
                    if ("payfailed".equals(payStatus)) break;
                    payStatusChange = "payfailed";
                    logger.info("gxsj \u540c\u6b65\u7f34\u6b3e\u72b6\u6001-\u9700\u8981\u66f4\u65b0\uff0c\u7cfb\u7edf\u4e0e\u7a0e\u5c40\u4e0d\u4e00\u81f4\u4e14\u7a0e\u5c40\u7f34\u6b3e\u5931\u8d25");
                    break;
                }
                case "3": {
                    if ("paying".equals(payStatus)) break;
                    payStatusChange = "paying";
                    logger.info("gxsj \u540c\u6b65\u7f34\u6b3e\u72b6\u6001-\u9700\u8981\u66f4\u65b0\uff0c\u7cfb\u7edf\u4e0e\u7a0e\u5c40\u4e0d\u4e00\u81f4\u4e14\u7a0e\u5c40\u7f34\u6b3e\u4e3a\u7f34\u6b3e\u4e2d");
                    break;
                }
                case "1": {
                    if (!"paying".equals(payStatus) && !"submitted".equals(payStatus) || requestId == null) break;
                    payStatusChange = "payfailed";
                    logger.info("gxsj \u540c\u6b65\u7f34\u6b3e\u72b6\u6001-\u9700\u8981\u66f4\u65b0\uff0c\u7cfb\u7edf\u5df2\u53d1\u8d77\u8fc7\u7f34\u6b3e\uff0c\u4f46\u662f\u7a0e\u5c40\u672a\u67e5\u8be2\u5230\u7f34\u6b3e\u8bb0\u5f55");
                    break;
                }
                case "0": {
                    return CustomApiResult.dealResponse(null, payStatusResult.getMessage(), "3", false);
                }
                default: {
                    logger.info("gxsj \u6bd4\u5bf9\u7a0e\u5c40\u7f34\u6b3e\u72b6\u6001\u540e,\u7a0e\u52a1\u4e91\u7f34\u6b3e\u72b6\u6001\u4e0d\u9700\u8981\u6539\u53d8");
                }
            }
            if (!payStatusChange.equals(payStatus)) {
                logger.info("gxsj \u67e5\u8be2\u6bd4\u5bf9\u7a0e\u5c40\u7f34\u6b3e\u72b6\u6001\u540e\u4fee\u6539\u7a0e\u52a1\u4e91\u7ed3\u679c\u4e3a:" + payStatusChange);
                if (payStatusChange.equals("paid")) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, payStatusChange, "2", failedLog);
                } else if (payStatusChange.equals("payfailed")) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, payStatusChange, "3", failedLog);
                } else {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, payStatusChange, "1", failedLog);
                }
            }
            return CustomApiResult.dealResponse(payStatusChange, payStatusResult.getMessage(), "4", true);
        }
        return CustomApiResult.dealResponse(null, payStatusResult.getMessage(), "3", false);
    }

    private static ApiResult tryDeclare(SBMessageBaseVo vo) {
        StringBuilder failedLog = new StringBuilder();
        logger.info("gxsj\u7533\u62a5step2-1,\u671f\u521d\u83b7\u53d6");
        ApiResult qcResult = GxsjDeclareService.getQc(vo);
        if (!qcResult.getSuccess()) {
            logger.info("gxsj\u7533\u62a5step2-1,\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25\uff08\u671f\u521d\u83b7\u53d6\u5931\u8d25\uff09\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25" + vo.getNsrsbh());
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"GxdzsjDeclareFromZzsynbsr_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), qcResult.getMessage()));
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS_PROPNAME, "declarefailed", "3", failedLog);
            return qcResult;
        }
        HashMap<String, String> zspmMap = new HashMap<String, String>();
        if (qcResult.getData() != null) {
            List list = (List)qcResult.getData();
            for (QcInfo info : list) {
                if (info.getZsxmDm() == null || info.getZsxmDm().length() == 0) continue;
                zspmMap.put("zsxm_" + info.getZsxmDm(), info.getZspmDm());
            }
        }
        logger.info("gxsj\u7533\u62a5step2-2,\u63d0\u4ea4\u7533\u62a5");
        ApiResult result = GxsjDeclareService.declare(vo, zspmMap);
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("gxsj\u7533\u62a5step2-2,\u63d0\u4ea4\u7533\u62a5\u6210\u529f");
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS_PROPNAME, "declared", "2", failedLog);
            } else if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("gxsj\u7533\u62a5step2-2,\u63d0\u4ea4\u7533\u62a5\u5931\u8d25" + vo.getNsrsbh());
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"GxdzsjDeclareFromZzsynbsr_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), result.getMessage()));
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS_PROPNAME, "declarefailed", "3", failedLog);
            } else {
                logger.info("gxsj\u7533\u62a5step2-2,\u63a5\u53e3\u53ef\u80fd\u8d85\u65f6 \u672a\u8fd4\u56de\u6570\u636e\uff0c\u89c6\u4f5c\u7533\u62a5\u4e2d");
            }
        } else if (StringUtils.equals((String)"2", (String)result.getErrorCode())) {
            logger.info("gxsj\u7533\u62a5step2-2,\u63a5\u53e3\u53ef\u80fd\u8d85\u65f6 \u672a\u8fd4\u56de\u6570\u636e\uff0c\u89c6\u4f5c\u7533\u62a5\u4e2d");
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"GxdzsjDeclareFromZzsynbsr_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), result.getMessage()));
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS_PROPNAME, "declarefailed", "3", failedLog);
        }
        return result;
    }

    private static ApiResult tryPay(SBMessageBaseVo vo) {
        StringBuilder failedLog = new StringBuilder();
        logger.info("gxsj\u7f34\u6b3estep2-1 \u67e5\u8be2\u7f34\u6b3e\u4fe1\u606f" + vo.getNsrsbh());
        String nsrsbh = vo.getNsrsbh();
        String nsrType = vo.getType();
        Date qq = vo.getSkssqq();
        Date qz = vo.getSkssqz();
        String status = "1";
        String requestId = null;
        DynamicObject dynObj = ConnectConfigService.getRequestId(nsrsbh, nsrType, qq, qz, status, RequestTypeEnum.PAY);
        if (dynObj != null) {
            requestId = dynObj.getString("requestid");
        }
        ApiResult payInfoResult = GxsjDeclareService.getPayInfo(vo, requestId);
        List payInfo = null;
        if (payInfoResult.getSuccess()) {
            payInfo = (List)payInfoResult.getData();
            BigDecimal sum = vo.getYbtse();
            StringBuilder detail = new StringBuilder();
            detail.append(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u5e94\u8865\u9000\u7a0e\u989d\u5408\u8ba1:", (String)"GxdzsjDeclareFromZzsynbsr_15", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(sum).append("\uff1b");
            detail.append(ResManager.loadKDString((String)"\u7a0e\u5c40\u5e94\u8865\u9000\u660e\u7ec6:", (String)"GxdzsjDeclareFromZzsynbsr_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            for (YjsfInfo yjsf : payInfo) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(yjsf.getYbtse());
                }
                catch (NumberFormatException numExe) {
                    logger.error("\u7a0e\u5c40\u63a5\u53e3\u8fd4\u56de\u5e94\u7f34\u7a0e\u8d39\u6570\u636e\u91d1\u989d\u5b57\u6bb5\u5f02\u5e38" + JSON.toJSONString((Object)payInfo));
                    failedLog.append(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u8fd4\u56de\u5e94\u7f34\u7a0e\u8d39\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"GxdzsjDeclareFromZzsynbsr_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "payfailed", "3", failedLog);
                    return CustomApiResult.dealResponse(null, failedLog.toString(), "3", false);
                }
                BigDecimal tbtse = new BigDecimal(yjsf.getYbtse());
                sum = sum.subtract(tbtse);
                detail.append(yjsf.getZsxmmc()).append("(").append(yjsf.getZspmmc()).append(")\uff1a").append(tbtse).append("\uff1b");
            }
            if (sum.compareTo(new BigDecimal(0)) != 0) {
                failedLog.append(ResManager.loadKDString((String)"\u7ec8\u6b62\u7f34\u6b3e\uff0c\u7533\u62a5\u8868\u7f34\u6b3e\u91d1\u989d\u4e0e\u7a0e\u5c40\u5e94\u5f81\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8be6\u7ec6\u4fe1\u606f: ", (String)"GxdzsjDeclareFromZzsynbsr_18", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append((CharSequence)detail);
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "payfailed", "3", failedLog);
                logger.info("gxsj \u7f34\u6b3e\u7ec8\u6b62\uff0c\u56e0\u4e3a\u7533\u62a5\u8868\u7f34\u6b3e\u91d1\u989d\u4e0e\u7a0e\u5c40\u5e94\u5f81\u4fe1\u606f\u4e0d\u4e00\u81f4");
                return CustomApiResult.dealResponse(null, failedLog.toString(), "3", false);
            }
        } else {
            failedLog.insert(0, payInfoResult.getMessage());
            logger.info("gxsj\u7f34\u6b3estep2-1 \u67e5\u8be2\u7f34\u6b3e\u4fe1\u606f\u5931\u8d25\uff0c" + payInfoResult.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "payfailed", "3", failedLog);
            return payInfoResult;
        }
        logger.info("gxsj\u7f34\u6b3estep2-2 \u6267\u884c\u7f34\u6b3e" + vo.getNsrsbh());
        String tranSeq = UUID.randomUUID().toString().replace("-", "");
        ApiResult payResult = GxsjDeclareService.pay(vo, payInfo, tranSeq);
        failedLog.insert(0, payResult.getMessage()).append(";");
        if (payResult.getSuccess()) {
            String data;
            switch (data = payResult.getData().toString()) {
                case "3": {
                    logger.info("gxsj\u7f34\u6b3estep2-2 \u6267\u884c\u7f34\u6b3e\u4e2d" + vo.getNsrsbh());
                    break;
                }
                case "2": {
                    logger.info("gxsj\u7f34\u6b3estep2-2 \u6267\u884c\u7f34\u6b3e\u6210\u529f" + vo.getNsrsbh());
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "paid", "2", failedLog);
                    break;
                }
                case "4": {
                    logger.info("gxsj\u7f34\u6b3estep2-2 \u6267\u884c\u7f34\u6b3e\u5931\u8d25" + vo.getNsrsbh());
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "payfailed", "3", failedLog);
                    break;
                }
                default: {
                    logger.info("gxsj\u7f34\u6b3estep2-2 \u6267\u884c\u7f34\u6b3e\u4e2d\uff08\u5f02\u5e38\u72b6\u6001\u5f53\u505a\u6267\u884c\u4e2d\u5904\u7406\uff09" + vo.getNsrsbh());
                    break;
                }
            }
        } else {
            logger.info("gxsj\u7f34\u6b3estep2-2 \u6267\u884c\u7f34\u6b3e\u5931\u8d25(\u63a5\u53e3\u53ef\u80fd\u5f02\u5e38)" + vo.getNsrsbh());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS_PROPNAME, "payfailed", "3", failedLog);
            return payResult;
        }
        return payResult;
    }

    private boolean checkIdentity(SBMessageBaseVo vo) {
        IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
        StringBuilder failedLog = new StringBuilder();
        if (identityData == null) {
            failedLog.append(ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38", (String)"GxdzsjDeclareFromZzsynbsr_4", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(SEPARATOR).append(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"GxdzsjDeclareFromZzsynbsr_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS_PROPNAME, "declarefailed", "3", failedLog);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResult saveZspz(SBMessageBaseVo vo, String fileType, List<byte[]> contents) {
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
        String orgName = ((DynamicObject)org.get("org")).getString("name");
        StringBuilder fileNameTemplate = new StringBuilder(vo.getPzTypeName());
        fileNameTemplate.append("-%s");
        fileNameTemplate.append(".").append(fileType);
        StringBuilder failedLog = new StringBuilder();
        ArrayList<Map<String, Object>> files = new ArrayList<Map<String, Object>>(contents.size());
        ArrayList<ByteArrayInputStream> inputs = new ArrayList<ByteArrayInputStream>(8);
        int fileIndex = 1;
        for (byte[] byArray : contents) {
            ByteArrayInputStream in = new ByteArrayInputStream(byArray);
            inputs.add(in);
            HashMap<String, Object> fileMap = new HashMap<String, Object>(8);
            fileMap.put("inputstream", in);
            fileMap.put("orgName", orgName);
            fileMap.put("filename", String.format(fileNameTemplate.toString(), fileIndex));
            files.add(fileMap);
            ++fileIndex;
        }
        try {
            SbpzRecordSaveUtils.saveRecordBatch(vo, files, failedLog);
        }
        catch (Exception e) {
            logger.error("gxsj \u51ed\u8bc1\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage());
        }
        finally {
            for (InputStream inputStream : inputs) {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("gxsj \u51ed\u8bc1\u4fdd\u5b58\u5b8c\u6210,\u6d41\u5173\u95ed\u5f02\u5e38\uff0c" + e.getMessage());
                }
            }
        }
        return CustomApiResult.dealResponse(null, null, "4", true);
    }
}

