/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.gxdzsj;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.RequestTypeEnum;
import kd.taxc.tsate.common.enums.gxdzsj.YzpzzlDmEnum;
import kd.taxc.tsate.common.enums.gxdzsj.ZsxmDmEnum;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbpzMessageVo;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.service.gxdzsj.GxsjMessageSendServiceImpl;
import kd.taxc.tsate.msmessage.service.gxdzsj.api.GxdzsjRequest;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.DeclareInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.Identification;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.PayStatusInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.SjSysConfig;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.VoucherInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.YjsfInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.helper.GxdzsjResponseHelper;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import kd.taxc.tsate.msxml.util.XmlUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;

public class GxsjDeclareService {
    private static final Log logger = LogFactory.getLog(GxsjDeclareService.class);

    private GxsjDeclareService() {
    }

    public static ApiResult cancellation(SBMessageBaseVo vo, DeclareInfo info) {
        SjSysConfig config;
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            return identificationResult;
        }
        Identification identification = (Identification)identificationResult.getData();
        ApiResult canceResult = GxdzsjRequest.cancellation(info, identification, config = GxsjDeclareService.getSjSysConfig());
        if (!canceResult.getSuccess()) {
            return canceResult;
        }
        if (canceResult.getData() != null) {
            String bodyXml = canceResult.getData().toString();
            if (bodyXml.indexOf("<returnBz>1</returnBz>") != -1) {
                return canceResult;
            }
            try {
                Document doc = DocumentHelper.parseText((String)bodyXml);
                String msg = XmlUtil.getSingleValueByPath(doc.getRootElement(), "taxML.SBSaveReturnVO.mesg");
                return CustomApiResult.dealResponse(null, msg, "3", false);
            }
            catch (DocumentException e) {
                return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u9a8c\u7b7e\u901a\u8fc7\u4f46\u8fd4\u56de\u4e1a\u52a1\u62a5\u6587\u4e0d\u662fxml\u683c\u5f0f\uff0c\u89e3\u6790\u5931\u8d25", (String)"GxsjDeclareService_35", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
            }
        }
        return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u9a8c\u7b7e\u901a\u8fc7\u4f46\u662f\u672a\u8fd4\u56de\u4efb\u4f55\u4e1a\u52a1\u62a5\u6587", (String)"GxsjDeclareService_36", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
    }

    public static ApiResult getYearEvaluation(SBMessageBaseVo vo, String year) {
        String nsrsbh = vo.getNsrsbh();
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            return identificationResult;
        }
        Identification identification = (Identification)identificationResult.getData();
        return GxdzsjRequest.queryYearEvaluation(nsrsbh, year, identification, GxsjDeclareService.getSjSysConfig());
    }

    public static ApiResult getCredit(SBMessageBaseVo vo) {
        String nsrsbh = vo.getNsrsbh();
        String year = "2021";
        String month = "12";
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            return identificationResult;
        }
        Identification identification = (Identification)identificationResult.getData();
        return GxdzsjRequest.queryCredit(nsrsbh, year, month, identification, GxsjDeclareService.getSjSysConfig());
    }

    public static ApiResult getDeclareInitInfo(SBMessageBaseVo vo) {
        String nsrsbh = vo.getNsrsbh();
        String qq = "2022-03-01";
        String qz = "2022-03-31";
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            return identificationResult;
        }
        Identification identification = (Identification)identificationResult.getData();
        return GxdzsjRequest.queryDeclareInit(nsrsbh, qq, qz, identification, GxsjDeclareService.getSjSysConfig());
    }

    public static ApiResult getQc(SBMessageBaseVo vo) {
        String nsrsbh = vo.getNsrsbh();
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            return identificationResult;
        }
        Identification identification = (Identification)identificationResult.getData();
        return GxdzsjRequest.queryTodo(nsrsbh, identification, GxsjDeclareService.getSjSysConfig());
    }

    public static ApiResult getDeclareStatus(SBMessageBaseVo vo) {
        String nsrsbh = vo.getNsrsbh();
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            identificationResult.setData((Object)"3");
            return identificationResult;
        }
        DynamicObject requestObj = ConnectConfigService.getRequestId(nsrsbh, vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1");
        if (requestObj != null) {
            logger.info("gxsj-\u6309\u8bf7\u6c42\u6d41\u6c34\u53f7\u67e5\u8be2\u7533\u62a5\u72b6\u6001");
            String requestId = requestObj.getString("requestid");
            ApiResult reqResult = GxsjDeclareService.getDeclareStatusByRequest(vo, requestId);
            if (reqResult.getSuccess() && !"2".equals(reqResult.getData().toString())) {
                ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSON.toJSONString((Object)reqResult), "2");
            }
            return reqResult;
        }
        logger.info("gxsj-\u6309\u7a0e\u671f\u67e5\u8be2\u7533\u62a5\u72b6\u6001");
        ApiResult periodResult = GxsjDeclareService.getDeclareStatusByTaxperiod(vo);
        return periodResult;
    }

    public static ApiResult getDeclareStatusByRequest(SBMessageBaseVo vo, String requestId) {
        String nsrsbh = vo.getNsrsbh();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String qq = sdf.format(vo.getSkssqq());
        String qz = sdf.format(vo.getSkssqz());
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            return identificationResult;
        }
        Identification identification = (Identification)identificationResult.getData();
        ApiResult reqResult = GxdzsjRequest.queryDeclareStatusByRequestId(nsrsbh, requestId, qq, qz, identification, GxsjDeclareService.getSjSysConfig());
        String kdStatus = "2";
        StringBuilder kdMssage = new StringBuilder();
        if (reqResult.getData() == null) {
            kdMssage.append(ResManager.loadKDString((String)"gxsj-\u63a5\u53e3\u5f02\u5e38\u4fe1\u606f\uff1a", (String)"GxsjDeclareService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            kdStatus = "2";
            if (reqResult.getMessage() != null) {
                kdMssage.append(reqResult.getMessage());
            } else {
                kdMssage.append(ResManager.loadKDString((String)"\u63a5\u53e3\u672a\u8fd4\u56de\u4efb\u4f55\u6709\u6548\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u63a5\u53e3\u8bf7\u6c42\u8bb0\u5f55", (String)"GxsjDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            }
            logger.error(kdMssage.toString());
        } else {
            String xmlData = (String)reqResult.getData();
            if (xmlData.indexOf("<sbxxGridlb>") != -1) {
                kdMssage.append(ResManager.loadKDString((String)"\u7533\u62a5\u6210\u529f", (String)"GxsjDeclareService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                kdStatus = "4";
            } else if (xmlData.indexOf("<code>") != -1) {
                Map<String, String> map = GxdzsjResponseHelper.parseDeclareStatusFromRequest(xmlData);
                String status = map.get("code");
                String statusName = map.get("codeName");
                String warmMessage = map.get("message");
                if (StringUtils.isEmpty((String)warmMessage)) {
                    warmMessage = ResManager.loadKDString((String)"\u6839\u636e\u6d41\u6c34\u53f7\u67e5\u8be2\u5f53\u524d\u7a0e\u671f\u7684\u4e0a\u6b21\u7533\u62a5\u7ed3\u679c\uff0c\u7a0e\u5c40\u672a\u8fd4\u56de\u4fe1\u606f", (String)"GxsjDeclareService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                }
                kdMssage.append(statusName).append(" ").append(warmMessage);
                if (status != null) {
                    switch (status) {
                        case "0": {
                            kdStatus = "1";
                            break;
                        }
                        case "1": {
                            kdStatus = "2";
                            break;
                        }
                        case "2": {
                            kdStatus = "4";
                            break;
                        }
                        case "3": {
                            kdStatus = "3";
                            break;
                        }
                        case "4": {
                            kdStatus = "3";
                            break;
                        }
                        default: {
                            logger.warn("gxsj-\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u5f02\u5e38");
                            kdStatus = "2";
                        }
                    }
                }
            } else if (xmlData.indexOf(ResManager.loadKDString((String)"\u65e0\u7533\u62a5\u8bb0\u5f55", (String)"GxsjDeclareService_6", (String)"taxc-tsate-mservice", (Object[])new Object[0])) != -1) {
                kdStatus = "3";
                kdMssage.append(xmlData).append(ResManager.loadKDString((String)"(\u7a0e\u5c40\u672a\u8fd4\u56de\u8be6\u7ec6\u7684\u9519\u8bef\u63d0\u793a\u4fe1\u606f)", (String)"GxsjDeclareService_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            } else {
                kdStatus = "3";
                kdMssage.append(ResManager.loadKDString((String)"\u7a0e\u5c40\u8fd4\u56de\u7684\u6570\u636e\u683c\u5f0f\u51fa\u73b0\u95ee\u9898", (String)"GxsjDeclareService_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            }
        }
        ApiResult result = CustomApiResult.dealResponse(kdStatus, kdMssage.toString(), "4", true);
        return result;
    }

    public static ApiResult declare(SBMessageBaseVo vo, Map<String, String> zspmMap) {
        ApiResult apiResult;
        try {
            ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
            if (!identificationResult.getSuccess()) {
                return identificationResult;
            }
            MessageSend send = new MessageSend();
            send.setMsgtype("declare");
            send.setBusinessid(vo.getBusinessId());
            send.setBusinesstype(vo.getType());
            send.setNodetype(vo.getSbdq());
            send.setSupplier(SupplierEnum.GXSJ.getName());
            String reqContent = MessageService.collectionData(send, zspmMap, vo.getDjxh(), vo.getNsrsbh());
            String tranSeq = UUID.randomUUID().toString().replace("-", "");
            String nsrsbh = vo.getNsrsbh();
            StringBuilder detailLog = new StringBuilder();
            detailLog.append(ResManager.loadKDString((String)"\u4ea4\u6613\u6d41\u6c34\u53f7", (String)"GxsjDeclareService_9", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(tranSeq);
            detailLog.append(reqContent);
            DirectDeclareLogUtils.dealDetailLog(detailLog, vo.getId());
            GxsjMessageSendServiceImpl.buildRequestId(tranSeq, vo);
            apiResult = GxdzsjRequest.declare(tranSeq, nsrsbh, reqContent, (Identification)identificationResult.getData(), GxsjDeclareService.getSjSysConfig());
            String erroCode = apiResult.getErrorCode();
            if (erroCode != null && !"2".equals(erroCode)) {
                DynamicObject reqObj = ConnectConfigService.getRequestId(nsrsbh, vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1");
                ConnectConfigService.updateStatusInfo(reqObj.getLong("id"), JSON.toJSONString((Object)apiResult), "2");
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u7533\u62a5\u5904\u7406\u5f02\u5e38, %s", (String)"GxsjDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            logger.error("\u7533\u62a5\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage());
            logger.error(message);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult getDeclareStatusByTaxperiod(SBMessageBaseVo vo) {
        return GxsjDeclareService.getDeclareStatusByTaxperiod(vo, null);
    }

    public static ApiResult getDeclareStatusByTaxperiod(SBMessageBaseVo vo, List<DeclareInfo> statusInfo) {
        String nsrsbh = vo.getNsrsbh();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String qq = sdf.format(vo.getSkssqq());
        String qz = sdf.format(vo.getSkssqz());
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            identificationResult.setData((Object)"3");
            return identificationResult;
        }
        Identification identification = (Identification)GxsjDeclareService.getIdentification(vo).getData();
        ApiResult result = GxdzsjRequest.queryDeclareStatusByPeriod(nsrsbh, qq, qz, identification, GxsjDeclareService.getSjSysConfig());
        Object rep = result.getData();
        if (rep == null) {
            result.setData((Object)"3");
        } else {
            String repData = (String)rep;
            if (repData.indexOf(ResManager.loadKDString((String)"\u7533\u62a5\u5904\u7406\u4e2d", (String)"GxsjDeclareService_10", (String)"taxc-tsate-mservice", (Object[])new Object[0])) != -1) {
                result.setData((Object)"2");
            } else if (repData.indexOf("sbxxGridlb") != -1) {
                List<DeclareInfo> list = GxdzsjResponseHelper.parseDeclareInfoFromStatusQuery(repData);
                if (list.size() > 0) {
                    if (statusInfo != null) {
                        statusInfo.addAll(list);
                    }
                    result.setData((Object)"4");
                } else {
                    result.setData((Object)"3");
                }
            } else {
                result.setData((Object)"3");
            }
        }
        return result;
    }

    public static ApiResult getPayStatus(SBMessageBaseVo vo, String requestId) {
        if (StringUtils.isNotEmpty((String)requestId)) {
            logger.info("gxsj \u67e5\u8be2\u7f34\u6b3e\u72b6\u6001,\u6309\u6d41\u6c34\u53f7\u67e5\u8be2\uff0c\u6d41\u6c34\u53f7\uff1a" + requestId);
        } else {
            logger.info("gxsj \u67e5\u8be2\u7f34\u6b3e\u72b6\u6001,\u6309\u7a0e\u671f\u67e5\u8be2:" + vo.getSkssqq() + "-" + vo.getSkssqz());
        }
        ApiResult payInfoResult = GxsjDeclareService.getPayInfo(vo, requestId);
        logger.info("gxsj \u67e5\u8be2\u7f34\u6b3e\u72b6\u6001,\u8fd4\u56de\u7ed3\u679c" + JSON.toJSONString((Object)payInfoResult));
        String payStatus = "0";
        StringBuilder payFailMessage = new StringBuilder();
        if (payInfoResult.getSuccess()) {
            List list = (List)payInfoResult.getData();
            int[] statusCount = new int[]{0, 0, 0, 0, 0};
            list.forEach(yjsfInfo -> {
                if ("1".equals(yjsfInfo.getJkzt())) {
                    String temp = ResManager.loadKDString((String)"%1$s(%s)\u7f34\u6b3e\u6210\u529f\uff0c\u5b9e\u7f34\u91d1\u989d-%2$s,\u5e94\u8865\u9000\u7a0e\u989d-%3$s;", (String)"GxsjDeclareService_13", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    payFailMessage.append(String.format(temp, yjsfInfo.getZsxmmc(), yjsfInfo.getZspmmc(), yjsfInfo.getKkje(), yjsfInfo.getYbtse()));
                    statusCount[2] = statusCount[2] + 1;
                } else if ("0".equals(yjsfInfo.getStatus())) {
                    String temp = ResManager.loadKDString((String)"%1$s(%2$s)\u672a\u7f34\u6b3e,\u5e94\u8865\u9000\u7a0e\u989d-%3$s;", (String)"GxsjDeclareService_19", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    payFailMessage.append(String.format(temp, yjsfInfo.getZsxmmc(), yjsfInfo.getZspmmc(), yjsfInfo.getYbtse()));
                    statusCount[0] = statusCount[0] + 1;
                } else if ("1".equals(yjsfInfo.getStatus())) {
                    String temp = ResManager.loadKDString((String)"%1$s(%2$s)\u7f34\u6b3e\u6267\u884c\u4e2d\uff0c\u5e94\u8865\u9000\u7a0e\u989d-%3$s;", (String)"GxsjDeclareService_20", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    payFailMessage.append(String.format(temp, yjsfInfo.getZsxmmc(), yjsfInfo.getZspmmc(), yjsfInfo.getYbtse()));
                    statusCount[1] = statusCount[1] + 1;
                } else if ("2".equals(yjsfInfo.getStatus())) {
                    String temp = ResManager.loadKDString((String)"%1$s(%s)\u7f34\u6b3e\u6210\u529f\uff0c\u5b9e\u7f34\u91d1\u989d-%2$s,\u5e94\u8865\u9000\u7a0e\u989d-%3$s;", (String)"GxsjDeclareService_13", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    payFailMessage.append(String.format(temp, yjsfInfo.getZsxmmc(), yjsfInfo.getZspmmc(), yjsfInfo.getKkje(), yjsfInfo.getYbtse()));
                    statusCount[2] = statusCount[2] + 1;
                } else if ("3".equals(yjsfInfo.getStatus())) {
                    String temp = ResManager.loadKDString((String)"%1$s(%2$s)\u7f34\u6b3e\u5931\u8d25\uff0c\u5b9e\u7f34\u91d1\u989d-%3$s,\u5e94\u8865\u9000\u7a0e\u989d-%4$s,\u8be6\u60c5-%5$s;", (String)"GxsjDeclareService_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    payFailMessage.append(String.format(temp, yjsfInfo.getZsxmmc(), yjsfInfo.getZspmmc(), yjsfInfo.getKkje(), yjsfInfo.getYbtse(), yjsfInfo.getMessage()));
                    statusCount[3] = statusCount[3] + 1;
                } else if ("0".equals(yjsfInfo.getJkzt())) {
                    String temp = ResManager.loadKDString((String)"%1$s(%2$s)\u672a\u7f34\u6b3e,\u5e94\u8865\u9000\u7a0e\u989d-%3$s;", (String)"GxsjDeclareService_19", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    payFailMessage.append(String.format(temp, yjsfInfo.getZsxmmc(), yjsfInfo.getZspmmc(), yjsfInfo.getYbtse()));
                    statusCount[0] = statusCount[0] + 1;
                } else {
                    payFailMessage.append(ResManager.loadKDString((String)"\u7a0e\u5c40\u8fd4\u56de\u6570\u636e\u5f02\u5e38(\u7f34\u6b3e\u72b6\u6001\u5f02\u5e38);", (String)"GxsjDeclareService_21", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    logger.error("gxsj \u7f34\u6b3e\u72b6\u6001\u67e5\u8be2\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u6570\u636e\uff1a" + JSON.toJSONString((Object)yjsfInfo));
                    statusCount[4] = statusCount[4] + 1;
                }
            });
            payStatus = statusCount[3] > 0 ? "4" : (statusCount[1] > 0 ? "3" : (statusCount[0] > 0 ? "1" : (statusCount[4] > 0 ? "0" : "2")));
            if (list.size() == 0) {
                payFailMessage.append(ResManager.loadKDString((String)"\u7a0e\u5c40\u8fd4\u56de\u6570\u636e\u5f02\u5e38(\u7f34\u6b3e\u72b6\u6001\u5f02\u5e38);", (String)"GxsjDeclareService_21", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                if (payInfoResult.getMessage() != null) {
                    payFailMessage.append(payInfoResult.getMessage());
                }
                logger.error("gxsj \u7f34\u6b3e\u72b6\u6001\u67e5\u8be2\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff0c\u6570\u636e\u4e3a\u7a7a");
                payStatus = "0";
            }
            logger.info("gxsj \u67e5\u8be2\u7f34\u6b3e\u72b6\u6001,\u67e5\u8be2\u6210\u529f\uff0c\u7a0e\u5c40\u72b6\u6001(GxdzsjMessageSendConstant)\u89e3\u6790\u4e3a\uff1a" + payStatus);
            return CustomApiResult.dealResponse(payStatus, payFailMessage.toString(), "4", true);
        }
        logger.info("gxsj \u67e5\u8be2\u7f34\u6b3e\u72b6\u6001,\u67e5\u8be2\u5931\u8d25");
        payFailMessage.append(payInfoResult.getMessage());
        return CustomApiResult.dealResponse(payStatus, payFailMessage.toString(), "3", false);
    }

    public static ApiResult pay(SBMessageBaseVo vo, List<YjsfInfo> payInfo, String tranSeq) {
        String nsrsbh = vo.getNsrsbh();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String qq = sdf.format(vo.getSkssqq());
        String qz = sdf.format(vo.getSkssqz());
        String sfxyh = GxsjMessageSendServiceImpl.getTripleAggrementInfo(vo);
        if (sfxyh == null) {
            return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u672a\u6b63\u786e\u8bbe\u7f6e\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\u7684\u4e09\u65b9\u534f\u8bae\u53f7", (String)"GxsjDeclareService_15", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            identificationResult.setData((Object)"3");
            return identificationResult;
        }
        Identification identification = (Identification)GxsjDeclareService.getIdentification(vo).getData();
        SjSysConfig config = GxsjDeclareService.getSjSysConfig();
        List<YjsfInfo> target = payInfo.stream().filter(info -> {
            if (StringUtils.isNotEmpty((String)info.getStatus())) {
                if ("0".equals(info.getStatus()) || "3".equals(info.getStatus())) {
                    return true;
                }
                if ("1".equals(info.getStatus()) || "2".equals(info.getStatus())) {
                    return false;
                }
                if ("0".equals(info.getJkzt())) {
                    return true;
                }
                if ("1".equals(info.getJkzt())) {
                    return false;
                }
                return false;
            }
            return "0".equals(info.getJkzt());
        }).collect(Collectors.toList());
        if (target.size() <= 0) {
            return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u65e0\u9700\u8981\u7f34\u6b3e\u7684\u5e94\u5f81\u51ed\u8bc1\u4fe1\u606f", (String)"GxsjDeclareService_22", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
        logger.info("gxsj\u7f34\u6b3e \u5f00\u59cb\u8bb0\u5f55\u7f34\u6b3e\u8bf7\u6c42\u4fe1\u606f" + vo.getNsrsbh());
        DynamicObject obj = GxsjMessageSendServiceImpl.buildRequestId(tranSeq, vo, RequestTypeEnum.PAY);
        ApiResult payResult = GxdzsjRequest.pay(tranSeq, nsrsbh, sfxyh, target, identification, config);
        String statusInfo = JSON.toJSONString((Object)payResult.getData());
        ConnectConfigService.updateStatusInfo(obj.getLong("id"), statusInfo, "2");
        logger.info("gxsj\u7f34\u6b3e \u8bb0\u5f55\u7f34\u6b3e\u8bf7\u6c42\u7ed3\u679c" + statusInfo);
        StringBuilder failedLog = new StringBuilder();
        if (payResult.getSuccess() && payResult.getData() != null) {
            PayStatusInfo payStatusInfo = GxdzsjResponseHelper.parsePayStatusFromPay(payResult.getData().toString());
            String taxStatus = payStatusInfo.getKkfhDm();
            String statusDescr = payStatusInfo.getKkfhmc();
            String kdStatus = "0";
            switch (taxStatus) {
                case "000": {
                    failedLog.append(ResManager.loadKDString((String)"\u7f34\u6b3e\u6210\u529f", (String)"GxsjDeclareService_23", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    kdStatus = "2";
                    break;
                }
                case "001": {
                    failedLog.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u4e2d", (String)"GxsjDeclareService_24", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    kdStatus = "3";
                    break;
                }
                case "002": {
                    failedLog.append(ResManager.loadKDString((String)"\u7a0e\u5c40\u8fd4\u56de\u4f5c\u5e9f\u72b6\u6001", (String)"GxsjDeclareService_25", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    kdStatus = "4";
                    ConnectConfigService.updateStatusInfo(obj.getLong("id"), statusInfo, "2");
                    break;
                }
                case "999": {
                    failedLog.append(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38,\u6838\u5fc3\u5f81\u7ba1\u8fde\u63a5\u7a0e\u5e93\u94f6\u8d85\u65f6", (String)"GxsjDeclareService_26", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    kdStatus = "4";
                    break;
                }
                default: {
                    failedLog.append(ResManager.loadKDString((String)"\u7a0e\u5c40\u8fd4\u56de\uff1a\u9519\u8bef\u7801", (String)"GxsjDeclareService_27", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(taxStatus).append(",");
                    if (StringUtils.isNotEmpty((String)statusDescr)) {
                        failedLog.append(statusDescr);
                    } else {
                        failedLog.append(ResManager.loadKDString((String)"(\u7a0e\u5c40\u63a5\u53e3\u672a\u8fd4\u56de\u8be6\u7ec6\u4fe1\u606f)", (String)"GxsjDeclareService_28", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    }
                    kdStatus = "4";
                }
            }
            return CustomApiResult.dealResponse(kdStatus, failedLog.toString(), "4", true);
        }
        return CustomApiResult.dealResponse(null, payResult.getMessage(), "3", false);
    }

    public static ApiResult getPayInfo(SBMessageBaseVo vo, String requestId) {
        String taxType = vo.getString(SbpzMessageVo.Key.TYPENUMBER);
        if (taxType == null) {
            taxType = vo.getType();
        }
        String nsrsbh = vo.getNsrsbh();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date skssqq = vo.getSkssqq();
        Date skssqz = vo.getSkssqz();
        if (skssqq == null) {
            skssqq = vo.getDate(SbpzMessageVo.Key.SKSSQQ);
        }
        if (skssqz == null) {
            skssqz = vo.getDate(SbpzMessageVo.Key.SKSSQZ);
        }
        String qq = sdf.format(skssqq);
        String qz = sdf.format(skssqz);
        String sfxyh = vo.getTransrc();
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            identificationResult.setData((Object)"3");
            return identificationResult;
        }
        Identification identification = (Identification)identificationResult.getData();
        SjSysConfig config = GxsjDeclareService.getSjSysConfig();
        ZsxmDmEnum zsxmDm = ZsxmDmEnum.valueOfTaxType((String)taxType);
        YzpzzlDmEnum yzpzzlDm = YzpzzlDmEnum.valueOfTaxType((String)taxType);
        if (zsxmDm == null) {
            logger.error("gxsj-\u67e5\u8be2\u7f34\u6b3e\u53c2\u6570 \u7a0e\u79cd\u672a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u5f81\u6536\u9879\u76ee\u4ee3\u7801");
            return CustomApiResult.dealResponse("null", ResManager.loadKDString((String)"\u7a0e\u79cd\u672a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u5f81\u6536\u9879\u76ee\u4ee3\u7801\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458", (String)"GxsjDeclareService_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
        if (yzpzzlDm == null) {
            logger.error("gxsj-\u67e5\u8be2\u7f34\u6b3e\u53c2\u6570 \u7a0e\u79cd\u672a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u5e94\u5f81\u51ed\u8bc1\u79cd\u7c7b\u4ee3\u7801");
            return CustomApiResult.dealResponse("null", ResManager.loadKDString((String)"\u7a0e\u79cd\u672a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u5e94\u5f81\u51ed\u8bc1\u79cd\u7c7b\u4ee3\u7801\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458", (String)"GxsjDeclareService_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
        ApiResult payResult = GxdzsjRequest.queryPayInfo(nsrsbh, qq, qz, zsxmDm.getZsxmDm(), yzpzzlDm.getYzpzzlDm(), null, requestId, identification, config);
        if (payResult.getSuccess()) {
            String xml = payResult.getData().toString();
            List<YjsfInfo> payInfo = GxdzsjResponseHelper.parsePayInfoFromQuery(xml);
            StringBuilder failedLog = new StringBuilder();
            if (payInfo.size() == 0) {
                if (xml.indexOf(ResManager.loadKDString((String)"\u5f53\u524d\u7eb3\u7a0e\u4eba\u65e0\u7f34\u6b3e\u4fe1\u606f", (String)"GxsjDeclareService_29", (String)"taxc-tsate-mservice", (Object[])new Object[0])) != -1) {
                    failedLog.append(xml);
                } else {
                    logger.error("gxsj \u7f34\u6b3e\u72b6\u6001\u67e5\u8be2 \u7a0e\u5c40\u63a5\u53e3\u8fd4\u56de\u672a\u5b9a\u4e49\u6570\u636e");
                    failedLog.append(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u8fd4\u56de\u672a\u5b9a\u4e49\u6570\u636e:", (String)"GxsjDeclareService_30", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(xml);
                }
                return CustomApiResult.dealResponse(payInfo, failedLog.toString(), "3", false);
            }
            return CustomApiResult.dealResponse(payInfo, failedLog.toString(), "4", true);
        }
        return payResult;
    }

    public static ApiResult issueVoucher(SBMessageBaseVo vo, String dzsphm) {
        String nsrsbh = vo.getNsrsbh();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String qq = sdf.format(vo.getSkssqq());
        String qz = sdf.format(vo.getSkssqz());
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            identificationResult.setData((Object)"3");
            return identificationResult;
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        DynamicObject requestDyn = GxsjMessageSendServiceImpl.buildRequestId(uuid, vo, RequestTypeEnum.VOUCHER);
        ApiResult result = GxdzsjRequest.issueVoucher(uuid, nsrsbh, qq, qz, dzsphm, (Identification)identificationResult.getData(), GxsjDeclareService.getSjSysConfig());
        Long id = requestDyn.getLong("id");
        StringBuilder erroInfo = new StringBuilder();
        if (!result.getSuccess()) {
            erroInfo.append(result.getMessage());
            ConnectConfigService.updateStatusInfo(id, result.getMessage(), "3");
            return result;
        }
        ConnectConfigService.updateStatusInfo(id, result.getMessage(), "2");
        VoucherInfo info = GxdzsjResponseHelper.parseVoucherFromIssure(result.getData().toString());
        return CustomApiResult.dealResponse(info, null, "4", true);
    }

    public static ApiResult getVoucher(SBMessageBaseVo vo, String wszmuuid, String fileuuid) {
        if (wszmuuid == null || fileuuid == null) {
            String tranSeqOfVoucher;
            DynamicObject requestDyn = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "2", RequestTypeEnum.VOUCHER);
            if (requestDyn == null) {
                return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u8f6c\u5f00\u51ed\u8bc1\u8bf7\u6c42\u8bb0\u5f55", (String)"GxsjDeclareService_31", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
            }
            wszmuuid = tranSeqOfVoucher = requestDyn.getString("requestid");
            fileuuid = tranSeqOfVoucher;
        }
        String nsrsbh = vo.getNsrsbh();
        ApiResult identificationResult = GxsjDeclareService.getIdentification(vo);
        if (!identificationResult.getSuccess()) {
            identificationResult.setData((Object)"3");
            return identificationResult;
        }
        ApiResult result = GxdzsjRequest.queryVoucher(nsrsbh, wszmuuid, fileuuid, (Identification)identificationResult.getData(), GxsjDeclareService.getSjSysConfig());
        if (!result.getSuccess()) {
            return result;
        }
        VoucherInfo info = GxdzsjResponseHelper.parseVoucherFromIssure(result.getData().toString());
        return CustomApiResult.dealResponse(info, null, "4", true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ApiResult downloadVoucher(SBMessageBaseVo vo, String sphm) {
        VoucherInfo voucherInfo;
        block5: {
            voucherInfo = null;
            logger.info("gxsj \u901a\u8fc7\u8f6c\u5f00\u83b7\u53d6\u51ed\u8bc1\u6587\u4ef6");
            ApiResult voucherInfoResult1 = GxsjDeclareService.issueVoucher(vo, sphm);
            if (!voucherInfoResult1.getSuccess()) {
                if (voucherInfoResult1.getMessage() != null && voucherInfoResult1.getMessage().indexOf(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u672a\u8f6c\u5f00\u7684\u7a0e\u6b3e\u4fe1\u606f", (String)"GxsjDeclareService_32", (String)"taxc-tsate-mservice", (Object[])new Object[0])) != -1) {
                    logger.warn("gxsj \u51ed\u8bc1\u5df2\u8f6c\u5f00\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u6267\u884c,\u7a0e\u7968\u53f7\uff1a" + sphm);
                    break block5;
                } else {
                    logger.error("gxsj \u8f6c\u5f00\u51ed\u8bc1\u5931\u8d25,\u539f\u56e0\uff1a" + voucherInfoResult1.getMessage());
                    DirectDeclareLogUtils.updateStatus(vo.getId(), "3", new StringBuilder(voucherInfoResult1.getMessage()));
                    return voucherInfoResult1;
                }
            }
            voucherInfo = (VoucherInfo)voucherInfoResult1.getData();
        }
        if (voucherInfo == null) {
            logger.warn("gxsj \u901a\u8fc7\u8f6c\u5f00\u6d41\u6c34\u53f7\u83b7\u53d6\u51ed\u8bc1\u6587\u4ef6");
            ApiResult voucherInfoResult2 = GxsjDeclareService.getVoucher(vo, null, null);
            if (!voucherInfoResult2.getSuccess()) {
                logger.error("gxsj \u67e5\u8be2\u51ed\u8bc1\u5931\u8d25\uff08\u8f85\u52a9\uff09\uff0c\u539f\u56e0\uff1a" + voucherInfoResult2.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", new StringBuilder(ResManager.loadKDString((String)"\u7a0e\u5c40\u67e5\u8be2\u51ed\u8bc1\u63a5\u53e3\u5f02\u5e38", (String)"GxsjDeclareService_33", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(voucherInfoResult2.getMessage()));
                return voucherInfoResult2;
            }
            voucherInfo = (VoucherInfo)voucherInfoResult2.getData();
        }
        return CustomApiResult.dealResponse(voucherInfo, null, "4", true);
    }

    private static SjSysConfig getSjSysConfig() {
        SjSysConfig config = new SjSysConfig();
        QFilter filter = new QFilter("key", "in", (Object)new String[]{"gxdzsj_appid", "gxdzsj_appsecret"});
        QueryServiceHelper.query((String)"tsate_param_setting", (String)"key,value", (QFilter[])new QFilter[]{filter}).forEach(dynamicObject -> {
            String key = dynamicObject.getString("key");
            String value = dynamicObject.getString("value");
            if ("gxdzsj_appid".equals(key)) {
                config.setAppid(value);
            } else if ("gxdzsj_appsecret".equals(key)) {
                config.setKey(value);
            }
        });
        return config;
    }

    private static ApiResult getIdentification(SBMessageBaseVo vo) {
        Identification identification = new Identification();
        IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
        if (identityData == null) {
            return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u7a0e\u5c40\u767b\u5f55\u914d\u7f6e\u672a\u6b63\u786e\u8bbe\u7f6e", (String)"GxsjDeclareService_34", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
        String sfzjhm = identityData.getTaxmanSfz();
        String xm1 = identityData.getTaxmanName();
        String pd = identityData.getPassword();
        identification.setRole("3");
        identification.setSfzjlxDm("201");
        identification.setYhlx("1");
        identification.setXm(xm1);
        identification.setSfzjhm(sfzjhm);
        identification.setPd(pd);
        return CustomApiResult.dealResponse(identification, "", "4", true);
    }
}

