/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.gxdzsj;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.business.TsateDeclareChecklistBusiness;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.creditlevel.TaxCreditLevelBusiness;
import kd.taxc.tsate.common.enums.RequestTypeEnum;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.dao.CreditLevelInfoDto;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbpzMessageVo;
import kd.taxc.tsate.msmessage.domain.SbsxxzMessageVo;
import kd.taxc.tsate.msmessage.enums.TaxCreditLevelEnums;
import kd.taxc.tsate.msmessage.enums.gxdzsj.TaxTypeDeclareForGxEnums;
import kd.taxc.tsate.msmessage.service.MessageSendService;
import kd.taxc.tsate.msmessage.service.gxdzsj.GxsjDeclareService;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.DeclareInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.QcInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.helper.GxdzsjResponseHelper;
import kd.taxc.tsate.msmessage.service.gxdzsj.helper.ZssxHelper;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import kd.taxc.tsate.msxml.util.XmlTJsonUtil;
import org.apache.commons.collections4.CollectionUtils;

public class GxsjMessageSendServiceImpl
implements MessageSendService {
    private static final Log logger = LogFactory.getLog(GxsjMessageSendServiceImpl.class);
    private static final String ENTITY_NAME = "tsate_credit_level_list";

    @Override
    public ApiResult sendMessage(SBMessageBaseVo vo) {
        ApiResult result;
        try {
            Class<?> clazz = Class.forName(TaxTypeDeclareForGxEnums.getClassPathByKey(vo.getType()));
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object newInstance = constructor.newInstance(new Object[0]);
            result = (ApiResult)clazz.getMethod("sendMessage", SBMessageBaseVo.class).invoke(newInstance, vo);
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04\u8c03\u7528\u5931\u8d25-" + ExceptionUtil.toString((Exception)e));
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25", (String)"GxsjMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
        return result;
    }

    @Override
    public ApiResult paymentRequest(SBMessageBaseVo vo) {
        ApiResult result;
        try {
            Class<?> clazz = Class.forName(TaxTypeDeclareForGxEnums.getClassPathByKey(vo.getType()));
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object newInstance = constructor.newInstance(new Object[0]);
            result = (ApiResult)clazz.getMethod("paymentRequest", SBMessageBaseVo.class).invoke(newInstance, vo);
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04\u8c03\u7528\u5931\u8d25-" + e.getMessage());
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25", (String)"GxsjMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
        return result;
    }

    @Override
    public ApiResult verify(SBMessageBaseVo vo) {
        return null;
    }

    @Override
    public ApiResult screenshot(SBMessageBaseVo vo) {
        return null;
    }

    @Override
    public ApiResult downloadVoucher(SBMessageBaseVo vo) {
        ApiResult result;
        StringBuilder failedlog = new StringBuilder();
        String declareTypeNumber = vo.getString(SbpzMessageVo.Key.TYPENUMBER);
        if (!"zzsybnsr".equals(declareTypeNumber)) {
            StringBuilder err = new StringBuilder(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u7533\u62a5\u8868\u7c7b\u578b\u4e0d\u652f\u6301\u4e0b\u8f7d", (String)"GxsjMessageSendServiceImpl_26", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            err.append("(").append(declareTypeNumber).append(")");
            logger.error("gxsj \u4e0b\u8f7d\u51ed\u8bc1\u5931\u8d25-\u4e0d\u652f\u6301\u7684\u7533\u62a5\u8868\u7c7b\u578b" + declareTypeNumber);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", err);
            return ApiResult.fail((String)err.toString());
        }
        try {
            Date skssqzDate = vo.getDate(SbpzMessageVo.Key.SKSSQZ);
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
            QFilter q1 = new QFilter("type", "=", (Object)TaxTypeDeclareForGxEnums.ZZSYBNSR.getType());
            QFilter q2 = new QFilter("skssqz", "=", (Object)sd.parse(sd.format(skssqzDate)));
            QFilter q3 = new QFilter("nsrsbh", "=", (Object)vo.getNsrsbh());
            DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"", (QFilter[])new QFilter[]{q1, q2, q3});
            StringBuilder queryInfo = new StringBuilder();
            queryInfo.append(ResManager.loadKDString((String)"\uff08\u67e5\u8be2\u6761\u4ef6\uff1a", (String)"GxsjMessageSendServiceImpl_14", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(q1).append(q2).append(q3).append(")");
            if (nsrxx != null) {
                String payStatus = nsrxx.getString("paystatus");
                if (!"paid".equals(payStatus) && !"nopay".equals(payStatus)) {
                    failedlog.append(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u5b8c\u7a0e\u51ed\u8bc1\u4e0b\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5173\u8054\u7684\u7533\u62a5\u8bb0\u5f55\u672a\u7f34\u6b3e", (String)"GxsjMessageSendServiceImpl_15", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    queryInfo.insert(0, ResManager.loadKDString((String)"gxsj \u51ed\u8bc1\u4e0b\u8f7d\u5931\u8d25\uff0c\u5173\u8054\u7684\u7533\u62a5\u8bb0\u5f55\u672a\u7f34\u6b3e", (String)"GxsjMessageSendServiceImpl_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    logger.error(queryInfo.toString());
                }
            } else {
                failedlog.append(ResManager.loadKDString((String)"\u589e\u503c\u7a0e\u5b8c\u7a0e\u51ed\u8bc1\u4e0b\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e0d\u5b58\u5728\u5173\u8054\u7684\u7a0e\u671f\u7533\u62a5\u8bb0\u5f55", (String)"GxsjMessageSendServiceImpl_17", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(ResManager.loadKDString((String)"(\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\uff1a", (String)"GxsjMessageSendServiceImpl_18", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(sd.format(skssqzDate)).append(")");
                queryInfo.insert(0, ResManager.loadKDString((String)"gxsj \u51ed\u8bc1\u4e0b\u8f7d\u5931\u8d25\uff0c\u672a\u627e\u5230\u5173\u8054\u7684\u7533\u62a5\u8bb0\u5f55", (String)"GxsjMessageSendServiceImpl_19", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                logger.error(queryInfo.toString());
            }
            if (failedlog.length() > 0) {
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedlog);
                return CustomApiResult.dealResponse(null, failedlog.toString(), "3", false);
            }
            Class<?> clazz = Class.forName(TaxTypeDeclareForGxEnums.ZZSYBNSR.getPath());
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object newInstance = constructor.newInstance(new Object[0]);
            result = (ApiResult)clazz.getMethod("downloadVoucher", SBMessageBaseVo.class).invoke(newInstance, vo);
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04\u8c03\u7528\u5931\u8d25-" + ExceptionUtil.toString((Exception)e));
            failedlog.append(ResManager.loadKDString((String)"\u51ed\u8bc1\u4e0b\u8f7d\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u67e5\u770b", (String)"GxsjMessageSendServiceImpl_20", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedlog);
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25", (String)"GxsjMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
        return result;
    }

    @Override
    public ApiResult refresh(SBMessageBaseVo vo) {
        ApiResult result;
        try {
            Class<?> clazz = Class.forName(TaxTypeDeclareForGxEnums.getClassPathByKey(vo.getType()));
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object newInstance = constructor.newInstance(new Object[0]);
            result = (ApiResult)clazz.getMethod("refresh", SBMessageBaseVo.class).invoke(newInstance, vo);
        }
        catch (Exception e) {
            logger.error("\u53cd\u5c04\u8c03\u7528\u5931\u8d25-" + ExceptionUtil.toString((Exception)e));
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25", (String)"GxsjMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
        return result;
    }

    @Override
    public ApiResult downloadSbsx(SBMessageBaseVo vo) {
        try {
            logger.info("gxsj \u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u5f00\u59cb " + vo.getNsrsbh());
            return this.doDownloadSbsx(vo);
        }
        catch (Exception e) {
            String stackMsg = ExceptionUtil.toString((Exception)e);
            TsateDeclareRecordBusiness.failRecord((Long)vo.getId(), (String)ResManager.loadKDString((String)"\u5e7f\u897f\u7a0e\u5c40\u4e0b\u8f7d\u4ee3\u529e\u5f02\u5e38", (String)"GxsjMessageSendServiceImpl_21", (String)"taxc-tsate-mservice", (Object[])new Object[0]), null, (String)stackMsg);
            logger.error("c" + e.getMessage());
            logger.error(stackMsg);
            return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u5e7f\u897f\u7a0e\u5c40\u4e0b\u8f7d\u4ee3\u529e\u5f02\u5e38", (String)"GxsjMessageSendServiceImpl_21", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
    }

    public ApiResult doDownloadSbsx(SBMessageBaseVo vo) {
        StringBuilder failLog = new StringBuilder();
        boolean exsitFail = false;
        SbsxxzMessageVo sbsxxzVo = (SbsxxzMessageVo)vo.handler(SbsxxzMessageVo.class);
        Long recordId = vo.getId();
        ApiResult todoResult = GxsjDeclareService.getQc(vo);
        if (!todoResult.getSuccess()) {
            TsateDeclareRecordBusiness.failRecord((Long)recordId, (String)todoResult.getMessage(), (String)todoResult.getMessage());
            return todoResult;
        }
        String swjgmc = null;
        Long orgId = Long.parseLong(vo.getOrg());
        Long taxorgId = sbsxxzVo.getLong(SbsxxzMessageVo.Key.TAXORG);
        String source = sbsxxzVo.getString(SbsxxzMessageVo.Key.DATASOURCE);
        Long createor = sbsxxzVo.getLong(SbsxxzMessageVo.Key.OPERATOR);
        Long taskId = sbsxxzVo.getLong(SbsxxzMessageVo.Key.TASK_ID);
        Date operateTime = new Date(sbsxxzVo.getLong(SbsxxzMessageVo.Key.OPERATTIME));
        Date now = new Date();
        Date ssqqMin = DateUtils.getFirstDateOfMonth((Date)now);
        Date ssqzMax = DateUtils.getLastDateOfMonth((Date)now);
        Date downLoadTime = DateUtils.stringToDate((String)DateUtils.format((Date)operateTime, (String)"yyyy-MM"), (String)"yyyy-MM");
        List list = (List)todoResult.getData();
        DynamicObject checklistGroup = TsateDeclareChecklistBusiness.newGroupInstance((Long)orgId, (String)source, (Long)createor, (Date)operateTime, (Date)downLoadTime, null, (String)"0");
        DynamicObjectCollection checklist = TsateDeclareChecklistBusiness.newBodyByChecklisHead((DynamicObject)checklistGroup);
        for (QcInfo info : list) {
            boolean itemError = false;
            StringBuilder itemLog = new StringBuilder();
            String sbsx = info.getZsxm();
            String xmCode = info.getZsxmDm();
            String pmCode = info.getZspmDm();
            String xmName = info.getZsxmmc();
            String pmName = info.getZspmmc();
            DynamicObject zsxm = ZssxHelper.getZsxmByTaxofficCode(xmCode, xmName);
            if (zsxm == null) {
                itemLog.append(ResManager.loadKDString((String)"\u7a0e\u79cd-", (String)"GxsjMessageSendServiceImpl_8", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(xmName).append(";");
                itemError = true;
            }
            DynamicObject zspm = null;
            if (StringUtils.isNotEmpty((String)pmName) && (zspm = ZssxHelper.getZspmByTaxofficCode(pmCode, pmName)) == null) {
                itemLog.append(ResManager.loadKDString((String)"\u54c1\u76ee-", (String)"GxsjMessageSendServiceImpl_9", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(pmName).append(";");
                itemError = true;
            }
            if (itemError) {
                exsitFail = true;
                itemLog.insert(0, ResManager.loadKDString((String)"\u7cfb\u7edf\u7f3a\u5931\uff1a", (String)"GxsjMessageSendServiceImpl_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                logger.warn(itemLog.toString());
                failLog.append((CharSequence)itemLog);
                continue;
            }
            int[] status = GxdzsjResponseHelper.parsePayAndDeclareStatusFromTodo(info);
            Date ssqq = DateUtils.stringToDate((String)info.getSkssqq());
            Date ssqz = DateUtils.stringToDate((String)info.getSkssqz());
            Date sbrq = DateUtils.stringToDate((String)info.getNssbrq());
            Date sbqx = DateUtils.stringToDate((String)info.getSbqx());
            if (ssqz.after(ssqzMax)) {
                ssqzMax = ssqz;
            }
            if (ssqq.before(ssqqMin)) {
                ssqqMin = ssqq;
            }
            if (StringUtils.isEmpty(swjgmc)) {
                swjgmc = info.getSwjgmc();
            }
            TsateDeclareChecklistBusiness.newInstanceBody((DynamicObjectCollection)checklist, (Long)taxorgId, (String)sbsx, (long)zsxm.getLong("id"), (Long)(zspm != null ? Long.valueOf(zspm.getLong("id")) : null), (Date)ssqq, (Date)ssqz, (Date)sbqx, (Date)sbrq, (String)(status[0] + ""), (String)(status[1] + ""));
        }
        checklistGroup.set("swjgmc", swjgmc);
        if (exsitFail) {
            logger.info(JSON.toJSONString((Object)list));
        }
        logger.info("\u5e7f\u897f\u7533\u62a5\u4e8b\u9879\u63a5\u53e3\u5f00\u59cb\u8986\u76d6\u672c\u6b21\u4e0b\u8f7d\u6570\u636e orgId={} \u4e0b\u8f7d\u6708\u4efd={} \u8986\u76d6\u6761\u6570={}", new Object[]{checklistGroup.getLong("org"), downLoadTime, checklist.size()});
        TsateDeclareChecklistBusiness.savaGroupByCurrentMonth((DynamicObject)checklistGroup, (Date)downLoadTime, (Long)taskId);
        String detailLog = "";
        String detailLogTag = "";
        if (exsitFail) {
            detailLog = ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210\uff0c\u4f46\u5b58\u5728\u90e8\u5206\u5931\u8d25\u9879\u76ee\u3002", (String)"GxsjMessageSendServiceImpl_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            detailLogTag = failLog.insert(0, detailLog).toString();
        }
        TsateDeclareRecordBusiness.successRecord((Long)recordId, null, (String)detailLog, (String)detailLogTag);
        return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u6210\u529f", (String)"GxsjMessageSendServiceImpl_13", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
    }

    @Override
    public ApiResult undo(SBMessageBaseVo vo) {
        logger.info("gxsj\u4f5c\u5e9fstep1 \u67e5\u8be2\u7a0e\u5c40\u7533\u62a5\u72b6\u6001" + vo.getNsrsbh());
        ArrayList<DeclareInfo> list = new ArrayList<DeclareInfo>(8);
        ApiResult result = GxsjDeclareService.getDeclareStatusByTaxperiod(vo, list);
        StringBuilder failedLog = new StringBuilder();
        if (!result.getSuccess()) {
            logger.info("gxsj\u7f34\u6b3estep1 \u67e5\u8be2\u7a0e\u5c40\u7533\u62a5\u72b6\u6001\u5931\u8d25,\u8be6\u60c5\uff1a" + result.getMessage());
            failedLog.append(ResManager.loadKDString((String)"\u4f5c\u5e9f\u5931\u8d25\uff0c\u67e5\u8be2\u7a0e\u5c40\u7533\u62a5\u72b6\u6001\u5f02\u5e38\uff0c\u8be6\u60c5:", (String)"GxsjMessageSendServiceImpl_24", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(result.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "payfailed", "3", failedLog);
            return result;
        }
        String code = result.getData().toString();
        if (!"4".equals(code)) {
            logger.info("gxsj\u7f34\u6b3estep1 \u7a0e\u5c40\u7533\u62a5\u672a\u5b8c\u6210\uff0c\u7ec8\u6b62\u4f5c\u5e9f");
            failedLog.append(ResManager.loadKDString((String)"\u4f5c\u5e9f\u5931\u8d25\uff0c\u7a0e\u5c40\u7533\u62a5\u72b6\u6001\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u5b8c\u6210\u7533\u62a5", (String)"GxsjMessageSendServiceImpl_27", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "payfailed", "3", failedLog);
            return result;
        }
        logger.info("gxsj\u4f5c\u5e9fstep2 \u67e5\u8be2\u7a0e\u5c40\u7533\u62a5\u72b6\u6001" + vo.getNsrsbh());
        Set pzxhs = list.stream().filter(item -> item.getPzxh() != null).map(item -> item.getPzxh()).collect(Collectors.toSet());
        int size = pzxhs.size();
        int successSize = 0;
        int failSize = 0;
        for (DeclareInfo info : list) {
            ApiResult undoresult = GxsjDeclareService.cancellation(vo, info);
            if (undoresult.getSuccess()) {
                ++successSize;
                continue;
            }
            ++failSize;
            failedLog.append(info.getPzxh()).append("-").append(undoresult.getMessage());
        }
        if (size > 1) {
            String sizeMsg = ResManager.loadKDString((String)"\uff08\u9644\u52a0\u4fe1\u606f-\u51ed\u8bc1\u5e8f\u53f7\u4e2a\u6570\uff1a%1$s  \u4f5c\u5e9f\u6210\u529f\u4e2a\u6570\uff1a%2$s \u5931\u8d25\u4e2a\u6570\uff1a%3$s\uff09", (String)"GxsjMessageSendServiceImpl_28", (String)"taxc-tsate-mservice", (Object[])new Object[]{size, successSize, failSize});
            failedLog.append(sizeMsg);
            logger.info(sizeMsg);
        }
        if (successSize > 0) {
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "editing", "2", failedLog);
        } else {
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return CustomApiResult.dealResponse(null, null, "4", true);
    }

    public static DynamicObject buildRequestId(String requestId, SBMessageBaseVo vo) {
        return GxsjMessageSendServiceImpl.buildRequestId(requestId, vo, RequestTypeEnum.DECLARE);
    }

    public static DynamicObject buildRequestId(String requestId, SBMessageBaseVo vo, RequestTypeEnum requestType) {
        DynamicObject taxOrg;
        if (requestType == null) {
            requestType = RequestTypeEnum.DECLARE;
        }
        if ((taxOrg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())})) != null) {
            Object obj;
            DynamicObject requestInfo = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1", requestType);
            if (requestInfo == null) {
                requestInfo = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_status_info");
                requestInfo.set("org", (Object)taxOrg.getLong("org"));
                requestInfo.set("skssqq", (Object)vo.getSkssqq());
                requestInfo.set("skssqz", (Object)vo.getSkssqz());
                requestInfo.set("type", (Object)vo.getType());
                requestInfo.set("billstatus", (Object)"C");
                requestInfo.set("requesttype", (Object)requestType.getCode());
            }
            requestInfo.set("executestatus", (Object)"1");
            requestInfo.set("createtime", (Object)new Date());
            requestInfo.set("creator", (Object)RequestContext.get().getUserId());
            requestInfo.set("requestid", (Object)requestId);
            Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{requestInfo});
            if (result.length > 0 && (obj = result[0]) instanceof DynamicObject) {
                DynamicObject dynObj = (DynamicObject)obj;
                return dynObj;
            }
        }
        return null;
    }

    public static String getTripleAggrementInfo(SBMessageBaseVo vo) {
        Optional<DynamicObject> optional;
        DynamicObjectCollection objs;
        DynamicObject d;
        if (EmptyCheckUtils.isNotEmpty((Object)vo.getOrg()) && null != (d = BusinessDataServiceHelper.loadSingle((String)"tctb_tax_main", (String)"entryentity.tripleaggrement,entryentity.bankacct,entryentity.taxacct", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)Long.valueOf(vo.getOrg()))})) && CollectionUtils.isNotEmpty((Collection)(objs = d.getDynamicObjectCollection("entryentity"))) && (optional = objs.stream().filter(a -> a.getBoolean("taxacct")).findFirst()).isPresent()) {
            return optional.get().getString("tripleaggrement");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResult creditLevelDownload(SBMessageBaseVo sbMessageBaseVo) {
        ApiResult result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u8c03\u7528\u5931\u8d25", (String)"GxsjMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        List<String> downLoadYears = sbMessageBaseVo.getDownLoadYears();
        HashMap<String, Object> successData = new HashMap<String, Object>();
        StringBuilder failedlog = new StringBuilder();
        Long recordId = sbMessageBaseVo.getId();
        try {
            for (String downLoadYear : downLoadYears) {
                ApiResult apiResult = GxsjDeclareService.getYearEvaluation(sbMessageBaseVo, downLoadYear);
                if (apiResult.getSuccess()) {
                    Object data = apiResult.getData();
                    successData.put(downLoadYear, data);
                    continue;
                }
                String failMsg = apiResult.getMessage();
                String notiffy = ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u6267\u884c\u7b49\u7ea7\u4e0b\u8f7d\u5b58\u5728\u5931\u8d25\u90e8\u5206: %1$s \u4e0b\u8f7d\u5e74\u5ea6\u4e3a%2$s-\u9519\u8bef\u63d0\u793a\uff1a%3$s", (String)"GxsjMessageSendServiceImpl_29", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                failedlog.append(String.format(notiffy, apiResult.getMessage(), System.lineSeparator(), downLoadYear, failMsg));
                DirectDeclareLogUtils.updateStatus(recordId, "3", new StringBuilder(failMsg));
                ApiResult apiResult2 = result;
                return apiResult2;
            }
            Map<String, CreditLevelInfoDto> saveData = this.dealSuccessData(successData);
            this.saveData(sbMessageBaseVo.getOrg(), saveData, sbMessageBaseVo.getDownLoadYears());
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u6210\u529f", (String)"GxsjMessageSendServiceImpl_13", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
        }
        catch (Exception e) {
            failedlog.append(ResManager.loadKDString((String)"\u8c03\u7528\u5e74\u5ea6\u4fe1\u7528\u7b49\u7ea7\u4e0b\u8f7d\u63a5\u53e3\u5f02\u5e38,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458", (String)"GxsjMessageSendServiceImpl_25", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            logger.error("\u8c03\u7528\u5e74\u5ea6\u4fe1\u7528\u7b49\u7ea7\u4e0b\u8f7d\u63a5\u53e3\u5f02\u5e38,recordId={},\u4e0b\u8f7d\u5e74\u5ea6\u4e3a{}\u2014{},\u5f02\u5e38\u4fe1\u606f={}", new Object[]{recordId, downLoadYears.get(downLoadYears.size()), downLoadYears.get(0), e.getMessage()});
        }
        finally {
            if (result.getSuccess()) {
                DirectDeclareLogUtils.updateStatus(recordId, "2", failedlog);
            } else {
                DirectDeclareLogUtils.updateStatus(recordId, "3", failedlog);
            }
        }
        return result;
    }

    private void saveData(String org, Map<String, CreditLevelInfoDto> saveData, List<String> downLoadYears) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,evaluationyear,evaluationresult,evaluationscore,evaluationlevel,isstartcreditlevel,isalldeal,modifytime,comparestatus,updatestatus", (QFilter[])new QFilter("org", "=", (Object)Long.valueOf(org)).and(new QFilter("evaluationyear", "in", downLoadYears)).toArray())) {
            CreditLevelInfoDto saveDatum;
            String evaluationyear = obj.getString("evaluationyear");
            if (StringUtils.isBlank((String)evaluationyear) || EmptyCheckUtils.isEmpty((Object)(saveDatum = saveData.get(evaluationyear)))) continue;
            this.buildSaveData(saveDatum, obj);
            saveData.remove(evaluationyear);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
        if (saveData.isEmpty()) {
            TaxCreditLevelBusiness.compareCreditWithDefaultFilter((DynamicObject[])objs);
            TaxCreditLevelBusiness.updateTaxMainInfoWithDefaultFilter((DynamicObject[])objs);
            return;
        }
        DynamicObject[] newData = new DynamicObject[saveData.size()];
        int index = 0;
        for (Map.Entry<String, CreditLevelInfoDto> entry : saveData.entrySet()) {
            CreditLevelInfoDto saveDatum = entry.getValue();
            DynamicObject creditLevel = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
            creditLevel.set("org", (Object)org);
            this.buildSaveData(saveDatum, creditLevel);
            newData[index] = creditLevel;
            ++index;
        }
        Object[] savedData = SaveServiceHelper.save((DynamicObject[])newData);
        TaxCreditLevelBusiness.compareCreditWithDefaultFilter((DynamicObject[])((DynamicObject[])savedData));
        TaxCreditLevelBusiness.updateTaxMainInfoWithDefaultFilter((DynamicObject[])((DynamicObject[])savedData));
    }

    private void buildSaveData(CreditLevelInfoDto saveDatum, DynamicObject obj) {
        obj.set("evaluationyear", (Object)saveDatum.getEvaluationyear());
        obj.set("evaluationresult", (Object)saveDatum.getEvaluationresult());
        obj.set("evaluationscore", (Object)saveDatum.getEvaluationscore());
        obj.set("evaluationlevel", (Object)saveDatum.getEvaluationlevel());
        obj.set("isstartcreditlevel", (Object)saveDatum.getIsstartcreditlevel());
        obj.set("isalldeal", (Object)saveDatum.getIsalldeal());
        obj.set("modifytime", (Object)new Date());
        obj.set("comparestatus", (Object)"undo");
        obj.set("updatestatus", (Object)"undo");
    }

    private Map<String, CreditLevelInfoDto> dealSuccessData(Map<String, Object> successData) {
        HashMap<String, CreditLevelInfoDto> saveData = new HashMap<String, CreditLevelInfoDto>(successData.size());
        for (Map.Entry<String, Object> entry : successData.entrySet()) {
            String downLoadYear = entry.getKey();
            CreditLevelInfoDto vo = this.dataToCreditLevelInfo(entry.getValue());
            vo.setEvaluationyear(downLoadYear);
            saveData.put(downLoadYear, vo);
        }
        return saveData;
    }

    private CreditLevelInfoDto dataToCreditLevelInfo(Object o) {
        CreditLevelInfoDto vo = new CreditLevelInfoDto();
        String testXML = String.valueOf(o);
        Map<String, Object> map = XmlTJsonUtil.xml2ObjectMap(testXML);
        Map resp = (Map)map.get("taxML");
        vo.setIsalldeal(this.sjKey2DataValue((String)resp.get("fhsqsfqbsl")));
        vo.setEvaluationresult(this.sjKey2DataValue((String)resp.get("pjjg")));
        vo.setIsstartcreditlevel(this.sjKey2DataValue((String)resp.get("sffqxyfh")));
        vo.setEvaluationscore((String)resp.get("pjfs"));
        vo.setEvaluationlevel(this.sjKey2DataValue((String)resp.get("pjjb")));
        return vo;
    }

    private String sjKey2DataValue(String s) {
        return TaxCreditLevelEnums.getTaxCreditLevelEnumsBySjType(s);
    }
}

