/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.gxdzsj.api;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.DeclareInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.Identification;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.QcInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.SjSysConfig;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.TechContent;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.YjsfInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.helper.GxdzsjResponseHelper;
import kd.taxc.tsate.msmessage.util.GxSM4Util;

public class GxdzsjRequest {
    private static Log logger = LogFactory.getLog(GxdzsjRequest.class);

    public static ApiResult cancellation(String nsrsbh, String pzxh, String skssqq, String skssqz, Identification identification, SjSysConfig config) {
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.HXZG.SB.BCSBZF");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(UUID.randomUUID().toString().replace("-", ""));
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        String businessContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><taxML><sbSbzfxxVO xmlbh=\"String\" bbh=\"String\" xmlmc=\"String\"><pzxh>$pzxh</pzxh><nsrsbh>$nsrsbh</nsrsbh><skssqq>$skssqq</skssqq><skssqz>$skssqz</skssqz></sbSbzfxxVO></taxML>";
        businessContent = businessContent.replace("$nsrsbh", nsrsbh);
        businessContent = businessContent.replace("$pzxh", pzxh);
        businessContent = businessContent.replace("$skssqq", skssqq);
        businessContent = businessContent.replace("$skssqz", skssqz);
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent, config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    public static ApiResult cancellation(DeclareInfo declareInfo, Identification identification, SjSysConfig config) {
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.HXZG.SB.BCSBZF");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(UUID.randomUUID().toString().replace("-", ""));
        techContent.setNsrsbh(declareInfo.getNsrsbh());
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        String businessContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><taxML><sbSbzfxxVO xmlbh=\"String\" bbh=\"String\" xmlmc=\"String\"><pzxh>$pzxh</pzxh><nsrsbh>$nsrsbh</nsrsbh><skssqq>$skssqq</skssqq><skssqz>$skssqz</skssqz><zsxmDm>$zsxmDm</zsxmDm><yzpzzlDm>$yzpzzlDm</yzpzzlDm><sbuuid>$sbuuid</sbuuid><sbrq1>$sbrq1</sbrq1><ybtse>$ybtse</ybtse></sbSbzfxxVO></taxML>";
        businessContent = businessContent.replace("$nsrsbh", declareInfo.getNsrsbh()).replace("$pzxh", declareInfo.getPzxh()).replace("$skssqq", declareInfo.getSkssqq()).replace("$skssqz", declareInfo.getSkssqz()).replace("$zsxmDm", declareInfo.getZsxmDm()).replace("$yzpzzlDm", declareInfo.getYzpzzlDm()).replace("$sbuuid", declareInfo.getSbuuid()).replace("$sbrq1", declareInfo.getSbrq()).replace("$ybtse", declareInfo.getYbtse());
        String encryptBusinessContent = null;
        logger.info("\u8bf7\u6c42\u53c2\u6570\uff08\u660e\u6587\uff09\uff1a{}", (Object)businessContent);
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent, config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    public static ApiResult queryYearEvaluation(String nsrsbh, String year, Identification identification, SjSysConfig config) {
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.JC2B.NSXY.NDPJJGCX");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(UUID.randomUUID().toString().replace("-", ""));
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        String businessContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><taxML xsi:type=\"RSJ2XY901Request\" xmlns=\"http://www.chinatax.gov.cn/dataspec/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><nsrsbh>$nsrsbh</nsrsbh><pjnd>$pjnd</pjnd></taxML>/nsrsbh></taxML>";
        businessContent = businessContent.replace("$nsrsbh", nsrsbh).replace("$pjnd", year);
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent, config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    public static ApiResult queryTodo(String nsrsbh, Identification identification, SjSysConfig config) {
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.SFPTFW.SB.CXDQSBSX");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(UUID.randomUUID().toString().replace("-", ""));
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        String businessContent = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?><taxML><nsrsbh>$nsrsbh</nsrsbh></taxML>";
        businessContent = businessContent.replace("$nsrsbh", nsrsbh);
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent, config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        String repXml = (String)checkResult.getData();
        List<QcInfo> data = GxdzsjResponseHelper.parsePmFromQc(repXml);
        checkResult.setData(data);
        return checkResult;
    }

    public static ApiResult queryDeclareInit(String nsrsbh, String qq, String qz, Identification identification, SjSysConfig config) {
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.HXZG.SB.ZZSYBRSBSQJKJHQQCSJ");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(UUID.randomUUID().toString().replace("-", ""));
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        String businessContent = "<taxML><sbNsrxxJhVO><nsrsbh>$nsrsbh</nsrsbh><skssqq>$skssqq</skssqq><skssqz>$skssqz</skssqz><sbsxDm1>$sbsxDm1</sbsxDm1><yzpzzlDm>$yzpzzlDm</yzpzzlDm></sbNsrxxJhVO></taxML>";
        businessContent = businessContent.replace("$nsrsbh", nsrsbh).replace("$nsrsbh", nsrsbh).replace("$skssqq", qq).replace("$skssqz", qz).replace("$sbsxDm1", "11").replace("$yzpzzlDm", "BDA0610606");
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent, config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        String repXml = (String)checkResult.getData();
        List<QcInfo> data = GxdzsjResponseHelper.parsePmFromQc(repXml);
        checkResult.setData(data);
        return checkResult;
    }

    public static ApiResult queryDeclareStatusByRequestId(String nsrsbh, String requestId, String qq, String qz, Identification identification, SjSysConfig config) {
        String token = identification.genToken(config.getKey());
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.SFPTFW.SB.CXSBXX");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(UUID.randomUUID().toString().replace("-", ""));
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(token);
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        String businessContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><taxML><jylsh>%s</jylsh><nsrsbh>%s</nsrsbh><skssqq>%s</skssqq><skssqz>%s</skssqz><zsxmDm>10101</zsxmDm><yzpzzlDm>BDA0610606</yzpzzlDm></taxML>";
        businessContent = String.format(businessContent, requestId, nsrsbh, qq, qz);
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent, config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        String repXml = (String)checkResult.getData();
        if (StringUtils.isNotEmpty((String)repXml)) {
            checkResult.setData((Object)repXml);
        }
        return checkResult;
    }

    public static ApiResult declare(String tranSeq, String nsrsbh, String businessContent, Identification identification, SjSysConfig config) {
        if (tranSeq.length() != 32) {
            logger.error("\u5e7f\u897f\u7a0e\u5c40\u7533\u62a5-\u7533\u62a5\u6d41\u6c34\u53f7\u9700\u898132\u4f4d\u5b57\u7b26\u4e32");
            return CustomApiResult.dealResponse(null, "system error\uff0ctranseq length should be 32", "3", false);
        }
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.HXZG.SB.BCZZSYBRSB");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(tranSeq);
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent, config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25");
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            String msg = checkResult.getMessage();
            if (StringUtils.isNotEmpty((String)msg) && msg.indexOf(ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38", (String)"GxdzsjRequest_0", (String)"taxc-tsate-mservice", (Object[])new Object[0])) != -1) {
                checkResult.setErrorCode("2");
            }
            return checkResult;
        }
        return checkResult;
    }

    public static ApiResult queryDeclareStatusByPeriod(String nsrsbh, String qq, String qz, Identification identification, SjSysConfig config) {
        String token = identification.genToken(config.getKey());
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.SFPTFW.SB.CXSBXX");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(UUID.randomUUID().toString().replace("-", ""));
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(token);
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        String businessContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><taxML><nsrsbh>$nsrsbh</nsrsbh><skssqq>$skssqq</skssqq><skssqz>$skssqz</skssqz><zsxmDm>10101</zsxmDm><yzpzzlDm>BDA0610606</yzpzzlDm></taxML>";
        businessContent = businessContent.replace("$nsrsbh", nsrsbh);
        businessContent = businessContent.replace("$skssqq", qq);
        businessContent = businessContent.replace("$skssqz", qz);
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent, config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        String repXml = (String)checkResult.getData();
        if (StringUtils.isNotEmpty((String)repXml)) {
            checkResult.setData((Object)repXml);
        }
        return checkResult;
    }

    public static ApiResult queryCredit(String nsrsbh, String year, String month, Identification identification, SjSysConfig config) {
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.SFPTFW.NSXY.CXNSRXYRCXX");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(UUID.randomUUID().toString().replace("-", ""));
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        String businessContent = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?><taxML><nsrsbh>$nsrsbh</nsrsbh><nd>$nd</nd><yf>$yf</yf></taxML>";
        businessContent = businessContent.replace("$nsrsbh", nsrsbh).replace("$nd", year).replace("$yf", month);
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent, config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    public static ApiResult queryPayInfo(String nsrsbh, String qq, String qz, String zsxmDm, String yzpzzlDm, String pzxh, String jylsh, Identification identification, SjSysConfig config) {
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.SFPTFW.ZS.CXYJSF");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(UUID.randomUUID().toString().replace("-", ""));
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        String businessContent = "<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?><taxML><nsrsbh>$nsrsbh</nsrsbh><nd>$nd</nd><yf>$yf</yf></taxML>";
        businessContent = "<taxML><jylsh>$jylsh</jylsh><pzxh>$pzxh</pzxh><nsrsbh>$nsrsbh</nsrsbh><skssqq>$skssqq</skssqq><skssqz>$skssqz</skssqz><zsxmDm>$zsxmDm</zsxmDm><yzpzzlDm>$yzpzzlDm</yzpzzlDm></taxML>";
        businessContent = StringUtils.isNotEmpty((String)jylsh) ? businessContent.replace("$jylsh", jylsh) : businessContent.replace("$jylsh", "");
        businessContent = businessContent.replace("$nsrsbh", nsrsbh);
        businessContent = businessContent.replace("$skssqq", qq);
        businessContent = businessContent.replace("$skssqz", qz);
        businessContent = businessContent.replace("$zsxmDm", zsxmDm);
        businessContent = businessContent.replace("$yzpzzlDm", yzpzzlDm);
        businessContent = StringUtils.isNotEmpty((String)pzxh) ? businessContent.replace("$pzxh", pzxh) : businessContent.replace("$pzxh", "");
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent, config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    public static ApiResult pay(String tranSeq, String nsrsbh, String sfxyh, List<YjsfInfo> yjsfInfoList, Identification identification, SjSysConfig config) {
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.HXZG.ZS.SKYSKJN");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(tranSeq);
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        StringBuilder detail = new StringBuilder();
        yjsfInfoList.forEach(yjsfInfo -> detail.append("<yzpzmxxhGridlb><yzpzmxxh>").append(yjsfInfo.getYzpzmxxh()).append("</yzpzmxxh><zsuuid>").append(yjsfInfo.getZsuuid()).append("</zsuuid><kkje>").append(yjsfInfo.getYbtse()).append("</kkje></yzpzmxxhGridlb>"));
        String yzpzxh = yjsfInfoList.get(0).getYzpzxh();
        StringBuilder businessContent = new StringBuilder();
        businessContent.append("<taxML><nsrsbh>").append(nsrsbh).append("</nsrsbh><sfxyh>").append(sfxyh).append("</sfxyh><yzpzxhGrid><yzpzxhGridlb><yzpzxh>").append(yzpzxh).append("</yzpzxh><yzpzmxxhGrid>").append((CharSequence)detail).append("</yzpzmxxhGrid></yzpzxhGridlb></yzpzxhGrid></taxML>");
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent.toString(), config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    public static ApiResult issueVoucher(String tranSeq, String nsrsbh, String qq, String qz, String dzsphm, Identification identification, SjSysConfig config) {
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.HXZG.ZS.ZKSSWSZM");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(tranSeq);
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        StringBuilder businessContent = new StringBuilder();
        businessContent.append("<taxML><nsrsbh>").append(nsrsbh).append("</nsrsbh><skssqq>").append(qq).append("</skssqq><skssqz>").append(qz).append("</skssqz><dzsphm>").append(dzsphm).append("</dzsphm></taxML>");
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent.toString(), config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    public static ApiResult queryVoucher(String nsrsbh, String wszmuuid, String fileUuid, Identification identification, SjSysConfig config) {
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.SFPTFW.ZS.CXZKSSWSZM");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(UUID.randomUUID().toString().replace("-", ""));
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        StringBuilder businessContent = new StringBuilder();
        businessContent.append("<taxML><nsrsbh>").append(nsrsbh).append("</nsrsbh><wszmuuid>").append(wszmuuid).append("</wszmuuid><fileUuid>").append(fileUuid).append("</fileUuid></taxML>");
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent.toString(), config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    public static ApiResult queryTripleAgreement(String nsrsbh, Identification identification, SjSysConfig config) {
        TechContent techContent = new TechContent();
        techContent.setAppId(config.getAppid());
        techContent.setTranId("SFPT.GX.HXZG.ZS.CXSFXYXX");
        Date now = new Date();
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("HHmmssSSS");
        techContent.setTranTime(sdfTime.format(now));
        techContent.setTranDate(sdfDate.format(now));
        techContent.setTranVersion("V1.0");
        techContent.setTranSeq(UUID.randomUUID().toString().replace("-", ""));
        techContent.setNsrsbh(nsrsbh);
        techContent.setToken(identification.genToken(config.getKey()));
        String sign = techContent.genSign(config.getKey());
        techContent.setSign(sign);
        StringBuilder businessContent = new StringBuilder();
        businessContent.append("<taxML><nsrsbh>").append(nsrsbh).append("</nsrsbh></taxML>");
        String encryptBusinessContent = null;
        try {
            encryptBusinessContent = GxSM4Util.encryptByEcb(businessContent.toString(), config.getKey());
        }
        catch (Exception e) {
            logger.error("\u56fd\u5bc6SM4\u52a0\u5bc6\u5931\u8d25" + e.getMessage());
            return CustomApiResult.dealResponse(null, e.getMessage(), "3", false);
        }
        String xml = GxdzsjRequest.getRequestXmlContent(techContent, encryptBusinessContent);
        String rep = GxdzsjRequest.httpRequest(xml);
        ApiResult checkResult = GxdzsjResponseHelper.checkRepTechContent(rep, config.getKey());
        if (!checkResult.getSuccess()) {
            return checkResult;
        }
        return checkResult;
    }

    private static String httpRequest(String xml) {
        String rep = null;
        try {
            rep = GxdzsjRequest.invokeService(xml);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rep;
    }

    private static String invokeService(String xmlBody) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("xmlbody", xmlBody);
        Object result = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscApicService", (String)"invokeExternalApi2", (Object[])new Object[]{"taxc_gxtax_common_post", param, "taxc-tsate"});
        return result.toString();
    }

    private static String getRequestXmlContent(TechContent techContent, String businessContetent) {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><service xmlns=\"http://www.chinatax.gov.cn/spec/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><head><app_id>");
        xml.append(techContent.getAppId());
        xml.append("</app_id><tran_id>");
        xml.append(techContent.getTranId());
        xml.append("</tran_id><tran_version>");
        xml.append(techContent.getTranVersion());
        xml.append("</tran_version><tran_seq>");
        xml.append(techContent.getTranSeq());
        xml.append("</tran_seq><tran_date>");
        xml.append(techContent.getTranDate());
        xml.append("</tran_date><tran_time>");
        xml.append(techContent.getTranTime());
        xml.append("</tran_time><nsrsbh>");
        xml.append(techContent.getNsrsbh());
        xml.append("</nsrsbh><token>");
        xml.append(techContent.getToken());
        xml.append("</token><sign>");
        xml.append(techContent.getSign());
        xml.append("</sign></head><body><![CDATA[");
        xml.append(businessContetent);
        xml.append("]]></body></service>");
        return xml.toString();
    }
}

