/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.gxdzsj.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.DeclareInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.PayStatusInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.QcInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.TechContent;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.VoucherInfo;
import kd.taxc.tsate.msmessage.service.gxdzsj.bean.YjsfInfo;
import kd.taxc.tsate.msmessage.util.GxSM4Util;
import kd.taxc.tsate.msxml.util.XmlUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GxdzsjResponseHelper {
    private static Log logger = LogFactory.getLog(GxdzsjResponseHelper.class);

    private GxdzsjResponseHelper() {
    }

    public static ApiResult checkRepTechContent(String xml, String key) {
        if (StringUtils.isEmpty((String)xml)) {
            logger.error("gxsj \u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38\uff0c\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e");
            return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38,\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e", (String)"GxdzsjResponseHelper_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
        ApiResult apiResult = null;
        Element root = null;
        try {
            root = DocumentHelper.parseText((String)xml).getRootElement();
        }
        catch (Exception e) {
            logger.error("gxsj \u63a5\u53e3\u8fd4\u56de XML \u89e3\u6790\u5f02\u5e38" + e.getMessage());
            return CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5f02\u5e38", (String)"GxdzsjResponseHelper_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        }
        String rtncode = XmlUtil.getSingleValueByPath(root, "service.head.rtn_code");
        StringBuilder erro = new StringBuilder();
        switch (rtncode.substring(0, 1)) {
            case "0": {
                break;
            }
            case "1": {
                erro.append(ResManager.loadKDString((String)"\u5b89\u5168\u8ba4\u8bc1\u6216\u6743\u9650\u9519\u8bef", (String)"GxdzsjResponseHelper_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                break;
            }
            case "2": {
                erro.append(ResManager.loadKDString((String)"\u62a5\u6587\u9519\u8bef", (String)"GxdzsjResponseHelper_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                break;
            }
            case "3": {
                erro.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf\u6267\u884c\u9519\u8bef", (String)"GxdzsjResponseHelper_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                break;
            }
            case "9": {
                erro.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u7ea7\u522b\u9519\u8bef", (String)"GxdzsjResponseHelper_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                break;
            }
        }
        Map<String, String> rtnMessage = XmlUtil.getSingleObjectByPath(root, "service.head.rtn_msg");
        String subCode = rtnMessage.get("Code");
        String message = rtnMessage.get("Message");
        String encryptBody = XmlUtil.getSingleValueByPath(root, "service.body");
        String bodyXml = null;
        if (StringUtils.isNotEmpty((String)encryptBody)) {
            try {
                bodyXml = GxSM4Util.decryptEcb(key, encryptBody);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!"0000".equals(rtncode)) {
            logger.info("gxsj \u63a5\u53e3\u8bf7\u6c42\u6210\u529f\u4f46\u8fd4\u56de\u9519\u8bef\u7801");
            logger.info("gxsj \u8fd4\u56de\u5185\u5bb9\uff1a" + xml);
            erro.append("-").append(message).append("(").append(subCode).append(")");
            apiResult = CustomApiResult.dealResponse(null, erro.toString(), "3", false);
            return apiResult;
        }
        Map<String, String> headMap = XmlUtil.getSingleObjectByPath(root, "service.head");
        String appid = headMap.get("app_id");
        String tranid = headMap.get("tran_id");
        String tranversion = headMap.get("tran_version");
        String transeq = headMap.get("tran_seq");
        String trandate = headMap.get("tran_date");
        String trantime = headMap.get("tran_time");
        String nsrsbh = headMap.get("nsrsbh");
        String sign = headMap.get("sign");
        TechContent techContent = new TechContent();
        techContent.setAppId(appid);
        techContent.setNsrsbh(nsrsbh);
        techContent.setSign(sign);
        techContent.setTranDate(trandate);
        techContent.setTranId(tranid);
        techContent.setTranSeq(transeq);
        techContent.setTranTime(trantime);
        techContent.setTranVersion(tranversion);
        if (!techContent.checkSign(key)) {
            apiResult = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u9a8c\u7b7e\u5931\u8d25", (String)"GxdzsjResponseHelper_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
            return apiResult;
        }
        StringBuilder success = new StringBuilder();
        success.append(ResManager.loadKDString((String)"\u6210\u529f-", (String)"GxdzsjResponseHelper_7", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(message).append("(").append(subCode).append(")");
        apiResult = CustomApiResult.dealResponse(bodyXml, success.toString(), "4", true);
        return apiResult;
    }

    public static List<QcInfo> parsePmFromQc(String xml) {
        ArrayList<QcInfo> list = new ArrayList<QcInfo>();
        Element root = null;
        try {
            root = DocumentHelper.parseText((String)xml).getRootElement();
        }
        catch (DocumentException e) {
            logger.error("\u89e3\u6790body xml \u5f02\u5e38");
            return list;
        }
        List<Map<String, String>> listMap = XmlUtil.getListObjectByPath(root, "taxML.dqsbsxList.dqsbsx");
        listMap.forEach(map -> {
            QcInfo info = new QcInfo();
            info.setSbqx((String)map.get("sbqx"));
            info.setSkssqq((String)map.get("skssqq"));
            info.setSkssqz((String)map.get("skssqz"));
            info.setZspmmc((String)map.get("zspmmc"));
            info.setZspmDm((String)map.get("zspmDm"));
            info.setZsxm((String)map.get("zsxm"));
            info.setZsxmmc((String)map.get("zsxmmc"));
            info.setZsxmDm((String)map.get("zsxmDm"));
            info.setSbztmc((String)map.get("sbztmc"));
            info.setSwjgmc((String)map.get("swjgmc"));
            list.add(info);
        });
        return list;
    }

    public static Map<String, String> parseDeclareStatusFromRequest(String xml) {
        Map<String, String> map = new HashMap<String, String>();
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            map = XmlUtil.getSingleObjectByPath(doc.getRootElement(), "taxML");
        }
        catch (DocumentException e) {
            logger.error("gxsj-\u4e1a\u52a1\u62a5\u6587\u683c\u5f0f\u4e0d\u6b63\u786e \u5bfc\u81f4\u89e3\u6790\u51fa\u9519");
        }
        return map;
    }

    public static List<DeclareInfo> parseDeclareInfoFromStatusQuery(String xml) {
        ArrayList<DeclareInfo> list = new ArrayList<DeclareInfo>();
        Element root = null;
        try {
            root = DocumentHelper.parseText((String)xml).getRootElement();
        }
        catch (DocumentException e) {
            logger.error("\u89e3\u6790body xml \u5f02\u5e38");
            return list;
        }
        List<Map<String, String>> listMap = XmlUtil.getListObjectByPath(root, "sbxxGrid.sbxxGridlb");
        listMap.forEach(map -> {
            DeclareInfo info = new DeclareInfo();
            info.setPzxh((String)map.get("pzxh"));
            info.setNsrsbh((String)map.get("nsrsbh"));
            info.setNsrmc((String)map.get("nsrmc"));
            info.setYzpzzlmc((String)map.get("yzpzzlmc"));
            info.setZspmmc((String)map.get("zspmmc"));
            info.setZsxmmc((String)map.get("zsxmmc"));
            info.setSkssqq((String)map.get("skssqq"));
            info.setSkssqz((String)map.get("skssqz"));
            info.setJsyj((String)map.get("jsyj"));
            info.setYnse((String)map.get("ynse"));
            info.setYbtse((String)map.get("ybtse"));
            info.setSbrq((String)map.get("sbrq"));
            info.setSbzt((String)map.get("sbzt"));
            info.setSbuuid((String)map.get("sbuuid"));
            info.setZsxmDm((String)map.get("zsxmdm"));
            info.setYzpzzlDm((String)map.get("yzpzzldm"));
            list.add(info);
        });
        return list;
    }

    public static List<YjsfInfo> parsePayInfoFromQuery(String xml) {
        ArrayList<YjsfInfo> list = new ArrayList<YjsfInfo>();
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            logger.error("\u89e3\u6790 xml \u5f02\u5e38");
            return list;
        }
        List<Map<String, String>> mapList = XmlUtil.getListObjectByPath(doc.getRootElement(), "yjsfGrid.yjsfGridlb");
        mapList.forEach(map -> {
            if (map.containsKey("zsuuid")) {
                YjsfInfo item = new YjsfInfo();
                item.setJkqx((String)map.get("jkqx"));
                item.setJkrq((String)map.get("jkrq"));
                item.setJkzt((String)map.get("jkzt"));
                item.setKkje((String)map.get("kkje"));
                item.setMessage((String)map.get("message"));
                item.setStatus((String)map.get("status"));
                item.setYbtse((String)map.get("ybtse"));
                item.setYzpzmxxh((String)map.get("yzpzmxxh"));
                item.setYzpzxh((String)map.get("yzpzxh"));
                item.setYzpzzlmc((String)map.get("yzpzzlmc"));
                item.setZspmmc((String)map.get("zspmmc"));
                item.setZsuuid((String)map.get("zsuuid"));
                item.setZsxmmc((String)map.get("zsxmmc"));
                item.setYpzh((String)map.get("ypzh"));
                item.setYpzxh((String)map.get("ypzxh"));
                list.add(item);
            }
        });
        return list;
    }

    public static PayStatusInfo parsePayStatusFromPay(String xml) {
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            logger.error("\u89e3\u6790 xml \u5f02\u5e38");
            return null;
        }
        Map<String, String> map = XmlUtil.getSingleObjectByPath(doc.getRootElement(), "taxML.yzxxGrid.yzxxGridlb");
        PayStatusInfo payStatusInfo = new PayStatusInfo();
        payStatusInfo.setDzsphm(map.get("dzsphm"));
        payStatusInfo.setKkfhDm(map.get("kkfhDm"));
        payStatusInfo.setKkfhmc(map.get("kkfhmc"));
        payStatusInfo.setSjse(map.get("sjse"));
        return payStatusInfo;
    }

    public static VoucherInfo parseVoucherFromIssure(String xml) {
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            logger.error("\u89e3\u6790 xml \u5f02\u5e38");
            return null;
        }
        Map<String, String> map = XmlUtil.getSingleObjectByPath(doc.getRootElement(), "taxML");
        VoucherInfo target = new VoucherInfo();
        target.setFileuuid(map.get("fileUuid"));
        target.setWszmuuid(map.get("wszmuuid"));
        target.setLayoutFile(map.get("layoutFile"));
        target.setFormat(map.get("format"));
        return target;
    }

    public static int[] parsePayAndDeclareStatusFromTodo(QcInfo info) {
        int[] status = new int[2];
        String ztmc = info.getSbztmc();
        if (StringUtils.isNotEmpty((String)ztmc)) {
            switch (ztmc) {
                case "\u672a\u7533\u62a5": {
                    status[0] = 0;
                    status[1] = 0;
                    break;
                }
                case "\u5df2\u7533\u62a5\u65e0\u9700\u7f34\u6b3e": {
                    status[0] = 1;
                    status[1] = 2;
                    break;
                }
                case "\u5df2\u7533\u62a5": {
                    status[0] = 1;
                    status[1] = 0;
                    break;
                }
                case "\u5df2\u7533\u62a5\u672a\u7f34\u6b3e": {
                    status[0] = 1;
                    status[1] = 0;
                    break;
                }
                case "\u5df2\u7f34\u6b3e": {
                    status[0] = 1;
                    status[1] = 1;
                    break;
                }
                case "\u5df2\u7533\u62a5\u5df2\u7f34\u6b3e": {
                    status[0] = 1;
                    status[1] = 1;
                }
            }
        }
        return status;
    }
}

