/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.service.MessageSendService;
import kd.taxc.tsate.msmessage.service.qxy.service.QxyCompanyInfoService;
import kd.taxc.tsate.msmessage.service.qxy.service.QxyDeclareFileService;
import kd.taxc.tsate.msmessage.service.qxy.service.QxyDeclareService;
import kd.taxc.tsate.msmessage.service.qxy.service.QxyHistoryService;
import kd.taxc.tsate.msmessage.service.qxy.service.QxyPayServie;
import kd.taxc.tsate.msmessage.service.qxy.service.QxyQcService;
import kd.taxc.tsate.msmessage.service.qxy.service.QxySbqcService;
import kd.taxc.tsate.msmessage.service.qxy.service.QxyServiceInterface;
import kd.taxc.tsate.msmessage.service.qxy.service.QxySyncTaxStatusService;
import kd.taxc.tsate.msmessage.service.qxy.service.enums.QxyTaskServiceEnum;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;

public class QxyMessageSendServiceImpl
implements MessageSendService {
    private static final Log logger = LogFactory.getLog(QxyMessageSendServiceImpl.class);

    @Override
    public ApiResult refresh(SBMessageBaseVo vo) {
        String type = vo.getOperationType();
        ExecuteTypeEnums executeType = ExecuteTypeEnums.valuesOfKey((String)type);
        String nsrsbh = vo.getNsrsbh();
        String qyId = TsateCompanyInfoBusiness.getQyId((String)nsrsbh, (SupplierEnum)SupplierEnum.QXY);
        Long rocordId = vo.getId();
        logger.info("qxy-\u5f00\u59cb\u8fdb\u884c\u4efb\u52a1\u72b6\u6001\u67e5\u8be2 type={} nsrsbh={} recordId={}", new Object[]{type, nsrsbh, rocordId});
        QxyServiceInterface qxyService = QxyTaskServiceEnum.getServiceByTypeNumber(vo.getOperationType());
        if (qxyService != null) {
            qxyService.syncData(vo);
        }
        if (ExecuteTypeEnums.SJYZ == executeType) {
            QxyCompanyInfoService.synVerifyResult(qyId, rocordId);
        } else if (ExecuteTypeEnums.ZLSB == executeType) {
            QxyDeclareService.refreshDeclare(vo);
        } else if (ExecuteTypeEnums.SBZF == executeType) {
            QxyDeclareService.refreshUndo(vo);
        } else if (ExecuteTypeEnums.ZLJK == executeType) {
            QxyPayServie.refresh(vo);
        } else if (ExecuteTypeEnums.WSPZ == executeType || ExecuteTypeEnums.SBBFILE == executeType) {
            QxyDeclareFileService.synDeclareFileResult(qyId, vo);
        } else if (ExecuteTypeEnums.QCXZ == executeType) {
            QxyQcService.refresh(vo);
        } else if (ExecuteTypeEnums.TBZT == executeType) {
            QxySyncTaxStatusService.refresh(vo);
        } else if (ExecuteTypeEnums.SBQC == executeType) {
            QxySbqcService.refresh(vo);
        } else if (ExecuteTypeEnums.LSXZ == executeType) {
            QxyHistoryService.refresh(vo);
        }
        return new ApiResult();
    }

    @Override
    public ApiResult sendMessage(SBMessageBaseVo vo) {
        try {
            QxyDeclareService.declare(vo);
        }
        catch (Exception e) {
            logger.error("\u7533\u62a5\u5f02\u5e38:{}", (Object)vo.getNsrsbh());
            logger.error(ExceptionUtil.toString((Exception)e));
        }
        return new ApiResult();
    }

    @Override
    public ApiResult paymentRequest(SBMessageBaseVo vo) {
        try {
            QxyPayServie.pay(vo);
        }
        catch (Exception e) {
            logger.error("\u7f34\u6b3e\u5f02\u5e38:{}", (Object)vo.getNsrsbh());
            logger.error(ExceptionUtil.toString((Exception)e));
        }
        return new ApiResult();
    }

    @Override
    public ApiResult verify(SBMessageBaseVo vo) {
        ApiResult result = CustomApiResult.buildDefultFailResponse();
        String nsrsbh = vo.getNsrsbh();
        try {
            logger.info("qxy-\u5f00\u59cb\u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f nsrsbh={}", (Object)nsrsbh);
            result = QxyCompanyInfoService.dealCompanyInfo(vo);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38\uff1aerror={} nsrsbh={}", (Object)ExceptionUtil.toString((Exception)e), (Object)nsrsbh);
            String notify = ResManager.loadKDString((String)"\u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u65f6\u53d1\u751f\u5f02\u5e38\uff1a %1$s", (String)"QxyMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, e.getMessage());
            result.setMessage(notifyMsg);
        }
        return result;
    }

    @Override
    public ApiResult screenshot(SBMessageBaseVo vo) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResult downloadVoucher(SBMessageBaseVo vo) {
        TaxResult result = new TaxResult(false, null, ResManager.loadKDString((String)"\u8c03\u7528\u4e0b\u8f7d\u63a5\u53e3\u5f02\u5e38,\u8be6\u60c5", (String)"QxyMessageSendServiceImpl_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), null);
        Long recordId = vo.getId();
        StringBuilder failedlog = new StringBuilder(ResManager.loadKDString((String)"\u8c03\u7528\u4e0b\u8f7d\u63a5\u53e3\u5f02\u5e38,\u8be6\u60c5\uff1a", (String)"QxyMessageSendServiceImpl_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        try {
            result = QxyDeclareFileService.sendDownLoadDeclareFileTask(vo);
        }
        catch (Exception e) {
            String message = e.getMessage();
            String stackMsg = ExceptionUtil.toString((Exception)e);
            logger.error("qxy-\u8c03\u7528\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25,recordId={}" + message, (Object)recordId);
            logger.error(stackMsg);
            failedlog.append(message);
        }
        finally {
            if (!result.isSuccess()) {
                failedlog.append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(recordId, "3", failedlog);
            }
        }
        return new ApiResult();
    }

    @Override
    public ApiResult undo(SBMessageBaseVo sbMessageBaseVo) {
        ApiResult result = new ApiResult();
        try {
            logger.info("qxy-\u5f00\u59cb\u4f5c\u5e9f");
            QxyDeclareService.undo(sbMessageBaseVo);
        }
        catch (Exception e) {
            logger.error("\u4f5c\u5e9f\u53d1\u751f\u5f02\u5e38\uff1aerror={} nsrsbh={}", (Object)ExceptionUtil.toString((Exception)e), (Object)sbMessageBaseVo.getNsrsbh());
            String notify = ResManager.loadKDString((String)"\u4f5c\u5e9f\u53d1\u751f\u5f02\u5e38\uff1a %1$s", (String)"QxyMessageSendServiceImpl_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, ExceptionUtil.toString((Exception)e));
            result.setMessage(notifyMsg);
        }
        return result;
    }

    @Override
    public ApiResult downloadQcData(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        try {
            logger.info("qxy-\u5f00\u59cb\u4e0b\u8f7d\u671f\u521d\u6570\u636e nsrsbh={}", (Object)vo.getNsrsbh());
            QxyQcService.startQcTask(vo);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u671f\u521d\u53d1\u751f\u5f02\u5e38\uff1aerror={} nsrsbh={}", (Object)ExceptionUtil.toString((Exception)e), (Object)vo.getNsrsbh());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public ApiResult downloadHistoryData(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        try {
            logger.info("qxy-\u5f00\u59cb\u4e0b\u8f7d\u5df2\u7533\u62a5\u6570\u636e nsrsbh={}", (Object)vo.getNsrsbh());
            QxyHistoryService.startHistoryTask(vo);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u5df2\u7533\u62a5\u6570\u636e\u53d1\u751f\u5f02\u5e38\uff1aerror={} nsrsbh={}", (Object)ExceptionUtil.toString((Exception)e), (Object)vo.getNsrsbh());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public ApiResult getStatus(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        try {
            logger.info("qxy-\u5f00\u59cb\u540c\u6b65\u7a0e\u5c40\u72b6\u6001 nsrsbh={}", (Object)vo.getNsrsbh());
            QxySyncTaxStatusService.syncStatus(vo);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u7a0e\u5c40\u72b6\u6001\u53d1\u751f\u5f02\u5e38\uff1aerror={} nsrsbh={}", (Object)ExceptionUtil.toString((Exception)e), (Object)vo.getNsrsbh());
            result.setMessage(e.getMessage());
        }
        return result;
    }

    @Override
    public ApiResult downloadSbsx(SBMessageBaseVo vo) {
        return QxySbqcService.startSbxxTask(vo);
    }

    @Override
    public ApiResult downloadVerification(SBMessageBaseVo vo) {
        try {
            logger.info("qxy-\u5f00\u59cb\u7a0e\u52a1\u4fe1\u606f\u91c7\u96c6 nsrsbh={}", (Object)vo.getNsrsbh());
            QxyTaskServiceEnum.getServiceByTypeNumber(vo.getOperationType()).sendTask(vo);
        }
        catch (Exception e) {
            logger.error("\u7a0e\u52a1\u4fe1\u606f\u91c7\u96c6\u53d1\u751f\u5f02\u5e38\uff1aerror={} nsrsbh={}", (Object)ExceptionUtil.toString((Exception)e), (Object)vo.getNsrsbh());
        }
        return new ApiResult();
    }
}

