/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ttk.agg.openapi.sdk.AggOpenAPI;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.msmessage.domain.SbpzMessageVo;
import kd.taxc.tsate.msmessage.service.qxy.bean.DiaologOption;
import kd.taxc.tsate.msmessage.service.qxy.bean.QxyConfig;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepCompanyInfoData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepDeclareTaskData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepHistoryData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepQcData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepSendFileTaskData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.qxy.bean.ZsxmRequestData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyTaxTypeEnum;
import kd.taxc.tsate.msmessage.service.qxy.helper.QxyCfgHelper;
import kd.taxc.tsate.msmessage.service.qxy.helper.QxyRepHelper;
import kd.taxc.tsate.msmessage.service.qxy.helper.QxyReqHelper;

public class QxyApi {
    private static final Log logger = LogFactory.getLog(QxyApi.class);
    protected static AggOpenAPI aggOpenAPI = new AggOpenAPI("t", "t", "t");

    public static AggOpenAPI getAPI() {
        QxyConfig cfg = QxyCfgHelper.getConfig();
        String host = aggOpenAPI.getApiHost();
        String key = aggOpenAPI.getAppKey();
        String secret = aggOpenAPI.getAppSecret();
        if (host.equals(cfg.getApiHost()) && key.equals(cfg.getAppKey()) && secret.equals(cfg.getAppSecret())) {
            return aggOpenAPI;
        }
        aggOpenAPI = new AggOpenAPI(cfg.getApiHost(), cfg.getAppKey(), cfg.getAppSecret());
        return aggOpenAPI;
    }

    protected static JSONObject req(String path, String jsonParam) {
        logger.info("{} \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)path, (Object)jsonParam);
        JSONObject rep = QxyApi.getAPI().rest(path, jsonParam);
        logger.info("{} \u54cd\u5e94\uff1a{}", (Object)path, (Object)JSON.toJSONString((Object)rep));
        return rep;
    }

    public static TaxResult<RepTaskData> pay(QxyTaxTypeEnum yzpzzlDm, String qyId, BigDecimal money, Date skssqq, Date skssqz, String agreementAccount) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        int year = c.get(1);
        int month = c.get(2) + 1;
        JSONObject json = new JSONObject();
        json.put("year", (Object)year);
        json.put("period", (Object)month);
        json.put("aggOrgId", (Object)qyId);
        JSONObject detail = new JSONObject();
        detail.put("yzpzzlDm", (Object)yzpzzlDm.getQxyCode());
        detail.put("fromDate", (Object)DateUtils.format((Date)skssqq));
        detail.put("toDate", (Object)DateUtils.format((Date)skssqz));
        detail.put("taxAmount", (Object)money.toPlainString());
        if (StringUtil.isNotEmpty((CharSequence)agreementAccount)) {
            detail.put("agreementAccount", (Object)agreementAccount);
        }
        if (yzpzzlDm == QxyTaxTypeEnum.WHSYJSF) {
            detail.put("zspmDm", (Object)"302170200");
        }
        JSONArray array = new JSONArray();
        array.add((Object)detail);
        json.put("detail", (Object)array);
        JSONObject rep = QxyApi.req("/v2/tax/qys/loadPaymentTask", json.toJSONString());
        return QxyRepHelper.parseRep(new RepTaskData(), rep);
    }

    public static TaxResult<RepTaskData> undo(QxyTaxTypeEnum yzpzzlDm, String qyId, Date skssqq, Date skssqz) {
        JSONObject json = new JSONObject();
        json.put("yzpzzlDm", (Object)yzpzzlDm.getQxyCode());
        Date sbqj = DateUtils.addMonth((Date)skssqz, (int)1);
        Calendar sbqjC = Calendar.getInstance();
        sbqjC.setTime(sbqj);
        json.put("year", (Object)sbqjC.get(1));
        json.put("period", (Object)(sbqjC.get(2) + 1));
        json.put("ssqQ", (Object)DateUtils.format((Date)skssqq));
        json.put("ssqZ", (Object)DateUtils.format((Date)skssqz));
        json.put("aggOrgId", (Object)qyId);
        JSONObject rep = QxyApi.req("/v2/tax/qys/loadCancelDeclareTask", json.toJSONString());
        return QxyRepHelper.parseRep(new RepTaskData(), rep);
    }

    public static TaxResult<Object> getQxyWebUrl(String qyId) {
        JSONObject json = new JSONObject();
        json.put("pageName", (Object)"ttk-tax-app-rpa-declare-payment");
        json.put("aggOrgId", (Object)qyId);
        JSONObject rep = QxyApi.req("/AGG/getWebUrl", json.toJSONString());
        return new TaxResult((Object)rep);
    }

    public static TaxResult<RepDeclareTaskData> declare(String qyId, Date sbqj, String bwKey, String bwContent) {
        return QxyApi.declare(qyId, sbqj, bwKey, bwContent, new ArrayList<DiaologOption>());
    }

    public static TaxResult<RepDeclareTaskData> declare(String qyId, Date sbqj, String bwKey, String bwContent, List<DiaologOption> options) {
        Calendar c = Calendar.getInstance();
        c.setTime(sbqj);
        int year = c.get(1);
        int month = c.get(2) + 1;
        JSONObject json = new JSONObject();
        json.put("year", (Object)year);
        json.put("period", (Object)month);
        json.put("aggOrgId", (Object)qyId);
        json.put("kkfs", (Object)"1");
        boolean isDerectDeclare = QxyCfgHelper.getConfig().isDirectDeclare();
        json.put("isDirectDeclare", (Object)isDerectDeclare);
        json.put(bwKey, (Object)bwContent);
        if (options != null && options.size() > 0) {
            json.put("optionCodeList", JSON.toJSON(options));
        }
        JSONObject rep = QxyApi.req("/v2/tax/qys/writeTaxData", json.toJSONString());
        return QxyRepHelper.parseRep(new RepDeclareTaskData(), rep);
    }

    public static TaxResult<RepDeclareTaskData> declareFi(String qyId, Date sbqj, String bwContent, List<Map<String, String>> attachmentsData) {
        QxyConfig cfg = QxyCfgHelper.getConfig();
        Calendar c = Calendar.getInstance();
        c.setTime(sbqj);
        int year = c.get(1);
        int month = c.get(2) + 1;
        JSONObject json = new JSONObject();
        json.put("year", (Object)year);
        json.put("period", (Object)month);
        json.put("aggOrgId", (Object)qyId);
        boolean isDerectDeclare = QxyCfgHelper.getConfig().isDirectDeclare();
        json.put("isDirectDeclare", (Object)isDerectDeclare);
        json.put("overloadKjzdzz", (Object)cfg.isCbzldmConfig());
        json.put("cbData", (Object)bwContent);
        if (!EmptyCheckUtils.isEmpty(attachmentsData)) {
            json.putAll(attachmentsData.get(0));
        }
        JSONObject rep = QxyApi.req("/v2/tax/qys/writeFiData", json.toJSONString());
        return QxyRepHelper.parseRep(new RepDeclareTaskData(), rep);
    }

    public static TaxResult<RepTaskData> getTaskStatus(String qyId, String taskId) {
        JSONObject json = new JSONObject();
        json.put("taskId", (Object)taskId);
        json.put("aggOrgId", (Object)qyId);
        JSONObject rep = QxyApi.req("/v2/tax/qys/queryTaskIdsInfo", json.toJSONString());
        return QxyRepHelper.parseRep(new RepTaskData(), rep);
    }

    public static TaxResult<RepTaskData> downloadWspz(String qyId, List<ZsxmRequestData> requestData, Date declareDate) {
        JSONObject json = QxyReqHelper.buildCommonRequest(qyId, declareDate);
        String requestJson = JSONObject.toJSONString(requestData);
        json.put("zsxmDtos", (Object)JSON.parseArray((String)requestJson));
        String requestJsonString = json.toJSONString();
        logger.info("qxy-downloadVoucherReq qyId={} requestJson={}", (Object)qyId, (Object)requestJsonString);
        JSONObject rep = QxyApi.req("/v2/tax/qys/loadWszmTask", requestJsonString);
        logger.info("qxy-downloadVoucherRep rep={}", (Object)qyId, (Object)rep.toJSONString());
        return QxyRepHelper.parseRep(new RepSendFileTaskData(), rep);
    }

    public static TaxResult<RepTaskData> downloadDeclarePdf(String qyId, ZsxmRequestData requestData, Date declareDate, SbpzMessageVo sbpzMessageVo) {
        String path;
        JSONObject taskReq;
        if (QxyReqHelper.isPassDate(declareDate)) {
            taskReq = QxyReqHelper.buildPassDateReqData(qyId, requestData, declareDate);
            path = "/v2/tax/qys/loadWqPdfTask";
        } else {
            taskReq = QxyReqHelper.buildNowDateReqData(qyId, requestData, declareDate, sbpzMessageVo);
            path = "/v2/tax/qys/loadPdfTask";
        }
        String requestJsonString = taskReq.toJSONString();
        logger.info("qxy-downloadDeclarePdf path ={} qyId={} requestJson={}", new Object[]{path, qyId, requestJsonString});
        JSONObject rep = QxyApi.req(path, requestJsonString);
        logger.info("qxy-downloadDeclarePdfRep rep={}", (Object)rep.toJSONString());
        return QxyRepHelper.parseRep(new RepSendFileTaskData(), rep);
    }

    private static TaxResult<RepCompanyInfoData> dealCompanyInfo(IdentityData loginInfo, String path) {
        JSONObject json = QxyReqHelper.buildCompanyInfoReq(loginInfo);
        logger.info("qxy-dealCompanyInfo requestJson={}", (Object)json.toString());
        JSONObject rep = QxyApi.req(path, json.toJSONString());
        logger.info("qxy-dealCompanyInfo Rep rep={}", (Object)rep.toJSONString());
        return QxyRepHelper.parseRep(new RepCompanyInfoData(), rep);
    }

    public static TaxResult<RepCompanyInfoData> createCompanyInfo(IdentityData loginInfo) {
        return QxyApi.dealCompanyInfo(loginInfo, "/v2/public/org/createInfo");
    }

    public static TaxResult<RepCompanyInfoData> modifyCompanyInfo(IdentityData loginInfo) {
        return QxyApi.dealCompanyInfo(loginInfo, "/v2/public/org/updateInfo");
    }

    public static TaxResult bindXh(String phone, String xh) {
        JSONObject json = new JSONObject();
        json.put("phoneNoA", (Object)phone);
        json.put("phoneNoX", (Object)xh);
        JSONObject rep = QxyApi.req("/v2/sjhm/bindAxn", json.toJSONString());
        return QxyRepHelper.parseRep(new RepData(), rep);
    }

    public static TaxResult unbindXh(String phone, String xh) {
        JSONObject json = new JSONObject();
        json.put("phoneNoA", (Object)phone);
        json.put("phoneNoX", (Object)xh);
        JSONObject rep = QxyApi.req("/v2/sjhm/unbind", json.toJSONString());
        return QxyRepHelper.parseRep(new RepData(), rep);
    }

    public static TaxResult updateXh(String oldPhone, String newPhone, String xh) {
        JSONObject json = new JSONObject();
        json.put("oldNoA", (Object)oldPhone);
        json.put("phoneNoA", (Object)newPhone);
        json.put("phoneNoX", (Object)xh);
        JSONObject rep = QxyApi.req("/v2/sjhm/updateNoA", json.toJSONString());
        return QxyRepHelper.parseRep(new RepData(), rep);
    }

    public static TaxResult<RepTaskData> startQcTask(String qyId, String yzpzzlDm, String zspmDm, String zlbsxlDm, String templateCode, Date sbqj, Date skssqq, Date skssqz) {
        Calendar c = Calendar.getInstance();
        c.setTime(sbqj);
        int year = c.get(1);
        int month = c.get(2) + 1;
        JSONObject json = new JSONObject();
        json.put("aggOrgId", (Object)qyId);
        json.put("year", (Object)year);
        json.put("period", (Object)month);
        JSONArray details = new JSONArray();
        JSONObject detail = new JSONObject();
        detail.put("yzpzzlDm", (Object)yzpzzlDm);
        detail.put("ssqQ", (Object)DateUtils.format((Date)skssqq));
        detail.put("ssqZ", (Object)DateUtils.format((Date)skssqz));
        if (zspmDm != null) {
            detail.put("zspmDm", (Object)zspmDm);
        }
        if (zlbsxlDm != null) {
            detail.put("zlbsxlDm", (Object)zlbsxlDm);
        }
        if (templateCode != null) {
            detail.put("templateCode", (Object)templateCode);
        }
        details.add((Object)detail);
        json.put("zsxmList", (Object)details);
        JSONObject rep = QxyApi.req("/v2/tax/qys/loadInitDataTask", json.toJSONString());
        return QxyRepHelper.parseRep(new RepTaskData(), rep);
    }

    public static TaxResult<RepQcData> getQcData(String qyId, String yzpzzlDm, Date sbqj) {
        Calendar c = Calendar.getInstance();
        c.setTime(sbqj);
        int year = c.get(1);
        int month = c.get(2) + 1;
        JSONObject json = new JSONObject();
        json.put("aggOrgId", (Object)qyId);
        json.put("year", (Object)year);
        json.put("period", (Object)month);
        json.put("yzpzzlDm", (Object)yzpzzlDm);
        JSONObject rep = QxyApi.req("/v2/tax/qys/getInitData", json.toJSONString());
        return QxyRepHelper.parseRep(new RepQcData(), rep);
    }

    public static TaxResult<RepTaskData> startLoadDeclareInfoTask(String qyId, Date sbqj, Date sbrq) {
        Calendar c = Calendar.getInstance();
        c.setTime(sbqj);
        int year = c.get(1);
        int month = c.get(2) + 1;
        if (sbrq != null) {
            c.setTime(sbrq);
            year = c.get(1);
            month = c.get(2) + 1;
        }
        JSONObject json = new JSONObject();
        json.put("aggOrgId", (Object)qyId);
        json.put("year", (Object)year);
        json.put("period", (Object)month);
        JSONObject rep = QxyApi.req("/v2/tax/qys/loadDeclareInfoTask", json.toJSONString());
        return QxyRepHelper.parseRep(new RepTaskData(), rep);
    }

    public static TaxResult<RepTaskData> loadSbxxTask(String qyId, int year, int period) {
        JSONObject json = new JSONObject();
        json.put("aggOrgId", (Object)qyId);
        json.put("year", (Object)year);
        json.put("period", (Object)period);
        JSONObject rep = QxyApi.req("/v2/tax/qys/loadDeclareInfoTask", json.toJSONString());
        return QxyRepHelper.parseRep(new RepTaskData(), rep);
    }

    public static TaxResult<RepTaskData> getSbxx(String qyId, String requestId) {
        JSONObject json = new JSONObject();
        json.put("taskId", (Object)requestId);
        json.put("aggOrgId", (Object)qyId);
        JSONObject rep = QxyApi.req("/v2/tax/qys/queryTaskTaxInfo", json.toJSONString());
        return QxyRepHelper.parseRep(new RepTaskData(), rep);
    }

    public static TaxResult<RepHistoryData> startHistoryTask(String appKey, String nsrsbh, String areaCode, String cjyfq, String cjyfz, String updateCache) {
        JSONObject json = new JSONObject();
        json.put("appKey", (Object)appKey);
        json.put("nsrsbh", (Object)nsrsbh);
        json.put("areaCode", (Object)areaCode);
        json.put("cjyfq", (Object)cjyfq);
        json.put("cjyfz", (Object)cjyfz);
        json.put("updateCache", (Object)updateCache);
        JSONObject rep = QxyApi.req("/v2/collect/beginFinTask", json.toJSONString());
        return QxyRepHelper.parseRep(new RepHistoryData(), rep);
    }

    public static TaxResult<RepHistoryData> getHistoryData(String taskId, String nsrsbh, String taxType, String skssqq, String skssqz) {
        JSONObject json = new JSONObject();
        json.put("taskId", (Object)taskId);
        json.put("nsrsbh", (Object)nsrsbh);
        JSONObject rep = QxyApi.req("/v2/collect/tax/getTaxInfo", json.toJSONString());
        RepHistoryData repHistoryData = new RepHistoryData();
        repHistoryData.setTaxType(taxType);
        repHistoryData.setSkssqq(skssqq);
        repHistoryData.setSkssqz(skssqz);
        return QxyRepHelper.parseRep(repHistoryData, rep);
    }
}

