/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.bean;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyBusinessStatusEnum;

public class RepDeclareTaskData
extends RepTaskData {
    private Map<String, List<String>> taskScreenUrl = new HashMap<String, List<String>>(8);
    private Map<String, JSONObject> dialogInfos = new HashMap<String, JSONObject>(8);

    @Override
    public void afterParse() {
        super.afterParse();
        this.parseErroDetail();
        this.parseImageDetail();
        this.parseErroSpecial();
        this.parseDialogDetail();
    }

    private void parseErroDetail() {
        JSONObject json;
        Object checkMessage;
        if (!this.getSuccess().booleanValue() && this.getOriginData() instanceof JSONObject && (checkMessage = (json = (JSONObject)this.getOriginData()).get((Object)"checkMessage")) instanceof JSONArray) {
            JSONArray erros = (JSONArray)checkMessage;
            StringBuilder sb = new StringBuilder();
            for (Object str : erros) {
                sb.append(str.toString());
            }
            sb.insert(0, ":");
            sb.insert(0, this.getMessage());
            this.setMessage(sb.toString());
        }
    }

    private void parseImageDetail() {
        JSONArray array = new JSONArray();
        if (this.getOriginData() instanceof JSONObject) {
            array.add(this.getOriginData());
        } else if (this.getOriginData() instanceof JSONArray) {
            array = (JSONArray)this.getOriginData();
        }
        for (int i = 0; i < array.size(); ++i) {
            JSONObject task = array.getJSONObject(i);
            String taskId = task.getString("taskId");
            ArrayList<String> imgList = new ArrayList<String>(8);
            JSONArray detailArray = task.getJSONArray("detail");
            if (detailArray == null) {
                return;
            }
            for (int z = 0; z < detailArray.size(); ++z) {
                JSONObject detail = detailArray.getJSONObject(z);
                String url = detail.getString("screenshot");
                if (!StringUtil.isNotEmpty((CharSequence)url)) continue;
                imgList.add(url);
            }
            this.taskScreenUrl.put(taskId, imgList);
        }
    }

    private void parseDialogDetail() {
        JSONArray array = new JSONArray();
        if (this.getOriginData() instanceof JSONObject) {
            array.add(this.getOriginData());
        } else if (this.getOriginData() instanceof JSONArray) {
            array = (JSONArray)this.getOriginData();
        }
        for (int i = 0; i < array.size(); ++i) {
            JSONObject task = array.getJSONObject(i);
            String taskId = task.getString("taskId");
            JSONObject dialog = task.getJSONObject("taxDialogDto");
            JSONObject dto = new JSONObject();
            dto.put("taxDialogDto", (Object)dialog);
            if (dialog == null) continue;
            this.dialogInfos.put(taskId, dto);
        }
    }

    private void parseErroSpecial() {
        JSONArray array = new JSONArray();
        if (this.getOriginData() instanceof JSONObject) {
            array.add(this.getOriginData());
        } else if (this.getOriginData() instanceof JSONArray) {
            array = (JSONArray)this.getOriginData();
        }
        for (int i = 0; i < array.size(); ++i) {
            String code;
            JSONObject detail;
            JSONObject task = array.getJSONObject(i);
            JSONArray details = task.getJSONArray("detail");
            if (details == null || details.size() <= 0 || (detail = details.getJSONObject(0)) == null || !"2002".equals(code = detail.getString("code"))) continue;
            this.setMessage(ResManager.loadKDString((String)"\u5df2\u5728\u5176\u4ed6\u6e20\u9053\u5b8c\u6210\u4e1a\u52a1\u64cd\u4f5c\uff0c\u4eba\u5de5\u6838\u5b9e\u540e\u8bf7\u624b\u5de5\u6807\u8bb0\u4efb\u52a1\u72b6\u6001", (String)"RepDeclareTaskData_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            break;
        }
    }

    @Override
    protected QxyBusinessStatusEnum parseDetailCodeStatus(JSONObject task) {
        JSONObject detail;
        QxyBusinessStatusEnum status = null;
        JSONArray details = task.getJSONArray("detail");
        String code = null;
        if (details != null && details.size() > 0 && (detail = details.getJSONObject(0)) != null) {
            code = detail.getString("code");
        }
        if (code == null) {
            this.setMessage(ResManager.loadKDString((String)"\u5f02\u5e38\uff01\u4f01\u4eab\u4e91\u7533\u62a5\u4efb\u52a1\u72b6\u6001\u672a\u8fd4\u56decode", (String)"RepDeclareTaskData_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            status = QxyBusinessStatusEnum.FAILD;
        } else {
            status = "2000".equals(code) ? QxyBusinessStatusEnum.SUCCESS : QxyBusinessStatusEnum.FAILD;
        }
        return status;
    }

    public List<String> getScreenUrl(String taskId) {
        List<String> list = this.taskScreenUrl.get(taskId);
        return list == null ? Collections.emptyList() : list;
    }

    public void setScreenUrl(String taskId, List<String> urls) {
        this.taskScreenUrl.put(taskId, urls);
    }

    public Map<String, JSONObject> getDialogInfos() {
        return this.dialogInfos;
    }
}

