/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.bean;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyCbZlbsxlDmEnum;

public class RepHistoryData
extends RepData {
    private static final Log logger = LogFactory.getLog(RepHistoryData.class);
    private String taxType;
    private String skssqq;
    private String skssqz;
    private String sbrq;
    private int status;

    public boolean isSuccessErroCode() {
        return "2000".equals(this.erroCode);
    }

    public boolean successIsTrue() {
        Boolean isSuccess = this.repData.getBoolean("success");
        if (isSuccess == null) {
            return false;
        }
        return isSuccess;
    }

    @Override
    public void afterParse() {
        try {
            this.setSuccess(this.successIsTrue() && this.isSuccessErroCode());
            Object data = this.getOriginData();
            if (data instanceof JSONObject) {
                JSONObject dataJsonObject = (JSONObject)data;
                if (!dataJsonObject.containsKey((Object)"status")) {
                    return;
                }
                this.setRepData(dataJsonObject);
                int status = dataJsonObject.getInteger("status");
                this.setStatus(status);
                switch (status) {
                    case 1: {
                        this.setStatusInfo(false, "\u67e5\u8be2\u5df2\u7533\u62a5\u6570\u636e-\u4f01\u4eab\u4e91\u5f53\u524d\u4efb\u52a1\u8fdb\u884c\u4e2d");
                        return;
                    }
                    case 3: {
                        if (!this.isStatusDetailSuccess(dataJsonObject)) {
                            return;
                        }
                        this.dealResponseReult(dataJsonObject);
                        return;
                    }
                }
                String errorString = dataJsonObject.containsKey((Object)"statusMsg") ? dataJsonObject.getString("statusMsg") : "\u67e5\u8be2\u5df2\u7533\u62a5\u6570\u636e-\u4f01\u4eab\u4e91\u63a5\u53e3\u8fd4\u56de\u5931\u8d25";
                this.setStatusInfo(false, errorString);
            }
        }
        catch (Exception e) {
            this.setSuccess(false);
            this.setMessage(e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getTaskId() {
        JSONObject valueData;
        String taskId = "";
        if (this.getOriginData() instanceof JSONObject && (valueData = (JSONObject)this.getOriginData()).containsKey((Object)"taskId")) {
            taskId = valueData.getString("taskId");
        }
        return taskId;
    }

    public void setStatusInfo(boolean isSuccess, String message) {
        this.setSuccess(isSuccess);
        this.setMessage(message);
    }

    public boolean isStatusDetailSuccess(JSONObject dataJsonObject) {
        if (!dataJsonObject.containsKey((Object)"statusDetails")) {
            this.setStatusInfo(false, "\u8fd4\u56de\u6570\u636e\u4e2d\u672a\u5305\u542b\u4efb\u52a1\u72b6\u6001\u8be6\u60c5\u3002");
            return false;
        }
        JSONObject statusDetails = dataJsonObject.getJSONObject("statusDetails");
        if (!statusDetails.containsKey((Object)"main")) {
            this.setStatusInfo(false, "\u8fd4\u56de\u6570\u636e\u4e2d\u672a\u5305\u542b\u5206\u7ec4\u4efb\u52a1\u603b\u72b6\u6001\u3002");
            return false;
        }
        int main = statusDetails.getInteger("main");
        if (main != 1 && main != 3) {
            this.setStatusInfo(false, ResManager.loadKDString((String)"\u67e5\u8be2\u5df2\u7533\u62a5\u6570\u636e-\u4f01\u4eab\u4e91\u63a5\u53e3\u8fd4\u56de\u5931\u8d25", (String)"RepHistoryData_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            return false;
        }
        if (main == 1) {
            this.setStatus(1);
            this.setStatusInfo(false, ResManager.loadKDString((String)"\u67e5\u8be2\u5df2\u7533\u62a5\u6570\u636e-\u4f01\u4eab\u4e91\u5f53\u524d\u4efb\u52a1\u8fdb\u884c\u4e2d", (String)"RepHistoryData_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void dealResponseReult(JSONObject dataJsonObject) {
        if (!dataJsonObject.containsKey((Object)"result")) {
            this.setRepData(dataJsonObject);
            this.setStatusInfo(false, ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u4e2d\u627e\u4e0d\u5230\u9009\u62e9\u7533\u62a5\u8868\u5bf9\u5e94\u7533\u62a5\u5c5e\u671f\u6570\u636e\uff0c\u65e0\u6cd5\u83b7\u53d6\u3002", (String)"RepHistoryData_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            return;
        }
        JSONObject result = dataJsonObject.getJSONObject("result");
        JSONObject sb = result.getJSONObject("sb");
        Set cbCode = Arrays.stream(QxyCbZlbsxlDmEnum.values()).map(cbEnum -> cbEnum.getDeclareType().getCode()).collect(Collectors.toSet());
        JSONArray rptList = null;
        rptList = cbCode.contains(this.getTaxType()) ? sb.getJSONArray("finRptList") : sb.getJSONArray("taxRptList");
        if (rptList == null || rptList.isEmpty()) {
            this.setStatusInfo(false, ResManager.loadKDString((String)"\u8fd4\u56de\u6570\u636e\u4e2d\u627e\u4e0d\u5230\u9009\u62e9\u7533\u62a5\u8868\u5bf9\u5e94\u7533\u62a5\u5c5e\u671f\u6570\u636e\uff0c\u65e0\u6cd5\u83b7\u53d6\u3002", (String)"RepHistoryData_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            return;
        }
        for (Object o : rptList) {
            JSONObject taxRptJSONObject = (JSONObject)o;
            if (!this.getSkssqq().equals(taxRptJSONObject.getString("ssqq")) || !this.getSkssqz().equals(taxRptJSONObject.getString("ssqz"))) continue;
            JSONArray resultData = taxRptJSONObject.getJSONArray("resultData");
            JSONObject newJSONObject = new JSONObject();
            for (int i = 0; i < resultData.size(); ++i) {
                JSONObject sbDataJSONObject = resultData.getJSONObject(i);
                Set entries = sbDataJSONObject.entrySet();
                for (Map.Entry entry : entries) {
                    newJSONObject.put((String)entry.getKey(), entry.getValue());
                }
            }
            this.setSbrq(taxRptJSONObject.getString("taxRq"));
            this.setRepData(newJSONObject);
            break;
        }
    }

    public String getTaxType() {
        return this.taxType;
    }

    public void setTaxType(String taxType) {
        this.taxType = taxType;
    }

    public String getSkssqq() {
        return this.skssqq;
    }

    public void setSkssqq(String skssqq) {
        this.skssqq = skssqq;
    }

    public String getSkssqz() {
        return this.skssqz;
    }

    public void setSkssqz(String skssqz) {
        this.skssqz = skssqz;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getSbrq() {
        return this.sbrq;
    }

    public void setSbrq(String sbrq) {
        this.sbrq = sbrq;
    }
}

