/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.bean;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyBusinessStatusEnum;

public class RepTaskData
extends RepData {
    private Map<String, QxyBusinessStatusEnum> taskStatusMap = new HashMap<String, QxyBusinessStatusEnum>(8);
    private boolean taskStatusInit = false;

    public void initTaskStatusMap() {
        if (this.taskStatusInit) {
            return;
        }
        Map<String, JSONObject> allTask = this.getAllTask();
        for (JSONObject task : allTask.values()) {
            this.buildStatus(task);
        }
        this.taskStatusInit = true;
    }

    private void buildStatus(JSONObject task) {
        if (task != null) {
            QxyBusinessStatusEnum codeStatus;
            String taskId = task.getString("taskId");
            QxyBusinessStatusEnum status = this.parseResultStatus(task);
            if (QxyBusinessStatusEnum.SUCCESS == status && (codeStatus = this.parseDetailCodeStatus(task)) != null) {
                status = codeStatus;
            }
            this.taskStatusMap.put(taskId, status);
        }
    }

    private Map<String, JSONObject> getAllTask() {
        HashMap<String, JSONObject> taskMap = new HashMap<String, JSONObject>(8);
        Object originData = this.getOriginData();
        if (originData instanceof JSONArray) {
            JSONArray tasks = (JSONArray)originData;
            for (int i = 0; i < tasks.size(); ++i) {
                JSONObject task = tasks.getJSONObject(i);
                if (task == null) continue;
                String taskId = task.getString("taskId");
                taskMap.put(taskId, task);
            }
        }
        if (originData instanceof JSONObject) {
            JSONObject task = (JSONObject)originData;
            String taskId = task.getString("taskId");
            taskMap.put(taskId, task);
        }
        return taskMap;
    }

    public QxyBusinessStatusEnum getResultStatus(String taskId) {
        Map<String, JSONObject> taskMap = this.getAllTask();
        JSONObject task = taskMap.get(taskId);
        return this.parseResultStatus(task);
    }

    private QxyBusinessStatusEnum parseResultStatus(JSONObject task) {
        String statusCode = task.getString("businessStatus");
        return QxyBusinessStatusEnum.valueOfCode(statusCode);
    }

    public QxyBusinessStatusEnum getDetailCodeStatus(String taskId) {
        Object status = null;
        Map<String, JSONObject> taskMap = this.getAllTask();
        JSONObject task = taskMap.get(taskId);
        return this.parseDetailCodeStatus(task);
    }

    protected QxyBusinessStatusEnum parseDetailCodeStatus(JSONObject task) {
        String code;
        JSONObject detail;
        QxyBusinessStatusEnum status = null;
        JSONArray details = task.getJSONArray("detail");
        if (details != null && details.size() > 0 && (detail = details.getJSONObject(0)) != null && (code = detail.getString("code")) != null) {
            status = !"2000".equals(code) ? QxyBusinessStatusEnum.FAILD : QxyBusinessStatusEnum.SUCCESS;
        }
        return status;
    }

    public String getTaskId() {
        String taskId = null;
        if (this.getOriginData() instanceof JSONObject) {
            JSONObject valueData = (JSONObject)this.getOriginData();
            taskId = valueData.getString("taskId");
        }
        return taskId;
    }

    public QxyBusinessStatusEnum getTaskStatus(String taskId) {
        this.initTaskStatusMap();
        return this.taskStatusMap.get(taskId);
    }

    public QxyBusinessStatusEnum getTaskStatus() {
        this.initTaskStatusMap();
        for (QxyBusinessStatusEnum status : this.taskStatusMap.values()) {
            if (status == null) continue;
            return status;
        }
        return null;
    }

    public String getTaskResultMessage() {
        String resultMessage = null;
        Object originData = this.getOriginData();
        JSONObject item = null;
        if (originData instanceof JSONArray) {
            JSONArray detail = (JSONArray)originData;
            item = (JSONObject)detail.get(0);
        }
        if (originData instanceof JSONObject) {
            item = (JSONObject)originData;
        }
        if (item != null) {
            resultMessage = item.getString("resultMessage");
        }
        return resultMessage;
    }

    public JSONObject getDetailInfo() {
        Object originData = this.getOriginData();
        JSONObject item = null;
        JSONObject detail = null;
        if (originData instanceof JSONArray) {
            item = ((JSONArray)originData).getJSONObject(0);
        }
        if (originData instanceof JSONObject) {
            item = (JSONObject)originData;
        }
        if (item != null) {
            Object detailData = item.get((Object)"detail");
            if (detailData instanceof JSONArray) {
                detail = ((JSONArray)detailData).getJSONObject(0);
            }
            if (detailData instanceof JSONObject) {
                detail = (JSONObject)detailData;
            }
        }
        return detail;
    }

    @Override
    public void afterParse() {
        String msg = this.getMessage();
        if (msg == null) {
            msg = "";
        }
        StringBuilder finalMsg = new StringBuilder(msg);
        String resultMsg = this.getTaskResultMessage();
        String detailMsg = this.getTaskDetailMessage();
        if (resultMsg == null) {
            resultMsg = "";
        }
        if (detailMsg == null) {
            detailMsg = "";
        }
        finalMsg.append(resultMsg);
        if (!resultMsg.equals(detailMsg) && StringUtil.isNotEmpty((CharSequence)detailMsg)) {
            finalMsg.append(" :").append(detailMsg);
        }
        this.setMessage(finalMsg.toString());
    }

    public String getTaskDetailMessage() {
        Object originData = this.getOriginData();
        JSONObject item = null;
        if (originData instanceof JSONArray) {
            JSONArray detail = (JSONArray)originData;
            item = (JSONObject)detail.get(0);
        }
        if (originData instanceof JSONObject) {
            item = (JSONObject)originData;
        }
        StringBuilder detailMsg = new StringBuilder();
        if (item != null) {
            JSONArray details = item.getJSONArray("detail");
            if (details == null) {
                return "";
            }
            for (int i = 0; i < details.size(); ++i) {
                detailMsg.append(details.getJSONObject(i).getString("message"));
            }
        }
        return detailMsg.toString();
    }
}

