/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.constant;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.TaxPeriodType;
import kd.taxc.tsate.common.util.DateUtils;

public enum QxyPzlDmEnum {
    ZZSYBNSR(Collections.singletonList(DeclareTypeEnum.ZZSYBNSR.getCode()), Collections.singletonList(DeclareTaxType.ZZS), "BDA0610606", null),
    ZZSYBNSR_YBHZ(Collections.singletonList(DeclareTypeEnum.ZZSYBNSR_YBHZ.getCode()), Collections.singletonList(DeclareTaxType.ZZS), "BDA0610606", null),
    ZZSXGMNSR(Collections.singletonList(DeclareTypeEnum.ZZSXGMNSR.getCode()), Collections.singletonList(DeclareTaxType.ZZS), "BDA0610611", null),
    QYSDSJB(Collections.singletonList(DeclareTypeEnum.QYSDSJB.getCode()), Collections.singletonList(DeclareTaxType.QYSDS), "BDA0611159", null),
    YHS(Collections.singletonList(DeclareTypeEnum.YHS.getCode()), Collections.singletonList(DeclareTaxType.YHS), "BDA0610794", null),
    FCS(Arrays.asList(DeclareTaxType.FCS.getBaseTaxCode(), DeclareTypeEnum.CCXWS_FCS.getCode()), Collections.singletonList(DeclareTaxType.FCS), "BDA0610791", null),
    CZTDSYS(Arrays.asList(DeclareTaxType.CZTDSYS.getBaseTaxCode(), DeclareTypeEnum.CCXWS_CZTDSYS.getCode()), Collections.singletonList(DeclareTaxType.CZTDSYS), "BDA0610790", null),
    CB_YB(Arrays.asList(DeclareTypeEnum.FR0001.getCode(), DeclareTypeEnum.FR0002.getCode(), DeclareTypeEnum.FR0003.getCode(), DeclareTypeEnum.FR0004.getCode(), DeclareTypeEnum.FR0011.getCode()), null, "CWBBSB", Arrays.asList("month", "season")),
    CB_NB(Arrays.asList(DeclareTypeEnum.FR0001.getCode(), DeclareTypeEnum.FR0002.getCode(), DeclareTypeEnum.FR0003.getCode(), DeclareTypeEnum.FR0004.getCode(), DeclareTypeEnum.FR0011.getCode()), null, "CWBBNDSB", Collections.singletonList("year")),
    QTSF_FSSTYSBB(Collections.singletonList(DeclareTypeEnum.QTSF_FSSTYSBB.getCode()), Collections.singletonList(DeclareTaxType.CZLJCLF), "BDA0611054", null),
    QTSF_TYSBB(Collections.singletonList(DeclareTypeEnum.QTSF_TYSBB.getCode()), Arrays.asList(DeclareTaxType.GHJF, DeclareTaxType.GHCBJ, DeclareTaxType.SLJSJJ), "BDA0610100", null),
    WHSYJSF(Collections.singletonList(DeclareTypeEnum.WHSYJSF.getCode()), Collections.singletonList(DeclareTaxType.WHSYJSF), "BDA0610334", null),
    XFSJFJ(Collections.singletonList(DeclareTypeEnum.XFSJFJ.getCode()), Collections.singletonList(DeclareTaxType.XFS), "BDA0611111", Arrays.asList("month", "season")),
    TOTF_CJRJYBZJ(Collections.singletonList(DeclareTypeEnum.TOTF_CJRJYBZJ.getCode()), Collections.singletonList(DeclareTaxType.CJRJYBZJ), "BDA0610857", null),
    HBS(Collections.singletonList(DeclareTypeEnum.TCEPT.getCode()), Collections.singletonList(DeclareTaxType.HBS), "BDA0610980", null);

    private final List<String> templateTypes;
    private final List<DeclareTaxType> taxTypes;
    private final String qxyCode;
    private final List<String> taxLimits;

    private QxyPzlDmEnum(List<String> templateTypes, List<DeclareTaxType> taxTypes, String qxyCode, List<String> taxLimits) {
        this.templateTypes = templateTypes;
        this.taxTypes = taxTypes;
        this.qxyCode = qxyCode;
        this.taxLimits = taxLimits;
    }

    public List<String> getTemplateTypes() {
        return this.templateTypes;
    }

    public List<DeclareTaxType> getTaxTypes() {
        return this.taxTypes;
    }

    public String getQxyCode() {
        return this.qxyCode;
    }

    public List<String> getTaxLimits() {
        return this.taxLimits;
    }

    public static String getQxyCodeBySsqAndTaxTypeCode(String declareTypeCode, Date skssqq, Date skssqz) {
        QxyPzlDmEnum qxyPzlDmEnum = QxyPzlDmEnum.getBySsqAndTaxTypeCode(declareTypeCode, skssqq, skssqz);
        if (qxyPzlDmEnum == null) {
            return "";
        }
        return qxyPzlDmEnum.getQxyCode();
    }

    public static QxyPzlDmEnum getBySsqAndTaxTypeCode(String declareTypeCode, Date skssqq, Date skssqz) {
        String taxLimit = DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz);
        return QxyPzlDmEnum.getByTaxLimitAndTaxTypeCode(declareTypeCode, taxLimit);
    }

    public static QxyPzlDmEnum getByTaxLimitAndTaxTypeCode(String declareTypeCode, String taxLimit) {
        for (QxyPzlDmEnum dmEnum : QxyPzlDmEnum.values()) {
            if (!dmEnum.getTemplateTypes().contains(declareTypeCode)) continue;
            List<String> taxLimits = dmEnum.getTaxLimits();
            if (taxLimits == null) {
                return dmEnum;
            }
            if (!taxLimits.contains(taxLimit)) continue;
            return dmEnum;
        }
        return null;
    }

    public static QxyPzlDmEnum getByTaxLimitAndTaxTypeCode(String declareTypeCode, TaxPeriodType taxLimit) {
        return QxyPzlDmEnum.getByTaxLimitAndTaxTypeCode(declareTypeCode, taxLimit.getCode());
    }
}

