/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.constant;

import java.util.Arrays;
import java.util.Optional;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;

public enum QxyTaxTypeEnum {
    ZZSYBNSR(DeclareTypeEnum.ZZSYBNSR, "BDA0610606"),
    ZZSXGMNSR(DeclareTypeEnum.ZZSXGMNSR, "BDA0610611"),
    QYSDSJB(DeclareTypeEnum.QYSDSJB, "BDA0611159"),
    YHS(DeclareTypeEnum.YHS, "BDA0610794"),
    CCXWS_FCS(DeclareTypeEnum.CCXWS_FCS, "BDA0610791"),
    CCXWS_TDS(DeclareTypeEnum.CCXWS_CZTDSYS, "BDA0610790"),
    FCSCZTDSYS(DeclareTypeEnum.CCXWS_FCJTDSYS, "BDA0000000"),
    FR0003(DeclareTypeEnum.FR0003, "cbData"),
    FR0001(DeclareTypeEnum.FR0001, "cbData"),
    FR0002(DeclareTypeEnum.FR0002, "cbData"),
    ZZSYBNSR_YBHZ(DeclareTypeEnum.ZZSYBNSR_YBHZ, "BDA0610606"),
    QTSF_FSSTYSBB(DeclareTypeEnum.QTSF_FSSTYSBB, "BDA0611054"),
    QTSF_TYSBB(DeclareTypeEnum.QTSF_TYSBB, "BDA0610100"),
    WHSYJSF(DeclareTypeEnum.WHSYJSF, "BDA0610334"),
    HBS(DeclareTypeEnum.TCEPT, "BDA0610980"),
    TOTF_CJRJYBZJ(DeclareTypeEnum.TOTF_CJRJYBZJ, "BDA0610857"),
    XFSJFJ(DeclareTypeEnum.XFSJFJ, "BDA0611111");

    private final DeclareTypeEnum declareType;
    private final String qxyCode;

    private QxyTaxTypeEnum(DeclareTypeEnum declareType, String code) {
        this.qxyCode = code;
        this.declareType = declareType;
    }

    public DeclareTypeEnum getDeclareType() {
        return this.declareType;
    }

    public String getQxyCode() {
        return this.qxyCode;
    }

    public static QxyTaxTypeEnum valueOfDeclareTypeCode(String declareTypeCode) {
        DeclareTypeEnum declareType = DeclareTypeEnum.valueOfCode((String)declareTypeCode);
        return QxyTaxTypeEnum.valueOfDeclareType(declareType);
    }

    public static QxyTaxTypeEnum valueOfDeclareType(DeclareTypeEnum declareType) {
        Optional<QxyTaxTypeEnum> op = Arrays.stream(QxyTaxTypeEnum.values()).filter(item -> item.declareType == declareType).findFirst();
        return op.isPresent() ? op.get() : null;
    }

    public static QxyTaxTypeEnum valueOfQxyCode(String code) {
        Optional<QxyTaxTypeEnum> op = Arrays.stream(QxyTaxTypeEnum.values()).filter(item -> item.qxyCode.equals(code)).findFirst();
        return op.isPresent() ? op.get() : null;
    }
}

