/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.helper;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyBusinessStatusEnum;
import kd.taxc.tsate.msmessage.service.qxy.constant.QyxToKdStatusMappingEnum;

public class QxyRepHelper {
    private static Log logger = LogFactory.getLog(QxyRepHelper.class);

    public static String parseReqId(JSONObject repJson) {
        JSONObject resultJson = repJson.getJSONObject("result");
        return resultJson.getString("reqId");
    }

    public static <T extends RepData> TaxResult<T> parseRep(T t, JSONObject repJson) {
        TaxResult result = new TaxResult();
        if (repJson == null) {
            QxyRepHelper.resultFaild(result, ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a", (String)"QxyRepHelper_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            return result;
        }
        t.parse(repJson);
        if (t.getSuccess().booleanValue()) {
            QxyRepHelper.resultSuccess(result, t);
        } else {
            QxyRepHelper.resultFaild(result, t.getMessage(), t);
        }
        return result;
    }

    public static void resultSuccess(TaxResult result, Object data) {
        QxyRepHelper.setResult(result, true, TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), null, data);
    }

    public static void resultFaild(TaxResult result, String erro, Object data) {
        QxyRepHelper.setResult(result, false, TaxcErrorCode.TAXC_FAILED_CODE.getCode(), erro, data);
    }

    public static void resultFaild(TaxResult result, String erro) {
        QxyRepHelper.resultFaild(result, TaxcErrorCode.TAXC_FAILED_CODE.getCode(), erro);
    }

    public static void resultFaild(TaxResult result, String code, String erro) {
        QxyRepHelper.setResult(result, false, code, erro, null);
    }

    public static void setResult(TaxResult result, Boolean success, String code, String erro, Object data) {
        result.setMessage(erro);
        result.setCode(code);
        result.setSuccess(success.booleanValue());
        result.setData(data);
    }

    public static boolean checkRepDataAndBuildErroApiResult(TaxResult result, ApiResult apiResult) {
        if (!result.isSuccess()) {
            apiResult.setSuccess(false);
            apiResult.setMessage(result.getMessage());
            apiResult.setErrorCode("3");
            return true;
        }
        return false;
    }

    public static <T extends RepTaskData> void updateSingleTaskStatus(TaxResult<T> taskStatus, Long rocordId, Long requestDataId) {
        String message;
        ExecuteStatusEnum kdStatus;
        RepTaskData data = (RepTaskData)taskStatus.getData();
        Object originData = data.getOriginData();
        QxyBusinessStatusEnum qxyStatus = data.getTaskStatus();
        if (originData == null) {
            kdStatus = ExecuteStatusEnum.FAIL;
            message = taskStatus.getMessage();
        } else {
            kdStatus = QyxToKdStatusMappingEnum.getKdTaskStatus(qxyStatus);
            message = data.getMessage();
            if (StringUtil.isEmpty((CharSequence)message)) {
                message = data.getTaskResultMessage();
            }
        }
        JSONObject detailinfo = new JSONObject();
        detailinfo.put("reqId", (Object)data.getReqId());
        try (TXHandle handle = TX.required();){
            try {
                logger.info("qyx-\u5f00\u59cb\u66f4\u65b0\u4efb\u52a1\u72b6\u6001 requestId={} kdStatus={} rocordId={}", new Object[]{requestDataId, kdStatus.getCode(), rocordId});
                TsateDeclareRecordBusiness.updateRecord((Long)rocordId, (String)message, null, (ExecuteStatusEnum)kdStatus);
                TsateRequestInfoBusiness.updateStatusWithStatusInfo((Long)requestDataId, (ExecuteStatusEnum)kdStatus, (String)detailinfo.toJSONString());
            }
            catch (Exception e) {
                handle.markRollback();
                logger.error("\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u5931\u8d25\uff1aerror={} rocordId={} requestId={}", new Object[]{ExceptionUtil.toString((Exception)e), rocordId, requestDataId});
            }
        }
    }

    public static <T extends RepTaskData> void updateSingleTaskFailStatus(TaxResult<T> taskStatus, Long rocordId, Long requestDataId, String message) {
        ExecuteStatusEnum kdStatus = ExecuteStatusEnum.FAIL;
        RepTaskData data = (RepTaskData)taskStatus.getData();
        JSONObject detailinfo = new JSONObject();
        detailinfo.put("reqId", (Object)data.getReqId());
        try (TXHandle handle = TX.required();){
            try {
                logger.info("qyx-\u5f00\u59cb\u66f4\u65b0\u4efb\u52a1\u72b6\u6001 requestId={} kdStatus={} rocordId={}", new Object[]{requestDataId, kdStatus.getCode(), rocordId});
                TsateDeclareRecordBusiness.updateRecord((Long)rocordId, (String)message, null, (ExecuteStatusEnum)kdStatus);
                TsateRequestInfoBusiness.updateStatusWithStatusInfo((Long)requestDataId, (ExecuteStatusEnum)kdStatus, (String)detailinfo.toJSONString());
            }
            catch (Exception e) {
                handle.markRollback();
                logger.error("\u66f4\u65b0\u4efb\u52a1\u72b6\u6001\u5931\u8d25\uff1aerror={} rocordId={} requestId={}", new Object[]{ExceptionUtil.toString((Exception)e), rocordId, requestDataId});
            }
        }
    }

    public static <T extends RepTaskData> boolean isRunningTask(TaxResult<T> taskStatus) {
        RepTaskData data = (RepTaskData)taskStatus.getData();
        QxyBusinessStatusEnum qxyStatus = data.getTaskStatus();
        return QxyBusinessStatusEnum.RUNNING == qxyStatus || QxyBusinessStatusEnum.NOTSTART == qxyStatus;
    }

    public static <T extends RepData> T translate(RepData from, T to) {
        JSONObject data = from.getRepData();
        to.parse(data);
        return to;
    }
}

