/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.RsaCryptTools;
import kd.taxc.tsate.msmessage.domain.SbpzMessageVo;
import kd.taxc.tsate.msmessage.service.qxy.bean.ZsxmRequestData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyApiConstant;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyCbZlbsxlDmEnum;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyLoginTypeEnum;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxySflxEnum;
import org.apache.commons.lang.StringUtils;

public class QxyReqHelper {
    public static JSONObject buildCompanyInfoReq(IdentityData loginInfo) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("aggOrgName", (Object)loginInfo.getNsrmc());
        reqJson.put("encryptionType", (Object)"1");
        reqJson.put("isFprz", (Object)false);
        String qyid = loginInfo.getQyid();
        JSONObject orgTaxLogin = QxyReqHelper.buildEncryptOrgTaxLoginInfo(loginInfo);
        if (StringUtils.isBlank((String)qyid)) {
            reqJson.put("nsrsbh", (Object)loginInfo.getNsrsbh());
            reqJson.put("orgTaxLogin", (Object)orgTaxLogin);
        } else {
            reqJson.put("aggOrgId", (Object)qyid);
            reqJson.putAll((Map)orgTaxLogin);
        }
        return reqJson;
    }

    public static JSONObject buildNowDateReqData(String qyId, ZsxmRequestData requestData, Date declareDate, SbpzMessageVo sbpzMessageVo) {
        JSONObject reqJson = QxyReqHelper.buildCommonRequest(qyId, declareDate);
        String requestJson = JSONObject.toJSONString((Object)requestData);
        JSONObject zsxmJson = JSON.parseObject((String)requestJson);
        QxyCbZlbsxlDmEnum qxyCbZlbsxlDmEnum = QxyCbZlbsxlDmEnum.valueOfDeclareType(sbpzMessageVo.getString(SbpzMessageVo.Key.TYPENUMBER));
        if (qxyCbZlbsxlDmEnum != null) {
            zsxmJson.put("zlbsxlDm", (Object)qxyCbZlbsxlDmEnum.getCode());
            zsxmJson.put("templateCode", (Object)qxyCbZlbsxlDmEnum.getTemplateCode());
        }
        JSONArray zsxmList = new JSONArray();
        zsxmList.add((Object)zsxmJson);
        reqJson.put("zsxmList", (Object)zsxmList);
        return reqJson;
    }

    public static JSONObject buildPassDateReqData(String qyId, ZsxmRequestData requestData, Date declareDate) {
        JSONObject reqJson = new JSONObject();
        reqJson.put("aggOrgId", (Object)qyId);
        String yzpzzlDm = requestData.getYzpzzlDm();
        String ssqQ = requestData.getSsqQ();
        String ssqZ = requestData.getSsqZ();
        reqJson.put("skssqq", (Object)ssqQ);
        reqJson.put("skssqz", (Object)ssqZ);
        reqJson.put("sbrqq", (Object)DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)declareDate)));
        reqJson.put("sbrqz", (Object)DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)declareDate)));
        reqJson.put("yzpzzlDms", (Object)yzpzzlDm);
        reqJson.put("projectType", (Object)0);
        if (QxyApiConstant.CB_TYPES.contains(yzpzzlDm)) {
            reqJson.put("projectType", (Object)1);
        }
        return reqJson;
    }

    public static boolean isPassDate(Date declareDate) {
        Date nowDate = new Date();
        return declareDate.before(nowDate) && DateUtils.getMonthDiff((Date)declareDate, (Date)nowDate) > 1;
    }

    public static JSONObject buildCommonRequest(String qyId, Date declareDate) {
        JSONObject json = new JSONObject();
        int year = DateUtils.getYearOfDate((Date)declareDate);
        int month = DateUtils.getMonthOfDate((Date)declareDate);
        json.put("aggOrgId", (Object)qyId);
        json.put("year", (Object)year);
        json.put("period", (Object)month);
        return json;
    }

    private static JSONObject buildEncryptOrgTaxLoginInfo(IdentityData loginInfo) {
        JSONObject orgTaxLogin = new JSONObject();
        HashMap<String, String> loginMap = new HashMap<String, String>();
        loginMap.put("dq", TsateCompanyInfoBusiness.getQxyAreaCode((String)loginInfo.getDldq()));
        loginMap.put("gdsdlzh", loginInfo.getUsername());
        loginMap.put("gdsdlmm", loginInfo.getPassword());
        loginMap.put("gryhm", loginInfo.getTaxmanName());
        loginMap.put("gryhmm", loginInfo.getTaxmanPwd());
        loginMap.put("zrrsfzh", loginInfo.getTaxmanSfz());
        loginMap.put("bssjhm", loginInfo.getTelephoneNum());
        loginMap.put("sjhm", loginInfo.getTelephoneNum());
        loginMap.put("sflx", QxySflxEnum.getQxySflxCode(loginInfo.getDlsf()));
        loginMap.put("gdsdlfs", QxyLoginTypeEnum.getQxyDlfsCode(loginInfo.getLoginType()));
        for (Map.Entry entry : loginMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (QxyApiConstant.NEED_ENCRYPT_FIELDS.contains(key)) {
                value = RsaCryptTools.qxyDataEncrypt((String)value);
            }
            orgTaxLogin.put(key, (Object)value);
        }
        return orgTaxLogin;
    }
}

