/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.service.qxy.api.QxyApi;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyBusinessStatusEnum;
import kd.taxc.tsate.msmessage.service.qxy.helper.QxyRepHelper;
import kd.taxc.tsate.msmessage.service.qxy.service.QxyServiceInterface;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;

public class AbstractQxyBaseService
implements QxyServiceInterface {
    private static Log logger = LogFactory.getLog(AbstractQxyBaseService.class);

    @Override
    public void syncData(SBMessageBaseVo vo) {
        this.synTaskResult(vo);
    }

    public void synTaskResult(SBMessageBaseVo vo) {
        String qyId = TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY);
        Long recordId = vo.getId();
        DynamicObject requestObj = TsateRequestInfoBusiness.queryOne((String)(recordId + ""), null, (String)"1");
        DynamicObject recordObj = TsateDeclareRecordBusiness.getRecordByIdAndStatus((Long)recordId, (ExecuteStatusEnum)ExecuteStatusEnum.PROCESSING);
        if (requestObj == null || recordObj == null) {
            logger.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684taskId\u6216recordId\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f rocordId={}", (Object)recordId);
            return;
        }
        String taskId = requestObj.getString("requestid");
        logger.info("qyx-\u8c03\u7528\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u5f00\u59cb qyid={} taskdId={}", (Object)qyId, (Object)taskId);
        TaxResult taskResult = this.queryResult(qyId, taskId);
        if (!taskResult.isSuccess()) {
            logger.info("\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5931\u8d25 qyId={}\uff0ctaskId={} msg={}", new Object[]{qyId, taskId, taskResult.getMessage()});
            return;
        }
        if (QxyRepHelper.isRunningTask(taskResult)) {
            return;
        }
        long requestId = requestObj.getLong("id");
        try {
            logger.info("qxy-\u5f00\u59cb\u8fdb\u884c\u4e1a\u52a1\u5904\u7406\u6570\u636e");
            this.doBusiness(qyId, (TaxResult<RepTaskData>)taskResult, vo);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
            if (this.getExIsUpdateFlag()) {
                QxyRepHelper.updateSingleTaskFailStatus(taskResult, recordId, requestId, this.getFailMsg(e.getMessage()));
            }
            return;
        }
        QxyRepHelper.updateSingleTaskStatus(taskResult, recordId, requestId);
    }

    public TaxResult<RepTaskData> getBusinessData(String qyId, SBMessageBaseVo vo, TaxResult<RepTaskData> taskResult) {
        return taskResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaxResult sendTask(SBMessageBaseVo vo) {
        TaxResult<RepTaskData> result = new TaxResult<RepTaskData>(false, null, ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u5f02\u5e38,\u8be6\u60c5", (String)"AbstractQxyBaseService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), null);
        StringBuilder failedlog = new StringBuilder(ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u5f02\u5e38,\u8be6\u60c5\uff1a", (String)"AbstractQxyBaseService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        try {
            result = this.getTaskResult(vo);
            this.saveRequestInfo(result, vo.getOrg(), vo.getId());
        }
        catch (Exception e) {
            logger.error("qxy-\u53d1\u8d77\u4efb\u52a1\u5f02\u5e38,recordId={}" + e.getMessage(), (Object)vo.getId());
            logger.error(ExceptionUtil.toString((Exception)e));
            failedlog.append(e.getMessage());
        }
        finally {
            if (!result.isSuccess()) {
                failedlog.append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedlog);
            }
        }
        return result;
    }

    public TaxResult<RepTaskData> getTaskResult(SBMessageBaseVo vo) {
        return new TaxResult(false, null, ResManager.loadKDString((String)"\u8c03\u7528\u4e0b\u8f7d\u63a5\u53e3\u5f02\u5e38,\u8be6\u60c5", (String)"AbstractQxyBaseService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), null);
    }

    public boolean getExIsUpdateFlag() {
        return true;
    }

    public String getFailMsg(String message) {
        return "";
    }

    public void doBusiness(String qyId, TaxResult<RepTaskData> taskResult, SBMessageBaseVo vo) {
        RepTaskData data = (RepTaskData)taskResult.getData();
        if (EmptyCheckUtils.isEmpty((Object)data) || EmptyCheckUtils.isEmpty((Object)data.getRepData())) {
            String notify = ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u4e0b\u8f7d\u63a5\u53e3\u672a\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002\u63a5\u53e3\u8fd4\u56de\u63d0\u793a\uff1a %1$s", (String)"AbstractQxyBaseService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, taskResult.getMessage());
            throw new KDBizException(notifyMsg);
        }
        if (QxyBusinessStatusEnum.SUCCESS == data.getTaskStatus()) {
            this.dealBusinessData(this.getBusinessData(qyId, vo, taskResult), vo);
        }
    }

    public void dealBusinessData(TaxResult<RepTaskData> businessData, SBMessageBaseVo vo) {
        if (!businessData.isSuccess()) {
            return;
        }
        if (EmptyCheckUtils.isEmpty((Object)((RepTaskData)businessData.getData()).getOriginData())) {
            String notify = ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u4e0b\u8f7d\u63a5\u53e3\u672a\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002\u63a5\u53e3\u8fd4\u56de\u63d0\u793a\uff1a %1$s", (String)"AbstractQxyBaseService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, businessData.getMessage());
            throw new KDBizException(notifyMsg);
        }
    }

    public TaxResult queryResult(String qyId, String taskId) {
        return QxyApi.getTaskStatus(qyId, taskId);
    }

    public void saveRequestInfo(TaxResult<RepTaskData> result, String orgId, Long recordId) {
        if (this.taskIsSuccess(result)) {
            RepTaskData data = (RepTaskData)result.getData();
            if (data == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u8fd4\u56de\u6210\u529f\u4f46\u7f3a\u5931\u5173\u952edata\u4fe1\u606f,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"AbstractQxyBaseService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            }
            String taskId = data.getTaskId();
            if (StringUtil.isBlank((CharSequence)taskId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u672a\u6b63\u5e38\u8fd4\u56de\u6570\u636e,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"AbstractQxyBaseService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            }
            logger.info("qxy -saveRequestInfo taskId={}", (Object)taskId, (Object)orgId);
            TsateRequestInfoBusiness.saveRequestId((String)orgId, (String)taskId, (String)(recordId + ""), null, null, (SupplierEnum)SupplierEnum.QXY);
        }
    }

    public boolean taskIsSuccess(TaxResult<RepTaskData> result) {
        return result.isSuccess();
    }
}

