/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.service.qxy.api.QxyApi;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepCompanyInfoData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.qxy.helper.QxyRepHelper;

public class QxyCompanyInfoService {
    private static final ExecuteTypeEnums SJYZ = ExecuteTypeEnums.SJYZ;
    private static final SupplierEnum qxy = SupplierEnum.QXY;
    private static Log logger = LogFactory.getLog(QxyCompanyInfoService.class);

    public static DynamicObject getCompanyInfo(String nsrsbh) {
        return TsateCompanyInfoBusiness.getCompanyInfo((String)nsrsbh, (SupplierEnum)SupplierEnum.QXY);
    }

    public static ApiResult dealCompanyInfo(SBMessageBaseVo vo) {
        ApiResult result = CustomApiResult.buildDefultFailResponse();
        StringBuilder failedLog = new StringBuilder();
        IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
        if (identityData == null) {
            String notify = ResManager.loadKDString((String)"\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38 %1$s \u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"QxyCompanyInfoService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, System.getProperty("line.separator"));
            result.setMessage(notifyMsg);
            return result;
        }
        identityData.setDldq(vo.getSbdq());
        return QxyCompanyInfoService.saveCompanyInfo(vo.getNsrsbh(), vo.getOrg(), identityData, result);
    }

    private static ApiResult saveCompanyInfo(String nsrshb, String org, IdentityData identityData, ApiResult result) {
        TaxResult<RepCompanyInfoData> dealResult;
        DynamicObject companyInfo = QxyCompanyInfoService.getCompanyInfo(nsrshb);
        if (companyInfo == null) {
            logger.info("qxy-\u521b\u5efa\u4f01\u4e1a\u5f00\u59cb nsrshb={}", (Object)nsrshb);
            companyInfo = TsateCompanyInfoBusiness.newCompanyInfo();
            dealResult = QxyApi.createCompanyInfo(identityData);
        } else {
            logger.info("qxy-\u4fee\u6539\u4f01\u4e1a\u5f00\u59cb nsrshb={}", (Object)nsrshb);
            identityData.setQyid(companyInfo.getString("authorizationcode"));
            dealResult = QxyApi.modifyCompanyInfo(identityData);
        }
        if (QxyRepHelper.checkRepDataAndBuildErroApiResult(dealResult, result)) {
            return result;
        }
        RepCompanyInfoData data = (RepCompanyInfoData)dealResult.getData();
        Object originData = data.getOriginData();
        if (originData == null || StringUtils.isBlank((CharSequence)data.getQyxOrgId())) {
            String notify = ResManager.loadKDString((String)"\u4fdd\u5b58\u4f01\u4e1a\u63a5\u53e3\u672a\u6b63\u5e38\u8fd4\u56de\u6570\u636e,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002 %1$s message\uff1a", (String)"QxyCompanyInfoService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, data.getMessage());
            throw new KDBizException(notifyMsg);
        }
        logger.info("qxy-\u5f00\u59cb\u4fdd\u5b58\u4f01\u4e1aid nsrshb={} qyid={}", (Object)nsrshb, (Object)data.getQyxOrgId());
        QxyCompanyInfoService.buildCompanyInfoAndSave(companyInfo, data.getQyxOrgId(), nsrshb);
        result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"QxyCompanyInfoService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
        QxyCompanyInfoService.buildVerifyRecord(data.getTaskId(), org);
        return result;
    }

    private static void buildVerifyRecord(String taskId, String orgId) {
        block17: {
            if (StringUtils.isBlank((CharSequence)taskId)) {
                return;
            }
            logger.info("qxy-\u5f00\u59cb\u751f\u6210\u4efb\u52a1 taskId={}", (Object)taskId);
            try (TXHandle handle = TX.required();){
                try {
                    String recordId;
                    DynamicObject requestObj;
                    DynamicObject qxySjyzTask = TsateDeclareRecordBusiness.getRecordByBusinessField((String)orgId, (String)SJYZ.getExecuteType(), (String)qxy.getCode(), (ExecuteStatusEnum)ExecuteStatusEnum.PROCESSING);
                    if (qxySjyzTask == null) {
                        qxySjyzTask = TsateDeclareRecordBusiness.assembleDeclareRecord((String)orgId, (ExecuteTypeEnums)SJYZ, (SupplierEnum)qxy);
                    }
                    if ((requestObj = TsateRequestInfoBusiness.queryOne((String)(recordId = qxySjyzTask.getString("id")), (String)"4", (String)"1")) == null) {
                        TsateRequestInfoBusiness.saveRequestId((String)orgId, (String)taskId, (String)recordId, (String)"", (String)"4", (SupplierEnum)qxy);
                        break block17;
                    }
                    TsateRequestInfoBusiness.updateRequestId((String)taskId, (String)recordId, (DynamicObject)requestObj);
                }
                catch (Exception e) {
                    handle.markRollback();
                    logger.error("\u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u540c\u65f6\u4e0b\u53d1\u7a0e\u52a1\u4fe1\u606f\u91c7\u96c6\u4efb\u52a1\u5931\u8d25\uff1aerror={} orgId={}", (Object)ExceptionUtil.toString((Exception)e), (Object)orgId);
                }
            }
        }
    }

    private static void buildCompanyInfoAndSave(DynamicObject companyInfo, String qyId, String nsrshb) {
        String authorizationcode = companyInfo.getString("authorizationcode");
        if (StringUtils.equals((CharSequence)authorizationcode, (CharSequence)qyId)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)authorizationcode)) {
            companyInfo.set("declarechannel", (Object)SupplierEnum.QXY.getId());
            companyInfo.set("nsrsbh", (Object)nsrshb);
            companyInfo.set("channel", (Object)SupplierEnum.QXY.getCode());
        }
        companyInfo.set("authorizationcode", (Object)qyId);
        TsateCompanyInfoBusiness.savaCompanyInfo((DynamicObject)companyInfo);
    }

    public static void synVerifyResult(String qyId, Long rocordId) {
        try {
            logger.info("qyx-\u5f00\u59cb\u8fdb\u884c\u7a0e\u5c40\u9a8c\u8bc1\u72b6\u6001\u83b7\u53d6");
            QxyCompanyInfoService.synTaskResult(qyId, rocordId);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u91c7\u96c6\u4efb\u52a1\u72b6\u6001\u5931\u8d25\uff1aerror={} rocordId={}", (Object)ExceptionUtil.toString((Exception)e), (Object)rocordId);
        }
    }

    private static void synTaskResult(String qyId, Long rocordId) {
        DynamicObject requestObj = TsateRequestInfoBusiness.queryOne((String)(rocordId + ""), (String)"4", (String)"1");
        DynamicObject qxySjyzTask = TsateDeclareRecordBusiness.getRecordByIdAndStatus((Long)rocordId, (ExecuteStatusEnum)ExecuteStatusEnum.PROCESSING);
        if (requestObj == null || qxySjyzTask == null) {
            logger.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684taskId\u6216recordId\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f rocordId={}", (Object)rocordId);
            return;
        }
        String taskId = requestObj.getString("requestid");
        logger.info("qyx-\u8c03\u7528\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u5f00\u59cb qyid={} taskdId={}", (Object)qyId, (Object)taskId);
        TaxResult<RepTaskData> taskResult = QxyApi.getTaskStatus(qyId, taskId);
        if (!taskResult.isSuccess()) {
            logger.info("\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5931\u8d25 qyId={}\uff0ctaskId={}", (Object)qyId, (Object)taskId);
            return;
        }
        if (QxyRepHelper.isRunningTask(taskResult)) {
            return;
        }
        QxyRepHelper.updateSingleTaskStatus(taskResult, rocordId, requestObj.getLong("id"));
    }
}

