/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbpzMessageVo;
import kd.taxc.tsate.msmessage.enums.DeclareMethodEnums;
import kd.taxc.tsate.msmessage.service.qxy.api.QxyApi;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.qxy.bean.ZsxmRequestData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyBusinessStatusEnum;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyDeclareFileUrlEnum;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyPzlDmEnum;
import kd.taxc.tsate.msmessage.service.qxy.helper.QxyRepHelper;
import kd.taxc.tsate.msmessage.util.SbpzRecordSaveUtils;
import org.apache.commons.lang.StringUtils;

public class QxyDeclareFileService {
    private static final Log logger = LogFactory.getLog(QxyDeclareFileService.class);

    public static TaxResult sendDownLoadDeclareFileTask(SBMessageBaseVo baseVo) {
        TaxResult<RepTaskData> result = new TaxResult<RepTaskData>();
        SbpzMessageVo sbpzMessageVo = (SbpzMessageVo)baseVo.handler(SbpzMessageVo.class);
        String operationType = baseVo.getOperationType();
        String qyId = TsateCompanyInfoBusiness.getQyId((String)baseVo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY);
        String orgId = baseVo.getOrg();
        Long recordId = baseVo.getId();
        if (DeclareMethodEnums.WSPZ.getKey().equals(operationType)) {
            logger.info("qxy - start sendWspzTask qyid={}\uff0crecordId={}", (Object)qyId, (Object)recordId);
            result = QxyDeclareFileService.sendWspzTask(qyId, sbpzMessageVo);
        }
        if (DeclareMethodEnums.SBBFILE.getKey().equals(operationType)) {
            logger.info("qxy - start sendSbbfileTask qyid={}\uff0crecordId={}", (Object)qyId, (Object)recordId);
            result = QxyDeclareFileService.sendSbbfileTask(qyId, sbpzMessageVo);
        }
        if (result.isSuccess()) {
            logger.info("qxy - begin saveRequestInfo");
            QxyDeclareFileService.saveRequestInfo(result, orgId, recordId);
        }
        return result;
    }

    private static void saveRequestInfo(TaxResult<RepTaskData> result, String orgId, Long recordId) {
        RepTaskData data = (RepTaskData)result.getData();
        if (data == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u8fd4\u56de\u6210\u529f\u4f46\u7f3a\u5931\u5173\u952edata\u4fe1\u606f,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"QxyDeclareFileService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        String taskId = data.getTaskId();
        if (StringUtil.isBlank((CharSequence)taskId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u672a\u6b63\u5e38\u8fd4\u56de\u6570\u636e,\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"QxyDeclareFileService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        logger.info("qxy -saveRequestInfo taskId={}", (Object)taskId, (Object)orgId);
        TsateRequestInfoBusiness.saveRequestId((String)orgId, (String)taskId, (String)(recordId + ""), null, null, (SupplierEnum)SupplierEnum.QXY);
    }

    public static TaxResult<RepTaskData> sendWspzTask(String qyId, SbpzMessageVo sbpzMessageVo) {
        return QxyApi.downloadWspz(qyId, QxyDeclareFileService.buildRequestData(sbpzMessageVo), sbpzMessageVo.getDate(SbpzMessageVo.Key.SBQJ));
    }

    public static TaxResult<RepTaskData> sendSbbfileTask(String qyId, SbpzMessageVo sbpzMessageVo) {
        return QxyApi.downloadDeclarePdf(qyId, QxyDeclareFileService.buildSingleData(sbpzMessageVo), sbpzMessageVo.getDate(SbpzMessageVo.Key.SBQJ), sbpzMessageVo);
    }

    private static List<ZsxmRequestData> buildRequestData(SbpzMessageVo sbpzMessageVo) {
        ArrayList<ZsxmRequestData> requestData = new ArrayList<ZsxmRequestData>();
        requestData.add(QxyDeclareFileService.buildSingleData(sbpzMessageVo));
        return requestData;
    }

    private static ZsxmRequestData buildSingleData(SbpzMessageVo sbpzMessageVo) {
        ZsxmRequestData requestData = new ZsxmRequestData();
        String typeNumber = sbpzMessageVo.getString(SbpzMessageVo.Key.TAXTYPE_NUMBER);
        Date skssqq = sbpzMessageVo.getDate(SbpzMessageVo.Key.SKSSQQ);
        Date skssqz = sbpzMessageVo.getDate(SbpzMessageVo.Key.SKSSQZ);
        requestData.setSsqQ(DateUtils.format((Date)skssqq));
        requestData.setSsqZ(DateUtils.format((Date)skssqz));
        requestData.setYzpzzlDm(QxyPzlDmEnum.getQxyCodeBySsqAndTaxTypeCode(typeNumber, skssqq, skssqz));
        if (DeclareTypeEnum.WHSYJSF.getCode().equals(typeNumber)) {
            requestData.setZspmDm("302170200");
        }
        return requestData;
    }

    public static void synDeclareFileResult(String qyId, SBMessageBaseVo vo) {
        try {
            logger.info("qyx-\u5f00\u59cb\u8fdb\u884c\u7a0e\u5c40\u9a8c\u8bc1\u72b6\u6001\u83b7\u53d6");
            QxyDeclareFileService.synTaskResult(qyId, vo);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u7533\u62a5\u6587\u4ef6\u5f02\u5e38\uff1aerror={} rocordId={}", (Object)ExceptionUtil.toString((Exception)e));
        }
    }

    private static void synTaskResult(String qyId, SBMessageBaseVo vo) {
        Long rocordId = vo.getId();
        DynamicObject requestObj = TsateRequestInfoBusiness.queryOne((String)(rocordId + ""), null, (String)"1");
        DynamicObject recordObj = TsateDeclareRecordBusiness.getRecordByIdAndStatus((Long)rocordId, (ExecuteStatusEnum)ExecuteStatusEnum.PROCESSING);
        if (requestObj == null || recordObj == null) {
            logger.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684taskId\u6216recordId\uff0c\u4efb\u52a1\u6267\u884c\u7ed3\u675f rocordId={}", (Object)rocordId);
            return;
        }
        String taskId = requestObj.getString("requestid");
        logger.info("qyx-\u8c03\u7528\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u5f00\u59cb qyid={} taskdId={}", (Object)qyId, (Object)taskId);
        TaxResult<RepTaskData> taskResult = QxyApi.getTaskStatus(qyId, taskId);
        if (!taskResult.isSuccess()) {
            logger.info("\u67e5\u8be2\u63a5\u53e3\u8c03\u7528\u5931\u8d25 qyId={}\uff0ctaskId={}", (Object)qyId, (Object)taskId);
            return;
        }
        if (QxyRepHelper.isRunningTask(taskResult)) {
            return;
        }
        long requestId = requestObj.getLong("id");
        try {
            logger.info("qxy-\u5f00\u59cb\u4fdd\u6301\u7533\u62a5\u6587\u4ef6\u6570\u636e");
            QxyDeclareFileService.doBusiness(taskResult, vo);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
            QxyRepHelper.updateSingleTaskFailStatus(taskResult, rocordId, requestId, ResManager.loadKDString((String)"\u4fdd\u5b58\u6587\u4ef6\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"QxyDeclareFileService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            return;
        }
        QxyRepHelper.updateSingleTaskStatus(taskResult, rocordId, requestId);
    }

    private static void doBusiness(TaxResult<RepTaskData> taskResult, SBMessageBaseVo vo) {
        RepTaskData data = (RepTaskData)taskResult.getData();
        String resultMessage = data.getTaskResultMessage();
        if (QxyBusinessStatusEnum.SUCCESS == data.getTaskStatus()) {
            JSONObject info = data.getDetailInfo();
            if (info == null) {
                String notify = ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u4e0b\u8f7d\u63a5\u53e3\u672a\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002\u63a5\u53e3\u8fd4\u56de\u63d0\u793a\uff1a %1$s", (String)"QxyDeclareFileService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                String notifyMsg = String.format(notify, resultMessage);
                throw new KDBizException(notifyMsg);
            }
            String fileOssUrl = info.getString(QxyDeclareFileUrlEnum.getFileUrlKeyByTaskKey(vo.getOperationType()));
            if (StringUtils.isBlank((String)fileOssUrl)) {
                String notify = ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u4e0b\u8f7d\u63a5\u53e3\u672a\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002\u63a5\u53e3\u8fd4\u56de\u63d0\u793a\uff1a %1$s", (String)"QxyDeclareFileService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                String notifyMsg = String.format(notify, resultMessage);
                throw new KDBizException(notifyMsg);
            }
            SbpzRecordSaveUtils.dealUrlAndSave(fileOssUrl, SupplierEnum.QXY, vo);
        }
    }
}

