/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.fi.TsateFiDeclareBusiness;
import kd.taxc.tsate.business.taxdialog.TasteDeclarePopupBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.taxdialog.vo.qxy.PoppupStatusEnum;
import kd.taxc.tsate.common.enums.DeclareStatusEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.XmlUtil;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.exception.MessageException;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.service.qxy.api.QxyApi;
import kd.taxc.tsate.msmessage.service.qxy.bean.DiaologOption;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepDeclareTaskData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyBusinessStatusEnum;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyBwTypeEnum;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyTaxTypeEnum;
import kd.taxc.tsate.msmessage.service.qxy.helper.QxyRepHelper;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;

public class QxyDeclareService {
    private static Log logger = LogFactory.getLog(QxyDeclareService.class);

    private static String getBw(SBMessageBaseVo vo) {
        String declareId = vo.getBusinessId();
        MessageSend send = new MessageSend();
        send.setMsgtype("declare");
        send.setBusinessid(declareId);
        send.setBusinesstype(vo.getBusinessType());
        send.setNsrType(vo.getType());
        send.setNodetype(vo.getSbdq());
        send.setSupplier(SupplierEnum.QXY.getName());
        send.setVersion(vo.getDeclareVersion());
        try {
            return MessageService.collectionData(send, null, null);
        }
        catch (MessageException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static TaxResult declare(SBMessageBaseVo vo) {
        TaxResult result = new TaxResult();
        String qyId = TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY);
        if (StringUtil.isEmpty((CharSequence)qyId)) {
            logger.error("qxy\u7533\u62a5-1.0 \u4f01\u4e1aid\u4e3a\u7a7a");
            QxyRepHelper.resultFaild(result, ResManager.loadKDString((String)"\u4f01\u4e1aid\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u4f01\u4e1a\u4fe1\u606f\u662f\u5426\u5df2\u6b63\u786e\u540c\u6b65\u5230\u4f01\u4eab\u4e91", (String)"QxyDeclareService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateDeclareStatusCompatible(vo.getBusinessId(), vo.getId(), "declarestatus", DeclareStatusEnum.DECLAREFAILED.getCode(), "3", new StringBuilder(result.getMessage()));
            logger.info("qxy\u7533\u62a5\u4efb\u52a1\u53d1\u8d77\u5931\u8d25");
            return result;
        }
        StringBuilder failedLog = new StringBuilder();
        Long recordId = vo.getId();
        Long declaremainId = Long.parseLong(vo.getBusinessId());
        logger.info("qxy\u7533\u62a5-1 \u5f00\u59cb\u540c\u6b65\u7533\u62a5\u72b6\u6001");
        TaxResult<DeclareStatusEnum> statusR = QxyDeclareService.getDeclareStatus(recordId, declaremainId);
        if (!statusR.isSuccess()) {
            logger.error("qxy\u7533\u62a5-1.1 \u7533\u62a5\u72b6\u6001\u540c\u6b65\u5931\u8d25,\u7533\u62a5\u76d1\u63a7\u4efb\u52a1{}", (Object)recordId);
            QxyRepHelper.resultFaild(result, statusR.getMessage());
            return result;
        }
        logger.info("qxy\u7533\u62a5-2 \u5f00\u59cb\u6821\u9a8c\u7533\u62a5\u72b6\u6001\uff0c\u68c0\u67e5\u662f\u5426\u9700\u8981\u65b0\u7533\u62a5");
        DeclareStatusEnum status = (DeclareStatusEnum)statusR.getData();
        if (DeclareStatusEnum.DECLARED == status || DeclareStatusEnum.DECLARING == status) {
            logger.info("qxy\u7533\u62a5-2.1 \u4e0d\u9700\u8981\u91cd\u65b0\u7533\u62a5,\u7533\u62a5\u6d41\u7a0b\u7ed3\u675f");
            failedLog.append(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u4e2d\u6216\u7533\u62a5\u5931\u8d25\u624d\u9700\u8981\u53d1\u8d77\u4efb\u52a1", (String)"QxyDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            QxyRepHelper.resultFaild(result, failedLog.toString());
            return result;
        }
        TaxResult r = QxyDeclareService.doDeclare(vo, qyId);
        if (r.isSuccess()) {
            DirectDeclareLogUtils.updateDeclareStatusCompatible(vo.getBusinessId(), vo.getId(), "declarestatus", DeclareStatusEnum.DECLARING.getCode(), "1", new StringBuilder());
            logger.info("qxy\u7533\u62a5\u4efb\u52a1\u53d1\u8d77\u6210\u529f");
        } else {
            DirectDeclareLogUtils.updateDeclareStatusCompatible(vo.getBusinessId(), vo.getId(), "declarestatus", DeclareStatusEnum.DECLAREFAILED.getCode(), "3", new StringBuilder(r.getMessage()));
            logger.info("qxy\u7533\u62a5\u4efb\u52a1\u53d1\u8d77\u5931\u8d25");
        }
        return r;
    }

    private static TaxResult<DeclareStatusEnum> getDeclareStatus(Long recordId, Long declaremainId) {
        DynamicObject declareMain = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)declaremainId);
        String declareStatusStr = declareMain.getString("declarestatus");
        DeclareStatusEnum kdDeclareStatus = DeclareStatusEnum.valueOfCode((String)declareStatusStr);
        return new TaxResult((Object)kdDeclareStatus);
    }

    private static TaxResult doDeclare(SBMessageBaseVo vo, String qyId) {
        String jsonBw;
        TaxResult<RepDeclareTaskData> result = new TaxResult<RepDeclareTaskData>();
        Long recordId = vo.getId();
        Long declaremainId = Long.parseLong(vo.getBusinessId());
        logger.info("qxy\u7533\u62a5-3 \u5f00\u59cb\u7533\u62a5");
        Date sbqj = new Date();
        String xmlBw = null;
        try {
            xmlBw = QxyDeclareService.getBw(vo);
            jsonBw = JSON.toJSONString((Object)XmlUtil.parseXmlString((String)xmlBw));
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u62a5\u6587\u5931\u8d25");
            logger.error(ExceptionUtil.toString((Exception)e));
            if (StringUtils.isNotBlank((CharSequence)xmlBw)) {
                DirectDeclareLogUtils.dealDetailLog(new StringBuilder(xmlBw), vo.getId());
            }
            QxyRepHelper.resultFaild((TaxResult)result, ResManager.loadKDString((String)"\u62a5\u6587\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u67e5\u770b", (String)"QxyDeclareService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            return result;
        }
        DirectDeclareLogUtils.dealDetailLog(new StringBuilder(jsonBw), vo.getId());
        if (StringUtils.isEmpty((CharSequence)jsonBw)) {
            logger.info("qxy\u7533\u62a5-3.1 \u62a5\u6587\u83b7\u53d6\u5931\u8d25");
            QxyRepHelper.resultFaild((TaxResult)result, ResManager.loadKDString((String)"\u7533\u62a5\u62a5\u6587\u83b7\u53d6\u5931\u8d25", (String)"QxyDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            return result;
        }
        DeclareTypeEnum declare = DeclareTypeEnum.valueOfCode((String)vo.getBusinessType());
        QxyBwTypeEnum bwType = QxyBwTypeEnum.valueOfDeclareType(declare);
        result = QxyDeclareService.startQxyDeclareTask(recordId, declaremainId, qyId, sbqj, bwType, jsonBw);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshDeclare(SBMessageBaseVo vo) {
        DLock lock = DLock.create((String)(vo.getBusinessId() + "-" + vo.getId() + "-refreshDeclare"));
        if (lock.tryLock()) {
            try {
                String qyId = TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY);
                TaxResult<DeclareStatusEnum> r = QxyDeclareService.syncDeclareStatus(vo.getId(), Long.parseLong(vo.getBusinessId()), qyId, true);
                if (!r.isSuccess()) {
                    logger.info("\u5ffd\u7565\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)r.getMessage());
                    return;
                }
                if (DeclareStatusEnum.EDITING == r.getData()) {
                    Long recordId = vo.getId();
                    Long declaremainId = Long.parseLong(vo.getBusinessId());
                    StringBuilder failedLog = new StringBuilder(ResManager.loadKDString((String)"\u672a\u6210\u529f\u53d1\u8d77\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u4e0b\u53d1", (String)"QxyDeclareService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    DirectDeclareLogUtils.updateDeclareStatusCompatible(declaremainId + "", recordId, "declarestatus", DeclareStatusEnum.DECLAREFAILED.getCode(), "3", failedLog);
                }
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    public static void refreshUndo(SBMessageBaseVo vo) {
        logger.info("qxy\u5237\u65b0\u4f5c\u5e9f\u4efb\u52a1 \u5f00\u59cb");
        String qyId = TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY);
        Long sbbid = Long.parseLong(vo.getBusinessId());
        QxyDeclareService.syncUndoStatus(sbbid, qyId, true);
        logger.info("qxy\u5237\u65b0\u4f5c\u5e9f\u4efb\u52a1 \u7ed3\u675f");
    }

    public static TaxResult<DeclareStatusEnum> syncDeclareStatus(Long recordId, Long sbbid, String qyId, boolean refresh) {
        DeclareStatusEnum kdDeclareStatus;
        logger.info("qxy\u72b6\u6001\u540c\u6b65 \u5f00\u59cb");
        QFilter declareRecordFilter = new QFilter("sbbid", "=", (Object)(sbbid + ""));
        declareRecordFilter.and("executestatus", "=", (Object)ExecuteStatusEnum.PROCESSING.getCode());
        declareRecordFilter.and("executetype", "=", (Object)ExecuteTypeEnums.ZLSB.getExecuteType());
        DynamicObject declareRecord = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_record", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,importlogs,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,detaillog_tag,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype,importlogs.seq,importlogs.logtitle,importlogs.log", (QFilter[])new QFilter[]{declareRecordFilter});
        DynamicObject declaremain = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)sbbid);
        String declareStatusStr = declaremain.getString("declarestatus");
        DeclareStatusEnum declareStatusAfterSync = kdDeclareStatus = DeclareStatusEnum.valueOfCode((String)declareStatusStr);
        if (declareRecord != null) {
            logger.info("qxy\u72b6\u6001\u67e5\u8be2-\u5b58\u5728\u7533\u62a5\u76d1\u63a7\u4efb\u52a1\u8bb0\u5f55\uff0c\u5e76\u6839\u636e\u4efb\u52a1id\u67e5\u627e\u4f01\u4eab\u4e91\u7533\u62a5\u72b6\u6001");
            Long declareRecordId = declareRecord.getLong("id");
            DynamicObject declareRequestInfo = TsateRequestInfoBusiness.queryOne((String)(declareRecordId + ""), (String)"1", null);
            if (declareRequestInfo != null) {
                String qxyTaskId = declareRequestInfo.getString("requestid");
                TaxResult<QxyBusinessStatusEnum> taskRep = QxyDeclareService.getQxyTaskStatus(sbbid, recordId, qyId, qxyTaskId);
                if (taskRep.isSuccess()) {
                    declareStatusAfterSync = QxyDeclareService.dealQxyDeclareStatus(taskRep, declaremain, declareRecord);
                } else {
                    logger.error("\u4efb\u52a1\u76d1\u63a7\u5b58\u5728\u4f01\u4eab\u4e91\u4efb\u52a1\u8bf7\u6c42id\uff0c\u4f46\u67e5\u8be2\u72b6\u6001\u5931\u8d25");
                    StringBuilder failedLog = new StringBuilder(taskRep.getMessage());
                    DirectDeclareLogUtils.updateDeclareStatusCompatible(sbbid + "", declareRecordId, "declarestatus", DeclareStatusEnum.DECLAREFAILED.getCode(), ExecuteStatusEnum.FAIL.getCode(), failedLog);
                    declareStatusAfterSync = DeclareStatusEnum.DECLAREFAILED;
                }
            } else if (refresh) {
                Date startTime = declareRecord.getDate("createtime");
                if (System.currentTimeMillis() - startTime.getTime() > 180000L) {
                    StringBuilder failedLog = new StringBuilder(ResManager.loadKDString((String)"\u4efb\u52a1\u5f02\u5e38,\u672a\u67e5\u627e\u5230\u4f01\u4eab\u4e91\u4efb\u52a1\u8bb0\u5f55,\u9700\u8981\u91cd\u65b0\u53d1\u8d77", (String)"QxyDeclareService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    DirectDeclareLogUtils.updateDeclareStatusCompatible(sbbid + "", declareRecordId, "declarestatus", DeclareStatusEnum.DECLAREFAILED.getCode(), ExecuteStatusEnum.FAIL.getCode(), failedLog);
                    declareStatusAfterSync = DeclareStatusEnum.DECLAREFAILED;
                    logger.info("qxy\u72b6\u6001\u67e5\u8be2-\u8d85\u65f6\u4e14\u4e0d\u5b58\u5728\u4f01\u4eab\u4e91\u4efb\u52a1\u8bb0\u5f55,\u7533\u62a5\u5931\u8d25");
                } else {
                    logger.info("qxy\u72b6\u6001\u67e5\u8be2-\u4e0d\u5b58\u5728\u4f01\u4eab\u4e91\u4efb\u52a1\u8bb0\u5f55,\u4f7f\u7528\u4e3b\u8868\u7533\u62a5\u72b6\u6001");
                    logger.info("\u672a\u8d85\u65f63\u5206\u949f");
                }
            } else {
                logger.info("qxy\u72b6\u6001\u67e5\u8be2-\u4e0d\u5b58\u5728\u4f01\u4eab\u4e91\u4efb\u52a1\u8bb0\u5f55,\u4f7f\u7528\u4e3b\u8868\u7533\u62a5\u72b6\u6001");
            }
        } else {
            logger.info("qxy\u72b6\u6001\u67e5\u8be2-\u4e0d\u5b58\u5728\u76d1\u63a7\u4efb\u52a1\u8bb0\u5f55,\u67e5\u8be2\u4e3b\u8868\u7533\u62a5\u72b6\u6001\uff08\u7279\u6b8a\u7684\u5f02\u5e38\u60c5\u51b5\uff09");
            declareStatusAfterSync = DeclareStatusEnum.DECLAREFAILED;
        }
        logger.info("qxy\u72b6\u6001\u540c\u6b65\u7ed3\u675f\uff0c\u7a0e\u52a1\u4e91\u6700\u7ec8\u7533\u62a5\u72b6\u6001{}", (Object)declareStatusAfterSync.name());
        return new TaxResult((Object)declareStatusAfterSync);
    }

    private static TaxResult<QxyBusinessStatusEnum> getQxyTaskStatus(Long declareId, Long recordId, String qyId, String qxyTaskId) {
        TaxResult result = new TaxResult();
        TaxResult<RepTaskData> taskRep = QxyApi.getTaskStatus(qyId, qxyTaskId);
        if (!taskRep.isSuccess()) {
            logger.error("qxy\u72b6\u6001\u67e5\u8be2-2.2.1 \u67e5\u8be2\u5931\u8d25");
            QxyRepHelper.resultFaild(result, taskRep.getMessage());
            return result;
        }
        RepDeclareTaskData declareTask = QxyRepHelper.translate((RepData)taskRep.getData(), new RepDeclareTaskData());
        QxyBusinessStatusEnum qxyTaskStatus = declareTask.getTaskStatus();
        result.setData((Object)qxyTaskStatus);
        result.setMessage(declareTask.getMessage());
        if (QxyBusinessStatusEnum.SUCCESS == qxyTaskStatus) {
            TsateRequestInfoBusiness.updateStatus((String)qxyTaskId, (ExecuteStatusEnum)ExecuteStatusEnum.SUCCESS);
        } else if (QxyBusinessStatusEnum.FAILD == qxyTaskStatus) {
            TsateRequestInfoBusiness.updateStatus((String)qxyTaskId, (ExecuteStatusEnum)ExecuteStatusEnum.FAIL);
        }
        try {
            List<String> imgList = declareTask.getScreenUrl(qxyTaskId);
            if (imgList.size() > 0) {
                TsateDeclareRecordBusiness.addPic((Long)recordId, imgList);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u56fe\u7247\u4fe1\u606f\u5931\u8d25");
        }
        try {
            Map<String, JSONObject> dialogs = declareTask.getDialogInfos();
            JSONObject dialogJson = dialogs.get(qxyTaskId);
            if (dialogJson != null) {
                TasteDeclarePopupBusiness.initQxyPopupData((String)(declareId + ""), (String)dialogJson.toJSONString());
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f39\u7a97\u4fe1\u606f\u5931\u8d25");
            logger.error(ExceptionUtil.toString((Exception)e));
        }
        return result;
    }

    public static TaxResult<DeclareStatusEnum> syncUndoStatus(Long sbbid, String qyId, boolean refresh) {
        logger.info("qxy\u540c\u6b65\u4f5c\u5e9f\u72b6\u6001 \u5f00\u59cb");
        TaxResult result = new TaxResult();
        QFilter declareRecordFilter = new QFilter("sbbid", "=", (Object)(sbbid + ""));
        declareRecordFilter.and("executestatus", "=", (Object)ExecuteStatusEnum.PROCESSING.getCode());
        declareRecordFilter.and("executetype", "=", (Object)ExecuteTypeEnums.SBZF.getExecuteType());
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_record", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,importlogs,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,detaillog_tag,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype,importlogs.seq,importlogs.logtitle,importlogs.log", (QFilter[])new QFilter[]{declareRecordFilter});
        DynamicObject declaremain = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)sbbid);
        Long recordId = record.getLong("id");
        String declareStatus = declaremain.getString("declarestatus");
        DeclareStatusEnum declareStatusAfterUndo = DeclareStatusEnum.valueOfCode((String)declareStatus);
        if (record != null) {
            logger.info("qxy\u72b6\u6001\u67e5\u8be2-2 \u67e5\u8be2\u6267\u884c\u4e2d\u7684\u4efb\u52a1");
            DynamicObject requestR = TsateRequestInfoBusiness.queryOne((String)(recordId + ""), (String)"5", (String)"1");
            if (requestR != null) {
                String declareTaskId = requestR.getString("requestid");
                logger.info("qxy\u72b6\u6001\u67e5\u8be2-2.1 \u5b58\u5728\u6267\u884c\u4e2d\u7684\u4efb\u52a1,\u5f00\u59cb\u67e5\u8be2\u4f01\u4eab\u4e91\uff0c\u4efb\u52a1id {}", (Object)declareTaskId);
                TaxResult<RepTaskData> taskRep = QxyApi.getTaskStatus(qyId, declareTaskId);
                if (!taskRep.isSuccess()) {
                    logger.info("qxy\u72b6\u6001\u67e5\u8be2-2.2.1 \u67e5\u8be2\u5931\u8d25");
                    QxyRepHelper.resultFaild(result, taskRep.getMessage());
                    return result;
                }
                logger.info("qxy\u72b6\u6001\u67e5\u8be2-2.3 \u67e5\u8be2\u6210\u529f\u4f01\u4eab\u4e91\u72b6\u6001{}\uff0c\u5f00\u59cb\u4fdd\u5b58\u72b6\u6001", (Object)((RepTaskData)taskRep.getData()).toString());
                declareStatusAfterUndo = QxyDeclareService.dealQxyUndoStatus((RepTaskData)taskRep.getData(), declaremain, record);
                result.setData((Object)declareStatusAfterUndo);
            } else {
                logger.info("\u4e0d\u5b58\u5728\u4f01\u4eab\u4e91\u4f5c\u5e9f\u4efb\u52a1\u8bb0\u5f55");
                if (refresh) {
                    StringBuilder failedLog = new StringBuilder(ResManager.loadKDString((String)"\u4efb\u52a1\u5f02\u5e38\uff0c\u672a\u67e5\u627e\u5230\u4f01\u4eab\u4e91\u4efb\u52a1\u8bb0\u5f55\uff0c\u9700\u8981\u91cd\u65b0\u53d1\u8d77", (String)"QxyDeclareService_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    DirectDeclareLogUtils.updateStatus(recordId, ExecuteStatusEnum.FAIL.getCode(), failedLog);
                }
            }
        } else {
            logger.info("\u4e0d\u5b58\u5728\u6267\u884c\u4e2d\u4f5c\u5e9f\u76d1\u63a7\u4efb\u52a1\u8bb0\u5f55");
        }
        logger.info("qxy\u72b6\u6001\u67e5\u8be2-2.4 \u72b6\u6001\u540c\u6b65\u7ed3\u675f\uff0c\u7a0e\u52a1\u4e91\u6700\u7ec8\u7533\u62a5\u72b6\u6001{}", (Object)declareStatusAfterUndo.name());
        result.setData((Object)declareStatusAfterUndo);
        return result;
    }

    private static DeclareStatusEnum dealQxyDeclareStatus(TaxResult<QxyBusinessStatusEnum> statusRep, DynamicObject declaremain, DynamicObject record) {
        QxyBusinessStatusEnum status = (QxyBusinessStatusEnum)((Object)statusRep.getData());
        Long recordId = record.getLong("id");
        Long sbbid = declaremain.getLong("id");
        String declareStatusStr = declaremain.getString("declarestatus");
        DeclareStatusEnum declareStatus = DeclareStatusEnum.valueOfCode((String)declareStatusStr);
        StringBuilder failedLog = new StringBuilder();
        if (DeclareStatusEnum.DECLARING == declareStatus || DeclareStatusEnum.IMPORTING == declareStatus || DeclareStatusEnum.SUBMITTED == declareStatus) {
            if (QxyBusinessStatusEnum.SUCCESS == status) {
                DirectDeclareLogUtils.updateDeclareStatusCompatible(sbbid + "", recordId, "declarestatus", DeclareStatusEnum.DECLARED.getCode(), "2", failedLog);
                return DeclareStatusEnum.DECLARED;
            }
            if (QxyBusinessStatusEnum.FAILD == status) {
                failedLog.append(statusRep.getMessage());
                DirectDeclareLogUtils.updateDeclareStatusCompatible(sbbid + "", recordId, "declarestatus", DeclareStatusEnum.DECLAREFAILED.getCode(), "3", failedLog);
                return DeclareStatusEnum.DECLAREFAILED;
            }
            if (QxyBusinessStatusEnum.RUNNING == status) {
                return DeclareStatusEnum.DECLARING;
            }
        }
        return declareStatus;
    }

    private static DeclareStatusEnum dealQxyUndoStatus(RepTaskData taskData, DynamicObject declaremain, DynamicObject record) {
        QxyBusinessStatusEnum status = taskData.getTaskStatus();
        Long recordId = record.getLong("id");
        Long sbbid = declaremain.getLong("id");
        String declareStatusStr = declaremain.getString("declarestatus");
        DeclareStatusEnum declareStatus = DeclareStatusEnum.valueOfCode((String)declareStatusStr);
        StringBuilder failedLog = new StringBuilder();
        if (DeclareStatusEnum.DECLARED == declareStatus) {
            if (QxyBusinessStatusEnum.SUCCESS == status) {
                DirectDeclareLogUtils.updateDeclareStatusCompatible(sbbid + "", recordId, "declarestatus", DeclareStatusEnum.EDITING.getCode(), "2", failedLog);
                TsateRequestInfoBusiness.updateStatus((String)taskData.getReqId(), (ExecuteStatusEnum)ExecuteStatusEnum.SUCCESS);
                return DeclareStatusEnum.EDITING;
            }
            if (QxyBusinessStatusEnum.FAILD == status) {
                failedLog.append(taskData.getMessage());
                DirectDeclareLogUtils.updateDeclareStatusCompatible(sbbid + "", recordId, "declarestatus", declareStatus.getCode(), "3", failedLog);
                TsateRequestInfoBusiness.updateStatus((String)taskData.getReqId(), (ExecuteStatusEnum)ExecuteStatusEnum.FAIL);
                return declareStatus;
            }
        }
        return declareStatus;
    }

    private static TaxResult<RepDeclareTaskData> startQxyDeclareTask(Long declareRecordId, Long declaremainId, String qyId, Date sbqj, QxyBwTypeEnum bwType, String jsonBw) {
        TaxResult<RepDeclareTaskData> result = new TaxResult<RepDeclareTaskData>();
        boolean hasDialog = false;
        if ("cbData".equals(bwType.getCode())) {
            Map fiAttachmentsBySbbid;
            try {
                fiAttachmentsBySbbid = TsateFiDeclareBusiness.getFiAttachmentsBySbbid((Long)declaremainId);
            }
            catch (Exception e) {
                QxyRepHelper.resultFaild((TaxResult)result, ResManager.loadKDString((String)"\u8c03\u7528\u8d22\u62a5\u63a5\u53e3\u65f6\u51fa\u73b0\u9519\u8bef\u3002\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u6216\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"QxyDeclareService_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                return result;
            }
            if (!TsateFiDeclareBusiness.checkQxySupportAttachment((Map)fiAttachmentsBySbbid)) {
                QxyRepHelper.resultFaild(result, ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u8d22\u62a5\u6682\u53ea\u652f\u6301\u4e0a\u4f20\u4e00\u4efdExcel\u683c\u5f0f\u9644\u4ef6\u76f4\u8fde\u7533\u62a5\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u7533\u62a5\u3002", (String)"QxyDeclareService_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                return result;
            }
            result = QxyApi.declareFi(qyId, sbqj, jsonBw, TsateFiDeclareBusiness.changeAttachmentDataAndEncrypt((Map)fiAttachmentsBySbbid, (String)"1"));
        } else {
            Map dialoginfo = TasteDeclarePopupBusiness.getQxyPopupSelectData((Long)declaremainId);
            if (dialoginfo != null && dialoginfo.size() > 0) {
                hasDialog = true;
                DiaologOption dialog = new DiaologOption();
                dialog.setMemoJson((String)dialoginfo.get("memoJson"));
                dialog.setOptionCode((String)dialoginfo.get("optionCode"));
                ArrayList<DiaologOption> options = new ArrayList<DiaologOption>();
                options.add(dialog);
                result = QxyApi.declare(qyId, sbqj, bwType.getCode(), jsonBw, options);
            } else {
                result = QxyApi.declare(qyId, sbqj, bwType.getCode(), jsonBw);
            }
        }
        if (result.isSuccess()) {
            String taskId = ((RepDeclareTaskData)result.getData()).getTaskId();
            TsateRequestInfoBusiness.saveRequestId((String)taskId, (String)(declareRecordId + ""), (String)(declaremainId + ""), (String)"1");
        }
        if (hasDialog) {
            PoppupStatusEnum status = result.isSuccess() ? PoppupStatusEnum.USED : PoppupStatusEnum.VOID;
            TasteDeclarePopupBusiness.updateQxyPopupDataStatus((String)(declaremainId + ""), (PoppupStatusEnum)status);
        }
        return result;
    }

    private static TaxResult<RepTaskData> startQxyUndoTask(Long declareRecordId, Long declaremainId, String qyId, Date skssqq, Date skssqz, QxyTaxTypeEnum qxyTaxType) {
        TaxResult<RepTaskData> result = QxyApi.undo(qxyTaxType, qyId, skssqq, skssqz);
        if (result.isSuccess()) {
            String taskId = ((RepTaskData)result.getData()).getTaskId();
            TsateRequestInfoBusiness.saveRequestId((String)taskId, (String)(declareRecordId + ""), (String)(declaremainId + ""), (String)"5");
        }
        return result;
    }

    public static TaxResult undo(SBMessageBaseVo vo) {
        String qyId;
        TaxResult result = new TaxResult();
        Long recordId = vo.getId();
        Long declaremainId = Long.parseLong(vo.getBusinessId());
        TaxResult<DeclareStatusEnum> t = QxyDeclareService.syncUndoStatus(declaremainId, qyId = TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY), false);
        if (!t.isSuccess()) {
            StringBuilder failedLog = new StringBuilder();
            failedLog.append(ResManager.loadKDString((String)"\u4f5c\u5e9f\u524d\u540c\u6b65\u72b6\u6001\u5931\u8d25,", (String)"QxyDeclareService_7", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(t.getMessage());
            DirectDeclareLogUtils.updateStatus(recordId, ExecuteStatusEnum.FAIL.getCode(), failedLog);
            QxyRepHelper.resultFaild(result, failedLog.toString());
            return result;
        }
        DeclareStatusEnum syncStatus = (DeclareStatusEnum)t.getData();
        if (DeclareStatusEnum.DECLARED == syncStatus) {
            String declareType;
            QxyTaxTypeEnum qxyTaxType;
            Date skssqz;
            DynamicObject declaremain = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)declaremainId);
            Date skssqq = declaremain.getDate("skssqq");
            TaxResult<RepTaskData> r = QxyDeclareService.startQxyUndoTask(recordId, declaremainId, qyId, skssqq, skssqz = declaremain.getDate("skssqz"), qxyTaxType = QxyTaxTypeEnum.valueOfDeclareTypeCode(declareType = vo.getBusinessType()));
            if (!r.isSuccess()) {
                StringBuilder failedLog = new StringBuilder();
                failedLog.append(r.getMessage());
                DirectDeclareLogUtils.updateStatus(recordId, ExecuteStatusEnum.FAIL.getCode(), failedLog);
            }
        } else {
            StringBuilder failedLog = new StringBuilder(ResManager.loadKDString((String)"\u540c\u6b65\u4f01\u4eab\u4e91\u7533\u62a5\u72b6\u6001\u5b8c\u6210\uff0c\u672a\u7533\u62a5\u5b8c\u6210\uff0c\u4e0d\u80fd\u53d1\u8d77\u4f5c\u5e9f", (String)"QxyDeclareService_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateStatus(recordId, ExecuteStatusEnum.FAIL.getCode(), failedLog);
            QxyRepHelper.resultFaild(result, failedLog.toString());
        }
        return result;
    }
}

