/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.business.historydeclaration.HistoryDeclarationHandlerFactory;
import kd.taxc.tsate.common.constant.RequestResult;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.helper.CommonUtils;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.HistoryDataUtils;
import kd.taxc.tsate.common.util.template.TemplateUtils;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.exception.MessageException;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.service.qxy.api.QxyApi;
import kd.taxc.tsate.msmessage.service.qxy.bean.QxyConfig;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepHistoryData;
import kd.taxc.tsate.msmessage.service.qxy.helper.QxyCfgHelper;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import kd.taxc.tsate.msxml.util.XmlTJsonUtil;

public class QxyHistoryService {
    private static final Log logger = LogFactory.getLog(QxyHistoryService.class);

    public static TaxResult<RepHistoryData> startHistoryTask(SBMessageBaseVo vo) {
        Long recordId = vo.getId();
        Map params = vo.getParams();
        QxyConfig config = QxyCfgHelper.getConfig();
        String appKey = config.getAppKey();
        DynamicObject areaInfo = CommonInfoUtil.getAreaInfoByNsrsbh((String)vo.getNsrsbh());
        if (areaInfo != null) {
            vo.setSbdq(areaInfo.getString("xzqh"));
        } else {
            logger.error("QxyHistoryService.startHistoryTask getAreaInfo fail nsrsbh=" + vo.getNsrsbh());
        }
        String areaCode = TsateCompanyInfoBusiness.getQxyAreaCode((String)vo.getSbdq());
        String nsrsbh = (String)params.get("nsrsbh");
        String cjyfq = (String)params.get("skssqq");
        String cjyfz = (String)params.get("skssqz");
        Date dateStart = DateUtils.stringToDate((String)cjyfq);
        Date dateEnd = DateUtils.stringToDate((String)cjyfz);
        cjyfq = DateUtils.format((Date)dateStart, (String)"yyyyMM");
        cjyfz = DateUtils.format((Date)dateEnd, (String)"yyyyMM");
        String updateCache = StringUtils.isEmpty((String)((String)params.get("updateCache"))) ? "1" : (String)params.get("updateCache");
        TaxResult<RepHistoryData> result = QxyApi.startHistoryTask(appKey, nsrsbh, areaCode, cjyfq, cjyfz, updateCache);
        if (result.isSuccess()) {
            String taskId = ((RepHistoryData)result.getData()).getTaskId();
            TsateRequestInfoBusiness.saveRequestId((String)taskId, (String)(recordId + ""), null, (String)"8");
            logger.info("\u4f01\u4eab\u4e91\u5df2\u7533\u62a5\u6570\u636e\u4e0b\u8f7d\u4efb\u52a1\u53d1\u8d77\u6210\u529f");
        } else {
            StringBuilder failedLog = new StringBuilder();
            failedLog.append(result.getMessage());
            DirectDeclareLogUtils.updateStatus(vo.getId(), ExecuteStatusEnum.FAIL.getCode(), failedLog);
            logger.info("\u4f01\u4eab\u4e91\u5df2\u7533\u62a5\u6570\u636e\u4e0b\u8f7d\u4efb\u52a1\u53d1\u8d77\u5931\u8d25");
        }
        return result;
    }

    public static void refresh(SBMessageBaseVo vo) {
        String requestStatus;
        String type;
        StringBuilder failedLog = new StringBuilder();
        String recordId = vo.getId() + "";
        String taskId = TsateRequestInfoBusiness.queryOneRequestId((String)recordId, (String)(type = "8"), (String)(requestStatus = ExecuteStatusEnum.PROCESSING.getCode()));
        if (taskId != null) {
            QxyHistoryService.downloadHistoryDdata(taskId, vo);
        } else {
            failedLog.append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u8bb0\u5f55\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u68c0\u67e5", (String)"QxyHistoryService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateStatus(vo.getId(), ExecuteStatusEnum.FAIL.getCode(), failedLog);
        }
    }

    public static void downloadHistoryDdata(String taskId, SBMessageBaseVo vo) {
        String nsrsbh = vo.getNsrsbh();
        TaxResult<RepHistoryData> result = QxyApi.getHistoryData(taskId, nsrsbh, vo.getType(), (String)vo.getParams().get("skssqq"), (String)vo.getParams().get("skssqz"));
        if (!result.isSuccess()) {
            RepHistoryData data = (RepHistoryData)result.getData();
            if (data.getStatus() == 1) {
                logger.info("\u4f01\u4eab\u4e91\u4efb\u52a1\u8fdb\u884c\u4e2d\uff1a" + data);
                return;
            }
            logger.info("\u5df2\u7533\u62a5\u6570\u636e\u4e0b\u8f7d\u5931\u8d25");
            StringBuilder failedLog = new StringBuilder();
            failedLog.append(ResManager.loadKDString((String)"\u5df2\u7533\u62a5\u6570\u636e\u4e0b\u8f7d\u5931\u8d25", (String)"QxyHistoryService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            failedLog.append(":").append(result.getMessage());
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            try {
                if (result.getData() != null && ((RepHistoryData)result.getData()).getRepData() != null) {
                    StringBuilder reqInfo = new StringBuilder(ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u8fd4\u56de\u6570\u636e\uff1a", (String)"QxyHistoryService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    reqInfo.append("historydata").append(JSON.toJSONString((Object)((RepHistoryData)result.getData()).getRepData()));
                    DirectDeclareLogUtils.dealDetailLog(reqInfo, vo.getId());
                }
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u4f01\u4eab\u4e91\u8fd4\u56de\u6570\u636e\u5931\u8d25");
                logger.error(ExceptionUtil.toString((Exception)e));
            }
        } else {
            logger.info("\u5df2\u7533\u62a5\u6570\u636e\u4e0b\u8f7d\u6210\u529f\uff0c\u5f00\u59cb\u4fdd\u5b58\u6570\u636e");
            try {
                JSONObject historyDataJsonObject = new JSONObject();
                historyDataJsonObject.put("historydata", (Object)((RepHistoryData)result.getData()).getRepData());
                String historyData = QxyHistoryService.getBw(historyDataJsonObject, vo.getType(), vo.getNsrsbh());
                TsateDeclareRecordBusiness.appendDetailLog((Long)vo.getId(), (String)historyData);
                Map<String, Object> sbbDataRootMap = XmlTJsonUtil.xml2ObjectMap(historyData);
                Map sbbDataMap = (Map)sbbDataRootMap.get("Root");
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                HashMap<String, String> extendParam = new HashMap<String, String>();
                if (sbbDataMap.containsKey("bqybtse")) {
                    String bqybtseStr = (String)sbbDataMap.get("bqybtse");
                    if (EmptyCheckUtils.isEmpty((Object)bqybtseStr)) {
                        bqybtseStr = "0.00";
                    }
                    extendParam.put("bqybtse", bqybtseStr);
                    sbbDataMap.remove("bqybtse");
                }
                if (!StringUtils.isEmpty((String)((RepHistoryData)result.getData()).getSbrq())) {
                    extendParam.put("sbrq", ((RepHistoryData)result.getData()).getSbrq());
                }
                paramMap.put("extendParams", extendParam);
                Map objectMap = HistoryDataUtils.embeded2Plate((Map)sbbDataMap, (String)"#");
                QFilter dateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)vo.getSkssqq()))).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)vo.getSkssqz()))));
                QFilter typeFilter = new QFilter("type", "=", (Object)vo.getType());
                QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(vo.getOrg()));
                Map nsrxxMap = TemplateUtils.dataToMap((String)"tcvat_nsrxx", (String)"#", (QFilter[])new QFilter[]{dateFilter, typeFilter, orgFilter});
                if (nsrxxMap == null || nsrxxMap.size() == 0) {
                    nsrxxMap = CommonUtils.createYbnsr((String)String.valueOf(DB.genLongId((String)"tcvat_nsrxx")), (String)vo.getType(), (String)vo.getOrg(), (String)DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"), (String)DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"), (boolean)true, new HashMap(), null);
                }
                objectMap.putAll(nsrxxMap);
                TemplateUtils.dealData((String)"#", (Map)objectMap);
                paramMap.put("orgId", vo.getOrg());
                paramMap.put("nsrsbh", vo.getNsrsbh());
                paramMap.put("templateType", vo.getType());
                paramMap.put("skssqq", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
                paramMap.put("skssqz", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
                HashMap<String, String> businessMap = new HashMap<String, String>(8);
                businessMap.put("declaredatatype", "1");
                paramMap.put("businessMap", businessMap);
                try {
                    StringBuilder reqInfo = new StringBuilder("request params\uff1a");
                    reqInfo.append("param").append(SerializationUtils.toJsonString(paramMap)).append(";");
                    reqInfo.append("object").append(JSON.toJSONString((Object)objectMap));
                    reqInfo.append("historydata").append(JSON.toJSONString((Object)((RepHistoryData)result.getData()).getRepData()));
                    DirectDeclareLogUtils.dealDetailLog(reqInfo, vo.getId());
                }
                catch (Exception e) {
                    logger.error("\u4fdd\u5b58\u670d\u52a1\u8bf7\u6c42\u53c2\u6570\u5931\u8d25");
                    logger.error(ExceptionUtil.toString((Exception)e));
                }
                objectMap.remove("tcvat_nsrxx#1#attachment");
                String resonse = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TaxBureauDeclareService", (String)"saveData", (Object[])new Object[]{SerializationUtils.toJsonString(paramMap), objectMap});
                if (EmptyCheckUtils.isNotEmpty((Object)resonse)) {
                    StringBuilder failedLog = new StringBuilder();
                    RequestResult reqResult = (RequestResult)SerializationUtils.fromJsonString((String)resonse, RequestResult.class);
                    if (reqResult.getSuccess()) {
                        DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
                        HistoryDeclarationHandlerFactory.get((String)vo.getType()).forEach(hanlder -> hanlder.post(paramMap, objectMap));
                    } else {
                        failedLog.append(ResManager.loadKDString((String)"\u5df2\u7533\u62a5\u6570\u636e\u4fdd\u5b58\u5931\u8d25", (String)"QxyHistoryService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                        DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                    }
                }
                logger.info("\u5df2\u7533\u62a5\u6570\u636e\u4fdd\u5b58\u7ed3\u675f");
            }
            catch (Exception e) {
                logger.error(ExceptionUtil.toString((Exception)e));
                StringBuilder failedLog = new StringBuilder();
                failedLog.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5df2\u7533\u62a5\u6570\u636e\u5f02\u5e38", (String)"QxyHistoryService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
        }
    }

    private static String getBw(JSONObject qxyQcData, String declareType, String nsrsbh) throws MessageException {
        MessageSend send = new MessageSend();
        send.setMsgtype(ExecuteTypeEnums.LSXZ.getKey());
        send.setBusinesstype(declareType);
        send.setNsrType(declareType);
        send.setSupplier(SupplierEnum.QXY.getName());
        String historyData = MessageService.collectionHistoryData(send, (Map<String, Object>)qxyQcData, nsrsbh);
        return historyData;
    }
}

