/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tsate.business.TctbTaxMainBusiness;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.PayStatusEnum;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.service.qxy.api.QxyApi;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyBusinessStatusEnum;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyTaxTypeEnum;
import kd.taxc.tsate.msmessage.service.qxy.helper.QxyRepHelper;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;

public class QxyPayServie {
    private static final Log logger = LogFactory.getLog(QxyPayServie.class);

    public static TaxResult pay(SBMessageBaseVo vo) {
        String qyId = TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY);
        StringBuilder failedLog = new StringBuilder();
        TaxResult result = new TaxResult();
        Long recordId = vo.getId();
        Long declaremainId = Long.parseLong(vo.getBusinessId());
        logger.info("qxy\u7f34\u6b3e-1 \u5f00\u59cb\u540c\u6b65\u7f34\u6b3e\u72b6\u6001");
        TaxResult<PayStatusEnum> statusR = QxyPayServie.syncPayStatus(recordId, declaremainId, qyId, false);
        if (!statusR.isSuccess()) {
            logger.error("qxy\u7f34\u6b3e-1.1 \u7f34\u6b3e\u72b6\u6001\u540c\u6b65\u5931\u8d25,\u7f34\u6b3e\u76d1\u63a7\u4efb\u52a1{}", (Object)recordId);
            failedLog.append(statusR.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusCompatible(vo.getBusinessId(), vo.getId(), "paystatus", PayStatusEnum.PAYFAILED.getCode(), "3", failedLog);
            QxyRepHelper.resultFaild(result, statusR.getMessage());
            return result;
        }
        logger.info("qxy\u7f34\u6b3e-2 \u5f00\u59cb\u6821\u9a8c\u7f34\u6b3e\u72b6\u6001\uff0c\u68c0\u67e5\u662f\u5426\u9700\u8981\u65b0\u7f34\u6b3e");
        PayStatusEnum status = (PayStatusEnum)statusR.getData();
        if (PayStatusEnum.PAID == status || PayStatusEnum.PARTPAID == status || PayStatusEnum.NOPAY == status) {
            logger.info("qxy\u7f34\u6b3e-2.1 \u4e0d\u9700\u8981\u91cd\u65b0\u7f34\u6b3e,\u7f34\u6b3e\u6d41\u7a0b\u7ed3\u675f");
            failedLog.append(ResManager.loadKDString((String)"\u53ea\u6709\u672a\u7f34\u6b3e\u624d\u9700\u8981\u53d1\u8d77\u4efb\u52a1", (String)"QxyPayServie_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateDeclareStatusCompatible(vo.getBusinessId(), vo.getId(), "paystatus", PayStatusEnum.PARTPAID.getCode(), "3", failedLog);
            QxyRepHelper.resultFaild(result, failedLog.toString());
            return result;
        }
        logger.info("qxy\u7f34\u6b3e-3 \u5f00\u59cb\u7f34\u6b3e");
        DeclareTypeEnum declareType = DeclareTypeEnum.valueOfCode((String)vo.getBusinessType());
        QxyTaxTypeEnum yzpzzlDm = QxyTaxTypeEnum.valueOfDeclareType(declareType);
        BigDecimal money = vo.getYbtse();
        Date skssqq = vo.getSkssqq();
        Date skssqz = vo.getSkssqz();
        String agreementAccount = TctbTaxMainBusiness.getTripleAggrementInfo((Long)Long.parseLong(vo.getOrg()));
        if (StringUtil.isEmpty((CharSequence)agreementAccount)) {
            logger.info("qxy\u7f34\u6b3e-3.1 \u672a\u627e\u5230\u7eb3\u7a0e\u4e3b\u4f53\u4e09\u65b9\u534f\u8bae\u53f7 \u5c06\u7531\u4f01\u4eab\u4e91\u81ea\u52a8\u5224\u65ad");
        }
        TaxResult<RepTaskData> payResult = QxyApi.pay(yzpzzlDm, qyId, money, skssqq, skssqz, agreementAccount);
        logger.info("qxy\u7f34\u6b3e-4 \u7f34\u6b3e\u4efb\u52a1\u4e0b\u53d1\u7ed3\u679c{}", (Object)JSON.toJSONString(payResult));
        if (!payResult.isSuccess()) {
            logger.info("qxy\u7f34\u6b3e-4.1 \u7f34\u6b3e\u4efb\u52a1\u4e0b\u53d1\u5931\u8d25");
            failedLog.append(payResult.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusCompatible(vo.getBusinessId(), vo.getId(), "paystatus", PayStatusEnum.PAYFAILED.getCode(), "3", failedLog);
        } else {
            String taskId = ((RepTaskData)payResult.getData()).getTaskId();
            logger.info("qxy\u7f34\u6b3e-5 \u8bb0\u5f55\u7f34\u6b3e\u4efb\u52a1id-{}", (Object)taskId);
            TsateRequestInfoBusiness.saveRequestId((String)taskId, (String)(recordId + ""), (String)(declaremainId + ""), (String)"2");
            DirectDeclareLogUtils.updateDeclareStatusCompatible(vo.getBusinessId(), vo.getId(), "paystatus", PayStatusEnum.PAYING.getCode(), "1", failedLog);
        }
        return new TaxResult();
    }

    public static void refresh(SBMessageBaseVo vo) {
        String qyId = TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY);
        TaxResult<PayStatusEnum> r = QxyPayServie.syncPayStatus(vo.getId(), Long.parseLong(vo.getBusinessId()), qyId, true);
        if (!r.isSuccess()) {
            logger.info("\u5ffd\u7565\u8bf7\u6c42\u5931\u8d25\uff1a{}", (Object)r.getMessage());
            return;
        }
        if (PayStatusEnum.UNPAID == r.getData()) {
            Long recordId = vo.getId();
            Long declaremainId = Long.parseLong(vo.getBusinessId());
            StringBuilder failedLog = new StringBuilder(ResManager.loadKDString((String)"\u672a\u6210\u529f\u53d1\u8d77\u4efb\u52a1\uff0c\u8bf7\u91cd\u65b0\u4e0b\u53d1", (String)"QxyPayServie_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateDeclareStatusCompatible(declaremainId + "", recordId, "paystatus", PayStatusEnum.PAYFAILED.getCode(), "3", failedLog);
        }
    }

    public static TaxResult<PayStatusEnum> syncPayStatus(Long recordId, Long sbbid, String qyId, boolean refresh) {
        logger.info("qxy\u72b6\u6001\u67e5\u8be2-1 \u5f00\u59cb");
        TaxResult result = new TaxResult();
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_record", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,importlogs,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,detaillog_tag,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype,importlogs.seq,importlogs.logtitle,importlogs.log", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)recordId)});
        DynamicObject declaremain = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)sbbid);
        String payStatus = declaremain.getString("paystatus");
        PayStatusEnum payStatusEnumAfterSync = PayStatusEnum.valueOfCode((String)payStatus);
        String recordStatus = record.getString("executestatus");
        ExecuteStatusEnum executeStatusEnum = ExecuteStatusEnum.valueOfCode((String)recordStatus);
        if (ExecuteStatusEnum.PROCESSING == executeStatusEnum) {
            logger.info("qxy\u72b6\u6001\u67e5\u8be2-2 \u67e5\u8be2\u6267\u884c\u4e2d\u7684\u4efb\u52a1");
            List list = TsateRequestInfoBusiness.query((String)(recordId + ""), (String)"2", (String)"1");
            if (list.size() > 0) {
                String declareTaskId = ((DynamicObject)list.get(0)).getString("requestid");
                logger.info("qxy\u72b6\u6001\u67e5\u8be2-2.1 \u5b58\u5728\u6267\u884c\u4e2d\u7684\u4efb\u52a1,\u5f00\u59cb\u67e5\u8be2\u4f01\u4eab\u4e91\uff0c\u4efb\u52a1id {}", (Object)declareTaskId);
                TaxResult<RepTaskData> taskRep = QxyApi.getTaskStatus(qyId, declareTaskId);
                logger.info("qxy\u72b6\u6001\u67e5\u8be2-2.2 \u67e5\u8be2\u7ed3\u679c {}", (Object)JSON.toJSONString(taskRep));
                if (!taskRep.isSuccess()) {
                    logger.error("qxy\u72b6\u6001\u67e5\u8be2-2.2.1 \u67e5\u8be2\u5931\u8d25");
                    QxyRepHelper.resultFaild(result, taskRep.getMessage());
                    return result;
                }
                QxyBusinessStatusEnum status = ((RepTaskData)taskRep.getData()).getTaskStatus();
                logger.info("qxy\u72b6\u6001\u67e5\u8be2-2.3 \u67e5\u8be2\u6210\u529f\u4f01\u4eab\u4e91\u72b6\u6001{}\uff0c\u5f00\u59cb\u4fdd\u5b58\u72b6\u6001", (Object)status.name());
                payStatusEnumAfterSync = QxyPayServie.dealQxyStatus((RepTaskData)taskRep.getData(), declaremain, record);
                logger.info("qxy\u72b6\u6001\u67e5\u8be2-2.4 \u72b6\u6001\u540c\u6b65\u7ed3\u675f\uff0c\u7a0e\u52a1\u4e91\u6700\u7ec8\u7f34\u6b3e\u72b6\u6001{}", (Object)payStatusEnumAfterSync.name());
            } else if (refresh) {
                logger.info("qxy\u72b6\u6001\u67e5\u8be2-2 \u6570\u636e\u5e93\u4e0d\u5b58\u5728\u4e0e\u5f53\u524d\u7f34\u6b3e\u8868\u5bf9\u5e94\u7684\u4f01\u4eab\u4e91\u7f34\u6b3e\u4efb\u52a1\u8bb0\u5f55");
                StringBuilder failedLog = new StringBuilder();
                failedLog.append(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u4f01\u4eab\u4e91\u7f34\u6b3e\u4efb\u52a1\u8bb0\u5f55\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458", (String)"QxyPayServie_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                DirectDeclareLogUtils.updateDeclareStatusCompatible(sbbid + "", recordId, "paystatus", PayStatusEnum.PAYFAILED.getCode(), "3", failedLog);
            } else {
                logger.info("qxy\u72b6\u6001\u67e5\u8be2-2 \u6570\u636e\u5e93\u4e0d\u5b58\u5728\u4e0e\u5f53\u524d\u7f34\u6b3e\u8868\u5bf9\u5e94\u7684\u4f01\u4eab\u4e91\u7f34\u6b3e\u4efb\u52a1\u8bb0\u5f55\uff0c\u89c6\u4f5c\u672a\u53d1\u8d77\u8fc7\u4efb\u52a1");
            }
        }
        return new TaxResult((Object)payStatusEnumAfterSync);
    }

    private static PayStatusEnum dealQxyStatus(RepTaskData taskRep, DynamicObject declaremain, DynamicObject record) {
        QxyBusinessStatusEnum status = taskRep.getTaskStatus();
        Long recordId = record.getLong("id");
        Long sbbid = declaremain.getLong("id");
        String payStatusStr = declaremain.getString("paystatus");
        PayStatusEnum payStatus = PayStatusEnum.valueOfCode((String)payStatusStr);
        StringBuilder failedLog = new StringBuilder();
        if (PayStatusEnum.PAYING == payStatus) {
            if (QxyBusinessStatusEnum.SUCCESS == status) {
                DirectDeclareLogUtils.updateDeclareStatusCompatible(sbbid + "", recordId, "paystatus", PayStatusEnum.PAID.getCode(), "2", failedLog);
                return PayStatusEnum.PAID;
            }
            if (QxyBusinessStatusEnum.FAILD == status) {
                failedLog.append(taskRep.getMessage());
                DirectDeclareLogUtils.updateDeclareStatusCompatible(sbbid + "", recordId, "paystatus", PayStatusEnum.PAYFAILED.getCode(), "3", failedLog);
                return PayStatusEnum.PAYFAILED;
            }
        }
        return payStatus;
    }
}

