/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.business.historydeclaration.HistoryDeclarationHandlerFactory;
import kd.taxc.tsate.common.constant.RequestResult;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.enums.TaxPeriodType;
import kd.taxc.tsate.common.helper.CommonUtils;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.HistoryDataUtils;
import kd.taxc.tsate.common.util.template.TemplateUtils;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.exception.MessageException;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.service.qxy.api.QxyApi;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepQcData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyBusinessStatusEnum;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyPzlDmEnum;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import kd.taxc.tsate.msxml.util.XmlTJsonUtil;

public class QxyQcService {
    private static final Log logger = LogFactory.getLog(QxyQcService.class);

    public static TaxResult<RepTaskData> startQcTask(SBMessageBaseVo vo) {
        Long recordId = vo.getId();
        String qyId = TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY);
        DeclareTypeEnum declareType = DeclareTypeEnum.valueOfCode((String)vo.getType());
        Date skssqq = vo.getSkssqq();
        Date skssqz = vo.getSkssqz();
        Date sbqj = DateUtils.addMonth((Date)skssqz, (int)1);
        TaxPeriodType periodType = DateUtils.getTaxLimit3((Date)skssqq, (Date)skssqz);
        QxyPzlDmEnum zldm = QxyPzlDmEnum.getByTaxLimitAndTaxTypeCode(declareType.getCode(), periodType.getCode());
        String yzpzzlDm = zldm == null ? null : zldm.getQxyCode();
        String zspmDm = null;
        String zlbsxlDm = null;
        String templateCode = null;
        if (DeclareTypeEnum.FR0001 == declareType) {
            zlbsxlDm = "ZL1001001";
            templateCode = "1";
        } else if (DeclareTypeEnum.FR0002 == declareType) {
            zlbsxlDm = "ZL1001001";
            templateCode = "2";
        } else if (DeclareTypeEnum.FR0003 == declareType) {
            zlbsxlDm = "ZL1001003";
        }
        TaxResult<RepTaskData> result = QxyApi.startQcTask(qyId, yzpzzlDm, zspmDm, zlbsxlDm, templateCode, sbqj, skssqq, skssqz);
        if (result.isSuccess()) {
            String taskId = ((RepTaskData)result.getData()).getTaskId();
            TsateRequestInfoBusiness.saveRequestId((String)taskId, (String)(recordId + ""), null, (String)"6");
            logger.info("\u4f01\u4eab\u4e91\u671f\u521d\u6570\u636e\u4e0b\u8f7d\u4efb\u52a1\u53d1\u8d77\u6210\u529f");
        } else {
            StringBuilder failedLog = new StringBuilder();
            failedLog.append(result.getMessage());
            DirectDeclareLogUtils.updateStatus(vo.getId(), ExecuteStatusEnum.FAIL.getCode(), failedLog);
            logger.info("\u4f01\u4eab\u4e91\u671f\u521d\u6570\u636e\u4e0b\u8f7d\u4efb\u52a1\u53d1\u8d77\u5931\u8d25");
        }
        return result;
    }

    public static void refresh(SBMessageBaseVo vo) {
        StringBuilder failedLog = new StringBuilder();
        String recordId = vo.getId() + "";
        String type = "6";
        String requestStatus = ExecuteStatusEnum.PROCESSING.getCode();
        String taskId = TsateRequestInfoBusiness.queryOneRequestId((String)recordId, (String)type, (String)requestStatus);
        String qyId = TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY);
        if (taskId != null) {
            QxyBusinessStatusEnum taskStatus = QxyQcService.syncQcTaskStatus(vo.getId(), qyId, taskId);
            if (QxyBusinessStatusEnum.SUCCESS == taskStatus) {
                QxyQcService.downloadQcDdata(vo);
            }
        } else {
            failedLog.append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u8bb0\u5f55\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u68c0\u67e5", (String)"QxyQcService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateStatus(vo.getId(), ExecuteStatusEnum.FAIL.getCode(), failedLog);
        }
    }

    private static QxyBusinessStatusEnum syncQcTaskStatus(Long recordId, String qyId, String taskId) {
        StringBuilder failedLog = new StringBuilder();
        if (taskId != null) {
            if (qyId == null) {
                failedLog.append(ResManager.loadKDString((String)"\u4f01\u4e1aid\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u4f01\u4e1a\u4fe1\u606f\u662f\u5426\u5df2\u6b63\u786e\u540c\u6b65\u5230\u4f01\u4eab\u4e91", (String)"QxyQcService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                DirectDeclareLogUtils.updateStatus(recordId, ExecuteStatusEnum.FAIL.getCode(), failedLog);
            }
            TaxResult<RepTaskData> result = QxyApi.getTaskStatus(qyId, taskId);
            RepTaskData taskRep = (RepTaskData)result.getData();
            if (result.isSuccess()) {
                QxyBusinessStatusEnum status = ((RepTaskData)result.getData()).getTaskStatus();
                if (QxyBusinessStatusEnum.FAILD == status) {
                    failedLog.append(taskRep.getMessage());
                    DirectDeclareLogUtils.updateStatus(recordId, ExecuteStatusEnum.FAIL.getCode(), failedLog);
                    return QxyBusinessStatusEnum.FAILD;
                }
                if (QxyBusinessStatusEnum.SUCCESS == status) {
                    return QxyBusinessStatusEnum.SUCCESS;
                }
            }
        } else {
            failedLog.append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u8bb0\u5f55\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u68c0\u67e5", (String)"QxyQcService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateStatus(recordId, ExecuteStatusEnum.FAIL.getCode(), failedLog);
        }
        return null;
    }

    public static void downloadQcDdata(SBMessageBaseVo vo) {
        Date skssqz;
        Date sbqj;
        TaxPeriodType periodType;
        String declareType;
        QxyPzlDmEnum zldm;
        String yzpzzlDm;
        String qyId = TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY);
        TaxResult<RepQcData> result = QxyApi.getQcData(qyId, yzpzzlDm = (zldm = QxyPzlDmEnum.getByTaxLimitAndTaxTypeCode(declareType = vo.getType(), (periodType = QxyQcService.getTaxPeriod(vo)).getCode())) == null ? null : zldm.getQxyCode(), sbqj = DateUtils.addMonth((Date)(skssqz = vo.getSkssqz()), (int)1));
        if (!result.isSuccess()) {
            logger.info("\u671f\u521d\u6570\u636e\u4e0b\u8f7d\u5931\u8d25");
            StringBuilder failedLog = new StringBuilder();
            String notify = ResManager.loadKDString((String)"\u671f\u521d\u6570\u636e\u4e0b\u8f7d\u5931\u8d25\uff1a%1$s", (String)"QxyQcService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, result.getMessage());
            failedLog.append(notifyMsg);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        } else {
            logger.info("\u671f\u521d\u6570\u636e\u4e0b\u8f7d\u6210\u529f\uff0c\u5f00\u59cb\u4fdd\u5b58\u6570\u636e");
            try {
                QFilter orgFilter;
                QFilter typeFilter;
                JSONObject qcData = new JSONObject();
                qcData.put("qcdata", ((RepQcData)result.getData()).getQcData());
                String historyData = QxyQcService.getBw(qcData, vo.getType(), vo.getNsrsbh());
                TsateDeclareRecordBusiness.appendDetailLog((Long)vo.getId(), (String)historyData);
                Map<String, Object> sbbDataRootMap = XmlTJsonUtil.xml2ObjectMap(historyData);
                Map sbbDataMap = (Map)sbbDataRootMap.get("Root");
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                if (sbbDataMap.containsKey("bqybtse")) {
                    String bqybtseStr = (String)sbbDataMap.get("bqybtse");
                    if (EmptyCheckUtils.isEmpty((Object)bqybtseStr)) {
                        bqybtseStr = "0.00";
                    }
                    HashMap<String, String> extendParam = new HashMap<String, String>();
                    extendParam.put("bqybtse", bqybtseStr);
                    paramMap.put("extendParams", extendParam);
                    sbbDataMap.remove("bqybtse");
                }
                Map objectMap = HistoryDataUtils.embeded2Plate((Map)sbbDataMap, (String)"#");
                QFilter dateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)vo.getSkssqq()))).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)vo.getSkssqz()))));
                Map nsrxxMap = TemplateUtils.dataToMap((String)"tcvat_nsrxx", (String)"#", (QFilter[])new QFilter[]{dateFilter, typeFilter = new QFilter("type", "=", (Object)vo.getType()), orgFilter = new QFilter("org", "=", (Object)Long.parseLong(vo.getOrg()))});
                if (nsrxxMap == null || nsrxxMap.size() == 0) {
                    nsrxxMap = CommonUtils.createYbnsr((String)String.valueOf(DB.genLongId((String)"tcvat_nsrxx")), (String)vo.getType(), (String)vo.getOrg(), (String)DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"), (String)DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"), (boolean)true, new HashMap(), null);
                }
                objectMap.putAll(nsrxxMap);
                TemplateUtils.dealData((String)"#", (Map)objectMap);
                paramMap.put("orgId", vo.getOrg());
                paramMap.put("templateType", vo.getType());
                paramMap.put("skssqq", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
                paramMap.put("skssqz", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
                HashMap<String, String> businessMap = new HashMap<String, String>(8);
                businessMap.put("declaredatatype", "0");
                paramMap.put("businessMap", businessMap);
                try {
                    StringBuilder reqInfo = new StringBuilder("request params\uff1a");
                    reqInfo.append("param").append(SerializationUtils.toJsonString(paramMap)).append(";");
                    reqInfo.append("object").append(JSON.toJSONString((Object)objectMap));
                    DirectDeclareLogUtils.dealDetailLog(reqInfo, vo.getId());
                }
                catch (Exception e) {
                    logger.error("\u4fdd\u5b58\u670d\u52a1\u8bf7\u6c42\u53c2\u6570\u5931\u8d25");
                    logger.error(ExceptionUtil.toString((Exception)e));
                }
                objectMap.remove("tcvat_nsrxx#1#attachment");
                String resonse = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TaxBureauDeclareService", (String)"saveData", (Object[])new Object[]{SerializationUtils.toJsonString(paramMap), objectMap});
                if (EmptyCheckUtils.isNotEmpty((Object)resonse)) {
                    StringBuilder failedLog = new StringBuilder();
                    RequestResult reqResult = (RequestResult)SerializationUtils.fromJsonString((String)resonse, RequestResult.class);
                    if (reqResult.getSuccess()) {
                        DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
                        HistoryDeclarationHandlerFactory.get((String)vo.getType()).forEach(hanlder -> hanlder.post(paramMap, objectMap));
                    } else {
                        failedLog.append(ResManager.loadKDString((String)"\u671f\u521d\u6570\u636e\u4fdd\u5b58\u5931\u8d25", (String)"QxyQcService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                        DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                    }
                }
                logger.info("\u671f\u521d\u6570\u636e\u4fdd\u5b58\u7ed3\u675f");
            }
            catch (Exception e) {
                logger.error(ExceptionUtil.toString((Exception)e));
                StringBuilder failedLog = new StringBuilder();
                failedLog.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u671f\u521d\u6570\u636e\u5f02\u5e38", (String)"QxyQcService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
        }
    }

    private static String getBw(JSONObject qxyQcData, String declareType, String nsrsbh) throws MessageException {
        MessageSend send = new MessageSend();
        send.setMsgtype(ExecuteTypeEnums.QCXZ.getKey());
        send.setBusinesstype(declareType);
        send.setNsrType(declareType);
        send.setSupplier(SupplierEnum.QXY.getName());
        String historyData = MessageService.collectionHistoryData(send, (Map<String, Object>)qxyQcData, nsrsbh);
        return historyData;
    }

    private static TaxPeriodType getTaxPeriod(SBMessageBaseVo vo) {
        Date skssqq = vo.getSkssqq();
        Date skssqz = vo.getSkssqz();
        TaxPeriodType periodType = DateUtils.getTaxLimit3((Date)skssqq, (Date)skssqz);
        return periodType;
    }
}

