/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.service;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbsxxzMessageVo;
import kd.taxc.tsate.msmessage.service.qxy.api.QxyApi;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.sbsxxz.qxy.QxyHandlerSbqcStrategy;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;

public class QxySbqcService {
    private static Log logger = LogFactory.getLog(QxySbqcService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiResult startSbxxTask(SBMessageBaseVo vo) {
        ApiResult result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u7533\u62a5\u4e8b\u9879\u4fe1\u606f\u4e0b\u8f7d\u8bf7\u6c42\u8c03\u7528\u5931\u8d25", (String)"QxySbqcService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        String orgId = vo.getOrg();
        String recordId = String.valueOf(vo.getId());
        StringBuilder failedLog = new StringBuilder();
        try {
            DynamicObject requestObject;
            String nsrsbh = vo.getString(SbsxxzMessageVo.Key.NSRSBH);
            LocalDate today = LocalDate.now();
            TaxResult<RepTaskData> sbxxTask = QxyApi.loadSbxxTask(TsateCompanyInfoBusiness.getQyId((String)nsrsbh, (SupplierEnum)SupplierEnum.QXY), today.getYear(), today.getMonthValue());
            if (!sbxxTask.isSuccess() || sbxxTask.getData() == null || ((RepTaskData)sbxxTask.getData()).getOriginData() == null) {
                failedLog.append(sbxxTask.getMessage());
                ApiResult apiResult = result;
                return apiResult;
            }
            String taskId = ((JSONObject)((RepTaskData)sbxxTask.getData()).getOriginData()).getString("taskId");
            if (StringUtils.isEmpty((CharSequence)taskId)) {
                logger.error("\u4f01\u4eab\u4e91\u7533\u62a5\u4e8b\u9879\u4fe1\u606f\u4e0b\u8f7d\u8bf7\u6c42 taskId\u4e3a\u7a7a");
                ApiResult apiResult = result;
                return apiResult;
            }
            DynamicObject runningRecord = TsateDeclareRecordBusiness.getRecordByBusinessField((String)orgId, (String)ExecuteTypeEnums.SBQC.getExecuteType(), (String)SupplierEnum.QXY.getCode(), (ExecuteStatusEnum)ExecuteStatusEnum.PROCESSING);
            if (runningRecord == null) {
                runningRecord = TsateDeclareRecordBusiness.assembleDeclareRecord((String)orgId, (ExecuteTypeEnums)ExecuteTypeEnums.SBQC, (SupplierEnum)SupplierEnum.QXY);
            }
            if ((requestObject = TsateRequestInfoBusiness.queryOne((String)(recordId = runningRecord.getString("id")), (String)"1", (String)"1")) == null) {
                TsateRequestInfoBusiness.saveRequestId((String)orgId, (String)taskId, (String)recordId, (String)"", (String)"1", (SupplierEnum)SupplierEnum.QXY);
            } else {
                TsateRequestInfoBusiness.updateRequestId((String)taskId, (String)recordId, (DynamicObject)requestObject);
            }
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u6210\u529f", (String)"QxySbqcService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
        }
        catch (Exception e) {
            String stackMsg = ExceptionUtil.toString((Exception)e);
            failedLog.append(ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5f02\u5e38\u6216\u5931\u8d25,\u8be6\u60c5\uff1a", (String)"QxySbqcService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(e.getMessage());
            logger.error("\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u5931\u8d25,recordId={}" + e.getMessage(), (Object)recordId);
            logger.error(stackMsg);
        }
        finally {
            if (!result.getSuccess()) {
                if (failedLog.length() == 0) {
                    failedLog.append(result.getMessage());
                }
                DirectDeclareLogUtils.updateStatus(Long.valueOf(recordId), "3", failedLog);
            }
        }
        return result;
    }

    public static void refresh(SBMessageBaseVo vo) {
        QxyHandlerSbqcStrategy qxyHandlerSbqcStrategy = new QxyHandlerSbqcStrategy();
        qxyHandlerSbqcStrategy.handle(ExecuteTypeEnums.SBQC.getExecuteType(), vo);
    }
}

