/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.helper.sfzhdxx.TsateSfzhdxxHelper;
import kd.taxc.tsate.msmessage.service.qxy.api.QxyOrgInfoApi;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.qxy.service.AbstractQxyBaseService;
import org.apache.commons.collections.CollectionUtils;

public class QxySjOrgInfoService
extends AbstractQxyBaseService {
    private static Log logger = LogFactory.getLog(QxySjOrgInfoService.class);

    @Override
    public TaxResult sendTask(SBMessageBaseVo vo) {
        logger.info("qyx-\u5f00\u59cb\u4e0b\u53d1\u7a0e\u52a1\u91c7\u96c6\u4efb\u52a1");
        return super.sendTask(vo);
    }

    @Override
    public TaxResult<RepTaskData> getTaskResult(SBMessageBaseVo vo) {
        return QxyOrgInfoApi.loadOrgTaxInfo(TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY));
    }

    @Override
    public void syncData(SBMessageBaseVo vo) {
        try {
            logger.info("qyx-\u5f00\u59cb\u8fdb\u884c\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u83b7\u53d6");
            super.syncData(vo);
        }
        catch (Exception e) {
            logger.error("\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38\uff1aerror={} rocordId={}", (Object)ExceptionUtil.toString((Exception)e));
        }
    }

    @Override
    public TaxResult<RepTaskData> getBusinessData(String qyId, SBMessageBaseVo vo, TaxResult<RepTaskData> taskResult) {
        return QxyOrgInfoApi.queryOrgInfo(qyId);
    }

    @Override
    public void dealBusinessData(TaxResult<RepTaskData> businessData, SBMessageBaseVo vo) {
        super.dealBusinessData(businessData, vo);
        JSONObject orgInfo = (JSONObject)((RepTaskData)businessData.getData()).getOriginData();
        if (CollectionUtils.isEmpty((Collection)orgInfo.getJSONArray("sfzxxDtos"))) {
            String notify = ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u4e0b\u8f7d\u63a5\u53e3\u672a\u6b63\u5e38\u8fd4\u56de\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002\u63a5\u53e3\u8fd4\u56de\u63d0\u793a\uff1a %1$s", (String)"QxySjOrgInfoService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, businessData.getMessage());
            throw new KDBizException(notifyMsg);
        }
        Map approvedData = (Map)JSON.parseObject((String)orgInfo.toString(), Map.class);
        TsateSfzhdxxHelper.saveAndCompareData(TsateSfzhdxxHelper.dataConversion(vo, approvedData, SupplierEnum.QXY), vo.getOrg(), vo.getId());
    }

    @Override
    public String getFailMsg(String msg) {
        return String.format(ResManager.loadKDString((String)"\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u4e0b\u8f7d\u65f6\u5f02\u5e38\uff1a%s", (String)"QxySjOrgInfoService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), msg);
    }
}

