/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.qxy.service;

import java.util.Collections;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.TaxPeriodType;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.service.qxy.api.QxyApi;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepSyncDeclareTaskData;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyBusinessStatusEnum;
import kd.taxc.tsate.msmessage.service.qxy.constant.QxyPzlDmEnum;
import kd.taxc.tsate.msmessage.service.qxy.helper.QxyRepHelper;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;

public class QxySyncTaxStatusService {
    private static final Log logger = LogFactory.getLog(QxySyncTaxStatusService.class);

    public static void syncStatus(SBMessageBaseVo vo) {
        TaxResult<RepTaskData> r = QxySyncTaxStatusService.startTask(vo);
        if (r.isSuccess()) {
            logger.info("qxy\u540c\u6b65\u7a0e\u5c40\u4efb\u52a1\u53d1\u8d77\u6210\u529f");
        } else {
            DirectDeclareLogUtils.updateStatus(vo.getId(), ExecuteStatusEnum.FAIL.getCode(), new StringBuilder(r.getMessage()));
            logger.info("qxy\u540c\u6b65\u7a0e\u5c40\u4efb\u52a1\u53d1\u8d77\u5931\u8d25");
        }
    }

    public static void refresh(SBMessageBaseVo vo) {
        DeclareStatusEnum stauts;
        Long declareId = Long.parseLong(vo.getBusinessId());
        Long recordId = vo.getId();
        QFilter filter = new QFilter("id", "=", (Object)recordId);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_record", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,importlogs,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,detaillog_tag,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype,importlogs.seq,importlogs.logtitle,importlogs.log", (QFilter[])new QFilter[]{filter});
        Date startTime = dyn.getDate("createtime");
        if (System.currentTimeMillis() - startTime.getTime() <= 60000L) {
            logger.info("\u4efb\u52a1\u521b\u5efa\u672a\u8d85\u8fc7\u4e00\u5206\u949f\uff0c\u4e0d\u6267\u884c\u5237\u65b0");
            return;
        }
        String qyId = TsateCompanyInfoBusiness.getQyId((String)vo.getNsrsbh(), (SupplierEnum)SupplierEnum.QXY);
        String taskId = TsateRequestInfoBusiness.queryOneRequestId((String)(recordId + ""), (String)"7", null);
        if (taskId == null) {
            StringBuilder failedLog = new StringBuilder(ResManager.loadKDString((String)"\u4efb\u52a1\u5f02\u5e38\uff0c\u672a\u67e5\u627e\u5230\u4f01\u4eab\u4e91\u4efb\u52a1\u8bb0\u5f55\uff0c\u9700\u8981\u91cd\u65b0\u53d1\u8d77", (String)"QxySyncTaxStatusService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            logger.info(failedLog.toString());
            DirectDeclareLogUtils.updateStatus(vo.getId(), ExecuteStatusEnum.FAIL.getCode(), failedLog);
        }
        TaxPeriodType periodType = DateUtils.getTaxLimit3((Date)vo.getSkssqq(), (Date)vo.getSkssqz());
        String type = "";
        type = "ccxws".equals(vo.getType()) ? vo.getBusinessType() : vo.getType();
        QxyPzlDmEnum pzzlDm = QxyPzlDmEnum.getByTaxLimitAndTaxTypeCode(type, periodType);
        TaxResult<DeclareStatusEnum> statusResult = QxySyncTaxStatusService.getTaskStatus(qyId, taskId, pzzlDm, vo.getSkssqq(), vo.getSkssqz());
        if (!statusResult.isSuccess()) {
            if (QxyBusinessStatusEnum.RUNNING.getCode().equals(statusResult.getCode()) || QxyBusinessStatusEnum.NOTSTART.getCode().equals(statusResult.getCode())) {
                logger.info("\u7a0e\u5c40\u72b6\u6001\u4fe1\u606f\u67e5\u8be2\uff0c\u4f01\u4eab\u4e91\u4efb\u52a1\u72b6\u6001\u4e3a\u672a\u5f00\u59cb\u6216\u6267\u884c\u4e2d");
                return;
            }
            logger.info("\u7a0e\u5c40\u72b6\u6001\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u6807\u8bb0\u4efb\u52a1\u5931\u8d25");
            DirectDeclareLogUtils.updateStatus(vo.getId(), ExecuteStatusEnum.FAIL.getCode(), new StringBuilder(statusResult.getMessage()));
        }
        logger.info("\u7a0e\u5c40\u72b6\u6001\u4e3a:{}{}", (Object)((stauts = (DeclareStatusEnum)statusResult.getData()) == null ? "null" : stauts.getCode()), (Object)(stauts == null ? "null" : stauts.getDescr()));
        if (DeclareStatusEnum.EDITING == stauts) {
            QxySyncTaxStatusService.resetUndeclaredStatus(declareId, recordId);
        } else {
            DirectDeclareLogUtils.updateStatus(vo.getId(), ExecuteStatusEnum.SUCCESS.getCode(), new StringBuilder());
        }
    }

    private static TaxResult<RepTaskData> startTask(SBMessageBaseVo vo) {
        Long declareRecordId = vo.getId();
        String nsrsbh = vo.getNsrsbh();
        Date skssqz = vo.getSkssqz();
        Date sbqj = DateUtils.addMonth((Date)skssqz, (int)1);
        Date sbrq = vo.getSbrq();
        String qyId = TsateCompanyInfoBusiness.getQyId((String)nsrsbh, (SupplierEnum)SupplierEnum.QXY);
        TaxResult<RepTaskData> result = QxyApi.startLoadDeclareInfoTask(qyId, sbqj, sbrq);
        if (result.isSuccess()) {
            String taskId = ((RepTaskData)result.getData()).getTaskId();
            TsateRequestInfoBusiness.saveRequestId((String)taskId, (String)(declareRecordId + ""), null, (String)"7");
        }
        return result;
    }

    private static TaxResult<DeclareStatusEnum> getTaskStatus(String qyId, String taskId, QxyPzlDmEnum pzzlDm, Date skssqq, Date skssqz) {
        logger.info("qxy\u72b6\u6001\u67e5\u8be2 getTaskStatus\u65b9\u6cd5\u5165\u53c2{} {} {} {} {}", new Object[]{qyId, taskId, pzzlDm == null ? "null" : pzzlDm.getQxyCode(), skssqq, skssqz});
        TaxResult result = new TaxResult();
        TaxResult<RepTaskData> taskRep = QxyApi.getTaskStatus(qyId, taskId);
        RepSyncDeclareTaskData syncTaskRepData = new RepSyncDeclareTaskData();
        if (!taskRep.isSuccess()) {
            logger.error("qxy\u72b6\u6001\u67e5\u8be2-2.2.1 \u67e5\u8be2\u5931\u8d25");
            QxyRepHelper.resultFaild(result, taskRep.getMessage());
            return result;
        }
        QxyRepHelper.translate((RepData)taskRep.getData(), syncTaskRepData);
        if (syncTaskRepData.getTaskStatus() != null && (QxyBusinessStatusEnum.FAILD == syncTaskRepData.getTaskStatus() || QxyBusinessStatusEnum.RUNNING == syncTaskRepData.getTaskStatus() || QxyBusinessStatusEnum.NOTSTART == syncTaskRepData.getTaskStatus())) {
            result.setSuccess(false);
            result.setCode(syncTaskRepData.getTaskStatus().getCode());
            result.setMessage(syncTaskRepData.getTaskStatus().getDescr());
            return result;
        }
        String state = syncTaskRepData.getState(taskId, pzzlDm, skssqq, skssqz);
        if ("1".equals(state)) {
            QxyRepHelper.resultSuccess(result, DeclareStatusEnum.DECLARED);
        } else if ("0".equals(state)) {
            QxyRepHelper.resultSuccess(result, DeclareStatusEnum.EDITING);
        } else if ("10".equals(state)) {
            QxyRepHelper.resultSuccess(result, DeclareStatusEnum.IMPORTING);
        } else if ("statenotfound".equals(state)) {
            QxyRepHelper.resultFaild(result, ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u8fd4\u56de\u4e2d\u65e0\u5bf9\u5e94\u5c5e\u671f\u7533\u62a5\u8868\u7684\u72b6\u6001\u4fe1\u606f\u3002", (String)"QxyDeclareService_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        } else {
            QxyRepHelper.resultFaild(result, ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u8fd4\u56de\u672a\u77e5\u72b6\u6001state:", (String)"QxySyncTaxStatusService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + state);
        }
        return result;
    }

    private static void resetUndeclaredStatus(Long declareId, Long recordId) {
        logger.info("\u91cd\u7f6e\u7533\u62a5\u72b6\u6001\u4e3a\u672a\u7533\u62a5");
        StringBuilder loginfo = new StringBuilder();
        QFilter qFilter = new QFilter("sbbid", "=", (Object)(declareId + "")).and(new QFilter("tasktype.number", "=", (Object)"YYJK")).and(new QFilter("executestatus", "=", (Object)"1"));
        DynamicObject[] recordObjs = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_record"), (QFilter[])new QFilter[]{qFilter});
        if (recordObjs != null && recordObjs.length > 0) {
            DirectDeclareLogUtils.updateStatus(recordObjs[0].getLong("id"), "2", loginfo);
        }
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelDeclare", (Object[])new Object[]{Collections.singletonList(declareId)});
        DirectDeclareLogUtils.updateDeclareStatusCompatible(declareId + "", recordId, "declarestatus", "editing", "2", loginfo);
        DirectDeclareLogUtils.updateDeclareStatusCompatible(declareId + "", recordId, "paystatus", "unpaid", "2", loginfo);
    }
}

