/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.sbsxxz;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.taxc.tsate.business.TsateDeclareChecklistBusiness;
import kd.taxc.tsate.business.TsateZspmAndZsxmBusiness;
import kd.taxc.tsate.common.util.DBUtils;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbsxxzMessageVo;
import kd.taxc.tsate.msmessage.service.sbsxxz.ISbsxxzBaseDataHandler;
import kd.taxc.tsate.msmessage.service.sbsxxz.dao.SbsxxzBaseRespVo;

public abstract class AbstractBaseDataHandler<T extends SbsxxzBaseRespVo>
implements ISbsxxzBaseDataHandler<T> {
    private static final String TABLE_NAME = "t_tsate_checklist_head";

    public void handle(String taskType, SBMessageBaseVo vo) {
    }

    @Override
    public ApiResult doDataQuery(String taskType, SBMessageBaseVo vo) {
        return null;
    }

    @Override
    public ApiResult doFileQuery(String taskType, SBMessageBaseVo vo) {
        return null;
    }

    @Override
    public DynamicObject newGroupInstance(SBMessageBaseVo vo) {
        Long orgId = vo.getLong(SbsxxzMessageVo.Key.ORG);
        String source = vo.getString(SbsxxzMessageVo.Key.DATASOURCE);
        Long creator = vo.getLong(SbsxxzMessageVo.Key.OPERATOR);
        Date operateTime = new Date(vo.getLong(SbsxxzMessageVo.Key.OPERATTIME));
        Long taskId = vo.getLong(SbsxxzMessageVo.Key.TASK_ID);
        String formatDate = DateUtils.format((Date)operateTime, (String)"yyyy-MM");
        Date downLoadTime = DateUtils.stringToDate((String)formatDate, (String)"yyyy-MM");
        return TsateDeclareChecklistBusiness.newGroupInstance((Long)orgId, (String)source, (Long)creator, (Date)operateTime, (Date)downLoadTime, (Long)taskId, (String)"0");
    }

    Map<String, Object> buildCommonData(Long zspmId, Long zsxmId, Long taxOrgId, SbsxxzBaseRespVo vo) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("zsxm", zsxmId);
        dataMap.put("zspm", zspmId);
        dataMap.put("sbzt", vo.getSbzt());
        dataMap.put("taxorg", taxOrgId);
        dataMap.put("compareresult", "0");
        return dataMap;
    }

    protected <T extends SbsxxzBaseRespVo> List<T> declareDataInfo(ApiResult result, String codeNumber, String succesCode, String dataNumber, Class<T> voClass) {
        if (!result.getSuccess()) {
            String notify = ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25: %1$s", (String)"AbstractBaseDataHandler_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, result.getMessage());
            throw new KDBizException(notifyMsg);
        }
        Object data = result.getData();
        Map dataMap = (Map)JsonUtil.fromJson((String)data.toString(), Map.class);
        if (!StringUtils.equals((CharSequence)succesCode, (CharSequence)String.valueOf(dataMap.get(codeNumber)))) {
            String notify = ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25: %1$s", (String)"AbstractBaseDataHandler_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, data.toString());
            throw new KDBizException(notifyMsg);
        }
        Object dataInfo = dataMap.get(dataNumber);
        if (dataInfo == null || EmptyCheckUtils.isEmpty((Object)dataInfo.toString())) {
            String notify = ResManager.loadKDString((String)"\u8c03\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25,\u7f3a\u5931\u5173\u952eData\u4fe1\u606f:  %1$s", (String)"AbstractBaseDataHandler_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, result.getMessage());
            throw new KDBizException(notifyMsg);
        }
        return JSON.parseArray((String)JSON.toJSONString(dataInfo), voClass);
    }

    public void beforeBuildBodys(DynamicObject groupInstance, List<T> resp, Long taxOrgId) {
    }

    @Override
    public DynamicObject buildBodys(DynamicObject groupInstance, List<T> resp, Long taxOrgId) {
        this.beforeBuildBodys(groupInstance, resp, taxOrgId);
        DynamicObjectCollection checklist = TsateDeclareChecklistBusiness.newBodyByChecklisHead((DynamicObject)groupInstance);
        ArrayList<Object> zsxmNames = new ArrayList<Object>();
        ArrayList<String> zspmNames = new ArrayList<String>();
        for (SbsxxzBaseRespVo vo : resp) {
            String zsxm = vo.getZsxm();
            String zspm = vo.getZspm();
            if (StringUtils.isNotEmpty((CharSequence)zsxm)) {
                zsxmNames.add(zsxm);
            }
            if (!StringUtils.isNotEmpty((CharSequence)zspm)) continue;
            zspmNames.add(zspm);
        }
        DynamicObjectCollection zspmByNames = TsateZspmAndZsxmBusiness.getZspmByNames(zspmNames);
        DynamicObjectCollection zsxmByNames = TsateZspmAndZsxmBusiness.getZsxmByNames(zsxmNames);
        for (SbsxxzBaseRespVo vo : resp) {
            String zsxm = vo.getZsxm();
            String zspm = vo.getZspm();
            Long zsxmId = null;
            Optional<DynamicObject> zsxmObj = zsxmByNames.stream().filter(zsxmByName -> zsxmByName.getString("name").equals(zsxm)).findFirst();
            if (zsxmObj.isPresent()) {
                zsxmId = zsxmObj.get().getLong("id");
            }
            List zspmObj = zspmByNames.stream().filter(zspmByName -> zspmByName.getString("name").equals(zspm)).collect(Collectors.toList());
            Long zspmId = TsateZspmAndZsxmBusiness.getZspmCheckTaxtype(zspmObj, (Long)zsxmId);
            checklist.add((Object)this.buildBody(this.buildCommonData(zspmId, zsxmId, taxOrgId, vo), checklist, vo));
        }
        long id = DBUtils.getLongId((String)TABLE_NAME);
        groupInstance.set("id", (Object)id);
        return groupInstance;
    }

    @Override
    public DynamicObject buildBody(Map<String, Object> dataMap, DynamicObjectCollection checklist, T vo) {
        return TsateDeclareChecklistBusiness.newInstanceBody((DynamicObjectCollection)checklist, dataMap);
    }

    @Override
    public void savaData(DynamicObject groupInstance) {
        TsateDeclareChecklistBusiness.savaGroupByCurrentMonth((DynamicObject)groupInstance, (Date)groupInstance.getDate("rqfz"), (Long)groupInstance.getLong("tasktype"));
    }
}

