/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.sbsxxz.qxy;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.business.company.TsateCompanyInfoBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbsxxzMessageVo;
import kd.taxc.tsate.msmessage.service.qxy.api.QxyApi;
import kd.taxc.tsate.msmessage.service.qxy.bean.RepTaskData;
import kd.taxc.tsate.msmessage.service.sbsxxz.AbstractBaseDataHandler;
import kd.taxc.tsate.msmessage.service.sbsxxz.dao.QxySbsxxzRespVo;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;

public class AbstractQxyBaseDataHandler
extends AbstractBaseDataHandler<QxySbsxxzRespVo> {
    private static final String SUCCESS_CODE = "SUCCESS";
    private static final String CODE_NUMBER = "code";
    private static final String DATA_NUMBER = "data";
    private static Log logger = LogFactory.getLog(AbstractQxyBaseDataHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String taskType, SBMessageBaseVo sbsxxzVo) {
        ApiResult result = null;
        try {
            result = this.doDataQuery(taskType, sbsxxzVo);
            DynamicObject groupInstance = this.newGroupInstance(sbsxxzVo);
            Long taxOrgId = Long.valueOf(sbsxxzVo.getOrg());
            List<QxySbsxxzRespVo> qxySbsxxzRespVos = this.declareQxyDataInfo(result);
            if (qxySbsxxzRespVos != null) {
                this.buildBodys(groupInstance, qxySbsxxzRespVos, taxOrgId);
                this.savaData(groupInstance, sbsxxzVo);
                this.dealUrlAndSave(groupInstance, qxySbsxxzRespVos);
            }
        }
        catch (Exception e) {
            logger.error("[AbstractQxyBaseDataHandler.handle]ERRO", (Object)ExceptionUtil.toString((Exception)e));
            this.updateRecordStatusFail(sbsxxzVo, ExceptionUtil.toString((Exception)e));
        }
        finally {
            if (result != null && "TSATEBIZERROR".equals(result.getErrorCode())) {
                this.updateRecordStatusFail(sbsxxzVo, result.getMessage());
            }
        }
    }

    @Override
    public ApiResult doDataQuery(String taskType, SBMessageBaseVo vo) {
        vo.getParams().put(SbsxxzMessageVo.Key.DATASOURCE.getKey(), "1");
        ApiResult apiResult = new ApiResult();
        apiResult.setSuccess(false);
        apiResult.setErrorCode("TSATEBIZERROR");
        apiResult.setData(null);
        try {
            String rocordId = String.valueOf(vo.getId());
            DynamicObject requestObject = TsateRequestInfoBusiness.queryOne((String)rocordId, (String)"1", (String)"1");
            if (requestObject == null) {
                String msg = String.format(ResManager.loadKDString((String)"%s\u65e0\u6267\u884c\u4e2d\u7684\u7533\u62a5\u4fe1\u606f\u8bb0\u5f55\u3002", (String)"AbstractQxyBaseDataHandler_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), rocordId);
                apiResult.setMessage(msg);
                return apiResult;
            }
            String requestId = requestObject.getString("requestid");
            if (StringUtils.isEmpty((CharSequence)requestId)) {
                apiResult.setMessage(ResManager.loadKDString((String)"taskId\u4e3a\u7a7a\u3002", (String)"AbstractQxyBaseDataHandler_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                return apiResult;
            }
            String nsrsbh = vo.getString(SbsxxzMessageVo.Key.NSRSBH);
            String qyId = TsateCompanyInfoBusiness.getQyId((String)nsrsbh, (SupplierEnum)SupplierEnum.QXY);
            logger.info("qxy - sbsxxz \u67e5\u8be2\u7533\u62a5\u4fe1\u606f\u4efb\u52a1 qyId={} taskId={}", (Object)qyId, (Object)requestId);
            if (StringUtils.isEmpty((CharSequence)nsrsbh) || StringUtils.isEmpty((CharSequence)qyId)) {
                apiResult.setMessage(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u6216\u4f01\u4e1aid\u4e3a\u7a7a\u3002", (String)"AbstractQxyBaseDataHandler_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                return apiResult;
            }
            TaxResult<RepTaskData> sbxx = QxyApi.getSbxx(qyId, requestId);
            if (sbxx == null || !sbxx.isSuccess() || ((RepTaskData)sbxx.getData()).getRepData() == null) {
                apiResult.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u7533\u62a5\u4fe1\u606f\u4efb\u52a1\u5931\u8d25\u3002", (String)"AbstractQxyBaseDataHandler_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                return apiResult;
            }
            JSONObject sbxxJsonObject = ((RepTaskData)sbxx.getData()).getRepData();
            String errorCode = sbxxJsonObject.getString(CODE_NUMBER);
            String message = sbxxJsonObject.getString("message");
            if (!SUCCESS_CODE.equals(errorCode)) {
                String msg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7533\u62a5\u4fe1\u606f\u4efb\u52a1\u5931\u8d25\u3002 CODE: %s", (String)"AbstractQxyBaseDataHandler_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), errorCode);
                apiResult.setMessage(msg);
                return apiResult;
            }
            if (sbxxJsonObject.containsKey((Object)DATA_NUMBER)) {
                JSONObject data = sbxxJsonObject.getJSONObject(DATA_NUMBER);
                if (2 == data.getInteger("businessStatus")) {
                    apiResult.setMessage(ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u67e5\u8be2\u7533\u62a5\u4fe1\u606f\u4efb\u52a1\u6267\u884c\u5931\u8d25\u3002", (String)"AbstractQxyBaseDataHandler_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    return apiResult;
                }
                if (0 == data.getInteger("businessStatus") || 1 == data.getInteger("businessStatus")) {
                    apiResult.setSuccess(true);
                    apiResult.setErrorCode("RUNNING");
                    apiResult.setMessage(ResManager.loadKDString((String)"\u4f01\u4eab\u4e91\u67e5\u8be2\u7533\u62a5\u4fe1\u606f\u4efb\u52a1\u6267\u884c\u4e2d\u3002", (String)"AbstractQxyBaseDataHandler_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    apiResult.setData((Object)sbxxJsonObject);
                    return apiResult;
                }
            }
            apiResult.setSuccess(true);
            apiResult.setErrorCode(SUCCESS_CODE);
            apiResult.setMessage(message);
            apiResult.setData((Object)sbxxJsonObject);
            return apiResult;
        }
        catch (Exception e) {
            logger.error("qxy - sbsxxz \u67e5\u8be2\u7533\u62a5\u4fe1\u606f\u4efb\u52a1\u5f02\u5e38 ", (Object)ExceptionUtil.toString((Exception)e));
            apiResult.setMessage(ResManager.loadKDString((String)"\u67e5\u8be2\u7533\u62a5\u4fe1\u606f\u4efb\u52a1\u5f02\u5e38\u3002", (String)"AbstractQxyBaseDataHandler_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            return apiResult;
        }
    }

    public List<QxySbsxxzRespVo> declareQxyDataInfo(ApiResult result) {
        logger.info("qxy - sbsxxz \u5f00\u59cb\u5904\u7406\u7533\u62a5\u4e8b\u9879\u6570\u636e isSuccess={} msg={} data={}", new Object[]{result.getSuccess(), result.getMessage(), result.getData()});
        return this.declareDataInfo(result, CODE_NUMBER, SUCCESS_CODE, DATA_NUMBER, QxySbsxxzRespVo.class);
    }

    public void savaData(DynamicObject groupInstance, SBMessageBaseVo sbsxxzVo) {
    }

    public void dealUrlAndSave(DynamicObject groupInstance, List<QxySbsxxzRespVo> qxySbsxxzRespVos) {
    }

    public void updateRecordStatusFail(SBMessageBaseVo sbsxxzVo, String errorMsg) {
        Throwable throwable;
        TXHandle handle;
        String recordId;
        block18: {
            block19: {
                block20: {
                    recordId = null;
                    handle = TX.required();
                    throwable = null;
                    recordId = String.valueOf(sbsxxzVo.getId());
                    if (!StringUtils.isEmpty((CharSequence)recordId)) break block18;
                    if (handle == null) break block19;
                    if (throwable == null) break block20;
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                handle.close();
            }
            return;
        }
        try {
            try {
                StringBuilder failedLog = new StringBuilder();
                if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                    failedLog.append(errorMsg);
                }
                DirectDeclareLogUtils.updateStatus(Long.valueOf(recordId), "3", failedLog);
                TsateRequestInfoBusiness.updateStatus((String)recordId, (ExecuteStatusEnum)ExecuteStatusEnum.FAIL);
            }
            catch (Exception e) {
                handle.markRollback();
                logger.error("\u66f4\u65b0\u7533\u62a5\u76d1\u63a7\u8bb0\u5f55\u548c\u7533\u62a5\u4fe1\u606f\u8bb0\u5f55\u4e3a\u5931\u8d25 \u5f02\u5e38\uff1aerror={} recordId={}", (Object)ExceptionUtil.toString((Exception)e), (Object)recordId);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    handle.close();
                }
            }
        }
    }
}

