/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.sbsxxz.qxy;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.TsateDeclareChecklistBusiness;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.FileUploadUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.service.sbsxxz.SbsxxzHandlerStrategy;
import kd.taxc.tsate.msmessage.service.sbsxxz.dao.QxySbsxxzRespVo;
import kd.taxc.tsate.msmessage.service.sbsxxz.dao.SbsxxzBaseRespVo;
import kd.taxc.tsate.msmessage.service.sbsxxz.qxy.AbstractQxyBaseDataHandler;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;

public class QxyHandlerSbqcStrategy
extends AbstractQxyBaseDataHandler
implements SbsxxzHandlerStrategy {
    public static final Map<String, String> ZSXM_TAX = new HashMap<String, String>(32);
    private static final String BUSINESSTYPE = "sbqc";
    private static Log logger = LogFactory.getLog(QxyHandlerSbqcStrategy.class);

    @Override
    public void handlerSbsxxzDownLoad(SBMessageBaseVo sbsxxzVo) {
        this.handle(BUSINESSTYPE, sbsxxzVo);
    }

    @Override
    public void beforeBuildBodys(DynamicObject groupInstance, List<QxySbsxxzRespVo> resp, Long taxOrgId) {
        for (QxySbsxxzRespVo vo : resp) {
            vo.setZspm(vo.getZspmMc());
            vo.setZsxm(ZSXM_TAX.get(vo.getYzpzzlDm()));
        }
    }

    @Override
    public DynamicObject buildBody(Map<String, Object> dataMap, DynamicObjectCollection checklist, QxySbsxxzRespVo vo) {
        dataMap.put("sbsx", vo.getTaxProjectName());
        dataMap.put("skssqq", this.parseDateString(vo.getFromDate()));
        dataMap.put("skssqz", this.parseDateString(vo.getToDate()));
        dataMap.put("sbqx", this.parseDateString(vo.getEndDate()));
        dataMap.put("sbrq", this.parseDateString(vo.getVoucherDate()));
        dataMap.put("sbzt", vo.getState() == 10 ? "3" : String.valueOf(vo.getState()));
        dataMap.put("jkzt", vo.getPaystate() == -1 ? "2" : String.valueOf(vo.getPaystate()));
        dataMap.put("ybtse", StringUtils.isEmpty((CharSequence)vo.getBqybtseSj()) ? null : new BigDecimal(vo.getBqybtseSj()));
        return super.buildBody(dataMap, checklist, vo);
    }

    @Override
    protected <T extends SbsxxzBaseRespVo> List<T> declareDataInfo(ApiResult result, String codeNumber, String succesCode, String dataNumber, Class<T> voClass) {
        if (!result.getSuccess()) {
            String msg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25:%s", (String)"QxyHandlerSbqcStrategy_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]), result.getMessage());
            throw new KDBizException(msg);
        }
        Object data = result.getData();
        Map dataMap = (Map)JsonUtil.fromJson((String)data.toString(), Map.class);
        if ("RUNNING".equals(result.getErrorCode())) {
            return null;
        }
        if (!StringUtils.equals((CharSequence)succesCode, (CharSequence)String.valueOf(dataMap.get(codeNumber)))) {
            String msg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25:%s", (String)"QxyHandlerSbqcStrategy_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]), data.toString());
            throw new KDBizException(msg);
        }
        Object dataInfo = dataMap.get(dataNumber);
        if (dataInfo == null || EmptyCheckUtils.isEmpty((Object)dataInfo.toString())) {
            String msg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25,\u7f3a\u5931\u5173\u952eData\u4fe1\u606f: %s", (String)"QxyHandlerSbqcStrategy_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]), result.getMessage());
            throw new KDBizException(msg);
        }
        if (dataInfo instanceof LinkedHashMap && ((LinkedHashMap)dataInfo).get("detail") == null) {
            String msg = String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25,\u7f3a\u5931\u5173\u952edetail\u4fe1\u606f: %s", (String)"QxyHandlerSbqcStrategy_18", (String)"taxc-tsate-mservice", (Object[])new Object[0]), result.getMessage());
            throw new KDBizException(msg);
        }
        dataInfo = ((LinkedHashMap)dataInfo).get("detail");
        return JSON.parseArray((String)JSON.toJSONString(dataInfo), voClass);
    }

    @Override
    public void savaData(DynamicObject groupInstance, SBMessageBaseVo sbsxxzVo) {
        Throwable throwable;
        TXHandle handle;
        String recordId;
        block17: {
            block18: {
                block19: {
                    recordId = null;
                    handle = TX.required();
                    throwable = null;
                    TsateDeclareChecklistBusiness.savaGroupByCurrentMonth((DynamicObject)groupInstance, (Date)groupInstance.getDate("rqfz"), (Long)groupInstance.getLong("tasktype"));
                    recordId = String.valueOf(sbsxxzVo.getId());
                    if (!StringUtils.isEmpty((CharSequence)recordId)) break block17;
                    if (handle == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                handle.close();
            }
            return;
        }
        try {
            try {
                DirectDeclareLogUtils.updateStatus(Long.valueOf(recordId), "2", new StringBuilder());
                TsateRequestInfoBusiness.updateStatus((String)recordId, (ExecuteStatusEnum)ExecuteStatusEnum.SUCCESS);
            }
            catch (Exception e) {
                handle.markRollback();
                logger.error("\u4fdd\u5b58\u7533\u62a5\u4e8b\u9879\u4fe1\u606f\u4e0b\u8f7d\u4efb\u52a1\u5931\u8d25\uff1aerror={} recordId={}", (Object)ExceptionUtil.toString((Exception)e), recordId);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    handle.close();
                }
            }
        }
    }

    public Date parseDateString(String dateString) {
        Date result = null;
        try {
            if (StringUtils.isEmpty((CharSequence)dateString)) {
                return result;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            result = simpleDateFormat.parse(dateString);
        }
        catch (ParseException e) {
            logger.error("parseDateString failed dateString={}", (Object)dateString);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dealUrlAndSave(DynamicObject groupInstance, List<QxySbsxxzRespVo> qxySbsxxzRespVos) {
        InputStream in = null;
        try {
            DynamicObject dynamicObject;
            if (groupInstance == null || qxySbsxxzRespVos == null || qxySbsxxzRespVos.isEmpty()) {
                return;
            }
            Long groupId = groupInstance.getLong("id");
            DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupInstance.getLong("org"))});
            String name = ((DynamicObject)org.get("org")).getString("name");
            HashSet<String> urlSet = new HashSet<String>(10);
            for (QxySbsxxzRespVo qxySbsxxzRespVo : qxySbsxxzRespVos) {
                urlSet.add(qxySbsxxzRespVo.getDqysb());
                urlSet.add(qxySbsxxzRespVo.getQcSbOssUrl());
                urlSet.add(qxySbsxxzRespVo.getQcJkOssUrl());
            }
            urlSet.remove(null);
            urlSet.remove("");
            int count = 1;
            for (String screenUrl : urlSet) {
                String fileType = screenUrl.substring(screenUrl.lastIndexOf("."));
                if (fileType.contains("?")) {
                    int i = fileType.indexOf(63);
                    fileType = fileType.substring(0, i);
                }
                String suffixName = String.format(ResManager.loadKDString((String)"\u7533\u62a5\u6e05\u518c%s", (String)"QxyHandlerSbqcStrategy_19", (String)"taxc-tsate-mservice", (Object[])new Object[0]), fileType);
                screenUrl = FileUploadUtils.dealWithGatewayUrl((String)screenUrl, (SupplierEnum)SupplierEnum.QXY);
                URL url = new URL(screenUrl);
                Map configMap = CommonInfoUtil.getCommonConfigInfo();
                String proxyUrl = (String)configMap.get("kd_file_proxy");
                if (kd.bos.util.StringUtils.isNotEmpty((String)proxyUrl)) {
                    String[] values = proxyUrl.trim().split(":");
                    if (values.length < 2) {
                        logger.error(ResManager.loadKDString((String)"\u4ee3\u7406\u914d\u7f6e\u683c\u5f0f\u9519\u8bef", (String)"KdMessageSendServiceImpl_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                        break;
                    }
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(values[0], Integer.parseInt(values[1])));
                    in = url.openConnection(proxy).getInputStream();
                } else {
                    in = url.openStream();
                }
                String fileName_end = this.getFileName(name, qxySbsxxzRespVos.get(0).getFromDate(), String.valueOf(count), suffixName);
                boolean uploadFileSuccess = FileUploadUtils.uploadAttachment((String)fileName_end, (InputStream)in, (String)"tsate_checklist_group", (Object)groupId, (String)"tsate");
                if (!uploadFileSuccess) {
                    logger.error("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25\u3002goupId={}", (Object)groupId);
                    continue;
                }
                ++count;
            }
            if (!urlSet.isEmpty() && (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"tsate_checklist_group")) != null) {
                dynamicObject.set("xqzs", (Object)"1");
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u548c\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38:" + ExceptionUtil.toString((Exception)e));
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u548c\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38");
                }
            }
        }
    }

    private String getFileName(String org, String fromDate, String number, String suffixName) {
        StringBuilder fileName = new StringBuilder(org).append("-").append(fromDate).append("-").append(number).append("-").append(suffixName);
        return fileName.toString();
    }

    static {
        ZSXM_TAX.put("BDA0610611", ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"QxyHandlerSbqcStrategy_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610606", ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"QxyHandlerSbqcStrategy_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0611111", ResManager.loadKDString((String)"\u6d88\u8d39\u7a0e", (String)"QxyHandlerSbqcStrategy_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0611159", ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"QxyHandlerSbqcStrategy_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610994", ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"QxyHandlerSbqcStrategy_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0611038", ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"QxyHandlerSbqcStrategy_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610794", ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"QxyHandlerSbqcStrategy_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610334", ResManager.loadKDString((String)"\u6587\u5316\u4e8b\u4e1a\u5efa\u8bbe\u8d39", (String)"QxyHandlerSbqcStrategy_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610135", ResManager.loadKDString((String)"\u4e2a\u4eba\u6240\u5f97\u7a0e", (String)"QxyHandlerSbqcStrategy_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0611062", ResManager.loadKDString((String)"\u4e2a\u4eba\u6240\u5f97\u7a0e", (String)"QxyHandlerSbqcStrategy_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0611065", ResManager.loadKDString((String)"\u4e2a\u4eba\u6240\u5f97\u7a0e", (String)"QxyHandlerSbqcStrategy_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0611068", ResManager.loadKDString((String)"\u4e2a\u4eba\u6240\u5f97\u7a0e", (String)"QxyHandlerSbqcStrategy_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610857", ResManager.loadKDString((String)"\u6b8b\u75be\u4eba\u5c31\u4e1a\u4fdd\u969c\u91d1", (String)"QxyHandlerSbqcStrategy_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610980", ResManager.loadKDString((String)"\u73af\u4fdd\u7a0e", (String)"QxyHandlerSbqcStrategy_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610790", ResManager.loadKDString((String)"\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", (String)"QxyHandlerSbqcStrategy_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610791", ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"QxyHandlerSbqcStrategy_9", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610790SYCJ", ResManager.loadKDString((String)"\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", (String)"QxyHandlerSbqcStrategy_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610791SYCJ", ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"QxyHandlerSbqcStrategy_9", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610036", ResManager.loadKDString((String)"\u8d44\u6e90\u7a0e", (String)"QxyHandlerSbqcStrategy_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610987", ResManager.loadKDString((String)"\u6c34\u8d44\u6e90\u7a0e", (String)"QxyHandlerSbqcStrategy_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610128", ResManager.loadKDString((String)"\u8f66\u8f86\u8d2d\u7f6e\u7a0e", (String)"QxyHandlerSbqcStrategy_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610005", ResManager.loadKDString((String)"\u8f66\u8239\u4f7f\u7528\u7a0e", (String)"QxyHandlerSbqcStrategy_13", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("BDA0610108", ResManager.loadKDString((String)"\u5951\u7a0e", (String)"QxyHandlerSbqcStrategy_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("CWBBSB", ResManager.loadKDString((String)"\u8d22\u52a1\u62a5\u8868", (String)"QxyHandlerSbqcStrategy_15", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        ZSXM_TAX.put("CWBBNDSB", ResManager.loadKDString((String)"\u8d22\u52a1\u62a5\u8868", (String)"QxyHandlerSbqcStrategy_15", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
    }
}

