/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.sbsxxz.szyh;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.business.TsateDeclareChecklistBusiness;
import kd.taxc.tsate.business.TsateZspmAndZsxmBusiness;
import kd.taxc.tsate.common.util.DBUtils;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.FileUploadUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbsxxzMessageVo;
import kd.taxc.tsate.msmessage.enums.szyh.SbsxxzSbztCodeEnums;
import kd.taxc.tsate.msmessage.service.sbsxxz.dao.SzyhSbsxxzRespVo;
import kd.taxc.tsate.msmessage.service.szyh.api.SzyhApi;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.IOUtils;

public abstract class AbstractSzyhBaseDataHandler {
    private static Log logger = LogFactory.getLog(AbstractSzyhBaseDataHandler.class);
    private static final String FORM_ID = "tsate_checklist_group";
    private static final String TABLE_NAME = "t_tsate_checklist_head";

    ApiResult doDataQuery(String taskType, SBMessageBaseVo vo) {
        String nsrsbh = vo.getString(SbsxxzMessageVo.Key.NSRSBH);
        Date operateTime = new Date(vo.getLong(SbsxxzMessageVo.Key.OPERATTIME));
        String formatDate = DateUtils.format((Date)operateTime, (String)"yyyy-MM");
        return SzyhApi.declareDataQuery(taskType, nsrsbh, formatDate);
    }

    ApiResult doFileQuery(String taskType, SBMessageBaseVo vo) {
        String nsrsbh = vo.getString(SbsxxzMessageVo.Key.NSRSBH);
        Date operateTime = new Date(vo.getLong(SbsxxzMessageVo.Key.OPERATTIME));
        String formatDate = DateUtils.format((Date)operateTime, (String)"yyyy-MM");
        return SzyhApi.declareFileQuery(taskType, nsrsbh, formatDate, null);
    }

    List<SzyhSbsxxzRespVo> declareDataInfo(ApiResult result) {
        if (!result.getSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25:%s", (String)"AbstractSzyhBaseDataHandler_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), result.getMessage()));
        }
        Object data = result.getData();
        Map dataMap = (Map)JsonUtil.fromJson((String)data.toString(), Map.class);
        if (!"200".equals(String.valueOf(dataMap.get("Code")))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25:%s", (String)"AbstractSzyhBaseDataHandler_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), data.toString()));
        }
        Object dataInfo = dataMap.get("Data");
        if (dataInfo == null || StringUtils.isBlank((CharSequence)dataInfo.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5931\u8d25,\u7f3a\u5931\u5173\u952eData\u4fe1\u606f:", (String)"AbstractSzyhBaseDataHandler_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        return JSON.parseArray((String)JSON.toJSONString(dataInfo), SzyhSbsxxzRespVo.class);
    }

    DynamicObject newGroupInstance(SBMessageBaseVo vo) {
        Long orgId = vo.getLong(SbsxxzMessageVo.Key.ORG);
        String source = vo.getString(SbsxxzMessageVo.Key.DATASOURCE);
        Long createor = vo.getLong(SbsxxzMessageVo.Key.OPERATOR);
        Date operateTime = new Date(vo.getLong(SbsxxzMessageVo.Key.OPERATTIME));
        Long taskId = vo.getLong(SbsxxzMessageVo.Key.TASK_ID);
        String formatDate = DateUtils.format((Date)operateTime, (String)"yyyy-MM");
        Date downLoadTime = DateUtils.stringToDate((String)formatDate, (String)"yyyy-MM");
        return TsateDeclareChecklistBusiness.newGroupInstance((Long)orgId, (String)source, (Long)createor, (Date)operateTime, (Date)downLoadTime, (Long)taskId, (String)"1");
    }

    DynamicObject buildBody(DynamicObjectCollection checklist, SzyhSbsxxzRespVo vo, Long zspmId, Long zsxmId, Long taxOrgId) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("zsxm", zsxmId);
        dataMap.put("zspm", zspmId);
        dataMap.put("sbsx", vo.getSbbmc());
        dataMap.put("skssqq", DateUtils.stringToDate((String)vo.getSsqs()));
        dataMap.put("skssqz", DateUtils.stringToDate((String)vo.getSsqz()));
        dataMap.put("sbqx", DateUtils.stringToDate((String)vo.getSbjzrq()));
        dataMap.put("sbjg", vo.getSbzt());
        dataMap.put("sbzt", SbsxxzSbztCodeEnums.getXtCodeByYhCode(vo.getSbztbm()));
        dataMap.put("taxorg", taxOrgId);
        dataMap.put("compareresult", "0");
        return TsateDeclareChecklistBusiness.newInstanceBody((DynamicObjectCollection)checklist, dataMap);
    }

    void buildBodysAndFile(DynamicObject groupInstance, List<SzyhSbsxxzRespVo> declareDataInfo, Long taxOrgId, ApiResult fileResult) {
        try {
            this.buildBodys(groupInstance, declareDataInfo, taxOrgId);
            this.uploadAttachment(groupInstance, fileResult);
        }
        catch (Exception e) {
            String stackMsg = ExceptionUtil.toString((Throwable)e);
            logger.error("\u5408\u5e76\u5904\u7406\u5f02\u5e38", (Object)stackMsg);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u5e76\u5904\u7406\u5f02\u5e38:%s", (String)"AbstractSzyhBaseDataHandler_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage()));
        }
    }

    void buildBodys(DynamicObject groupInstance, List<SzyhSbsxxzRespVo> resp, Long taxOrgId) {
        DynamicObjectCollection checklist = TsateDeclareChecklistBusiness.newBodyByChecklisHead((DynamicObject)groupInstance);
        ArrayList<Object> zsxmNames = new ArrayList<Object>();
        ArrayList<String> zspmNames = new ArrayList<String>();
        for (SzyhSbsxxzRespVo vo : resp) {
            String zsxm = vo.getZsxm();
            String zspm = vo.getZspm();
            if (StringUtils.isNotEmpty((CharSequence)zsxm)) {
                zsxmNames.add(zsxm);
            }
            if (!StringUtils.isNotEmpty((CharSequence)zspm)) continue;
            zspmNames.add(zspm);
        }
        DynamicObjectCollection zspmByNames = TsateZspmAndZsxmBusiness.getZspmByNames(zspmNames);
        DynamicObjectCollection zsxmByNames = TsateZspmAndZsxmBusiness.getZsxmByNames(zsxmNames);
        for (SzyhSbsxxzRespVo vo : resp) {
            String zsxm = vo.getZsxm();
            String zspm = vo.getZspm();
            Long zsxmId = null;
            Optional<DynamicObject> zsxmObj = zsxmByNames.stream().filter(zsxmByName -> zsxmByName.getString("name").equals(zsxm)).findFirst();
            if (zsxmObj.isPresent()) {
                zsxmId = zsxmObj.get().getLong("id");
            }
            List zspmObj = zspmByNames.stream().filter(zspmByName -> zspmByName.getString("name").equals(zspm)).collect(Collectors.toList());
            Long zspmId = TsateZspmAndZsxmBusiness.getZspmCheckTaxtype(zspmObj, (Long)zsxmId);
            checklist.add((Object)this.buildBody(checklist, vo, zspmId, zsxmId, taxOrgId));
        }
        long id = DBUtils.getLongId((String)TABLE_NAME);
        groupInstance.set("id", (Object)id);
    }

    public void uploadAttachment(DynamicObject groupInstance, ApiResult fileResult) {
        if (!fileResult.getSuccess()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u6587\u4ef6\u622a\u56fe\u63a5\u53e3\u5931\u8d25:%s", (String)"AbstractSzyhBaseDataHandler_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), fileResult.getMessage()));
        }
        byte[] data = (byte[])fileResult.getData();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ZipArchiveInputStream zipIn = new ZipArchiveInputStream((InputStream)in);
        ByteArrayInputStream bis = null;
        ByteArrayOutputStream bos = null;
        byte[] bytes = new byte[1024];
        ZipArchiveEntry nextEntry = null;
        try {
            while ((nextEntry = zipIn.getNextZipEntry()) != null) {
                bos = new ByteArrayOutputStream();
                if (nextEntry.isDirectory()) continue;
                int len = 0;
                while ((len = zipIn.read(bytes)) != -1) {
                    bos.write(bytes, 0, len);
                }
                bos.flush();
                String[] split = nextEntry.getName().split("/");
                bis = new ByteArrayInputStream(bos.toByteArray());
                FileUploadUtils.uploadAttachment((String)split[split.length - 1], (InputStream)bis, (String)FORM_ID, (Object)groupInstance.getPkValue(), (String)"tsate");
            }
        }
        catch (Exception e) {
            try {
                String stackMsg = ExceptionUtil.toString((Throwable)e);
                logger.error(stackMsg);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u4e8b\u9879\u5904\u7406\u6587\u4ef6\u5931\u8d25:%s", (String)"AbstractSzyhBaseDataHandler_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly((InputStream)zipIn);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bis);
        IOUtils.closeQuietly((OutputStream)bos);
        IOUtils.closeQuietly((InputStream)zipIn);
        IOUtils.closeQuietly((InputStream)in);
    }

    void savaData(DynamicObject groupInstance) {
        TsateDeclareChecklistBusiness.savaGroupByCurrentMonth((DynamicObject)groupInstance, (Date)groupInstance.getDate("rqfz"), (Long)groupInstance.getLong("tasktype"));
    }
}

