/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.sbsxxz.zwy;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.business.BastaxTaxorgBusiness;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbsxxzMessageVo;
import kd.taxc.tsate.msmessage.service.sbsxxz.AbstractBaseDataHandler;
import kd.taxc.tsate.msmessage.service.sbsxxz.dao.ZwySbsxxzRespVo;
import kd.taxc.tsate.msmessage.service.zwy.api.ZwyApi;

public abstract class AbstractZwyBaseDataHandler
extends AbstractBaseDataHandler<ZwySbsxxzRespVo> {
    private static Log logger = LogFactory.getLog(AbstractZwyBaseDataHandler.class);
    private static final String SUCCESS_CODE = "0";
    private static final String CODE_NUMBER = "code";
    private static final String DATA_NUMBER = "data";

    @Override
    public void handle(String taskType, SBMessageBaseVo sbsxxzVo) {
        Long taxOrgId = sbsxxzVo.getLong(SbsxxzMessageVo.Key.TAXORG);
        ApiResult result = this.doDataQuery(taskType, sbsxxzVo);
        DynamicObject groupInstance = this.newGroupInstance(sbsxxzVo);
        this.buildBodys(groupInstance, this.declareZwyDataInfo(result), taxOrgId);
        this.savaData(groupInstance);
    }

    @Override
    public DynamicObject buildBodys(DynamicObject groupInstance, List<ZwySbsxxzRespVo> resp, Long taxOrgId) {
        this.buildDafultTaxOrgName(groupInstance, taxOrgId);
        return super.buildBodys(groupInstance, resp, taxOrgId);
    }

    private void buildDafultTaxOrgName(DynamicObject groupInstance, Long taxOrgId) {
        groupInstance.set("swjgmc", (Object)BastaxTaxorgBusiness.getTaxOrganNameById((Long)taxOrgId));
    }

    @Override
    public ApiResult doDataQuery(String taskType, SBMessageBaseVo vo) {
        String nsrsbh = vo.getString(SbsxxzMessageVo.Key.NSRSBH);
        logger.info("zwy - sbsxxz \u53d1\u8d77\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u8bf7\u6c42 nsrsbh={} type={}", (Object)nsrsbh, (Object)taskType);
        return ZwyApi.declareDataQuery(taskType, nsrsbh);
    }

    List<ZwySbsxxzRespVo> declareZwyDataInfo(ApiResult result) {
        logger.info("zwy - sbsxxz \u5f00\u59cb\u5904\u7406\u7533\u62a5\u4e8b\u9879\u6570\u636e isSuccess={} msg={} data={}", new Object[]{result.getSuccess(), result.getMessage(), result.getData()});
        return this.declareDataInfo(result, CODE_NUMBER, SUCCESS_CODE, DATA_NUMBER, ZwySbsxxzRespVo.class);
    }

    @Override
    public DynamicObject buildBody(Map<String, Object> dataMap, DynamicObjectCollection checklist, ZwySbsxxzRespVo vo) {
        DynamicObject body = super.buildBody(dataMap, checklist, vo);
        body.set(MetadataUtil.slipNumber((String)"checklist.sbqx"), (Object)DateUtils.stringToDate((String)vo.getSbqx()));
        body.set(MetadataUtil.slipNumber((String)"checklist.skssqq"), (Object)DateUtils.stringToDate((String)vo.getPeriodBegin()));
        body.set(MetadataUtil.slipNumber((String)"checklist.skssqz"), (Object)DateUtils.stringToDate((String)vo.getPeriodEnd()));
        return body;
    }
}

