/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.szyh.api;

import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.taxc.tsate.common.ext.cloudcc.utils.Md5Utils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class BaseRequestParams {
    private static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private String accessKeyID;
    private String version;
    private String signatureNonce;
    private String signature;
    private String timeStamp;

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getSignatureNonce() {
        return this.signatureNonce;
    }

    public void setSignatureNonce(String signatureNonce) {
        this.signatureNonce = signatureNonce;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getAccessKeyID() {
        return this.accessKeyID;
    }

    public void setAccessKeyID(String accessKeyID) {
        this.accessKeyID = accessKeyID;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Map<String, Object> genFullParams(Map<String, Object> otherParams, String secret) {
        Date time = new Date();
        String timeStamp = DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00"));
        String signatureNonce = UUID.randomUUID().toString();
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("AccessKeyID", this.getAccessKeyID());
        map.put("TimeStamp", timeStamp);
        map.put("SignatureNonce", signatureNonce);
        map.put("Version", this.getVersion());
        String sign = this.genSign(map, secret);
        map.put("Signature", sign);
        this.setSignatureNonce(signatureNonce);
        this.setSignature(sign);
        this.setTimeStamp(timeStamp);
        map.putAll(otherParams);
        return map;
    }

    public String getUrlParams() {
        StringBuilder urlParams = new StringBuilder();
        urlParams.append("?AccessKeyID=").append(this.getAccessKeyID()).append("&TimeStamp=").append(this.getTimeStamp()).append("&SignatureNonce=").append(this.getSignatureNonce()).append("&Signature=").append(this.getSignature()).append("&Version=").append(this.getVersion());
        return urlParams.toString();
    }

    public String genSign(Map<String, Object> allParams, String secret) {
        TreeMap map = new TreeMap(Comparator.naturalOrder());
        map.putAll(allParams);
        StringBuilder strs = new StringBuilder();
        map.forEach((k, v) -> strs.append((String)k).append("=").append(v).append("&"));
        strs.deleteCharAt(strs.length() - 1);
        try {
            String accessKeySecret = Md5Utils.getEncode((byte[])secret.getBytes("UTF-8"));
            String signature = Md5Utils.getSignature((byte[])strs.toString().getBytes("UTF-8"), (byte[])accessKeySecret.getBytes("UTF-8"));
            return signature;
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u4e91\u901a\u8bf7\u6c42\u53c2\u6570\u7b7e\u540d\u5931\u8d25", (String)"BaseRequestParams_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
    }
}

