/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.szyh.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.common.util.CommonInfoUtil;

public class TaxTypeTranslateHelper {
    private static final String TAXMAIN = "tctb_tax_main";
    private static TaxTypeTranslateHelper helper;
    private static final String[] TAXOFFCE_GHJF1;
    private static final String[] TAXOFFCE_GHJF2;
    private static final String[] TAXOFFCE_SLJSJJ1;
    private static final String[] TAXOFFCE_SLJSJJ2;

    private TaxTypeTranslateHelper() {
    }

    public static List<String> kdTaxTypeToSzyh(String kdTaxNumber, Long orgId) {
        return helper.getByKdTaxType(kdTaxNumber, orgId);
    }

    public static List<String> kdDeclareTypeToSzyh(String declareType, Long orgId) {
        return helper.getByKdDeclareType(declareType, orgId);
    }

    public List<String> getByKdTaxType(String kdTaxNumber, Long orgId) {
        ArrayList<String> target = new ArrayList<String>(4);
        switch (kdTaxNumber) {
            case "001": {
                target.add(this.taxTranslate_zzs(orgId));
                break;
            }
            case "003": {
                target.add(this.taxTranslate_qysds());
                break;
            }
            case "035": {
                target.addAll(this.taxTranslate_cwbb(orgId));
                break;
            }
            case "023": {
                target.add(this.taxTranslate_ghjf(orgId));
                break;
            }
            case "024": {
                target.add(this.taxTranslate_sljsjj(orgId));
                break;
            }
            case "034": {
                target.add(this.taxTranslate_ghcbj());
                break;
            }
            case "025": {
                target.add(this.taxTranslate_ljclf());
                break;
            }
            case "008": {
                target.add(this.taxTranslate_yhs());
            }
        }
        target.remove(null);
        return target;
    }

    public List<String> getByKdDeclareType(String kdTaxNumber, Long orgId) {
        ArrayList<String> target = new ArrayList<String>(8);
        switch (kdTaxNumber) {
            case "zzsybnsr": {
                target.add(this.declareTranslate_zzsybnsr());
                break;
            }
            case "qysdsjb": {
                target.add(this.declareTranslate_qysdsjb());
                break;
            }
            case "FR0002": {
                target.add(this.declareTranslate_cbyzx());
                break;
            }
            case "FR0001": {
                target.add(this.declareTranslate_cbwzx());
                break;
            }
            case "qtsf_tysbb": {
                target.addAll(this.declareTranslate_tysb(orgId));
                break;
            }
            case "qtsf_fsstysbb": {
                target.add(this.declareTranslate_fssrtysbb());
                break;
            }
            case "ccxws": {
                target.add(this.declareTranslate_ccxws());
                break;
            }
            case "FR0003": {
                target.add(this.declareTranslate_xqykjzz());
                break;
            }
            case "zzsxgmnsr": {
                target.add(this.declareTranslate_xgmzzs());
            }
        }
        target.remove(null);
        return target;
    }

    private Map<String, Object> getTaxMainInfo(Long orgId) {
        QFilter filter = new QFilter("orgid", "=", (Object)orgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)TAXMAIN, (String)"accountingstandards.projectname,newrule,categoryentryentity,taxoffice.number,taxoffice.id", (QFilter[])new QFilter[]{filter});
        String kszzzd = dyn.getString("accountingstandards.projectname");
        String sfyzx = dyn.getString("newrule");
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)TAXMAIN, (String)"categoryentryentity.taxtype,categoryentryentity.taxpayertype", (QFilter[])new QFilter[]{filter});
        String taxpayertype = null;
        Optional<DynamicObject> optDyn = dyns.stream().filter(item -> "zzs".equals(item.getString("categoryentryentity.taxtype"))).findFirst();
        if (optDyn.isPresent()) {
            taxpayertype = optDyn.get().getString("categoryentryentity.taxpayertype");
        }
        String officeNumber = dyn.getString("taxoffice.number");
        Long officeId = dyn.getLong("taxoffice.id");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("kszzzd", kszzzd);
        map.put("sfyzx", sfyzx);
        map.put("taxpayertype", taxpayertype);
        map.put("officeNumber", officeNumber);
        map.put("officeId", officeId);
        return map;
    }

    private boolean matchKszzzd(Map<String, Object> taxmainInfo, String kszzzd) {
        return kszzzd.equals(taxmainInfo.get("kszzzd"));
    }

    private boolean matchSfyzx(Map<String, Object> taxmainInfo, String sfyzx) {
        return sfyzx.equals(taxmainInfo.get("sfyzx"));
    }

    private boolean matchTaxpayertype(Map<String, Object> taxmainInfo, String type) {
        return type.equals(taxmainInfo.get("taxpayertype"));
    }

    private boolean matchOfficeNumber(Map<String, Object> taxmainInfo, String ... officeNumbers) {
        String officNum = (String)taxmainInfo.get("officeNumber");
        if (officNum == null) {
            return false;
        }
        officNum = CommonInfoUtil.getParentTaxauthorityNumberById((Long)((Long)taxmainInfo.get("officeId")));
        for (String number : officeNumbers) {
            if (!officNum.equals(number)) continue;
            return true;
        }
        return false;
    }

    private String taxTranslate_zzs(Long orgId) {
        Map<String, Object> taxmainInfo = this.getTaxMainInfo(orgId);
        if (this.matchTaxpayertype(taxmainInfo, "ybnsr")) {
            return "010100";
        }
        if (this.matchTaxpayertype(taxmainInfo, "xgmnsr")) {
            return "010200";
        }
        return null;
    }

    private List<String> taxTranslate_cwbb(Long orgId) {
        ArrayList<String> list = new ArrayList<String>(2);
        Map<String, Object> taxmainInfo = this.getTaxMainInfo(orgId);
        if (this.matchKszzzd(taxmainInfo, ResManager.loadKDString((String)"\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"TaxTypeTranslateHelper_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]))) {
            if (this.matchSfyzx(taxmainInfo, "yes")) {
                list.add("700410");
            } else if (this.matchSfyzx(taxmainInfo, "no")) {
                list.add("700310");
            } else {
                list.add("700410");
                list.add("700310");
            }
        } else if (this.matchKszzzd(taxmainInfo, ResManager.loadKDString((String)"\u5c0f\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219", (String)"TaxTypeTranslateHelper_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]))) {
            list.add("700210");
        }
        return list;
    }

    private String taxTranslate_ghjf(Long orgId) {
        Map<String, Object> taxmainInfo = this.getTaxMainInfo(orgId);
        String[] officeNumbers1 = TAXOFFCE_GHJF1;
        String[] officeNumbers2 = TAXOFFCE_GHJF2;
        if (this.matchOfficeNumber(taxmainInfo, officeNumbers1)) {
            return "910100";
        }
        if (this.matchOfficeNumber(taxmainInfo, officeNumbers2)) {
            return "910400";
        }
        return "910300";
    }

    private String taxTranslate_sljsjj(Long orgId) {
        Map<String, Object> taxmainInfo = this.getTaxMainInfo(orgId);
        String[] officeNumbers1 = TAXOFFCE_SLJSJJ1;
        String[] officeNumbers2 = TAXOFFCE_SLJSJJ2;
        if (this.matchOfficeNumber(taxmainInfo, officeNumbers1)) {
            return "910100";
        }
        if (this.matchOfficeNumber(taxmainInfo, officeNumbers2)) {
            return "910700";
        }
        return "910200";
    }

    private String taxTranslate_qysds() {
        return "040101";
    }

    private String taxTranslate_ghcbj() {
        return "910100";
    }

    private String taxTranslate_ljclf() {
        return "910700";
    }

    private String taxTranslate_yhs() {
        return "300100";
    }

    private String declareTranslate_zzsybnsr() {
        return "010100";
    }

    private String declareTranslate_qysdsjb() {
        return "040101";
    }

    private String declareTranslate_cbyzx() {
        return "700410";
    }

    private String declareTranslate_cbwzx() {
        return "700310";
    }

    private List<String> declareTranslate_tysb(Long orgId) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.taxTranslate_ghjf(orgId));
        list.add(this.taxTranslate_ghcbj());
        list.add(this.taxTranslate_sljsjj(orgId));
        return list;
    }

    private String declareTranslate_fssrtysbb() {
        return this.taxTranslate_ljclf();
    }

    private String declareTranslate_ccxws() {
        return "300100";
    }

    private String declareTranslate_xqykjzz() {
        return "700210";
    }

    private String declareTranslate_xgmzzs() {
        return "010200";
    }

    public static String getTaxTypeNotFindMessage(String kdTaxtypeCode) {
        StringBuilder msg = new StringBuilder();
        if (kdTaxtypeCode.equals("035")) {
            msg.append(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6240\u9002\u7528\u7684\u4f1a\u8ba1\u51c6\u5219\u6216\u4f1a\u8ba1\u5236\u5ea6\u65e0\u6cd5\u6b63\u5e38\u83b7\u53d6\u7533\u62a5\u51ed\u8bc1\uff08\u63d0\u793a\uff1a\u7cfb\u7edf\u652f\u6301\u83b7\u53d6\u4e00\u822c\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219\u548c\u5c0f\u4f01\u4e1a\u4f1a\u8ba1\u51c6\u5219\u7684\u7533\u62a5\u51ed\u8bc1\uff09", (String)"TaxTypeTranslateHelper_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        } else {
            msg.append(ResManager.loadKDString((String)"\u91d1\u8776\u7a0e\u79cd\u7f16\u7801\uff08%s\uff09\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u7684\u63a5\u53e3\u5546\u7a0e\u79cd", (String)"TaxTypeTranslateHelper_3", (String)"taxc-tsate-mservice", (Object[])new Object[]{kdTaxtypeCode}));
        }
        return msg.toString();
    }

    static {
        TAXOFFCE_GHJF1 = new String[]{"12100000000", "13500000000", "15100000000", "13300000000"};
        TAXOFFCE_GHJF2 = new String[]{"14400000000"};
        TAXOFFCE_SLJSJJ1 = new String[]{"14300000000", "12200000000"};
        TAXOFFCE_SLJSJJ2 = new String[]{"14500000000"};
        helper = new TaxTypeTranslateHelper();
    }
}

