/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service.zwy.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.enums.KddlfsMappingEnums;
import kd.taxc.tsate.msmessage.service.KdDirectDeclareService;
import kd.taxc.tsate.msmessage.service.zwy.ZwyRequest;
import kd.taxc.tsate.msmessage.service.zwy.api.BaseRequestParams;
import kd.taxc.tsate.msmessage.service.zwy.constant.ZwyDfsfMappingEnums;

public class ZwyApi {
    private static final String CODE_NUMBER = "code";
    private static final String MSG_NUMBER = "message";
    private static Log logger = LogFactory.getLog(ZwyApi.class);
    private static String ZWYTOKENKEY = "tsate_zwytoken_key";

    public static ApiResult taxProve(String submitMonth, String skssqq, String skssqz, String taxCode, String taxType, IdentityData identityData) {
        ApiResult tokenResult = ZwyApi.refreshToken();
        if (!tokenResult.getSuccess()) {
            return tokenResult;
        }
        BaseRequestParams reqparams = ZwyApi.getBaseRequstParams((String)tokenResult.getData(), identityData);
        HashMap<String, Object> businessParams = new HashMap<String, Object>(8);
        businessParams.put("periodBegin", skssqq);
        businessParams.put("periodEnd", skssqz);
        businessParams.put("submitMonth", submitMonth);
        businessParams.put("taxCode", taxCode);
        businessParams.put("taxType", taxType);
        reqparams.addBusinessParams(businessParams);
        reqparams.addExtraInfoParams(ZwyApi.getExtralInfo(identityData));
        reqparams.genSign();
        Map configMap = CommonInfoUtil.getCommonConfigInfo();
        String baseUrl = (String)configMap.get("zwy_base_url");
        String url = baseUrl + "/taxopenservice/auto-tax/tax-info/get/tax/prove";
        String rep = ZwyRequest.doPost(url, new HashMap<String, String>(0), JSON.toJSONString((Object)reqparams));
        JSONObject json = JSON.parseObject((String)rep);
        String code = json.getString(CODE_NUMBER);
        if (!"0".equals(code)) {
            String msg = json.getString(MSG_NUMBER);
            return ApiResult.fail((String)msg);
        }
        return ApiResult.success((Object)rep);
    }

    private static BaseRequestParams getBaseRequstParams(String token, IdentityData identityData) {
        Map configMap = CommonInfoUtil.getCommonConfigInfo();
        String appCode = (String)configMap.get("zwy_app_id");
        String nonce = UUID.randomUUID().toString();
        Long timestamp = System.currentTimeMillis();
        BaseRequestParams reqParams = new BaseRequestParams();
        reqParams.setAppId(appCode);
        reqParams.setNonce(nonce);
        reqParams.setTimestamp(timestamp.toString());
        reqParams.setToken(token);
        if (identityData != null) {
            reqParams.addExtraInfoParams(ZwyApi.getExtralInfo(identityData));
        }
        return reqParams;
    }

    private static Map<String, Object> getExtralInfo(IdentityData identityData) {
        HashMap<String, Object> extraInfo = new HashMap<String, Object>();
        extraInfo.put("username", identityData.getUsername());
        extraInfo.put("password", identityData.getPassword());
        extraInfo.put("taxmanName", identityData.getTaxmanName());
        extraInfo.put("taxmanPwd", identityData.getTaxmanPwd());
        ZwyDfsfMappingEnums dlsfEnum = ZwyDfsfMappingEnums.valueOfKdCode(identityData.getDlsf());
        if (dlsfEnum == null) {
            dlsfEnum = ZwyDfsfMappingEnums.BSR;
        }
        extraInfo.put("dlsf", dlsfEnum.getZwyCode());
        extraInfo.put("dlfs", KddlfsMappingEnums.getDlfsByCode(identityData.getLoginType()));
        HashMap<String, String> additionalExtend = new HashMap<String, String>();
        additionalExtend.put("sfzjhm", identityData.getUsername());
        additionalExtend.put("shPhone", identityData.getTelephoneNum());
        additionalExtend.put("caPwd", identityData.getCapassword());
        additionalExtend.put("rackId", identityData.getJghm());
        additionalExtend.put("rackPort", identityData.getJgport());
        extraInfo.put("additionalExtend", additionalExtend);
        return extraInfo;
    }

    private static ApiResult refreshToken() {
        return KdDirectDeclareService.getToken();
    }

    public static ApiResult declareDataQuery(String taskType, String nsrsbh) {
        ApiResult tokenResult = ZwyApi.refreshToken();
        if (!tokenResult.getSuccess()) {
            return tokenResult;
        }
        BaseRequestParams reqparams = ZwyApi.getBaseRequstParams((String)tokenResult.getData(), null);
        HashMap<String, Object> businessParams = new HashMap<String, Object>(8);
        businessParams.put("infoType", taskType);
        businessParams.put("taxCode", nsrsbh);
        reqparams.addBusinessParams(businessParams);
        reqparams.genSign();
        Map configMap = CommonInfoUtil.getCommonConfigInfo();
        String baseUrl = (String)configMap.get("zwy_base_url");
        String url = baseUrl + "/taxopenservice/auto-tax/tax-info/get/home/information";
        String rep = ZwyRequest.doPost(url, new HashMap<String, String>(0), JSON.toJSONString((Object)reqparams));
        JSONObject json = JSON.parseObject((String)rep);
        String code = json.getString(CODE_NUMBER);
        String msg = json.getString(MSG_NUMBER);
        if (!"0".equals(code)) {
            return ApiResult.fail((String)msg);
        }
        ApiResult successResult = ApiResult.success((Object)rep);
        successResult.setMessage(msg);
        return successResult;
    }

    public static ApiResult downLoadApprovedinfosTask(String nsrsbh) {
        ApiResult tokenResult = ZwyApi.refreshToken();
        if (!tokenResult.getSuccess()) {
            return tokenResult;
        }
        HashMap<String, Object> businessParams = new HashMap<String, Object>(8);
        businessParams.put("taxCode", nsrsbh);
        BaseRequestParams reqParams = ZwyApi.getBaseRequstParamsAndBuildSignInfo((String)tokenResult.getData(), businessParams, ConnectConfigService.queryIdentityDataByNsrsbh(nsrsbh));
        logger.info("zwy approvedInfos task reqparams={}", (Object)JSON.toJSONString((Object)reqParams));
        String rep = ZwyRequest.doPost(ZwyApi.buildUrl("/taxopenservice/auto-tax/tax-info/approvedInfos"), new HashMap<String, String>(0), JSON.toJSONString((Object)reqParams));
        return ZwyApi.dealRespResult(rep);
    }

    public static ApiResult downLoadApprovedInfos(String nsrsbh) {
        ApiResult tokenResult = ZwyApi.refreshToken();
        if (!tokenResult.getSuccess()) {
            return tokenResult;
        }
        HashMap<String, Object> businessParams = new HashMap<String, Object>(8);
        businessParams.put("taxCode", nsrsbh);
        BaseRequestParams reqParams = ZwyApi.getBaseRequstParamsAndBuildSignInfo((String)tokenResult.getData(), businessParams, null);
        logger.info("zwy get approvedInfos reqparams={}", (Object)JSON.toJSONString((Object)reqParams));
        String rep = ZwyRequest.doPost(ZwyApi.buildUrl("/taxopenservice/auto-tax/tax-info/get/approvedInfos"), new HashMap<String, String>(0), JSON.toJSONString((Object)reqParams));
        return ZwyApi.dealRespResult(rep);
    }

    private static ApiResult dealRespResult(String rep) {
        return ZwyApi.dealRespResultByNumber(rep, CODE_NUMBER, MSG_NUMBER);
    }

    private static ApiResult dealRespResultByNumber(String rep, String codeNumber, String msgNumber) {
        JSONObject json = JSON.parseObject((String)rep);
        String code = json.getString(codeNumber);
        String msg = json.getString(msgNumber);
        ApiResult result = !"0".equals(code) ? ApiResult.fail((String)msg) : ApiResult.success((Object)rep);
        result.setErrorCode(code);
        result.setMessage(msg);
        return result;
    }

    private static String buildUrl(String url) {
        Map configMap = CommonInfoUtil.getCommonConfigInfo();
        String baseUrl = (String)configMap.get("zwy_base_url");
        String completeUrl = baseUrl + url;
        return completeUrl;
    }

    private static BaseRequestParams getBaseRequstParamsAndBuildSignInfo(String data, Map<String, Object> businessParams, IdentityData identityData) {
        BaseRequestParams reqparams = ZwyApi.getBaseRequstParams(data, identityData);
        reqparams.addBusinessParams(businessParams);
        reqparams.genSign();
        return reqparams;
    }
}

