/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.task;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.common.ext.cloudcc.beans.UrlParams;
import kd.taxc.tsate.common.ext.cloudcc.utils.HttpUtils;
import kd.taxc.tsate.common.ext.cloudcc.utils.Md5Utils;
import kd.taxc.tsate.common.threadpools.Task;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.FileUploadUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.service.szyh.SzyhRequest;
import org.apache.commons.lang3.time.DateFormatUtils;

public class ShSyncTask
extends Task<Map<String, Object>> {
    private static Log logger = LogFactory.getLog(ShSyncTask.class);
    private static final String VERSION = "1.0";
    private static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String FAIL_STATUS = "fail";
    private static final String SUCCESS_STATUS = "success";
    private static final String DYN_SH = "dynsh";
    private static final String TSATE_DECLARE_SHINFO = "tsate_declare_shinfo";
    private static final String DECLARE_RECORD_CS = "id,org,executetype,executestatus,creator,createtime,channel,detaillog,deallog";
    private static final String DECLARE_DYNSH = "id,org,nsrsbh,status,channel";
    private Map<String, Object> param;

    public ShSyncTask(Map<String, Object> param) {
        this.param = param;
    }

    public List<Map<String, Object>> getValue() {
        return null;
    }

    public Map<String, Object> executor(Map<String, Object> ex) {
        logger.info("\u5f00\u59cb\u6267\u884c:" + Thread.currentThread().getName());
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuilder failedLog = new StringBuilder();
        ApiResult apiResult = null;
        apiResult = this.dynSH(this.param, failedLog);
        map.put("apiResult", apiResult);
        map.put("failedLog", failedLog);
        return map;
    }

    private ApiResult dynSH(Map<String, Object> vo, StringBuilder failedLog) {
        ApiResult apiResult = new ApiResult();
        try {
            StringBuilder reqStringBuilder = new StringBuilder();
            this.dealParamToURL(vo, reqStringBuilder);
            HashMap<String, Object> params = new HashMap<String, Object>();
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String groupId = (String)configMap.get("cloudcc_access_group_id");
            params.put("GroupId", groupId);
            params.put("OrgName", vo.get("OrgName").toString());
            params.put("OrgTaxNum", vo.get("OrgTaxNum").toString());
            params.put("Nsrdzdah", vo.get("OrgTaxNum").toString());
            params.put("OrgId", vo.get("szyh_org_id").toString());
            String response = SzyhRequest.doPost(reqStringBuilder.toString(), null, params);
            logger.info(String.format("cloudcc dynUser resonse: %s \u767b\u5f55\u540d %s", response, vo.get("OrgName").toString()));
            if (StringUtils.isBlank((CharSequence)response)) {
                String message = ResManager.loadKDString((String)"\u540c\u6b65\u7a0e\u53f7\u4efb\u52a1\u72b6\u6001\u8fd4\u56de\u4e3a\u7a7a,\u6267\u884c\u5931\u8d25,\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"ShSyncTask_0", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.get("OrgTaxNum")});
                StringBuilder sb = new StringBuilder();
                sb.append(message);
                ShSyncTask.update_record("3", vo, sb.toString());
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = ShSyncTask.dealResponse(responseMap, vo, DYN_SH);
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25, \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"ShSyncTask_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.get("OrgTaxNum"));
            ShSyncTask.update_record("3", vo, msg);
        }
        return apiResult;
    }

    private void dealParamToURL(Map<String, Object> vo, StringBuilder reqStringBuilder) throws UnsupportedEncodingException {
        Map configMap = CommonInfoUtil.getCommonConfigInfo();
        String baseUrl = (String)configMap.get("cloudcc_base_url");
        String reqUrl = baseUrl + "/servyou/orgService/orgInit";
        String accessKeyId = (String)configMap.get("cloudcc_access_id");
        reqStringBuilder.append(reqUrl);
        String password = (String)configMap.get("cloudcc_access_password");
        String orgName = vo.get("OrgName").toString();
        String orgTaxNum = vo.get("OrgTaxNum").toString();
        UrlParams urlParams = new UrlParams();
        urlParams.setVersion(VERSION);
        urlParams.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
        urlParams.setSignatureNonce(UUID.randomUUID().toString());
        urlParams.setAccessKeyID(accessKeyId);
        ShSyncTask.buildSignature(urlParams, password, reqStringBuilder);
    }

    private static ApiResult dealResponse(Map<String, Object> responseMap, Map<String, Object> vo, String key) throws InterruptedException {
        ApiResult apiResult = new ApiResult();
        if (responseMap != null) {
            if ("200".equals(String.valueOf(responseMap.get("Code")))) {
                DynamicObject[] orgtaxnums = BusinessDataServiceHelper.load((String)TSATE_DECLARE_SHINFO, (String)"id,org,orgtaxnum,orgid", (QFilter[])new QFilter[]{new QFilter("orgtaxnum", "=", (Object)vo.get("OrgTaxNum").toString())});
                DynamicObject dy = null;
                if (orgtaxnums != null && orgtaxnums.length > 0) {
                    dy = orgtaxnums[0];
                } else {
                    dy = BusinessDataServiceHelper.newDynamicObject((String)TSATE_DECLARE_SHINFO);
                    dy.set("id", (Object)DB.genLongId((String)TSATE_DECLARE_SHINFO));
                }
                dy.set("org", vo.get("OrgName"));
                dy.set("orgtaxnum", vo.get("OrgTaxNum"));
                dy.set("orgid", (Object)responseMap.get("orgId").toString());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
                ShSyncTask.update_record("2", vo, responseMap.get("Message").toString());
                apiResult = CustomApiResult.dealResponse(null, responseMap.get("Message").toString(), "3", true);
            } else {
                String msg = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25, \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"ShSyncTask_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.get("OrgTaxNum"));
                ShSyncTask.update_record("3", vo, msg);
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"ShSyncTask_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        return apiResult;
    }

    private static void update_record(String type, Map<String, Object> vo, String message) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)DECLARE_RECORD_CS, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(vo.get("OrgId").toString())).and("executetype", "=", (Object)"TBSH")}, (String)"createtime desc");
        load[0].set("executestatus", (Object)type);
        load[0].set("org", vo.get("OrgId"));
        ShSyncTask.uploadLog(new StringBuilder(message), load[0]);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{load[0]});
        DynamicObject ogs = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_dynsh", (String)DECLARE_DYNSH, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.valueOf(vo.get("OrgId").toString()))});
        ogs.set("status", (Object)type);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ogs});
    }

    private static void buildSignature(UrlParams urlParams, String passWord, StringBuilder url) throws UnsupportedEncodingException {
        String urlParam = HttpUtils.buildUrlParams((UrlParams)urlParams);
        String accessKeySecret = Md5Utils.getEncode((byte[])passWord.getBytes("UTF-8"));
        String signature = Md5Utils.getSignature((byte[])urlParam.getBytes("UTF-8"), (byte[])accessKeySecret.getBytes("UTF-8"));
        urlParams.setSignature(signature);
        url.append("?").append(HttpUtils.buildUrlParams((UrlParams)urlParams));
    }

    private static void uploadLog(StringBuilder log, DynamicObject dynamicObject) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(log.toString().getBytes(StandardCharsets.UTF_8));){
            String billNo = dynamicObject.getString("id");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNo)) {
                TsateDeclareRecordBusiness.setLogDetail((DynamicObject)dynamicObject, (StringBuilder)log);
                String storePath = "/taxc/tsate/msg/" + dynamicObject.getString("id");
                String url = FileUploadUtils.upload((String)(storePath + ".txt"), (String)(dynamicObject.getString("id") + ".txt"), (InputStream)is);
                dynamicObject.set("deallog", (Object)("FILE:" + url));
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }
}

