/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.task;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.common.ext.cloudcc.beans.UrlParams;
import kd.taxc.tsate.common.ext.cloudcc.utils.HttpUtils;
import kd.taxc.tsate.common.ext.cloudcc.utils.Md5Utils;
import kd.taxc.tsate.common.threadpools.Task;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.FileUploadUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.service.szyh.SzyhRequest;
import org.apache.commons.lang3.time.DateFormatUtils;

public class UserSyncTask
extends Task<Map<String, Object>> {
    private static Log logger = LogFactory.getLog(UserSyncTask.class);
    private static final String VERSION = "1.0";
    private static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String DYN_USER = "dynuser";
    private static final String DECLARE_RECORD_YH = "id,executetype,executestatus,creator,createtime,channel,detaillog,deallog";
    private static final String DECLARE_DYNYH = "id,user,status,channel";
    private Map<String, Object> param;

    public List<Map<String, Object>> getValue() {
        return null;
    }

    public UserSyncTask(Map<String, Object> params) {
        this.param = params;
    }

    public Map<String, Object> executor(Map<String, Object> params) {
        logger.info("\u5f00\u59cb\u6267\u884c:" + Thread.currentThread().getName());
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuilder failedLog = new StringBuilder();
        ApiResult apiResult = UserSyncTask.dynUser(this.param, failedLog);
        map.put("apiResult", apiResult);
        map.put("failedLog", failedLog);
        return map;
    }

    public static ApiResult dynUser(Map<String, Object> vo, StringBuilder failedLog) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String baseUrl = (String)configMap.get("cloudcc_base_url");
            String reqUrl = baseUrl + "/servyou/userService/userInit";
            logger.info(reqUrl);
            String accessKeyId = (String)configMap.get("cloudcc_access_id");
            String userName = vo.get("UserName").toString();
            String groupId = (String)configMap.get("cloudcc_access_group_id");
            String orgId = vo.get("OrgId").toString();
            String athorityTpe = (String)configMap.get("cloudcc_access_athoritytpe");
            String userid = vo.get("UserId").toString();
            StringBuilder reqStringBuilder = new StringBuilder(reqUrl);
            String password = (String)configMap.get("cloudcc_access_password");
            UrlParams urlParams = new UrlParams();
            urlParams.setVersion(VERSION);
            urlParams.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
            urlParams.setSignatureNonce(UUID.randomUUID().toString());
            urlParams.setAccessKeyID(accessKeyId);
            UserSyncTask.buildSignature(urlParams, password, reqStringBuilder);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("UserName", userName);
            params.put("GroupId", groupId);
            params.put("UserId", userid);
            params.put("OrgId", "");
            params.put("AthorityTpe", athorityTpe);
            logger.info(((Object)params).toString());
            String response = SzyhRequest.doPost(reqStringBuilder.toString(), null, params);
            logger.info(String.format("cloudcc dynUser resonse: %s \u767b\u5f55\u540d %s", response, userName));
            if (StringUtils.isBlank((CharSequence)response)) {
                String msg = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u7528\u6237\u4efb\u52a1\u72b6\u6001\u8fd4\u56de\u4e3a\u7a7a,\u7528\u6237\u5de5\u53f7\uff1a%s", (String)"UserSyncTask_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.get("UserName"));
                UserSyncTask.update_record("3", vo, msg);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = UserSyncTask.dealResponse(responseMap, vo, DYN_USER);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u767b\u5f55\u540d %s", e.getMessage(), vo.get("UserName").toString()));
            String msg = String.format(ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38,\u7528\u6237\u5de5\u53f7\uff1a%s", (String)"UserSyncTask_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.get("UserName"));
            UserSyncTask.update_record("3", vo, msg);
        }
        return apiResult;
    }

    private static ApiResult dealResponse(Map<String, Object> responseMap, Map<String, Object> vo, String key) throws InterruptedException {
        ApiResult apiResult = new ApiResult();
        if (responseMap != null) {
            if ("200".equals(String.valueOf(responseMap.get("Code")))) {
                DynamicObject[] users = BusinessDataServiceHelper.load((String)"tsate_declare_userinfo", (String)"id,number,userid", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)vo.get("UserName").toString())});
                DynamicObject dy = null;
                if (users != null && users.length > 0) {
                    dy = users[0];
                } else {
                    dy = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_userinfo");
                    dy.set("id", (Object)DB.genLongId((String)"tsate_declare_userinfo"));
                }
                dy.set("number", (Object)vo.get("UserName").toString());
                dy.set("userid", (Object)responseMap.get("UserId").toString());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dy});
                String msg = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\uff0c\u7528\u6237\u5de5\u53f7\uff1a%s", (String)"UserSyncTask_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.get("UserName"));
                UserSyncTask.update_record("2", vo, msg);
            } else {
                String msg = String.format(ResManager.loadKDString((String)"\u7528\u6237\u5de5\u53f7\uff1a%s", (String)"UserSyncTask_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.get("UserName"));
                UserSyncTask.update_record("3", vo, msg);
            }
        }
        return apiResult;
    }

    private static void update_record(String type, Map<String, Object> vo, String message) {
        DynamicObject[] yhs = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)DECLARE_RECORD_YH, (QFilter[])new QFilter[]{new QFilter("deallog", "=", (Object)vo.get("deallog").toString()).and("executetype", "=", (Object)"TBYH")}, (String)"createtime desc");
        yhs[0].set("executestatus", (Object)type);
        UserSyncTask.uploadLog(new StringBuilder(message), yhs[0]);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{yhs[0]});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", vo.get("UserName"))});
        DynamicObject ogs = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_dynuser", (String)DECLARE_DYNYH, (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)dynamicObject.getLong("id"))});
        ogs.set("status", (Object)type);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ogs});
    }

    private static void buildSignature(UrlParams urlParams, String passWord, StringBuilder url) throws UnsupportedEncodingException {
        String urlParam = HttpUtils.buildUrlParams((UrlParams)urlParams);
        String accessKeySecret = Md5Utils.getEncode((byte[])passWord.getBytes("UTF-8"));
        String signature = Md5Utils.getSignature((byte[])urlParam.getBytes("UTF-8"), (byte[])accessKeySecret.getBytes("UTF-8"));
        urlParams.setSignature(signature);
        url.append("?").append(HttpUtils.buildUrlParams((UrlParams)urlParams));
    }

    private static void uploadLog(StringBuilder log, DynamicObject dynamicObject) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(log.toString().getBytes(StandardCharsets.UTF_8));){
            String billNo = dynamicObject.getString("id");
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)billNo)) {
                TsateDeclareRecordBusiness.setLogDetail((DynamicObject)dynamicObject, (StringBuilder)log);
                String storePath = "/taxc/tsate/msg/" + dynamicObject.getString("id");
                String url = FileUploadUtils.upload((String)(storePath + ".txt"), (String)(dynamicObject.getString("id") + ".txt"), (InputStream)is);
                dynamicObject.set("deallog", (Object)("FILE:" + url));
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }
}

