/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.event.DeclareMainStatusChangedEventBusiness;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.FileUploadUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import org.apache.commons.lang3.StringUtils;

public class DirectDeclareLogUtils {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static Log logger = LogFactory.getLog(DirectDeclareLogUtils.class);

    public static void updateDeclareStatusCompatible(String sbbid, Long recordId, String updateType, String declareStatus, String executStatus, StringBuilder failedLog) {
        DirectDeclareLogUtils.updateDeclareStatusCompatible(sbbid, recordId, updateType, declareStatus, executStatus, failedLog, false);
    }

    public static void updateDeclareStatusCompatible(String sbbid, Long recordId, String updateType, String declareStatus, String executStatus, StringBuilder failedLog, boolean awaysLog) {
        DynamicObject newData;
        DynamicObject oldData;
        try (TXHandle tx = TX.required();){
            DynamicObject declare = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)Long.valueOf(sbbid));
            DynamicObject recordObj = TsateDeclareRecordBusiness.getRecordById((Long)recordId);
            if (declare == null || recordObj == null) {
                logger.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7533\u62a5\u8868\u4e3b\u8868\u8bb0\u5f55\u6216\u62a5\u7a0e\u4efb\u52a1\u76d1\u63a7\u8bb0\u5f55 sbbid={} recordId={}", (Object)sbbid, (Object)recordId);
                return;
            }
            try {
                oldData = DeclareMainStatusChangedEventBusiness.copyData((DynamicObject)declare);
                String sbStatus = declare.getString("declarestatus");
                String kkStatus = declare.getString("paystatus");
                DeclareOperationEnum operation = null;
                if (!"editing".equals(sbStatus) && "declarestatus".equals(updateType)) {
                    declare.set(updateType, (Object)declareStatus);
                    operation = DeclareOperationEnum.DIRECTDECLARE;
                    if ("declared".equals(declareStatus)) {
                        operation = DeclareOperationEnum.APPLY;
                        BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
                        if (BigDecimal.ZERO.compareTo(bqybtse) >= 0) {
                            declare.set("paystatus", (Object)"nopay");
                        }
                    } else if ("declarefailed".equals(declareStatus) || "editing".equals(declareStatus)) {
                        ConnectConfigService.dealFkxx(null, sbbid, false);
                        if ("editing".equals(declareStatus)) {
                            if ("payfailed".equals(kkStatus)) {
                                declare.set("paystatus", (Object)"unpaid");
                            }
                            declare.set("modifytime", (Object)new Date());
                            declare.set("modifier", (Object)RequestContext.get().getCurrUserId());
                            declare.set("declaremethod", (Object)"");
                            declare.set("paytype", (Object)"");
                            declare.set("sbrq", null);
                            declare.set("paydate", null);
                            declare.set("payer", (Object)0L);
                            declare.set("declarer", (Object)0L);
                        }
                    }
                }
                if ("paystatus".equals(updateType)) {
                    operation = DeclareOperationEnum.DIRECTPAY;
                    declare.set(updateType, (Object)declareStatus);
                    if ("paid".equals(declareStatus)) {
                        operation = DeclareOperationEnum.PAY;
                        declare.set("paytype", (Object)"1");
                        declare.set("paydate", (Object)new Date());
                    } else if ("unpaid".equals(declareStatus)) {
                        declare.set("modifytime", (Object)new Date());
                        declare.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        declare.set("paytype", (Object)"");
                        declare.set("paydate", null);
                        declare.set("payer", (Object)0L);
                    } else if ("nopay".equals(declareStatus)) {
                        declare.set("modifytime", (Object)new Date());
                        declare.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        declare.set("paytype", (Object)"");
                        declare.set("paydate", null);
                        declare.set("payer", null);
                    }
                }
                newData = declare;
                DeclarationMainFormBusniess.updateSingleDeclareMainTable((DynamicObject)declare, (DeclareOperationEnum)operation);
                if (recordObj != null) {
                    boolean statuseChange = false;
                    if (!StringUtils.equals((CharSequence)executStatus, (CharSequence)recordObj.getString("executestatus"))) {
                        recordObj.set("modifytime", (Object)new Date());
                        recordObj.set("executestatus", (Object)executStatus);
                        statuseChange = true;
                    }
                    if (statuseChange || awaysLog) {
                        DirectDeclareLogUtils.uploadLog(failedLog, recordObj);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("\u66f4\u65b0\u7533\u62a5\u6216\u6263\u6b3e\u72b6\u6001\u5931\u8d25 %s %s", ExceptionUtils.getExceptionStackTraceMessage((Exception)e), sbbid));
                throw new KDBizException(e.getMessage());
            }
        }
        DeclareMainStatusChangedEventBusiness.convertDataAndSendEvent((DynamicObject)oldData, (DynamicObject)newData);
    }

    public static void updateDeclareStatusAndBackupData(String sbbid, Long recordId, String updateType, String declareStatus, String executStatus, StringBuilder failedLog) {
        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(sbbid, recordId, updateType, declareStatus, executStatus, failedLog, false);
    }

    public static void updateDeclareStatusAndBackupData(String sbbid, Long recordId, String updateType, String declareStatus, String executStatus, StringBuilder failedLog, boolean awaysLog) {
        DynamicObject newData;
        DynamicObject oldData;
        DeclareOperationEnum operation = null;
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(sbbid), (String)"tcvat_nsrxx");
                oldData = DeclareMainStatusChangedEventBusiness.copyData((DynamicObject)declare);
                DynamicObject recordObj = null;
                if (recordId != null) {
                    recordObj = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)"tsate_declare_record");
                }
                String sbStatus = declare.getString("declarestatus");
                String kkStatus = declare.getString("paystatus");
                String type = declare.getString("type");
                if (!"editing".equals(sbStatus) && "declarestatus".equals(updateType)) {
                    operation = DeclareOperationEnum.DIRECTDECLARE;
                    declare.set(updateType, (Object)declareStatus);
                    if ("declared".equals(declareStatus)) {
                        operation = DeclareOperationEnum.APPLY;
                        try {
                            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualDeclare", (Object[])new Object[]{Collections.singletonList(declare.getLong("id"))});
                        }
                        catch (Exception e) {
                            logger.error(String.format("\u8c03\u7528\u7f34\u7eb3\u5355\u63a5\u53e3\u5f02\u5e38 \u7533\u62a5\u72b6\u6001 %s %s", e, sbbid));
                        }
                        BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
                        if (BigDecimal.ZERO.compareTo(bqybtse) >= 0) {
                            declare.set("paystatus", (Object)"nopay");
                        }
                    } else if ("declarefailed".equals(declareStatus) || "editing".equals(declareStatus)) {
                        ConnectConfigService.dealFkxx(null, sbbid, false);
                        if ("editing".equals(declareStatus)) {
                            if ("payfailed".equals(kkStatus)) {
                                declare.set("paystatus", (Object)"unpaid");
                            }
                            declare.set("modifytime", (Object)new Date());
                            declare.set("modifier", (Object)RequestContext.get().getUserId());
                            declare.set("declaretype", (Object)"");
                            declare.set("paytype", (Object)"");
                            declare.set("sbrq", null);
                            declare.set("paydate", null);
                            declare.set("payer", (Object)0L);
                            declare.set("declarer", (Object)0L);
                        }
                    }
                }
                if ("paystatus".equals(updateType)) {
                    operation = DeclareOperationEnum.DIRECTPAY;
                    declare.set(updateType, (Object)declareStatus);
                    if ("paid".equals(declareStatus)) {
                        operation = DeclareOperationEnum.PAY;
                        declare.set("paytype", (Object)"1");
                        declare.set("paydate", (Object)new Date());
                    } else if ("unpaid".equals(declareStatus)) {
                        declare.set("modifytime", (Object)new Date());
                        declare.set("modifier", (Object)RequestContext.get().getUserId());
                        declare.set("paytype", (Object)"");
                        declare.set("paydate", null);
                        declare.set("payer", (Object)0L);
                    } else if ("nopay".equals(declareStatus)) {
                        declare.set("modifytime", (Object)new Date());
                        declare.set("modifier", (Object)RequestContext.get().getUserId());
                        declare.set("paytype", (Object)"");
                        declare.set("paydate", null);
                        declare.set("payer", null);
                    }
                }
                newData = declare;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{declare});
                if ("paystatus".equals(updateType) && "paid".equals(declareStatus)) {
                    try {
                        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualPay", (Object[])new Object[]{Collections.singletonList(declare.getLong("id"))});
                    }
                    catch (Exception e) {
                        logger.error(String.format("\u8c03\u7528\u7f34\u7eb3\u5355\u63a5\u53e3\u5f02\u5e38  %s %s", ExceptionUtils.getExceptionStackTraceMessage((Exception)e), sbbid));
                    }
                }
                if (recordObj != null) {
                    boolean statuseChange = false;
                    if (!StringUtils.equals((CharSequence)executStatus, (CharSequence)recordObj.getString("executestatus"))) {
                        recordObj.set("modifytime", (Object)new Date());
                        recordObj.set("executestatus", (Object)executStatus);
                        statuseChange = true;
                    }
                    if (statuseChange || awaysLog) {
                        DirectDeclareLogUtils.uploadLog(failedLog, recordObj);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(String.format("\u66f4\u65b0\u7533\u62a5\u6216\u6263\u6b3e\u72b6\u6001\u5931\u8d25 %s %s", ExceptionUtils.getExceptionStackTraceMessage((Exception)e), sbbid));
                throw new KDBizException(e.getMessage());
            }
        }
        DeclarationMainFormBusniess.syncModel2DataToModel3((Long)Long.valueOf(sbbid));
        DeclarationMainFormBusniess.fireModel2DeclareMainChangeEvent((DynamicObject)newData, (DeclareOperationEnum)operation);
        DeclareMainStatusChangedEventBusiness.convertDataAndSendEvent((DynamicObject)oldData, (DynamicObject)newData);
    }

    public static void updateStatus(Long id, String executStatus, StringBuilder failedLog) {
        DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tsate_declare_record");
        if (StringUtils.equals((CharSequence)recordObj.getString("executestatus"), (CharSequence)"1")) {
            DirectDeclareLogUtils.uploadLog(failedLog, recordObj);
            recordObj.set("modifytime", (Object)new Date());
            recordObj.set("executestatus", (Object)executStatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
        }
    }

    public static void updateTaxPeriod(Long id, String taxType, Date skssqq, Date skssqz) {
        DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tsate_declare_record");
        if (StringUtils.equals((CharSequence)recordObj.getString("executestatus"), (CharSequence)"1")) {
            recordObj.set("skssqq", (Object)skssqq);
            recordObj.set("skssqz", (Object)skssqz);
            recordObj.set("type", (Object)taxType);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
        }
    }

    private static void uploadLog(StringBuilder log, DynamicObject dynamicObject) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(log.toString().getBytes(StandardCharsets.UTF_8));){
            String billNo = dynamicObject.getString("billno");
            if (StringUtils.isNotBlank((CharSequence)billNo)) {
                if (log != null && kd.bos.util.StringUtils.isNotEmpty((String)log.toString())) {
                    TsateDeclareRecordBusiness.setLogDetail((DynamicObject)dynamicObject, (StringBuilder)log);
                    String storePath = "/taxc/tsate/msg/" + dynamicObject.getString("billno");
                    String url = FileUploadUtils.upload((String)(storePath + ".txt"), (String)(dynamicObject.getString("billno") + ".txt"), (InputStream)is);
                    dynamicObject.set("deallog", (Object)("FILE:" + url));
                } else {
                    logger.info("\u65e5\u5fd7\u4fe1\u606f\u4e3a\u7a7a\u4e0d\u8bb0\u5f55");
                    dynamicObject.set("deallog", (Object)"");
                }
            }
        }
        catch (IOException e) {
            logger.error("DirectDeclareLogUtils uploadLog", (Object)e.getMessage());
        }
    }

    public static void uploadLogById(StringBuilder log, Long recordId) {
        DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)"tsate_declare_record");
        DirectDeclareLogUtils.uploadLog(log, recordObj);
        recordObj.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
    }

    public static void dealPicxx(Map<String, Object> info, Long recordId) {
        DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((Object)recordId, (String)"tsate_declare_record");
        if (recordObj != null) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(JsonUtil.toJson(info).getBytes(StandardCharsets.UTF_8));){
                String billNo = recordObj.getString("billno");
                if (StringUtils.isNotBlank((CharSequence)billNo)) {
                    String storePath = "/taxc/tsate/data/" + recordObj.getString("billno");
                    String url = FileUploadUtils.upload((String)(storePath + ".txt"), (String)(recordObj.getString("billno") + ".txt"), (InputStream)is);
                    recordObj.set("piclog", (Object)url);
                }
            }
            catch (IOException e) {
                logger.error("DirectDeclareLogUtils dealPicxx", (Object)e.getMessage());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
        }
    }

    public static void dealDetailLog(StringBuilder log, Long id) {
        if (EmptyCheckUtils.isNotEmpty((Object)id)) {
            DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tsate_declare_record");
            if (StringUtils.isNotBlank((CharSequence)recordObj.getString("detaillog_tag"))) {
                StringBuilder recordLog = new StringBuilder(recordObj.getString("detaillog_tag")).append(SEPARATOR);
                recordLog.append((CharSequence)log);
                recordObj.set("detaillog_tag", (Object)recordLog.toString());
            } else {
                recordObj.set("detaillog_tag", (Object)log.toString());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
        }
    }
}

