/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.util;

import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import kd.taxc.tsate.common.util.ByteUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GxSM3Util {
    private static final String ENCODING = "UTF-8";

    public static String encrypt(String src) {
        return ByteUtils.toHexString((byte[])GxSM3Util.getEncryptBySrcByte(src.getBytes()));
    }

    public static byte[] getEncryptBySrcByte(byte[] srcByte) {
        SM3Digest sm3 = new SM3Digest();
        sm3.update(srcByte, 0, srcByte.length);
        byte[] encryptByte = new byte[sm3.getDigestSize()];
        sm3.doFinal(encryptByte, 0);
        return encryptByte;
    }

    public static String encrypt(String src, String key) throws Exception {
        return ByteUtils.toHexString((byte[])GxSM3Util.getEncryptByKey(src, key));
    }

    public static byte[] getEncryptByKey(String src, String key) throws Exception {
        byte[] srcByte = src.getBytes(ENCODING);
        byte[] keyByte = key.getBytes(ENCODING);
        KeyParameter keyParameter = new KeyParameter(keyByte);
        SM3Digest sm3 = new SM3Digest();
        HMac hMac = new HMac((Digest)sm3);
        hMac.init((CipherParameters)keyParameter);
        hMac.update(srcByte, 0, srcByte.length);
        byte[] result = new byte[hMac.getMacSize()];
        hMac.doFinal(result, 0);
        return result;
    }

    public static boolean verify(String src, String sm3HexStr) throws Exception {
        byte[] sm3HashCode = ByteUtils.fromHexString((String)sm3HexStr);
        byte[] newHashCode = GxSM3Util.getEncryptBySrcByte(src.getBytes(ENCODING));
        return Arrays.equals(newHashCode, sm3HashCode);
    }

    public static boolean verify(String src, String key, String sm3HexStr) throws Exception {
        byte[] sm3HashCode = ByteUtils.fromHexString((String)sm3HexStr);
        byte[] newHashCode = GxSM3Util.getEncryptByKey(src, key);
        return Arrays.equals(newHashCode, sm3HashCode);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

