/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.util;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import kd.taxc.tsate.common.util.ByteUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class GxSM4Util {
    private static final String ENCODING = "UTF-8";
    private static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE = 128;

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    public static byte[] autoGenerateKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    public static String encryptByEcb(String srcStr, String key) throws Exception {
        byte[] keyData = ByteUtils.fromHexString((String)key);
        byte[] srcData = srcStr.getBytes(ENCODING);
        byte[] cipherArray = GxSM4Util.encrypt_Ecb_Padding(keyData, srcData);
        return ByteUtils.toHexString((byte[])cipherArray);
    }

    public static byte[] encrypt_Ecb_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = GxSM4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    public static String decryptEcb(String hexKey, String cipherText) throws Exception {
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] srcData = GxSM4Util.decrypt_Ecb_Padding(keyData, cipherData);
        return new String(srcData, ENCODING);
    }

    public static byte[] decrypt_Ecb_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = GxSM4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static boolean verifyByEcb(String hexKey, String cipherText, String paramStr) throws Exception {
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] decryptData = GxSM4Util.decrypt_Ecb_Padding(keyData, cipherData);
        byte[] srcData = paramStr.getBytes(ENCODING);
        return Arrays.equals(decryptData, srcData);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

