/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.DBUtils;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.FileUploadUtils;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbpzMessageVo;
import kd.taxc.tsate.msmessage.enums.DeclareFileSuffixNameEnum;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;

public class SbpzRecordSaveUtils {
    private static Log logger = LogFactory.getLog(SbpzRecordSaveUtils.class);

    public static void saveRecord(SBMessageBaseVo vo, InputStream in, String fileName, String suffixName, StringBuilder failedLog) {
        DynamicObject dyn = SbpzRecordSaveUtils.saveNewSbpzRecord(vo);
        Long pzId = dyn.getLong("id");
        String number = dyn.getString("billno");
        String fileName_end = SbpzRecordSaveUtils.getFileName(fileName, DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SBQJ), (String)"yyyy-MM"), number, suffixName);
        FileUploadUtils.uploadAttachment((String)fileName_end, (InputStream)in, (String)"tsate_sbpz_admin", (Object)pzId, (String)"tsate");
        DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
    }

    public static void saveRecordBatch(SBMessageBaseVo vo, List<Map<String, Object>> files, StringBuilder failedLog) {
        DynamicObject dyn = SbpzRecordSaveUtils.saveNewSbpzRecord(vo);
        Long pzId = dyn.getLong("id");
        String number = dyn.getString("billno");
        for (Map<String, Object> file : files) {
            String fileName_end = SbpzRecordSaveUtils.getFileName(String.valueOf(file.get("orgName")), DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SBQJ), (String)"yyyy-MM"), number, String.valueOf(file.get("filename")));
            FileUploadUtils.uploadAttachment((String)fileName_end, (InputStream)((InputStream)file.get("inputstream")), (String)"tsate_sbpz_admin", (Object)pzId, (String)"tsate");
        }
        DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
    }

    private static DynamicObject saveNewSbpzRecord(SBMessageBaseVo vo) {
        String declareTypeNumber = vo.getString(SbpzMessageVo.Key.TYPENUMBER);
        String taxType = vo.getString(SbpzMessageVo.Key.TAXTYPE);
        Long taxTypeId = SbpzRecordSaveUtils.getTaxtypeId(taxType);
        Date skssqq = vo.getDate(SbpzMessageVo.Key.SKSSQQ);
        Date skssqz = vo.getDate(SbpzMessageVo.Key.SKSSQZ);
        QFilter filter = new QFilter("org", "=", (Object)Long.valueOf(vo.getOrg())).and("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz).and("datasource", "=", (Object)"1").and("name", "=", (Object)vo.getPzTypeName());
        if (StringUtils.isNotEmpty((String)declareTypeNumber)) {
            filter.and("declaretype", "=", (Object)declareTypeNumber);
        } else {
            filter.and(new QFilter("declaretype", "is null", (Object)declareTypeNumber).or("declaretype", "=", (Object)" "));
        }
        if (taxTypeId != null) {
            filter.and("taxtype", "=", (Object)taxTypeId);
        } else {
            filter.and(new QFilter("taxtype", "is null", (Object)taxTypeId).or("taxtype", "=", (Object)0L));
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"tsate_sbpz_admin", (String)"id", (QFilter[])new QFilter[]{filter});
        if (load != null && load.length > 0) {
            List ids = Arrays.stream(load).map(o -> o.getLong("id")).collect(Collectors.toList());
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"tsate_sbpz_admin");
            BusinessDataServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])ids.toArray());
            List idss = Arrays.stream(load).map(o -> o.getString("id")).collect(Collectors.toList());
            DynamicObject[] loads = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"id", (QFilter[])new QFilter[]{new QFilter("finterid", "in", idss)});
            List attIds = Arrays.stream(loads).map(o -> o.getPkValue()).collect(Collectors.toList());
            MainEntityType dataEntity = EntityMetadataCache.getDataEntityType((String)"bos_attachment");
            BusinessDataServiceHelper.delete((IDataEntityType)dataEntity, (Object[])attIds.toArray());
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_sbpz_admin");
        long pzId = DBUtils.getLongId((String)"tsate_sbpz_admin");
        dynamicObject.set("id", (Object)pzId);
        dynamicObject.set("sbqj", (Object)vo.getDate(SbpzMessageVo.Key.SBQJ));
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String number = codeRuleService.getNumber("tsate_sbpz_admin", dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        dynamicObject.set("name", (Object)vo.getPzTypeName());
        dynamicObject.set("org", (Object)Long.valueOf(vo.getOrg()));
        dynamicObject.set("datasource", (Object)"1");
        Date date = new Date();
        dynamicObject.set("createtime", (Object)date);
        dynamicObject.set("modifytime", (Object)date);
        dynamicObject.set("billstatus", (Object)"C");
        DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((Object)vo.getId(), (String)"tsate_declare_record");
        if (recordObj != null) {
            dynamicObject.set("creater", recordObj.get("creator"));
            dynamicObject.set("modifier", recordObj.get("creator"));
        }
        dynamicObject.set("declaretype", (Object)declareTypeNumber);
        dynamicObject.set("taxtype", (Object)taxTypeId);
        dynamicObject.set("isarchive", (Object)0);
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("skssqz", (Object)skssqz);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    public static void dealUrlAndSave(String screenUrl, SupplierEnum supplier, SBMessageBaseVo vo) {
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
        String name = ((DynamicObject)org.get("org")).getString("name");
        String fileType = screenUrl.substring(screenUrl.lastIndexOf("."));
        if (fileType.contains("?")) {
            int i = fileType.indexOf(63);
            fileType = fileType.substring(0, i);
        }
        String suffixName = DeclareFileSuffixNameEnum.valueOfType(vo.getOperationType()) + fileType;
        InputStream in = null;
        try {
            screenUrl = FileUploadUtils.dealWithGatewayUrl((String)screenUrl, (SupplierEnum)supplier);
            URL url = new URL(screenUrl);
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String proxyUrl = (String)configMap.get("kd_file_proxy");
            if (StringUtils.isNotEmpty((String)proxyUrl)) {
                String[] values = proxyUrl.trim().split(":");
                if (values.length < 2) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u914d\u7f6e\u683c\u5f0f\u9519\u8bef", (String)"KdMessageSendServiceImpl_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(values[0], Integer.parseInt(values[1])));
                in = url.openConnection(proxy).getInputStream();
            } else {
                in = url.openStream();
            }
            DynamicObject dyn = SbpzRecordSaveUtils.saveNewSbpzRecord(vo);
            Long pzId = dyn.getLong("id");
            String fileName_end = SbpzRecordSaveUtils.getFileNameForQxy(name, vo.getString(SbpzMessageVo.Key.TYPENUMBER), DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SKSSQQ), (String)"yyyy-MM-dd"), DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SKSSQZ), (String)"yyyy-MM-dd"), suffixName);
            boolean uploadFileSuccess = FileUploadUtils.uploadAttachment((String)fileName_end, (InputStream)in, (String)"tsate_sbpz_admin", (Object)pzId, (String)"tsate");
            if (!uploadFileSuccess) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25\u3002", (String)"SbpzRecordSaveUtils_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error("message" + e.getMessage());
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u548c\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38:" + ExceptionUtil.toString((Exception)e));
            String msg = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6587\u4ef6\u548c\u6570\u636e\u65f6\u51fa\u73b0\u5f02\u5e38: %s", (String)"SbpzRecordSaveUtils_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), e.getMessage());
            throw new KDBizException(msg);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38");
                }
            }
        }
    }

    private static String getFileName(String org, String sbqj, String number, String suffixName) {
        StringBuilder fileName = new StringBuilder(org).append("-").append(sbqj).append("-").append(number).append("-").append(suffixName);
        return fileName.toString();
    }

    private static String getFileNameForQxy(String org, String declareTypeNumber, String skssqq, String skssqz, String suffixName) {
        StringBuilder fileName = new StringBuilder(org).append("-").append(DeclareTypeEnum.getNameByCode((String)declareTypeNumber)).append("-").append(skssqq).append("-").append(skssqz).append("-").append(suffixName);
        return fileName.toString();
    }

    private static Long getTaxtypeId(String taxTypeNumber) {
        if (StringUtils.isEmpty((String)taxTypeNumber)) {
            return null;
        }
        QFilter filter = new QFilter("number", "=", (Object)taxTypeNumber);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_taxcategory", (String)"id,number", (QFilter[])new QFilter[]{filter});
        return dyn.getLong("id");
    }
}

