/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.msmessage.exception.MessageException;
import kd.taxc.tsate.velocity.tools.VelocityToolsRegister;
import org.apache.commons.io.FilenameUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VmTemplateUtils {
    private static Log logger = LogFactory.getLog(VmTemplateUtils.class);
    private static final Set<String> TEMPLATE_LIST = new HashSet<String>(16);
    private static String BASE_PATH = System.getProperty("user.home") + File.separator;
    private static String USERDIRECTIVE = "kd.taxc.tsate.velocity.Calculate,kd.taxc.tsate.velocity.Mapping,kd.taxc.tsate.velocity.Query,kd.taxc.tsate.velocity.CalculateSavaValue";

    public static String generateFromTemplate(String templatePath, Map<?, ?> contentMap) {
        StringWriter stringWriter = new StringWriter();
        try {
            logger.info("\u83b7\u53d6\u914d\u7f6e\u6a21\u677f" + templatePath);
            File templateFile = VmTemplateUtils.getConfigFile(templatePath);
            if (templateFile == null || !templateFile.exists()) {
                String msg = ResManager.loadKDString((String)"\u6d88\u606f\u6a21\u677f[%s]\u4e0d\u5b58\u5728\u3002", (String)"VmTemplateUtils_5", (String)"taxc-tsate-mservice", (Object[])new Object[]{templatePath});
                logger.info(msg);
                throw new MessageException(msg);
            }
            Properties properties = new Properties();
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put("data", contentMap);
            VelocityToolsRegister.toolsInject(velocityContext, templatePath);
            String filePath = templateFile.getParentFile().getAbsolutePath();
            logger.info("\u6839\u636e\u6a21\u677f\u751f\u6210\u5185\u5bb9" + filePath);
            properties.put("file.resource.loader.class", "kd.taxc.tsate.velocity.resourceloader.KdResourceLoader");
            properties.setProperty("file.resource.loader.path", filePath);
            properties.setProperty("UTF-8", "UTF-8");
            properties.setProperty("resource.default_encoding", "UTF-8");
            properties.setProperty("userdirective", USERDIRECTIVE);
            VelocityEngine velocityEngine = new VelocityEngine();
            velocityEngine.init(properties);
            String fileName = templateFile.getName();
            Template template = velocityEngine.getTemplate(fileName);
            template.merge((Context)velocityContext, (Writer)stringWriter);
        }
        catch (Exception e) {
            logger.error("VmTemplateUtils generateFromTemplate" + ExceptionUtil.toString((Exception)e));
        }
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getConfigFile(String template) throws IOException {
        String templatePath = FilenameUtils.getPath((String)template) + FilenameUtils.getName((String)template);
        String fileName = BASE_PATH + templatePath;
        File file = new File(FilenameUtils.normalize((String)fileName));
        file.getParentFile().mkdirs();
        if (!TEMPLATE_LIST.contains(fileName) || !file.exists()) {
            try (InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(FilenameUtils.normalize((String)templatePath));
                 FileOutputStream fos = new FileOutputStream(FilenameUtils.normalize((String)fileName));){
                int length;
                if (inStream == null) {
                    File file2 = null;
                    return file2;
                }
                byte[] b = new byte[1024];
                while ((length = inStream.read(b)) > 0) {
                    fos.write(b, 0, length);
                }
            }
            catch (Exception e) {
                logger.error("VmTemplateUtils getConfigFile", (Object)e.getMessage());
            }
            finally {
                TEMPLATE_LIST.add(fileName);
            }
        }
        return file;
    }
}

