/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msxml.domain;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.msmessage.util.VmTemplateUtils;
import kd.taxc.tsate.msxml.domain.XmlSchemaField;
import kd.taxc.tsate.msxml.domain.XmlSchemaItem;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlSchema {
    private static Log logger = LogFactory.getLog(XmlSchema.class);
    private static String SCHEMA = "schema";
    private static String FIELD = "field";
    private static String INTERFACE_COMMON = "common";
    private static Map<String, List<XmlSchemaItem>> xmlItemMap = new HashMap<String, List<XmlSchemaItem>>(16);

    private XmlSchema() {
    }

    private static void loadInit(String type) {
        String path = "schema/" + type + ".xml";
        try {
            File templateFile = VmTemplateUtils.getConfigFile(path);
            if (templateFile != null) {
                XmlSchema.load(type, templateFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void load(String type, File file) throws Exception {
        List xmlItemList = xmlItemMap.getOrDefault(type, new ArrayList());
        xmlItemList.clear();
        SAXReader reader = new SAXReader();
        Document document = reader.read(file);
        Element root = document.getRootElement();
        List lstElement = root.elements(SCHEMA);
        Element currentInterface = null;
        for (int i = 0; i < lstElement.size(); ++i) {
            XmlSchemaItem interfaceItem = new XmlSchemaItem();
            currentInterface = (Element)lstElement.get(i);
            XmlSchema.attributeToObject(currentInterface, interfaceItem);
            interfaceItem.setType(type);
            List lstField = currentInterface.elements(FIELD);
            for (int j = 0; j < lstField.size(); ++j) {
                XmlSchemaField xmlField = new XmlSchemaField();
                Element currentTB = (Element)lstField.get(j);
                XmlSchema.attributeToObject(currentTB, xmlField);
                interfaceItem.addInterfaceField(xmlField);
            }
            xmlItemList.add(interfaceItem);
        }
        xmlItemMap.put(type, xmlItemList);
    }

    private static void attributeToObject(Element element, Object object) throws IllegalArgumentException, IllegalAccessException {
        AccessibleObject[] fields = object.getClass().getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            if (!((Field)field).getType().isAssignableFrom(String.class)) continue;
            String value = XmlSchema.getData(element.attributeValue(((Field)field).getName()));
            ((Field)field).set(object, value);
        }
    }

    public static XmlSchemaItem getXmlItemByName(String interfaceName) {
        return XmlSchema.getXmlItemByName(INTERFACE_COMMON, interfaceName);
    }

    public static XmlSchemaItem getXmlItemByName(String type, String interfaceName) {
        if (StringUtils.isBlank((CharSequence)interfaceName)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u63a5\u53e3\u914d\u7f6e\u7c7b\u578b\u4f20\u5165\u4e3a\u7a7a!", (String)"XmlSchema_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        XmlSchemaItem temp = null;
        if (!xmlItemMap.containsKey(type)) {
            XmlSchema.loadInit(type);
        }
        List xmlItemList = xmlItemMap.getOrDefault(type, new ArrayList());
        for (int i = 0; xmlItemList != null && i < xmlItemList.size(); ++i) {
            try {
                temp = (XmlSchemaItem)xmlItemList.get(i);
                if (temp == null || !temp.getName().equalsIgnoreCase(interfaceName)) continue;
                return temp;
            }
            catch (Exception e) {
                logger.error("XmlSchema XmlSchemaItem", (Object)e.getMessage());
            }
        }
        return null;
    }

    public static String getData(String data) {
        return data == null ? "" : data.trim();
    }

    static {
        XmlSchema.loadInit(INTERFACE_COMMON);
    }
}

