/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msxml.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.common.util.BigDecimalUtil;
import kd.taxc.tsate.msxml.domain.XmlData;
import kd.taxc.tsate.msxml.domain.XmlSchema;
import kd.taxc.tsate.msxml.domain.XmlSchemaField;
import kd.taxc.tsate.msxml.domain.XmlSchemaItem;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class XmlSchemaUtils {
    private static Log logger = LogFactory.getLog(XmlSchemaUtils.class);
    private static String ELEMENT_MUST_EXIST = "M";
    private static String ELEMENT_TYPE_LIST = "List";
    private static String ELEMENT_TYPE_DATE = "Date";
    private static String ELEMENT_TYPE_DOUBLE = "double";
    private static String ELEMENT_TYPE_LONG = "long";
    private static String ELEMENT_TYPE_INT = "int";
    private static String ELEMENT_TYPE_INTCLASS = "intclass";
    private static String ELEMENT_TYPE_BOOLEAN = "boolean";
    private static String ELEMENT_TYPE_BIGDECIMAL = "BigDecimal";
    private static String ELEMENT_TYPE_DECIMAL = "Decimal";
    private static String ELEMENT_TYPE_STRING = "String";
    private static String ELEMENT_TYPE_TEXT = "Text";
    private static String ELEMENT_TYPE_DYNAMICOBJECT = "DynamicObject";

    public static XmlData convertXmlElementToObject(String type, String schemaName, Element element) throws Exception {
        XmlData vo = new XmlData();
        XmlSchemaItem schemaItem = XmlSchema.getXmlItemByName(type, schemaName);
        if (schemaItem == null) {
            vo.setErrorDesc("XmlFileSchema.xml cannot find name=" + schemaName);
            vo.setValidated(Boolean.FALSE);
            return vo;
        }
        Object targetObj = XmlSchemaUtils.createTarObject(schemaItem.getClassType(), schemaItem.getEntityId());
        String errorMsg = XmlSchemaUtils.checkElement(schemaItem, element, targetObj);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            vo.setValidated(Boolean.FALSE);
            vo.setErrorDesc(errorMsg);
            return vo;
        }
        vo.setValidated(Boolean.TRUE);
        vo.setTargetObject(targetObj);
        return vo;
    }

    private static String checkElement(XmlSchemaItem schemaItem, Element element, Object targetObj) throws Exception {
        List<XmlSchemaField> lstFtpItem = schemaItem.getFtpSchemaFieldList();
        for (XmlSchemaField ftpSchemaField : lstFtpItem) {
            String name = ftpSchemaField.getXmlField();
            if (!StringUtils.isEmpty((CharSequence)ftpSchemaField.getDefaultValue())) {
                XmlSchemaUtils.setDefault(ftpSchemaField, targetObj);
                continue;
            }
            Element fieldEle = element.element(name);
            String refSchema = ftpSchemaField.getRefSchema();
            if (StringUtils.isBlank((CharSequence)refSchema)) {
                String result = XmlSchemaUtils.checkField(ftpSchemaField, targetObj, fieldEle);
                if ("".equals(result)) continue;
                return element.getUniquePath() + "/" + result;
            }
            XmlSchemaItem schemaChild = XmlSchema.getXmlItemByName(schemaItem.getType(), refSchema);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                Object childTargetObj;
                String classType = schemaChild.getClassType();
                String sfield = ftpSchemaField.getJavaField();
                String maxLength = ftpSchemaField.getMaxLength();
                String elementMustExist = ftpSchemaField.getElementMustExist();
                Element baseElement = XmlSchemaUtils.getElementByPath(element, ftpSchemaField.getFieldPath());
                if (null == baseElement) {
                    if (!ELEMENT_MUST_EXIST.equals(elementMustExist)) continue;
                    return String.format(ResManager.loadKDString((String)"%1$s%2$s/%3$s\u4e0d\u5b58\u5728", (String)"XmlSchemaUtils_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), element.getUniquePath(), ftpSchemaField.getFieldPath(), name);
                }
                List lstChild = baseElement.elements(name);
                if (lstChild == null || lstChild.isEmpty()) {
                    if (!ELEMENT_MUST_EXIST.equals(elementMustExist)) continue;
                    return String.format(ResManager.loadKDString((String)"%1$s%2$s/%3$s\u4e0d\u5b58\u5728", (String)"XmlSchemaUtils_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]), element.getUniquePath(), ftpSchemaField.getFieldPath(), name);
                }
                if (ELEMENT_TYPE_LIST.equals(ftpSchemaField.getType())) {
                    if (StringUtils.isNotBlank((CharSequence)maxLength) && lstChild.size() > Integer.parseInt(maxLength)) {
                        return String.format(ResManager.loadKDString((String)"%1$s%2$s/%3$s\u8d85\u8fc7\u6700\u5927\u6570\u91cf%4$s", (String)"XmlSchemaUtils_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), element.getUniquePath(), ftpSchemaField.getFieldPath(), name, maxLength);
                    }
                    ArrayList<Object> listTargetObject = new ArrayList<Object>(lstChild.size());
                    for (Element eleChild : lstChild) {
                        if (eleChild.elements().size() > 0) {
                            Object childTargetObj2 = XmlSchemaUtils.createTarObject(schemaChild.getClassType(), schemaChild.getEntityId());
                            listTargetObject.add(childTargetObj2);
                            String childErrorMsg = XmlSchemaUtils.checkElement(schemaChild, eleChild, childTargetObj2);
                            if (!StringUtils.isNotBlank((CharSequence)childErrorMsg)) continue;
                            return childErrorMsg;
                        }
                        if (!ELEMENT_MUST_EXIST.equals(ftpSchemaField.getFormat())) continue;
                        return String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"XmlSchemaUtils_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), eleChild.getUniquePath());
                    }
                    XmlSchemaUtils.setValue(targetObj, listTargetObject, sfield);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)classType)) {
                    if (StringUtils.isNotBlank((CharSequence)sfield)) {
                        childTargetObj = XmlSchemaUtils.createTarObject(schemaChild.getClassType(), schemaChild.getEntityId());
                        if (targetObj instanceof Map) {
                            ((Map)targetObj).put(sfield, childTargetObj);
                        } else {
                            String methodName = "set" + sfield.substring(0, 1).toUpperCase() + sfield.substring(1);
                            Method m = targetObj.getClass().getMethod(methodName, childTargetObj.getClass());
                            m.invoke(targetObj, childTargetObj);
                        }
                    } else {
                        childTargetObj = targetObj;
                    }
                } else {
                    childTargetObj = targetObj;
                }
                for (Element childElement : lstChild) {
                    String childErrorMsg = XmlSchemaUtils.checkElement(schemaChild, childElement, childTargetObj);
                    if (!StringUtils.isNotBlank((CharSequence)childErrorMsg)) continue;
                    return name + "/" + childErrorMsg;
                }
                continue;
            }
            String childErrorMsg = XmlSchemaUtils.checkElement(schemaChild, element, targetObj);
            if (!StringUtils.isNotBlank((CharSequence)childErrorMsg)) continue;
            return name;
        }
        return null;
    }

    private static Element getElementByPath(Element startElement, String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return startElement;
        }
        String[] ps = path.split("/");
        Element element = startElement;
        int index = 0;
        for (String elementName : ps) {
            if (!StringUtils.isNotEmpty((CharSequence)elementName)) continue;
            if (index == 0) {
                element = startElement.element(elementName);
            } else {
                if (null == element) {
                    return null;
                }
                element = element.element(elementName);
            }
            ++index;
        }
        return element;
    }

    private static String checkField(XmlSchemaField ftpSchemaField, Object targetObj, Element fieldEle) throws Exception {
        String value;
        boolean result = true;
        String name = ftpSchemaField.getXmlField();
        String elementMustExist = ftpSchemaField.getElementMustExist();
        if (fieldEle == null && ELEMENT_MUST_EXIST.equals(elementMustExist)) {
            return String.format(ResManager.loadKDString((String)"%s\u8282\u70b9\u4e0d\u5b58\u5728", (String)"XmlSchemaUtils_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), name);
        }
        if (fieldEle == null) {
            return "";
        }
        String validateRegex = ftpSchemaField.getValidateRegex();
        String string = value = StringUtils.isEmpty((CharSequence)fieldEle.getText()) ? null : fieldEle.getText().trim();
        if (StringUtils.isBlank((CharSequence)value) && ELEMENT_MUST_EXIST.equals(ftpSchemaField.getFormat())) {
            return String.format(ResManager.loadKDString((String)"%s\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"XmlSchemaUtils_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]), name);
        }
        if (value != null && StringUtils.isNotEmpty((CharSequence)ftpSchemaField.getMaxLength()) && StringUtils.isNotEmpty((CharSequence)value) && value.length() > Integer.parseInt(ftpSchemaField.getMaxLength())) {
            return String.format(ResManager.loadKDString((String)"%1$s\u8d85\u8fc7\u6700\u5927\u957f\u5ea6[%2$s]", (String)"XmlSchemaUtils_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]), name, ftpSchemaField.getMaxLength());
        }
        if (value != null && value.length() > 0) {
            if (StringUtils.isNotBlank((CharSequence)validateRegex) && !Pattern.matches(validateRegex, value)) {
                return ResManager.loadKDString((String)"%1$s\u5fc5\u987b\u7b26\u5408[%2$s]", (String)"XmlSchemaUtils_6", (String)"taxc-tsate-mservice", (Object[])new Object[]{name, validateRegex});
            }
            String resultStr = XmlSchemaUtils.setData(ftpSchemaField, targetObj, value, result);
            if (!"".equals(resultStr)) {
                return name + resultStr;
            }
        }
        return "";
    }

    private static void setDefault(XmlSchemaField ftpSchemaField, Object targetObj) throws Exception {
        XmlSchemaUtils.setData(ftpSchemaField, targetObj, ftpSchemaField.getDefaultValue(), true);
    }

    private static String setData(XmlSchemaField ftpSchemaField, Object targetObj, String fieldValue, boolean result) throws Exception {
        Object valueObj;
        block13: {
            try {
                if (ELEMENT_TYPE_DATE.equals(ftpSchemaField.getType())) {
                    SimpleDateFormat formatter;
                    String format = "yyyy-MM-dd";
                    if (StringUtils.isNotBlank((CharSequence)ftpSchemaField.getDateFormat())) {
                        format = ftpSchemaField.getDateFormat();
                    }
                    if (!fieldValue.equals((formatter = new SimpleDateFormat(format)).format(valueObj = formatter.parse(fieldValue)))) {
                        return ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u5fc5\u987b\u7b26\u5408[%2$s]\u683c\u5f0f", (String)"XmlSchemaUtils_7", (String)"taxc-tsate-mservice", (Object[])new Object[]{fieldValue, format});
                    }
                    break block13;
                }
                if (ELEMENT_TYPE_DOUBLE.equals(ftpSchemaField.getType())) {
                    valueObj = Double.valueOf(fieldValue);
                    break block13;
                }
                if (ELEMENT_TYPE_LONG.equals(ftpSchemaField.getType())) {
                    valueObj = Long.valueOf(fieldValue);
                    break block13;
                }
                if (ELEMENT_TYPE_INT.equals(ftpSchemaField.getType())) {
                    valueObj = Integer.valueOf(fieldValue);
                    break block13;
                }
                if (ELEMENT_TYPE_INTCLASS.equals(ftpSchemaField.getType())) {
                    valueObj = Integer.valueOf(fieldValue);
                    break block13;
                }
                if (ELEMENT_TYPE_BOOLEAN.equals(ftpSchemaField.getType())) {
                    valueObj = Boolean.valueOf(fieldValue);
                    break block13;
                }
                if (ELEMENT_TYPE_BIGDECIMAL.equals(ftpSchemaField.getType()) || ELEMENT_TYPE_DECIMAL.equalsIgnoreCase(ftpSchemaField.getType())) {
                    valueObj = BigDecimalUtil.toBigDecimal((Object)fieldValue);
                    break block13;
                }
                if (ELEMENT_TYPE_STRING.equals(ftpSchemaField.getType()) || ELEMENT_TYPE_TEXT.equalsIgnoreCase(ftpSchemaField.getType())) {
                    valueObj = fieldValue;
                    break block13;
                }
                return ResManager.loadKDString((String)"\u7c7b\u578b\u9519\u8bef%s", (String)"XmlSchemaUtils_10", (String)"taxc-tsate-mservice", (Object[])new Object[]{ftpSchemaField.getType()});
            }
            catch (Exception e) {
                logger.error("XmlSchemaUtils setData", (Object)e.getMessage());
                return ResManager.loadKDString((String)"\u503c[%1$s]\u4e0d\u662f[%2$s]", (String)"XmlSchemaUtils_11", (String)"taxc-tsate-mservice", (Object[])new Object[]{fieldValue, ftpSchemaField.getType()});
            }
        }
        if (valueObj != null) {
            XmlSchemaUtils.setValue(targetObj, valueObj, ftpSchemaField.getJavaField());
        }
        return "";
    }

    private static Object createTarObject(String classType, String entityId) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object targetObj = null;
        if (classType.endsWith(ELEMENT_TYPE_DYNAMICOBJECT)) {
            targetObj = BusinessDataServiceHelper.newDynamicObject((String)entityId);
        } else {
            Class<?> targetClass = Class.forName(classType);
            targetObj = targetClass.newInstance();
        }
        return targetObj;
    }

    private static void setValue(Object targetObj, Object valueObj, String fieldName) throws Exception {
        if (targetObj instanceof Map) {
            ((Map)targetObj).put(fieldName, valueObj);
        } else if (ELEMENT_TYPE_DYNAMICOBJECT.equals(targetObj.getClass().getSimpleName())) {
            Method method = targetObj.getClass().getMethod("set", String.class, Object.class);
            method.invoke(targetObj, fieldName, valueObj);
        } else {
            Field modelField = targetObj.getClass().getDeclaredField(fieldName);
            AccessibleObject.setAccessible(new AccessibleObject[]{modelField}, true);
            modelField.set(targetObj, valueObj);
        }
    }
}

