/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msxml.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.JsonUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlTJsonUtil {
    private static Log logger = LogFactory.getLog(XmlTJsonUtil.class);
    private static String root = "root";

    public Element getRoot(String xml) throws DocumentException {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            xml = "<" + root + ">" + xml + "</" + root + ">";
            document = DocumentHelper.parseText((String)xml);
            System.err.println(ResManager.loadKDString((String)"\nxml\u4e2d\u672a\u53d1\u73b0\u6839\u8282\u70b9\uff0c\u7cfb\u7edf\u81ea\u52a8\u6dfb\u52a0\u3002\n", (String)"XmlTJsonUtil_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        Element root = document.getRootElement();
        return root;
    }

    public List<Element> getAllNodeByName(String nodeName, Element node) {
        ArrayList<Element> elements = new ArrayList<Element>();
        this.saveNodeToList(nodeName, node, elements);
        return elements;
    }

    private void saveNodeToList(String nodeName, Element node, List<Element> elements) {
        if (this.emptyStr(nodeName)) {
            elements.add(node);
        } else if (nodeName.equals(node.getName())) {
            elements.add(node);
        }
        List listElement = node.elements();
        for (Element e : listElement) {
            this.saveNodeToList(nodeName, e, elements);
        }
    }

    public List<String> getAllAttrByName(String attrName, Element node) {
        ArrayList<String> attrs = new ArrayList<String>();
        this.saveAttrToList(attrName, node, attrs);
        return attrs;
    }

    private void saveAttrToList(String attrName, Element node, List<String> attrs) {
        List listAttr = node.attributes();
        for (Attribute attr : listAttr) {
            if (this.emptyStr(attrName)) {
                attrs.add(attr.getValue());
                continue;
            }
            if (!attrName.equals(attr.getName())) continue;
            attrs.add(attr.getValue());
        }
        List listElement = node.elements();
        for (Element e : listElement) {
            this.saveAttrToList(attrName, e, attrs);
        }
    }

    public Map<String, String> AttrNameToText(Element node, String nodeName, int nodeIndex) {
        List<Element> elements = this.getAllNodeByName(nodeName, node);
        if (--nodeIndex > elements.size()) {
            nodeIndex = elements.size();
        }
        if (nodeIndex < 0) {
            nodeIndex = 0;
        }
        Element e = elements.get(nodeIndex);
        List listAttr = e.attributes();
        HashMap<String, String> map = new HashMap<String, String>(listAttr.size());
        for (Attribute a : listAttr) {
            map.put(a.getName(), a.getValue());
        }
        return map;
    }

    private boolean emptyStr(String str) {
        return StringUtils.isEmpty((String)str);
    }

    public static Element xml2Element(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            Element root = doc.getRootElement();
            return root;
        }
        catch (Exception e) {
            logger.error("XmlTJsonUtil xml2Element", (Object)e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> xml2ObjectMap(String xml) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            Element root = XmlTJsonUtil.xml2Element(xml);
            if (null != root) {
                map.put(root.getName(), XmlTJsonUtil.iterateElement(root));
            }
            return map;
        }
        catch (Exception e) {
            logger.error("XmlTJsonUtil xml2ObjectMap", (Object)e.getMessage());
            return null;
        }
    }

    public static String xml2JSONString(String xml) {
        Map<String, Object> map = XmlTJsonUtil.xml2Map(xml);
        try {
            return JsonUtils.mapToStr(map);
        }
        catch (Exception e) {
            logger.error("XmlTJsonUtil xml2ObjectMap", (Object)e.getMessage());
            return null;
        }
    }

    public static Map<String, Object> xml2Map(String xml) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            Element root = XmlTJsonUtil.xml2Element(xml);
            if (null != root) {
                map.put(root.getName(), XmlTJsonUtil.iterateElements(root));
                return map;
            }
            return null;
        }
        catch (Exception e) {
            logger.error("XmlTJsonUtil xml2Map", (Object)e.getMessage());
            return null;
        }
    }

    public String xml2JSON(File file) {
        HashMap<String, Map> obj = new HashMap<String, Map>(16);
        try {
            SAXReader sax = new SAXReader();
            Document doc = sax.read(file);
            Element root = doc.getRootElement();
            obj.put(root.getName(), XmlTJsonUtil.iterateElement(root));
            return JsonUtils.mapToStr(obj);
        }
        catch (Exception e) {
            logger.error("XmlTJsonUtil xml2JSON", (Object)e.getMessage());
            return null;
        }
    }

    private static Map iterateElement(Element element) {
        List Listjiedian = element.elements();
        Element et = null;
        HashMap<String, Object> obj = new HashMap<String, Object>();
        List<Object> list = null;
        for (int i = 0; i < Listjiedian.size(); ++i) {
            list = new LinkedList<Object>();
            et = (Element)Listjiedian.get(i);
            if (et.getTextTrim().equals("")) {
                Object strObj;
                if (et.elements().size() == 0) {
                    if (obj.containsKey(et.getName())) continue;
                    obj.put(et.getName(), et.getTextTrim());
                    continue;
                }
                if (obj.containsKey(et.getName()) && EmptyCheckUtils.isNotEmpty(strObj = obj.get(et.getName()))) {
                    if (strObj instanceof List) {
                        list = (List)strObj;
                    } else {
                        list.add(strObj);
                    }
                }
                list.add(XmlTJsonUtil.iterateElement(et));
                obj.put(et.getName(), list);
                continue;
            }
            obj.put(et.getName(), et.getTextTrim());
        }
        return obj;
    }

    private static Map iterateElements(Element element) {
        List Listjiedian = element.elements();
        Element et = null;
        HashMap<String, Object> obj = new HashMap<String, Object>();
        List list = null;
        for (int i = 0; i < Listjiedian.size(); ++i) {
            Object strObj;
            list = new LinkedList();
            et = (Element)Listjiedian.get(i);
            if (et.getTextTrim().equals("")) {
                if (et.elements().size() == 0) continue;
                if (obj.containsKey(et.getName())) {
                    strObj = obj.get(et.getName());
                    if (strObj instanceof List) {
                        list = (List)strObj;
                    } else {
                        list.add(strObj);
                    }
                }
                list.add(XmlTJsonUtil.iterateElements(et));
                obj.put(et.getName(), list);
                continue;
            }
            if (obj.containsKey(et.getName())) {
                strObj = obj.get(et.getName());
                if (strObj instanceof List) {
                    list = (List)strObj;
                } else {
                    list.add(strObj);
                }
                list.add(et.getTextTrim());
                obj.put(et.getName(), list);
                continue;
            }
            obj.put(et.getName(), et.getTextTrim());
        }
        return obj;
    }
}

