/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msxml.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlUtil {
    private static Log logger = LogFactory.getLog(XmlUtil.class);

    public static Map<String, String> reMsg(InputStream in) {
        SAXReader sax = new SAXReader();
        HashMap<String, String> mapMsg = new HashMap<String, String>();
        try {
            Document document = sax.read(in);
            Element root = document.getRootElement();
            XmlUtil.getSonElement(root, mapMsg);
        }
        catch (DocumentException e) {
            logger.error("XmlUtil reMsg", (Object)e.getMessage());
        }
        return mapMsg;
    }

    public static void getSonElement(Element ele, Map<String, String> resultMap) {
        List sons = ele.elements();
        if (0 != sons.size()) {
            Iterator i = ele.elementIterator();
            while (i.hasNext()) {
                Element son = (Element)i.next();
                String name = son.getName();
                String text = son.getText();
                resultMap.put(name, text);
                XmlUtil.getSonElement(son, resultMap);
            }
        }
    }

    public static Map<String, String> readMsg(String xml) {
        HashMap<String, String> mapMsg = new HashMap<String, String>();
        try {
            Document document = DocumentHelper.parseText((String)xml);
            Element root = document.getRootElement();
            XmlUtil.getSonElement(root, mapMsg);
            return mapMsg;
        }
        catch (DocumentException e) {
            return null;
        }
    }

    public static Map xmlToMap(String xml, Boolean islow) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            if (doc == null) {
                return map;
            }
            Element root = doc.getRootElement();
            Iterator iterator = root.elementIterator();
            while (iterator.hasNext()) {
                Element e = (Element)iterator.next();
                List list = e.elements();
                if (list.size() > 0) {
                    if (islow.booleanValue()) {
                        map.put(e.getName(), XmlUtil.ElementToMap(e));
                        continue;
                    }
                    map.put(e.getName().toLowerCase(), XmlUtil.ElementToMap(e));
                    continue;
                }
                if (islow.booleanValue()) {
                    map.put(e.getName(), e.getText());
                    continue;
                }
                map.put(e.getName().toLowerCase(), e.getText());
            }
        }
        catch (Exception e) {
            logger.error("XmlUtil xmlToMap", (Object)e.getMessage());
        }
        return map;
    }

    public static Map ElementToMap(Element e) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List mapList = new ArrayList();
                if (iter.elements().size() > 0) {
                    Map m = XmlUtil.ElementToMap(iter);
                    String rowName = iter.getName();
                    if (map.get(iter.getName()) != null || "ROW".equals(rowName) || "ITEM".equals(rowName)) {
                        if (!"ROW".equals(rowName) && !"ITEM".equals(rowName) || "ROW".equals(rowName) && map.get(iter.getName()) != null || "ITEM".equals(rowName) && map.get(iter.getName()) != null) {
                            Object obj = map.get(iter.getName());
                            if (!obj.getClass().isAssignableFrom(ArrayList.class)) {
                                mapList = new ArrayList();
                                mapList.add(obj);
                                mapList.add(m);
                            }
                            if (obj.getClass().isAssignableFrom(ArrayList.class)) {
                                mapList = (List)obj;
                                mapList.add(m);
                            }
                            map.put(iter.getName(), mapList);
                            continue;
                        }
                        ArrayList<Map> rows = new ArrayList<Map>();
                        rows.add(m);
                        map.put(rowName, rows);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!obj.getClass().isAssignableFrom(ArrayList.class)) {
                        mapList = new ArrayList();
                        mapList.add(obj);
                        mapList.add(iter.getText());
                    }
                    if (obj.getClass().isAssignableFrom(ArrayList.class)) {
                        mapList = (List)obj;
                        mapList.add(iter.getText());
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static List<Map<String, String>> getListObjectByPath(Element root, String path) {
        if (path == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"path \u4e0d\u80fd\u4e3a\u7a7a", (String)"XmlUtil_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        ArrayList<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
        ArrayList<Element> targetEles = new ArrayList<Element>();
        String[] names = path.split("\\.");
        if (!names[0].equals(root.getName())) {
            logger.warn(path + "\u8def\u5f84\u5f02\u5e38\uff0c\u8282\u70b9\u8def\u5f84\u4e0d\u5b58\u5728" + names[0]);
            return listMap;
        }
        if (names.length == 1) {
            targetEles.add(root);
        } else {
            String[] nodes = Arrays.copyOfRange(names, 1, names.length);
            Element temp = root;
            for (int i = 0; i < nodes.length; ++i) {
                String node = nodes[i];
                int start = node.indexOf("[");
                int end = node.indexOf("]");
                if (start != -1 && end != -1) {
                    int index = Integer.parseInt(node.substring(start + 1, end));
                    String realNode = node.substring(0, start);
                    int size = temp.elements().size();
                    if (size < index + 1) {
                        logger.warn(path + "\u8def\u5f84\u5f02\u5e38\uff0c\u8282\u70b9\u8d8a\u754c" + node);
                        break;
                    }
                    temp = (Element)temp.elements(realNode).get(index);
                    if (i != nodes.length - 1) continue;
                    targetEles.add(temp);
                    continue;
                }
                Element next = temp.element(node);
                if (next == null) {
                    logger.warn(path + "\u8def\u5f84\u5f02\u5e38\uff0c\u8282\u70b9\u8def\u5f84\u4e0d\u5b58\u5728" + node);
                    break;
                }
                if (i == nodes.length - 1) {
                    targetEles.addAll(temp.elements(node));
                    continue;
                }
                temp = next;
            }
        }
        targetEles.forEach(item -> {
            HashMap map = new HashMap();
            item.elements().forEach(child -> map.put(child.getName(), child.getText()));
            listMap.add(map);
        });
        return listMap;
    }

    public static Map<String, String> getSingleObjectByPath(Element root, String path) {
        List<Map<String, String>> list = XmlUtil.getListObjectByPath(root, path);
        if (list.size() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u89e3\u6790\u5de5\u5177\u5f02\u5e38,\u8def\u5f84\u6570\u636e\u5f02\u5e38\u672a\u83b7\u53d6\u5230\u63d0\u793a\u4fe1\u606f", (String)"XmlUtil_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        return list.get(0);
    }

    public static String getSingleValueByPath(Element root, String path) {
        String[] strArray = path.split("\\.");
        if (strArray.length == 1) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u89e3\u6790\u5de5\u5177\u5f02\u5e38,\u4e0d\u652f\u6301\u6839\u8282\u70b9\u8def\u5f84\u83b7\u53d6\u503c", (String)"XmlUtil_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        int endIndex = path.lastIndexOf(".");
        String objectPath = path.substring(0, endIndex);
        String paramName = strArray[strArray.length - 1];
        Map<String, String> map = XmlUtil.getSingleObjectByPath(root, objectPath);
        return map.get(paramName);
    }
}

