/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.TsateDeclareChecklistBusiness;
import kd.taxc.tsate.business.TsateTaskTypeBusiness;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.upgrade.ITsateUpgradService;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;

public class CheckListUpgradeService
implements ITsateUpgradService {
    private static Log LOGGER = LogFactory.getLog(CheckListUpgradeService.class);
    private static final String META_ENTITYID = "tsate_declare_checklist";
    private static final String COPY_FIELDS = "id,taxorg,sbsx,zsxm,zspm,skssqz,skssqq,sbqx,sbrq,sbzt,jkzt";
    private static final String DOWNLOAD_SOURCE = "1";
    private static final String HANDWORK_SOURCE = "2";

    public String getName() {
        return ResManager.loadKDString((String)"\u7533\u62a5\u68c0\u67e5\u5217\u8868\u5386\u53f2\u6570\u636e\u5347\u7ea7", (String)"CheckListUpgradeService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
    }

    public void upgrade(String id) {
        UpgradeResult up = new UpgradeResult();
        up.setSuccess(true);
        up.setLog(ResManager.loadKDString((String)"\u7533\u62a5\u68c0\u67e5\u5386\u53f2\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"CheckListUpgradeService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        try {
            List<Long> historyDataIds = this.getHistoryDataIds();
            QFilter filter = new QFilter("id", "not in", historyDataIds);
            LOGGER.info(ResManager.loadKDString((String)"\u5f00\u59cb\u5347\u7ea7\u6570\u636e\u4e0b\u8f7d\u6570\u636e", (String)"CheckListUpgradeService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            this.buildNewDataAndSave(DOWNLOAD_SOURCE, filter);
            LOGGER.info(ResManager.loadKDString((String)"\u5f00\u59cb\u5347\u7ea7\u624b\u5de5\u4e0a\u4f20\u6570\u636e", (String)"CheckListUpgradeService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            this.buildNewDataAndSave(HANDWORK_SOURCE, filter);
        }
        catch (Exception e) {
            up.setSuccess(false);
            String errorLog = ResManager.loadKDString((String)"\u7533\u62a5\u68c0\u67e5\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5931\u8d25\uff1a", (String)"CheckListUpgradeService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + ExceptionUtil.toString((Exception)e);
            up.setLog(errorLog);
            LOGGER.error(errorLog);
            throw new KDBizException(errorLog);
        }
    }

    private List<Long> getHistoryDataIds() {
        DynamicObject[] historyData;
        ArrayList<Long> historyIds = new ArrayList<Long>();
        for (DynamicObject historyDatum : historyData = TsateDeclareChecklistBusiness.getHistoryData()) {
            DynamicObjectCollection checklist = historyDatum.getDynamicObjectCollection("checklist");
            List ids = checklist.stream().map(data -> data.getLong("id")).collect(Collectors.toList());
            historyIds.addAll(ids);
        }
        return historyIds;
    }

    private void buildNewDataAndSave(String dataSource, QFilter filter) {
        Map<Long, Map<Date, List<DynamicObject>>> uptData = this.buildUptData(dataSource, filter);
        if (CollectionUtils.isEmpty(uptData)) {
            return;
        }
        int count = 0;
        DynamicObjectCollection byTakeNumber = TsateTaskTypeBusiness.getByTakeNumber((String)"SBSXXZ", null);
        ArrayList<DynamicObject> savaData = new ArrayList<DynamicObject>();
        for (Map.Entry<Long, Map<Date, List<DynamicObject>>> entry : uptData.entrySet()) {
            Long orgId = entry.getKey();
            Map<Date, List<DynamicObject>> dateGroup = entry.getValue();
            for (Map.Entry<Date, List<DynamicObject>> group : dateGroup.entrySet()) {
                Date operateTime = group.getKey();
                List<DynamicObject> value = group.getValue();
                Date gxsj = value.get(0).getDate("gxsj");
                long creatorId = value.get(0).getLong("creator.id");
                String swjgmc = value.get(0).getString("swjgmc");
                DynamicObject head = TsateDeclareChecklistBusiness.newGroupInstance((Long)orgId, (String)dataSource, (Long)creatorId, (Date)gxsj, (Date)operateTime, (Long)((DynamicObject)byTakeNumber.get(0)).getLong("id"), (String)"0");
                DynamicObjectCollection checklist = TsateDeclareChecklistBusiness.newBodyByChecklisHead((DynamicObject)head);
                head.set("swjgmc", (Object)swjgmc);
                head.set("historyflag", (Object)DOWNLOAD_SOURCE);
                for (DynamicObject object : value) {
                    TsateDeclareChecklistBusiness.createBodyByObject((DynamicObjectCollection)checklist, (DynamicObject)object, (String)COPY_FIELDS, (String)",");
                    ++count;
                }
                savaData.add(head);
            }
        }
        Object[] saveResult = SaveServiceHelper.save((DynamicObject[])savaData.toArray(new DynamicObject[0]));
        if (saveResult.length > 0) {
            LOGGER.info(ResManager.loadKDString((String)"\u6210\u529f\u5347\u7ea7\u5206\u7ec4\u6570\u636e{}\u6761,\u5386\u53f2\u5e73\u94fa\u6570\u636e{}\u6761", (String)"CheckListUpgradeService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]), (Object)saveResult.length, (Object)count);
        }
    }

    private Map<Long, Map<Date, List<DynamicObject>>> buildUptData(String dataSource, QFilter filter) {
        QFilter sourceFilter = new QFilter("datasource", "=", (Object)dataSource).and(filter);
        DynamicObject[] downLoadData = this.getDataByFilter(sourceFilter);
        HashMap<Long, Map<Date, List<DynamicObject>>> updDate = new HashMap<Long, Map<Date, List<DynamicObject>>>(64);
        for (DynamicObject datum : downLoadData) {
            ArrayList<DynamicObject> updObjects;
            long orgId = datum.getDynamicObject("org").getLong("id");
            Date gxsj = datum.getDate("gxsj");
            Date formatDate = this.dataFormatByDataSource(dataSource, gxsj);
            HashMap<Date, ArrayList<DynamicObject>> dataGroupMap = (HashMap<Date, ArrayList<DynamicObject>>)updDate.get(orgId);
            if (dataGroupMap == null) {
                dataGroupMap = new HashMap<Date, ArrayList<DynamicObject>>(16);
            }
            if ((updObjects = (ArrayList<DynamicObject>)dataGroupMap.get(formatDate)) == null) {
                updObjects = new ArrayList<DynamicObject>(16);
            }
            updObjects.add(datum);
            dataGroupMap.put(formatDate, updObjects);
            updDate.put(orgId, dataGroupMap);
        }
        return updDate;
    }

    private Date dataFormatByDataSource(String dataSource, Date gxsj) {
        if (DOWNLOAD_SOURCE.equals(dataSource)) {
            return DateUtils.stringToDate((String)DateUtils.format((Date)gxsj, (String)"yyyy-MM"), (String)"yyyy-MM");
        }
        return DateUtils.trunc((Date)gxsj);
    }

    private DynamicObject[] getDataByFilter(QFilter filter) {
        return BusinessDataServiceHelper.load((String)META_ENTITYID, (String)MetadataUtil.getAllFieldString((String)META_ENTITYID), (QFilter[])filter.toArray());
    }
}

