/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.upgrade;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.common.upgrade.ITsateUpgradService;

public class DeclareRecordCleanEmptyLog
implements ITsateUpgradService {
    Log logger = LogFactory.getLog(DeclareRecordCleanEmptyLog.class);
    private static final String META = "tsate_declare_record";

    public String getName() {
        return ResManager.loadKDString((String)"\u76d1\u63a7\u8bb0\u5f55\u6e05\u9664\u7a7a\u65e5\u5fd7", (String)"DeclareRecordCleanEmptyLog_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
    }

    public void upgrade(String id) {
        DynamicObjectCollection dyns = this.getAllDeclareRecord();
        int querySize = dyns.size();
        int emptySize = 0;
        for (DynamicObject dyn : dyns) {
            if (!this.checkLogEmpty(dyn)) continue;
            ++emptySize;
            this.cleanEmptyLog(dyn);
        }
        this.logger.info(this.getName() + "\uff1a\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
        this.logger.info("\u67e5\u8be2\u603b\u6570\uff1a" + querySize);
        this.logger.info("\u7a7a\u65e5\u5fd7\u603b\u6570\uff1a" + emptySize);
    }

    private DynamicObjectCollection getAllDeclareRecord() {
        QFilter q = new QFilter("deallog", "like", (Object)"FILE:%");
        q.and("tasktype.number", "=", (Object)"ZLSB");
        return QueryServiceHelper.query((String)META, (String)"id,deallog", (QFilter[])new QFilter[]{q});
    }

    private boolean checkLogEmpty(DynamicObject declareRecord) {
        String text;
        String deallog = declareRecord.getString("deallog");
        return deallog.startsWith("FILE:") && StringUtils.isEmpty((String)(text = this.getFileText(deallog)));
    }

    public void cleanEmptyLog(DynamicObject declareRecord) {
        QFilter q = new QFilter("id", "=", (Object)declareRecord.getLong("id"));
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)META, (String)"id,deallog", (QFilter[])new QFilter[]{q});
        obj.set("deallog", (Object)"");
        SaveServiceHelper.update((DynamicObject)obj);
    }

    private String getFileText(String fileUrl) {
        String path;
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        if (!fileService.exists(path = fileUrl.substring(5))) {
            return null;
        }
        InputStream in = fileService.getInputStream(fileUrl.substring(5));
        String text = this.getStringByInputStream(in);
        return text;
    }

    private String getStringByInputStream(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] b = new byte[1024];
            while ((n = inputStream.read(b)) != -1) {
                outputStream.write(b, 0, n);
            }
        }
        catch (Exception e) {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (Exception e1) {
                this.logger.error((Throwable)e1);
            }
        }
        return outputStream.toString();
    }
}

