/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.upgrade;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tsate.business.TsatePramSettingBusiness;
import kd.taxc.tsate.common.upgrade.ITsateUpgradService;

public class ParamSettingUpgradeService
implements ITsateUpgradService {
    private static final String SQL_QUERY_ALL = "select fid,fkey,fvalue,ftype from t_tsate_param_setting where ftype != '0'";
    private static final String SQL_UPDATE = "update t_tsate_param_setting set fvalue=? ,ftype=? where fid=?";

    public String getName() {
        return "ParamSettingUpgradeService";
    }

    public void upgrade(String id) {
        ArrayList<Object[]> needUpdate = new ArrayList<Object[]>(10);
        DataSet ds = DB.queryDataSet((String)"ParamSettingUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (String)SQL_QUERY_ALL);
        while (ds.hasNext()) {
            Row row = ds.next();
            Long fid = row.getLong("fid");
            String key = row.getString("fkey");
            String value = row.getString("fvalue");
            String type = row.getString("ftype");
            Object[] rowparam = new Object[]{value, type, fid};
            if (StringUtil.isEmpty((CharSequence)type)) {
                rowparam[1] = "0";
                needUpdate.add(rowparam);
            }
            if (!"1".equals(type)) continue;
            String encodeV = TsatePramSettingBusiness.getEncodeValueInUpgrade((String)value);
            rowparam[0] = encodeV;
            rowparam[1] = "0";
            needUpdate.add(rowparam);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)SQL_UPDATE, needUpdate);
    }
}

