/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.tsate.business.TsateChannelDbBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.util.DBUtils;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;

public class SbpzSssqUpgradeService
implements IUpgradeService {
    private static Log LOGGER = LogFactory.getLog(SbpzSssqUpgradeService.class);
    private static final String ALGOKEY = "SbpzSssqUpgradeService";
    private static final String DBKEY_TAX = "taxc";
    private static final String DATASOURCE_DOWNLOAD = "1";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult up = new UpgradeResult();
        up.setSuccess(true);
        up.setLog(ResManager.loadKDString((String)"\u7533\u62a5\u51ed\u8bc1\u6240\u5c5e\u7a0e\u671f\u5c5e\u6027\u5347\u7ea7\u6210\u529f", (String)"SbpzSssqUpgradeService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        LOGGER.info(ResManager.loadKDString((String)"SbpzSssqUpgradeService\u7533\u62a5\u51ed\u8bc1\u5347\u7ea7\u6240\u5c5e\u7a0e\u671f\u5b57\u6bb5\uff0c\u5f00\u59cb\u5347\u7ea7", (String)"SbpzSssqUpgradeService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        try {
            List<Map<String, Object>> list = this.queryNeedUpgrade();
            LOGGER.info(ResManager.loadKDString((String)"\u9700\u8981\u5347\u7ea7\u7684\u6570\u91cf", (String)"SbpzSssqUpgradeService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + list.size());
            List<Map<String, Object>> info = this.updateSssq(list);
            LOGGER.info(ResManager.loadKDString((String)"\u5b9e\u9645\u5347\u7ea7\u6570\u91cf", (String)"SbpzSssqUpgradeService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + info.size());
            this.batchSave(info);
            LOGGER.info(ResManager.loadKDString((String)"\u5347\u7ea7\u7ed3\u675f", (String)"SbpzSssqUpgradeService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        catch (Exception e) {
            up.setSuccess(true);
            up.setLog(ResManager.loadKDString((String)"\u7533\u62a5\u51ed\u8bc1\u6240\u5c5e\u7a0e\u671f\u5c5e\u6027\u5347\u7ea7\u5931\u8d25\uff1a", (String)"SbpzSssqUpgradeService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + ExceptionUtil.toString((Exception)e));
            LOGGER.error(ResManager.loadKDString((String)"\u7533\u62a5\u51ed\u8bc1\u6240\u5c5e\u7a0e\u671f\u5c5e\u6027\u5347\u7ea7\u5931\u8d25\uff1a", (String)"SbpzSssqUpgradeService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + ExceptionUtil.toString((Exception)e));
        }
        return up;
    }

    private List<Map<String, Object>> queryNeedUpgrade() {
        ArrayList<Map<String, Object>> target = new ArrayList<Map<String, Object>>(8);
        StringBuilder sql = new StringBuilder("select t1.fid,t1.fdatasource ,t1.fsbqj,t1.forgid,t1.fdeclaretype,t2.fnumber");
        sql.append(" from t_tsate_sbpz_admin t1");
        sql.append(" left join t_tctb_template_type t2 on t1.fdeclaretype=t2.fid");
        sql.append(" where t1.fsbqj is not null and t1.fskssqq is null");
        DataSet datas = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)DBKEY_TAX), (String)sql.toString());
        while (datas.hasNext()) {
            Row row = datas.next();
            Date sbqj = row.getDate("fsbqj");
            Long id = row.getLong("fid");
            Long orgId = row.getLong("forgid");
            String declareTypeId = row.getString("fdeclaretype");
            String declaretypenumber = row.getString("fnumber");
            String datasource = row.getString("fdatasource");
            HashMap<String, Object> sbpz = new HashMap<String, Object>(8);
            sbpz.put("sbqj", sbqj);
            sbpz.put("id", id);
            sbpz.put("orgid", orgId);
            sbpz.put("declaretypeid", declareTypeId);
            sbpz.put("declaretypenumber", declaretypenumber);
            sbpz.put("datasource", datasource);
            target.add(sbpz);
        }
        datas.close();
        return target;
    }

    private List<Map<String, Object>> updateSssq(List<Map<String, Object>> sbpzs) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(20);
        List orgIds = sbpzs.stream().map(item -> (Long)item.get("orgid")).collect(Collectors.toList());
        Map config = TsateChannelDbBusiness.getChannelConfigByOrgId(orgIds);
        sbpzs.forEach(sbpz -> {
            HashMap info = new HashMap();
            info.put("id", sbpz.get("id"));
            Long orgId = (Long)sbpz.get("orgid");
            Date sbqj = (Date)sbpz.get("sbqj");
            if (sbqj == null) {
                return;
            }
            String datasource = (String)sbpz.get("datasource");
            String declaretype = (String)sbpz.get("declaretypenumber");
            if (DATASOURCE_DOWNLOAD.equals(datasource)) {
                String channelCode = TsateChannelDbBusiness.getChannelNumberFromConfig((Long)orgId, (String)declaretype, (Map)config);
                SupplierEnum Supplier2 = SupplierEnum.valueOfCode((String)channelCode);
                if (Supplier2 == null) {
                    return;
                }
                if (Supplier2 == SupplierEnum.CLOUDCC || Supplier2 == SupplierEnum.SZYH || Supplier2 == SupplierEnum.GXSJ) {
                    Date date = DateUtils.addMonth((Date)sbqj, (int)-1);
                    info.put("skssqq", DateUtils.getFirstDateOfMonth((Date)date));
                    info.put("skssqz", DateUtils.getLastDateOfMonth((Date)date));
                    list.add(info);
                    return;
                }
            }
            info.put("skssqq", DateUtils.getFirstDateOfMonth((Date)sbqj));
            info.put("skssqz", DateUtils.getLastDateOfMonth((Date)sbqj));
            list.add(info);
        });
        return list;
    }

    private void batchSave(List<Map<String, Object>> list) {
        if (list == null || list.size() <= 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(4);
        for (Map<String, Object> item : list) {
            Object[] objs = new Object[]{item.get("skssqq"), item.get("skssqz"), item.get("id")};
            params.add(objs);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update t_tsate_sbpz_admin set fskssqq = ? , fskssqz= ? where fid= ?");
        DBUtils.executeBatch((String)DBKEY_TAX, (String)sql.toString(), params);
    }
}

