/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.velocity;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.Node;

public class Query
extends Directive {
    Log logger = LogFactory.getLog(Query.class);
    private static final String ID = "id";
    private static final int QUERY_ID = 1;
    private static final int QUERY_MULTI = 2;

    public String getName() {
        return "query";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        int size = node.jjtGetNumChildren();
        if (size != 4) {
            StringBuilder detailLog = this.getDetailLog(node);
            detailLog.append(ResManager.loadKDString((String)" velocity\u9519\u8bef\uff1aquery\u6307\u4ee4\u53c2\u6570\u6570\u91cf\u5e94==3\uff0c\u5b9e\u9645\u6570\u91cf", (String)"Query_0", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(size);
            this.logger.error(detailLog.toString());
            throw new KDBizException(detailLog.toString());
        }
        String metaname = (String)node.jjtGetChild(1).value(internalContextAdapter);
        if (StringUtils.isEmpty((String)metaname)) {
            return false;
        }
        String filds = (String)node.jjtGetChild(2).value(internalContextAdapter);
        if (StringUtils.isEmpty((String)filds)) {
            return false;
        }
        String queryStr = (String)node.jjtGetChild(3).value(internalContextAdapter);
        QFilter filter = this.parseFilter(queryStr, this.getFildType(metaname));
        if (filter == null) {
            StringBuilder detailLog = this.getDetailLog(node);
            detailLog.append(ResManager.loadKDString((String)" velocity\u9519\u8bef\uff1a\u89e3\u6790\u67e5\u8be2\u6761\u4ef6\u5931\u8d25\uff1a\u8bf7\u6c42\u53c2\u6570-", (String)"Query_1", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(queryStr);
            this.logger.info(detailLog.toString());
            return false;
        }
        int queryMode = this.queryMode(queryStr);
        if (1 == queryMode) {
            Node ref;
            DynamicObject dyn2 = QueryServiceHelper.queryOne((String)metaname, (String)filds, (QFilter[])new QFilter[]{filter});
            HashMap map = new HashMap(8);
            if (dyn2 != null) {
                Arrays.stream(filds.split(",")).forEach(key -> map.put(key, dyn2.get(key)));
            }
            if ((ref = node.jjtGetChild(0)) instanceof ASTReference) {
                ASTReference refNode = (ASTReference)ref;
                if (map != null) {
                    refNode.setValue(internalContextAdapter, map);
                }
            }
        } else {
            ArrayList list = new ArrayList(8);
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)metaname, (String)filds, (QFilter[])new QFilter[]{filter});
            dyns.forEach(dyn -> {
                Map<String, Object> map = Arrays.stream(filds.split(",")).collect(Collectors.toMap(k1 -> k1, k2 -> dyn.get(k2)));
                list.add(map);
            });
            Node ref = node.jjtGetChild(0);
            if (ref instanceof ASTReference) {
                ASTReference refNode = (ASTReference)ref;
                if (list != null) {
                    refNode.setValue(internalContextAdapter, list);
                }
            }
        }
        return true;
    }

    private StringBuilder getDetailLog(Node node) {
        StringBuilder detailLog = new StringBuilder();
        detailLog.append(ResManager.loadKDString((String)"\u6587\u4ef6 ", (String)"Query_2", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(node.getTemplateName()).append(ResManager.loadKDString((String)" \u884c\u53f7", (String)"Query_3", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(node.getLine()).append(ResManager.loadKDString((String)" \u5217\u53f7", (String)"Query_4", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(node.getColumn()).append(ResManager.loadKDString((String)" \u5b57\u7b26\u4e32", (String)"Query_5", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(node.literal()).append("\n");
        return detailLog;
    }

    private int queryMode(String queryStr) {
        if (queryStr.indexOf("=") != -1) {
            return 2;
        }
        return 1;
    }

    private QFilter parseFilter(String queryStr, Map<String, Class> fildsTypes) {
        if (StringUtils.isEmpty((String)queryStr)) {
            return null;
        }
        QFilter filter = null;
        int quryMode = this.queryMode(queryStr);
        if (2 == quryMode) {
            HashMap params = new HashMap(8);
            Arrays.stream(queryStr.split(",")).forEach(row -> {
                String[] condition;
                if (StringUtils.isNotEmpty((String)row) && (condition = row.split("=")).length == 2) {
                    String valueStr = condition[1];
                    String filed = condition[0];
                    Object value = this.stringToObj(valueStr, (Class)fildsTypes.get(filed));
                    if (value != null) {
                        params.put(filed, value);
                    } else {
                        this.logger.info("\u503c\u4e3a\u7a7a\u4e0d\u89e3\u6790\u4e3aQFilter\uff1a" + queryStr);
                    }
                }
            });
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (filter == null) {
                    filter = new QFilter(key, "=", value);
                    continue;
                }
                filter.and(key, "=", value);
            }
        } else if (1 == quryMode) {
            if (StringUtils.isEmpty((String)queryStr) || "0".equals(queryStr)) {
                return null;
            }
            filter = new QFilter(ID, "=", (Object)Long.parseLong(queryStr));
        } else {
            return null;
        }
        return filter;
    }

    private Map<String, Class> getFildType(String metaKey) {
        HashMap<String, Class> fildTypes = new HashMap<String, Class>(32);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaKey);
        mainEntityType.getAllFields().entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            IDataEntityProperty value = (IDataEntityProperty)entry.getValue();
            fildTypes.put(key, value.getPropertyType());
        });
        return fildTypes;
    }

    private Object stringToObj(String str, Class clazz) {
        if (clazz == Long.class || clazz == DynamicObject.class) {
            if (StringUtils.isNotEmpty((String)str)) {
                return Long.parseLong(str);
            }
            return null;
        }
        return str;
    }
}

